﻿function BuildHeader()
{
	if (_page == "order_list")
		return BuildAjaxPath(true) + "?Status=" + $("#Status").val() + "&Page=" + _pageNumber;
	else if (_page == "product_list")
		return BuildAjaxPath(true) + "?Kind=" + $("#Kind").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "order_feedback" || _page == "product_feedback" || _page == "website_list")
		return BuildAjaxPath(true) + "?Page=" + _pageNumber;
}

function Search()
{
	if (arguments.length > 0 && typeof(arguments[0]) != "object")
		_pageNumber = arguments[0];
	
	SetStatusMessage(_lang_working);
	$.ajax(
	{
		url : BuildHeader(),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			$("#List").html(HandleFake404(data, "text"));
			SetStatusMessage();
			Init();
		}
	});
}

function AddFeedback()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	if (this.Content.value == "")
	{
		Alert(_lang_content_empty, function(){this.Content.select();}, this);
		return false;
	}
	
	if (this.Content.value.length > 255)
	{
		Alert(_lang_content_too_long, function(){this.Content.select();}, this);
		return false;
	}
	
	var data = "OrderID=" + _orderID;
	data += "&Content=" + encodeURIComponent(this.Content.value);
	if (_page == "product_feedback")
		data += "&OrderDetailID=" + _orderDetailID;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Feedback&Operation=Add&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_add_feedback_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			$("#List").html(data);
		
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	return false;
}

function ShowPayDialog(id)
{
	var path = HandleFake404("pay.aspx?ID=" + id, "url");
	if ($.browser.msie)
		window.showModalDialog(path, window, "status=0;dialogWidth=500px;dialogHeight=300px;center=1;help=0;resizable=1;scroll=1");
	else
		window.open(path,null,"width=500,height=300,dialog=yes,modal=yes,maximize=no,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no");
}

function ShowUpdateDialog(id)
{
	var path = HandleFake404("update.aspx?ID=" + id, "url");
	if ($.browser.msie)
		window.showModalDialog(path, window, "status=0;dialogWidth=500px;dialogHeight=300px;center=1;help=0;resizable=1;scroll=1");
	else
		window.open(path,null,"width=500,height=300,dialog=yes,modal=yes,maximize=no,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no");
}

function ShowTryDialog(id)
{
	var path = HandleFake404("try.aspx?ID=" + id, "url");
	if ($.browser.msie)
		window.showModalDialog(path, window, "status=0;dialogWidth=500px;dialogHeight=220px;center=1;help=0;resizable=1;scroll=1");
	else
		window.open(path,null,"width=500,height=200,dialog=yes,modal=yes,maximize=no,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no");
}

function ShowOrderDialog()
{
	var path = HandleFake404("order.aspx?ID=" + this.id, "url");
	if ($.browser.msie)
		window.showModalDialog(path, window, "status=0;dialogWidth=400px;dialogHeight=300px;center=1;help=0;resizable=1;scroll=1");
	else
		window.open(path,null,"width=400,height=300,dialog=yes,modal=yes,maximize=no,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no");
}

function ShowInstallDialog(id)
{
	var path = HandleFake404("install.aspx?ID=" + id, "url");
	if ($.browser.msie)
		window.showModalDialog(path, window, "status=0;dialogWidth=400px;dialogHeight=200px;center=1;help=0;resizable=1;scroll=1");
	else
		window.open(path,null,"width=400,height=200,dialog=yes,modal=yes,maximize=no,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no");
}

function Pay()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	if (_amount > _balance)
	{
		Alert(_lang_balance_not_enough);
		return false;
	}

	var paymentNumber = FormatDate(new Date(), "YYYYMMDDhhmmssSSS");
	var memo = this.Memo.value;

	var data = "Amount=" + _amount;
	data += "&PaymentNumber=" + encodeURIComponent(paymentNumber);
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Order&Operation=Pay&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_pay_fail, function(){window.close();});
			SetStatusMessage();
		},
		success : function(data)
		{
			SetStatusMessage(_lang_pay_complete);
			MakePayment(paymentNumber, memo);
		}
	});
	return false;
}

function MakePayment(paymentNumber, memo)
{
	var data = "OrderID=" + _orderID;
	data += "&Number=" + encodeURIComponent(paymentNumber);
	data += "&Amount=" + _amount;
	data += "&Memo=" + encodeURIComponent(memo);

	SetStatusMessage(_lang_making_payment);
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Payment&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_make_payment_fail, function(){window.close();});
			SetStatusMessage();
		},
		success : function(data)
		{
			if (_autoOrder)
			{
				Deliver();
			}
			else
			{
				if ($.browser.msie)
					window.dialogArguments.Search();
				else
					window.opener.Search();
				
				Alert(_lang_operation_success, function(){window.close();});
				SetStatusMessage();
			}
		}
	});
}

function Deliver()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return;
    }

	var time = FormatDate(new Date(), "YYYY-MM-DD hh:mm:ss");

	var data = "&Amount=" + _products[_productIndex].Amount;
	data += "&Time=" + time;

	SetStatusMessage(_lang_delivering);
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Order.Detail&Operation=Deliver&ID=" + _products[_productIndex].InnerID,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_deliver_fail, function(){window.close();});
			SetStatusMessage();
		},
		success : function(data)
		{
			MakeDelivery(time)
		}
	});
}

function MakeDelivery(time)
{
	var data = "OrderID=" + _orderID;
	data += "&OrderDetailID=" + _products[_productIndex].ID;
	data += "&Number=" + encodeURIComponent(FormatDate(new Date(), "YYYYMMDDhhmmssSSS"));
	data += "&Amount=" + _products[_productIndex].Amount;
	data += "&Time=" + time;

	SetStatusMessage(_lang_making_delivery);
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Delivery&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_make_delivery_fail, function(){window.close();});
			SetStatusMessage();
		},
		success : function(data)
		{
			_productIndex++;
			if (_productIndex < _products.length)
			{
				Deliver();
			}
			else
			{
				if ($.browser.msie)
					window.dialogArguments.Search();
				else
					window.opener.Search();
				
				Alert(_lang_operation_success, function(){window.close();});
				SetStatusMessage();
			}
		}
	});
}

function Try()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_delivering);
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Order.Detail&Operation=Try&ID=" + _id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail, function(){window.close();});
			SetStatusMessage();
		},
		success : function(data)
		{
			if ($.browser.msie)
				window.dialogArguments.Search();
			else
				window.opener.Search();
			
			Alert(_lang_operation_success, function(){window.close();});
			SetStatusMessage();
		}
	});
	return false;
}

function EditHost()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	var serverBindings = "";
	for (var i = 0; i < this.ServerBindings.options.length; i++)
	{
		if (serverBindings != "")
			serverBindings += "|";
		serverBindings += this.ServerBindings.options[i].text;
	}
	
	var data = "";
	if (_serverBindings != serverBindings)
	{
		if (data != "")
			data += "&";

		_serverBindings = serverBindings;
		data += "ServerBindings=" + encodeURIComponent(_serverBindings);
	}
	if (_logEnabled != $("#LogEnabledYes")[0].checked)
	{
		if (data != "")
			data += "&";

		_logEnabled = !_logEnabled;
		data += "LogEnabled=" + _logEnabled;
	}
	if (_defaultDoc != this.DefaultDoc.value)
	{
		if (data != "")
			data += "&";

		_defaultDoc = this.DefaultDoc.value;
		data += "DefaultDoc=" + encodeURIComponent(_defaultDoc);
	}
	if (_error404 != this.Error404.value)
	{
		if (data != "")
			data += "&";

		_error404 = this.Error404.value;
		data += "Error404=" + encodeURIComponent(_error404);
	}
	
	if (data == "")
		return false;
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Order.Detail&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
		}
	});
	return false;
}

function AddServerBinding()
{
	var form = document.forms[0];
	var serverBinding = $.trim(form.ServerBinding.value.toLowerCase());
	if (serverBinding.indexOf("http://") == 0)
		serverBinding = serverBinding.substr(7);
	if (serverBinding == "" || serverBinding.indexOf(":") != -1)
	{
		Alert(_lang_domain_incorrect, function(){form.ServerBinding.select();}, this);
		return false;
	}

	for (var i = 0; i < form.ServerBindings.options.length; i++)
	{
		if (serverBinding == form.ServerBindings.options[i].text)
		{
			Alert(_lang_domain_exist, function(){form.ServerBinding.select();}, this);
			return false;
		}
	}
	
	if (form.ServerBindings.options.length >= _serverBindingsCount)
	{
		Alert(_lang_domain_max_count, function(){form.ServerBinding.select();}, this);
		return false;
	}
	
	var forbiddenDomains = _forbiddenDomain.split("|");
	for (var i = 0; i < forbiddenDomains.length; i++)
	{
		if (forbiddenDomains[i] == "")
			continue;
		
		if (serverBinding.indexOf(forbiddenDomains[i]) != -1)
		{
			Alert(_lang_forbidden_domain, function(){form.ServerBinding.select();}, this);
			return false;
		}
	}

	var option = document.createElement("OPTION");
	option.text = serverBinding;
	$(option).appendTo(form.ServerBindings);
	
	return false;
}

function DeleteServerBinding()
{
	var form = document.forms[0];
	if (form.ServerBindings.length == 1)
	{
		Alert(_lang_cant_delete_all_domain);
		return;
	}
	if (form.ServerBindings.selectedIndex != -1)
		form.ServerBindings.remove(form.ServerBindings.selectedIndex);
}

function ModifyBeforeUpdate()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	if (parseFloat(_sum) > _balance)
	{
		Alert(_lang_balance_not_enough);
		return false;
	}
	
	$("span").each(function()
	{
		if (typeof(this.unitAmount) == "undefined")
			return false;

		_children[_children.length] = new Object();
		_children[_children.length - 1].ID = $(this).attr("id");
		_children[_children.length - 1].Amount = $(this).html();
	}
	);

	var data = "DeliveredAmount=0&Amount=" + _amount;
	data += "&Discount=" + _discount;
	data += "&NeedInvoice=" + $("#NeedInvoiceYes")[0].checked;
	data += "&TaxRate=" + _taxRate;
	data += "&PriceAdjustment=" + _priceAdjustment;
	data += "&Sum=" + _sum;
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Order.Detail&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail, function(){window.close();});
			SetStatusMessage();
		},
		success : function(data)
		{
			if (_childIndex < _children.length)
				ModifyChildBeforeUpdate();
			else
				Update();
		}
	});
	return false;
}

function ModifyChildBeforeUpdate()
{
	var data = "DeliveredAmount=0&Amount=" + _children[_childIndex].Amount;
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Order.Detail&Operation=Modify&ID=" + _children[_childIndex].id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail, function(){window.close();});
			SetStatusMessage();
		},
		success : function(data)
		{
			_childIndex++;
			if (_childIndex < _children.length)
				ModifyChildBeforeUpdate();
			else
				Update();
		}
	});
}

function Update()
{
	var paymentNumber = FormatDate(new Date(), "YYYYMMDDhhmmssSSS");

	var data = "PaymentNumber=" + paymentNumber;
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Order.Detail&Operation=Update&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail, function(){window.close();});
			SetStatusMessage();
		},
		success : function(data)
		{
			MakeUpdatePayment(paymentNumber);
		}
	});
}

function MakeUpdatePayment(paymentNumber)
{
	var data = "OrderID=" + _orderID;
	data += "&OrderDetailID=" + _orderDetailID;
	data += "&Number=" + encodeURIComponent(paymentNumber);
	data += "&Amount=" + _sum;
	data += "&Memo=" + encodeURIComponent(_lang_memo);

	SetStatusMessage(_lang_making_payment);
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Payment&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail, function(){window.close();});
			SetStatusMessage();
		},
		success : function(data)
		{
			if ($.browser.msie)
				window.dialogArguments.Search();
			else
				window.opener.Search();
			
			Alert(_lang_operation_success, function(){window.close();});
			SetStatusMessage();
		}
	});
}

function Order()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	var data = "Number=" + FormatDate(new Date(), "YYYYMMDDhhmmssSSS");
	data += "&Member=" + encodeURIComponent(GetCookie("UserName"));
	data += "&MemberID=" + GetCookie("UserID");
	data += "&Discount=" + _discount;
	data += "&NeedInvoice=" + $("#NeedInvoiceYes")[0].checked;
	data += "&TaxRate=" + _taxRate;
	data += "&PriceAdjustment=" + _priceAdjustment;
	data += "&Memo=" + encodeURIComponent(this.Memo.value);
	data += "&Price=" + _price;
	data += "&Sum=" + _sum;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Order&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail, function(){window.close();});
			SetStatusMessage();
		},
		success : function(data)
		{
			AddOrderProduct(data);
		}
	});
	return false;
}

function AddOrderProduct(orderID)
{
	var data = "OrderID=" + orderID;
	data += "&ProductID=" + _product.ProductID;
	data += "&ProductNumber=" + encodeURIComponent(_product.ProductNumber);
	data += "&Name=" + encodeURIComponent(_product.Name);
	data += "&Kind=" + _product.Kind;
	data += "&Amount=" + _amount;
	data += "&UnitID=" + _product.UnitID;
	data += "&Price=" + _price;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Order.Detail&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail, function(){window.close();});
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success, function(){window.close();});
			SetStatusMessage();
		}
	});			
}

function ComputeUpdateSum()
{
	var price = _price * _amount;
	var beforeTax = price - price * (100 - _discount) / 100;
	var afterTax = beforeTax;
	if ($("#NeedInvoiceYes")[0].checked)
		afterTax = beforeTax + beforeTax * _taxRate / 100;
	_sum = (afterTax + _priceAdjustment).toFixed(2);
		
	$("#SumTD").html(_sum);
}

function ComputeOrderSum()
{
	var beforeTax = _price - _price * (100 - _discount) / 100;
	var afterTax = beforeTax;
	if ($("#NeedInvoiceYes")[0].checked)
		afterTax = beforeTax + beforeTax * _taxRate / 100;
	_sum = (afterTax + _priceAdjustment).toFixed(2);
	$("#Sum").html(_sum);
}

function Install()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	if (this.HostID.selectedIndex == -1)
	{
		Alert(_lang_select_host);
		return false;
	}
	
	var data = "WebSiteID=" + _webSiteID;
	data += "&HostID=" + this.HostID.value;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Order.Detail&Operation=InstallWebSite",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail, function(){window.close();});
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success, function(){window.close();});
			SetStatusMessage();
		}
	});
	return false;
}

function Init()
{
	if (typeof (_page) == "undefined")
		return;
	
	if (_page == "order_list")
	{
		$("a").each(function()
		{
			if (this.id.indexOf("Pay") == 0)
			{
				$(this).attr("href", "javascript:ShowPayDialog(" + this.id.substr(3) + ")");
			}
		});

		if (arguments.length == 0)
		    return;

		$("#Status").change(Search);
	}
	else if (_page == "order_feedback" || _page == "product_feedback")
	{
		$("form").submit(AddFeedback);
	}
	else if (_page == "pay")
	{
		$("form").submit(Pay);
	}
	else if (_page == "try")
	{
		$("form").submit(Try);
	}
	else if (_page == "product_list")
	{
		$("a").each(function()
		{
			if (this.id.indexOf("Update") == 0)
				$(this).attr("href", "javascript:ShowUpdateDialog(" + this.id.substr(6) + ")");
			else if (this.id.indexOf("Try") == 0)
				$(this).attr("href", "javascript:ShowTryDialog(" + this.id.substr(3) + ")");
			else if (this.id.indexOf("Install") == 0)
				$(this).attr("href", "javascript:ShowInstallDialog(" + this.id.substr(7) + ")");
		});

		if (arguments.length == 0)
		    return;

		$("#Kind,#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
	}
	else if (_page == "host")
	{
		$("form").submit(EditHost);
		$("input[name=ServerBinding]").keydown(function(e){if(e.keyCode == 13)return AddServerBinding();});
		$("#AddServerBinding").click(AddServerBinding);
		$("#DeleteServerBinding").click(DeleteServerBinding);
	}
	else if (_page == "update")
	{
		$("form").submit(ModifyBeforeUpdate);
		$("input[name='NeedInvoice']").change(ComputeUpdateSum);
		ComputeUpdateSum();
	}
	else if (_page == "website_list")
	{
		$("button").click(ShowOrderDialog);
	}
	else if (_page == "order")
	{
		$("form").submit(Order);
		$("input[name='NeedInvoice']").change(ComputeOrderSum);
		ComputeOrderSum();
	}
	else if (_page == "install")
	{
		$("form").submit(Install);
	}
}
Init(true);