﻿var _nameExist = false;
var _emailExist = false;

function Register()
{
	if (_nameExist)
	{
		Alert(_lang_name_exist, function(){this.Name.select();}, this);
		return false;
	}
	
	if (_emailExist)
	{
		Alert(_lang_email_exist, function(){this.Email.select();}, this);
		return false;
	}
	
	if ($.trim(this.Name.value) == "")
	{
		Alert(_lang_name_incorrect, function(){this.Name.select();}, this);
		return false;
	}
	
	if ($.trim(this.Password.value) == "")
	{
		Alert(_lang_password_incorrect, function(){this.Password.select();}, this);
		return false;
	}
	
	if (this.Password.value != this.Confirm.value)
	{
		Alert(_lang_confirm_incorrect, function(){this.Confirm.select();}, this);
		return false;
	}
	
	if ($.trim(this.PasswordQuestion.value) == "")
	{
		Alert(_lang_password_question_incorrect, function(){this.PasswordQuestion.select();}, this);
		return false;
	}
	
	if ($.trim(this.PasswordAnswer.value) == "")
	{
		Alert(_lang_password_answer_incorrect, function(){this.PasswordAnswer.select();}, this);
		return false;
	}
	
	if (!this.Email.value.match(/\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/))
	{
		Alert(_lang_email_incorrect, function(){this.Email.select();}, this);
		return false;
	}
	
	if (this.CheckCode != null && $.trim(this.CheckCode.value) == "")
	{
		Alert(_lang_check_code_incorrect, function(){this.CheckCode.select();}, this);
		return false;
	}
	
	if ($("#More")[0].checked)
	{
		var re = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;	
		if (this.Birthday.value != "" && !re.test(this.Birthday.value))
		{
			Alert(_lang_birthday_incorrect, function(){this.Birthday.select();}, this);
			return false;
		}
	}
	
	var data = "RoleID=" + _defaultRoleID;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&Password=" + encodeURIComponent(this.Password.value);
	data += "&PasswordQuestion=" + encodeURIComponent(this.PasswordQuestion.value);
	data += "&PasswordAnswer=" + encodeURIComponent(this.PasswordAnswer.value);
	data += "&Email=" + encodeURIComponent(this.Email.value);
	data += "&PageID=" + FormatDate(new Date(), "YYYYMMDDhhmmssSSS");
	if (this.CheckCode != null)
    	data += "&CheckCode=" + encodeURIComponent(this.CheckCode.value);
	data += "&IsChecked=" + !_isNeedToCheck;
	if ($("#More")[0].checked)
	{
		if (this.RealName.value != "") data += "&RealName=" + encodeURIComponent(this.RealName.value);
		if (this.Birthday.value != "") data += "&Birthday=" + encodeURIComponent(this.Birthday.value);
		if (this.Phone.value != "") data += "&Phone=" + encodeURIComponent(this.Phone.value);
		if (this.Mobile.value != "") data += "&Mobile=" + encodeURIComponent(this.Mobile.value);
		if (this.Address.value != "") data += "&Address=" + encodeURIComponent(this.Address.value);
		if (this.Zip.value != "") data += "&Zip=" + encodeURIComponent(this.Zip.value);
		if (this.Homepage.value != "") data += "&Homepage=" + encodeURIComponent(this.Homepage.value);
		if (this.QQ.value != "") data += "&QQ=" + encodeURIComponent(this.QQ.value);
		if (this.MSN.value != "") data += "&MSN=" + encodeURIComponent(this.MSN.value);
		if (this.SexID.value != "") data += "&SexID=" + this.SexID.value;
		if (this.RegionID.value != "") data += "&RegionID=" + this.RegionID.value;
		if (this.IndustryID.value != "") data += "&IndustryID=" + this.IndustryID.value;
		if (this.CertificateTypeID.value != "") data += "&CertificateTypeID=" + this.CertificateTypeID.value;
		if (this.Certificate.value != "") data += "&Certificate=" + encodeURIComponent(this.Certificate.value);
	}
	
	$(":submit")[0].disabled = true;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Member&Operation=Register",
		data : data,
		type : "POST",
		error : function (request)
		{
			Alert(_lang_register_fail);
	        $(":submit")[0].disabled = false;
			$("#CheckCodeImage").attr("src", _webPath + "ilghar.aspx?Action=CheckCode&" + Math.random());
		},
		success : function (data)
		{
			Alert(_lang_register_success);
			window.location.href = _loginPath;
		}
	});
	
	return false;
}

function Login()
{
	if ($.trim(this.Name.value) == "")
	{
		Alert(_lang_name_incorrect, function(){this.Name.select();}, this);
		return false;
	}
	
	if ($.trim(this.Password.value) == "")
	{
		Alert(_lang_password_incorrect, function(){this.Password.select();}, this);
		return false;
	}
	
	if (this.CheckCode != null && $.trim(this.CheckCode.value) == "")
	{
		Alert(_lang_check_code_incorrect, function(){this.CheckCode.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&Password=" + encodeURIComponent(this.Password.value);
	if (this.CheckCode != null)
		data += "&CheckCode=" + encodeURIComponent(this.CheckCode.value);
	
	$(":submit")[0].disabled = true;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Member&Operation=Login",
		data : data,
		type : "POST",
		error : function (request)
		{
			Alert(_lang_login_fail);
			$("#CheckCodeImage").attr("src", _webPath + "ilghar.aspx?Action=CheckCode&" + Math.random());
	        $(":submit")[0].disabled = false;
		},
		success : function  (data)
		{
			window.location.href = _channelPath;
		}
	});
	return false;
}

function OnFindPassword()
{
	var form = this.form;
	
	if ($.trim(form.Name.value) == "")
	{
		Alert(_lang_name_incorrect, function(){form.Name.select();}, this);
		return;
	}
	
	if ($.trim(form.CheckCode.value) == "")
	{
		Alert(_lang_check_code_incorrect, function(){form.CheckCode.select();}, this);
		return;
	}

	var nameExist = false;
	form.Submit1.disabled = true;
	form.Submit2.disabled = true;
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Member&Operation=IsNameExist&Name=" + encodeURIComponent(form.Name.value),
		type : "GET",
		async : false,
		complete : function (request)
		{
			if (request.responseText.toLowerCase() == "true")
				nameExist = true;
			else
				nameExist = false;
		}
	});
	
	if (!nameExist)
	{
		Alert(_lang_member_not_exist);
		form.Submit1.disabled = false;
		form.Submit2.disabled = false;
		return;
	}
	
	if (this.name == "Submit1")
	{
		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Object=Member&Operation=SendPasswordToMail",
			data : "Name=" + encodeURIComponent(form.Name.value) + "&CheckCode=" + encodeURIComponent(form.CheckCode.value),
			type : "POST",
			error : function (request)
			{
				Alert(_lang_send_mail_fail);
				$("#CheckCodeImage").attr("src", _webPath + "ilghar.aspx?Action=CheckCode&" + Math.random());
				form.Submit1.disabled = false;
				form.Submit2.disabled = false;
			},
			success : function  (data)
			{
				Alert(_lang_send_mail_success);
				form.Submit1.disabled = false;
				form.Submit2.disabled = false;
			}
		});
	}
	else
	{
		var question = null;
		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Object=Member&Operation=GetQuestion",
			data : "Name=" + encodeURIComponent(form.Name.value) + "&CheckCode=" + encodeURIComponent(form.CheckCode.value),
			type : "POST",
			async : false,
			error : function (request)
			{
				Alert(_lang_get_question_fail);
				$("#CheckCodeImage").attr("src", _webPath + "ilghar.aspx?Action=CheckCode&" + Math.random());
				form.Submit1.disabled = false;
				form.Submit2.disabled = false;
			},
			success : function  (data)
			{
				$("#CheckCodeImage").attr("src", _webPath + "ilghar.aspx?Action=CheckCode&" + Math.random());
				question = data;
			}
		});
		if (question == null)
			return;
		
		var answer = prompt(_lang_please_answer_question + question, "");
		if (answer == null || answer == "")
			return;

		var checkCode = prompt(_lang_please_input_new_check_code, "");
		if (checkCode == null || checkCode == "")
			return;

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Object=Member&Operation=AnswerQuestion",
			data : "Name=" + encodeURIComponent(form.Name.value) + "&PasswordAnswer=" + encodeURIComponent(answer) + "&CheckCode=" + encodeURIComponent(checkCode),
			type : "POST",
			error : function (request)
			{
				Alert(_lang_answer_question_fail);
				form.Submit1.disabled = false;
				form.Submit2.disabled = false;
			},
			success : function  (data)
			{
				if (data == "")
				{
					Alert(_lang_answer_incorrect);
					$("#CheckCodeImage").attr("src", _webPath + "ilghar.aspx?Action=CheckCode&" + Math.random());
				}
				else
				{
					Alert(_lang_your_password + data);
				}
			}
		});
	}	
}

function Name_OnChange(e)
{
    if ((e.type == "keydown" && e.keyCode != 13) || this.value == "")
        return;
    
	$.get(_webPath + "ilghar.aspx?Object=Member&Operation=IsNameExist&Name=" + encodeURIComponent(this.value),function(data)
    {
	    if (data.toLowerCase() == "true")
	    {
		    _nameExist = true;
		    $("#NameExist").html(_lang_name_exist);
	    }
	    else
	    {
		    _nameExist = false;
		    $("#NameExist").html("");
	    }
    });
    
    if (e.keyCode == 13)	
        e.preventDefault();
}

function Email_OnChange(e)
{
    if ((e.type == "keydown" && e.keyCode != 13) || this.value == "")
        return;
	
	$.get(_webPath + "ilghar.aspx?Object=Member&Operation=IsEmailExist&Email=" + encodeURIComponent(this.value),function(data)
    {
	    if (data.toLowerCase() == "true")
	    {
		    _emailExist = true;
		    $("#EmailExist").html(_lang_email_exist);
	    }
	    else
	    {
		    _emailExist = false;
		    $("#EmailExist").html("");
	    }
    });
    
    if (e.keyCode == 13)	
        e.preventDefault();
}

function Init()
{
   if (typeof(SetupIme) != "undefined")
		SetupIme();
	
	if (typeof(_page) == "undefined")
		return;
	
	if (_page == "register")
	{
		$("form").submit(Register);
		$("[name=Name]").change(Name_OnChange).keydown(Name_OnChange);
		$("[name=Email]").change(Email_OnChange).keydown(Email_OnChange);
		$("#CheckCodeImage").css("cursor", "pointer").click(function(){this.src = _webPath + "ilghar.aspx?Action=CheckCode&" + Math.random();});
		$("[name=Birthday]").focus(function(){new DatePicker(this);});
		
		$("#More").click(function()
		{
		    var rows = $("[class=Hidden]");
		    if (this.checked)
		        rows.show();
		    else
		        rows.hide();
		});
	}
	else if (_page == "login")
	{
		$("form").submit(Login);
		$("#Register").click(function(){window.location = _registerPath;});
		$("#CheckCodeImage").css("cursor", "pointer").click(function(){this.src = _webPath + "ilghar.aspx?Action=CheckCode&" + Math.random();});
	}
	else if (_page == "find_password")
	{
		$("form :button").click(OnFindPassword);
	}
}
Init();