﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.MemberPageBase" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ilghar:Get ID="Person" Object="Person" InnerID="Request.QueryString['ID']" />
<ilghar:Get ID="Config" Object="InstanceConfig" Operation="GetBasicSettings()" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>编辑人物</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<script type="text/javascript">
var _page = "person_edit";
var _webPath = "<%=WebPath%>";
var _imagePath = "<%=ImagePath%>";
var _id = "<%=Request.QueryString["ID"]%>";
var _guid = "<%=Person[ID]%>";
var _tagAddList = new Array();
var _tagDeleteList = new Array();
var _tagAddIndex = 0;
var _tagDeleteIndex = 0;
var _uploadPicture;
var _uploadThumbnail;
var _isLocked = <%=Convert.ToString(User["IsLocked"]).ToLower()%>;
var _lang_locked = "你被锁定，不能操作！";
var _lang_working = "正在操作...";
var _lang_operation_fail = "操作失败！";
var _lang_operation_success = "操作成功！";
var _lang_name_empty = "名称不能空！";
var _lang_picture_type_must_be = "大图类型应为：";
var _lang_start_upload_picture = "开始上传大图...";
var _lang_uploading_picture = "正在上传大图...";
var _lang_thumbnail_type_must_be = "小图类型应为：";
var _lang_start_upload_thumbnail = "开始上传小图...";
var _lang_uploading_thumbnail = "正在上传小图...";
var _lang_modifying_tag = "正在修改标签...";

var _tags = new Array();
<ilghar:List Object="Person.Tag" Condition="PersonID=Person[ID]">
	<ilghar:Record>
		_tags[_tags.length] = {ID:"<%=TagID%>",Name:"<%=TagName%>",PageGenerate:"<%=TagPageGenerate%>",PageTemplate:"<%=TagPageTemplate%>",PageID:"<%=TagPageID%>",PageExtension:"<%=TagPageExtension%>"};
	</ilghar:Record>
</ilghar:List>
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame_flipCHS.gif" alt="关闭侧栏导航" /></div>
	<div class="Title"><a href="list.aspx">人物列表</a> → <%=Person[Name]%></div>
</div>
<div class="Block">
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle">编辑</li>
		<li class="Right"></li>
	</ul>
	<form>
		<table border="0" cellpadding="4" cellspacing="1">
			<tfoot>
				<tr><td colspan="2"><input type="submit" value="编辑" /></td></tr>
			</tfoot>
			<tbody>
				<tr>
					<th width="120">名称：</th>
					<td><input type="text" name="Name" value="<%=Person[Name]%>" size="60" maxlength="255" class="Text <%=PageLang%>Font" /></td>
				</tr>
				<tr>
					<th>首字母：</th>
					<td>
						<select name="FirstLetter" class="<%=PageLang%>Font">
							<ilghar:List Source="Manager.SplitToTable(Config[FirstLetter])">
									<ilghar:Record>
										<%If String.Equals([0], Person[FirstLetter])%>
											<option value="<%=[0]%>" selected="selected"><%=[0]%></option>
										<%Else%>
											<option value="<%=[0]%>"><%=[0]%></option>
										<%EndIf%>
									</ilghar:Record>
							</ilghar:List>
						</select>
					</td>
				</tr>
				<tr>
					<th>性别：</th>
					<td>
						<select name="SexID" class="<%=PageLang%>Font">
							<option value="" Name="" PageGenerate="" PageTemplate="" PageID="" PageExtension="">未指定</option>
							<ilghar:List Object="Sex">
								<ilghar:Record>
									<%If Guid.Equals(ID, Person[SexID])%>
										<option value="<%=ID%>" Name="<%=Name%>" PageGenerate="<%=PageGenerate%>" PageTemplate="<%=PageTemplate%>" PageID="<%=PageID%>" PageExtension="<%=PageExtension%>" selected="selected"><%=Name%></option>
									<%Else%>
										<option value="<%=ID%>" Name="<%=Name%>" PageGenerate="<%=PageGenerate%>" PageTemplate="<%=PageTemplate%>" PageID="<%=PageID%>" PageExtension="<%=PageExtension%>"><%=Name%></option>
									<%EndIf%>
								</ilghar:Record>
							</ilghar:List>
						</select>
					</td>
				</tr>
				<tr>
					<th>地区：</th>
					<td>
						<select name="RegionID" class="<%=PageLang%>Font">
							<option value="" Name="" PageGenerate="" PageTemplate="" PageID="" PageExtension="">未指定</option>
							<ilghar:Tree Object="Region">
								<ilghar:Control>
									<ilghar:Space>&nbsp;&nbsp;</ilghar:Space>
									<ilghar:Line>│</ilghar:Line>
									<ilghar:TopOpen>┌</ilghar:TopOpen>
									<ilghar:Top>┌</ilghar:Top>
									<ilghar:MiddleOpen>├</ilghar:MiddleOpen>
									<ilghar:Middle>├</ilghar:Middle>
									<ilghar:BottomOpen>└</ilghar:BottomOpen>
									<ilghar:Bottom>└</ilghar:Bottom>
								</ilghar:Control>
								<ilghar:Record>
									<%If Guid.Equals(ID, Person[RegionID])%>
										<option value="<%=ID%>" Name="<%=Name%>" PageGenerate="<%=PageGenerate%>" PageTemplate="<%=PageTemplate%>" PageID="<%=PageID%>" PageExtension="<%=PageExtension%>" selected="selected"><%=Control%><%=Name%></option>
									<%Else%>
										<option value="<%=ID%>" Name="<%=Name%>" PageGenerate="<%=PageGenerate%>" PageTemplate="<%=PageTemplate%>" PageID="<%=PageID%>" PageExtension="<%=PageExtension%>"><%=Control%><%=Name%></option>
									<%EndIf%>
									<%=ChildRecords%>
								</ilghar:Record>
							</ilghar:Tree>
						</select>
					</td>
				</tr>
				<tr>
					<th>语言：</th>
					<td>
						<select name="LanguageID" class="<%=PageLang%>Font">
							<option value="" Name="" PageGenerate="" PageTemplate="" PageID="" PageExtension="">未指定</option>
							<ilghar:List Object="Language">
								<ilghar:Record>
									<%If Guid.Equals(ID, Person[LanguageID])%>
										<option value="<%=ID%>" Name="<%=Name%>" PageGenerate="<%=PageGenerate%>" PageTemplate="<%=PageTemplate%>" PageID="<%=PageID%>" PageExtension="<%=PageExtension%>" selected="selected"><%=Name%></option>
									<%Else%>
										<option value="<%=ID%>" Name="<%=Name%>" PageGenerate="<%=PageGenerate%>" PageTemplate="<%=PageTemplate%>" PageID="<%=PageID%>" PageExtension="<%=PageExtension%>"><%=Name%></option>
									<%EndIf%>
								</ilghar:Record>
							</ilghar:List>
						</select>
					</td>
				</tr>
				<tr>
					<th>大图：</th>
					<td>
						<input id="PictureTextbox" type="text" name="Picture" value="<%=Person[Picture]%>" size="55" class="Text CHSFont" />
						<input id="PictureBrowse" type="button" value="浏览..." />
						<input type="hidden" name="PictureAllowedType" value="gif|jpg|jpeg|png|bmp" />
						<a href="<%=Person[Picture]%>" target="_blank"><img src="<%=Person[Picture]%>" height="22" id="PictureView" alt="大图" style="vertical-align:bottom" /></a>
						<input type="checkbox" id="MakeThumbnail" /><label for="MakeThumbnail">生成小图</label>
						<input type="checkbox" id="AddWaterMarkToPicture" /><label for="AddWaterMarkToPicture">水印</label>
					</td>
				</tr>
				<tr id="ThumbnailRow">
					<th>小图：</th>
					<td>
						<input id="ThumbnailTextbox" type="text" name="Thumbnail" value="<%=Person[Thumbnail]%>" size="55" class="Text CHSFont" />
						<input id="ThumbnailBrowse" type="button" value="浏览..." />
						<input type="hidden" name="ThumbnailAllowedType" value="gif|jpg|jpeg|png|bmp" />
						<a href="<%=Person[Thumbnail]%>" target="_blank"><img src="<%=Person[Thumbnail]%>" height="22" id="ThumbnailView" alt="小图" style="vertical-align:bottom" /></a>
						<input type="checkbox" id="AddWaterMarkToThumbnail" /><label for="AddWaterMarkToThumbnail">水印</label>
					</td>
				</tr>
				<tr>
					<th>标签：</th>
					<td>
						<input type="button" id="TagSelect" value="选择" class="Button" />
						<div id="TagDiv"></div>
					</td>
				</tr>
				<tr>
					<th>简介：</th>
					<td>
						<textarea id="HtmlEditor" EditorLang="<%=PageLang%>" EditorInstanceID="<%=Channel[IlgharCMS.SystemModule.Alias.Instance.InnerID]%>" style="display:none;width:600px;height:400px"><%=HttpUtility.HtmlEncode(Person[Description].ToString())%></textarea>
					</td>
				</tr>
			</tbody>
		</table>
	</form>
	<div class="Footer"></div>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>uploader.js"></script>
<script type="text/javascript" src="<%=CommonPath%>IlgharHtmlEditor.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<%If PageLang == "UYG" || PageLang == "KZA" || PageLang == "KGA"%>
	<script type="text/javascript" src="<%=CommonPath%>IlgharIme.js"></script>
<%EndIf%>
<script type="text/javascript" src="<%=JsPath%>common.js"></script>
<script type="text/javascript" src="<%=JsPath%>music.js"></script>
</body>
</html>