﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.MemberPageBase" %>
<%If Convert.IsDBNull(OrderDetail[ExpiredTime]) || !Int32.Equals(OrderDetail[DeliveredAmount], OrderDetail[Amount]) || (String.Equals(OrderDetail[Kind], "Host") && Guid.Equals(OrderDetail[ServerID], Guid.Empty))%>
	<%Response.End();%>
<%EndIf%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ilghar:Get ID="OrderDetail" Object="Order.Detail" InnerID="Request.QueryString['ID']" Validate="True" />
<ilghar:Get ID="Order" Object="Order" Guid="OrderDetail[OrderID]" />
<ilghar:List ID="Unit" Object="Unit" />
<ilghar:Get ID="Balance" Mark="Member" Object="Deposit" Operation="GetBalance((Guid)Order[MemberID])" />
<ilghar:Get ID="Member" Mark="Member" Object="Member" Guid="Order[MemberID]" />
<ilghar:List ID="Discounts" Object="Discount" />
<ilghar:Get ID="Config" Object="InstanceConfig" Operation="GetBasicSettings()" />
<base target="_self" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="pragma" content="no-cache" />
<meta http-equiv="Cache-Control" content="no-cache" />
<meta http-equiv="Expires" content="Mon,1 Fab 1979 23:36:05 GMT" />
<title>续费</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<script language="c#" runat="server">
protected string GetUnitName(object unitID)
{
	if (Guid.Equals(unitID, Guid.Empty))
		return String.Empty;

	DataRow[] rows = Unit.Select(Alias.Unit.ID + "='" + unitID + "'");
	if (rows.Length == 0)
		return String.Empty;
	else
		return rows[0][Alias.Unit.Name].ToString();
}

protected int Discount
{
	get
	{
		int result = 100;
		string roleInnerIDs = Member[IlgharCMS.MemberModule.Alias.Member.RoleInnerIDs].ToString();
		foreach (DataRow discount in Discounts.Rows)
		{
			if (roleInnerIDs.Contains("|" + discount[Alias.Discount.RoleInnerID] + "|"))
			{
				if ((int)discount[Alias.Discount.Amount] < result)
					result = (int)discount[Alias.Discount.Amount];
			}
		}
		
		return result;
	}
}
</script>
<script type="text/javascript">
var _page = "update";
var _webPath = "<%=WebPath%>";
var _id = <%=Request.QueryString["ID"]%>;
var _amount = 1;
var _priceAdjustment = 0;
var _sum = 0;
var _balance = <%=Balance%>;
var _discount = <%=Discount%>;
var _taxRate = <%=Config[TaxRate]%>;
var _price = <%=OrderDetail[Price]%>;
var _orderID = "<%=Order[ID]%>";
var _orderDetailID = "<%=OrderDetail[ID]%>";
var _childIndex = 0;
var _children = new Array();
var _isLocked = <%=Convert.ToString(User["IsLocked"]).ToLower()%>;
var _lang_locked = "你被锁定，不能操作！";
var _lang_memo = "续费";
var _lang_balance_not_enough = "预存款不够！";
var _lang_making_payment = "正在生成收款单...";
var _lang_working = "正在操作...";
var _lang_operation_success = "操作成功！";
var _lang_operation_fail = "操作失败！";
</script>
</head>
<body>
<div class="Block">
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle">续费</li>
		<li class="Right"></li>
	</ul>
	<form action="">
		<table border="0" cellpadding="4" cellspacing="1">
			<tfoot>
				<tr>
					<td colspan="2">
						<input type="submit" value="续费" />
					</td>
				</tr>
			</tfoot>
			<tbody>
				<tr>
					<th width="120">产品：</th>
					<td><%=OrderDetail[Name]%></td>
				</tr>
				<tr>
					<th>数量：</th>
					<td>1 <%=GetUnitName(OrderDetail[UnitID])%></td>
				</tr>
				<tr>
					<th>需要发票：</th>
					<td>
						<input type="radio" name="NeedInvoice" id="NeedInvoiceYes" /><label for="NeedInvoiceYes">是</label>
						<input type="radio" name="NeedInvoice" id="NeedInvoiceNo" checked="checked" /><label for="NeedInvoiceNo">否</label>
					</td>
				</tr>
				<tr>
					<th>预存款：</th>
					<td><%=Balance%></td>
				</tr>
				<tr>
					<th>续费总额：</th>
					<td id="SumTD">0</td>
				</tr>
				<%If String.Equals(OrderDetail[Kind], "Set")%>
					<ilghar:List Object="Order.Detail" Condition="ParentID=OrderDetail[ID] and IsPresent=false">
						<tr>
							<td colspan="2">
								<table border="0" cellpadding="4" cellspacing="1">
									<thead>
										<tr>
											<th style="width:120px">货号</th>
											<th>名称</th>
											<th style="width:60px">数量</th>
										</tr>
									</thead>
									<tbody>
										<ilghar:Record>
											<tr>
												<td><%=ProductNumber%></td>
												<td><%=Name%></td>
												<td><span id="<%=InnerID%>" unitAmount="<%=UnitAmount%>"><%=UnitAmount%></span> <%=GetUnitName(UnitID)%></td>
											</tr>
										</ilghar:Record>
									</tbody>
								</table>
							</td>
						</tr>
					</ilghar:List>
				<%EndIf%>
			</tbody>
		</table>
	</form>
	<div class="Footer"></div>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<script type="text/javascript" src="<%=JsPath%>common.js"></script>
<script type="text/javascript" src="<%=JsPath%>host.js"></script>
</body>
</html>