﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.MemberPageBase" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>已购产品</title>
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder(Alias.Order.Detail.IsCanceled + "=false");
	string and = " AND ";

	#region 性质
	string kind = Request.QueryString["Kind"];
	if (kind != null && kind != "*")
		condition.Append(and + Alias.Order.Detail.Kind + "='" + kind + "'");
	#endregion

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Number")
			condition.Append(and + Alias.Order.Detail.OrderNumber + "='" + keyword + "'");
		else if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + Alias.Order.Detail.Name + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Order.Detail.InnerID + " DESC";
			break;
		case "2":
			sort = Alias.Order.Detail.InnerID + " ASC";
			break;
		case "3":
			sort = Alias.Order.Detail.ExpiredTime + " DESC";
			break;
		case "4":
			sort = Alias.Order.Detail.ExpiredTime + " ASC";
			break;
		default:
			sort = Alias.Order.Detail.InnerID + " DESC";
			break;
	}
	
	return sort;
}
</script>
<script type="text/javascript">
var _page = "product_list";
var _lang_working = "正在操作...";
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame_flipCHS.gif" alt="关闭侧栏导航" /></div>
	<div class="Title">已购产品</div>
</div>
<div class="Block">
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle">已购产品</li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<select id="Kind">
			<option value="*">所有性质</option>
			<option value="AutoSite">智能建站</option>
			<option value="Host">虚拟主机</option>
			<option value="WebSite">网站</option>
			<option value="Set">套餐</option>
			<option value="">其他</option>
		</select>
		<select id="Sort">
			<option value="1">序号↓</option>
			<option value="2">序号↑</option>
			<option value="3">过期↓</option>
			<option value="4">过期↑</option>
		</select>
		<input id="Keyword" class="Text" />
		<select id="KeywordType">
			<option value="Number">订单号</option>
			<option value="Name">产品名</option>
		</select>
		<input type="button" value="搜索" class="Button" />
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1">
			<thead>
				<tr>
					<th>名称</th>
					<th>订单号</th>
					<th>创建时间</th>
					<th>状态</th>
					<th>操作</th>
				</tr>
			</thead>
			<tbody>
				<ilghar:List ID="List" Object="Order.Detail" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
					<ilghar:Record>
						<tr>
							<td>
								<a href="view.aspx?ID=<%=InnerID%>"><%=Name%></a>
							</td>
							<td><a href="../order/view.aspx?ID=<%=OrderInnerID%>"><%=OrderNumber%></a></td>
							<td><%=CreateTime%></td>
							<td>
								<%If Int32.Equals(DeliveredAmount, Amount)%>
									已发货
								<%ElseIf Convert.ToInt32(DeliveredAmount) > 0%>
									部分发货
								<%Else%>
									未发货
								<%EndIf%>
								<%If Convert.ToBoolean(OnTrial)%>
									，试用中
								<%EndIf%>
								<%If !Convert.IsDBNull(ExpiredTime)%>
									<%If DateTime.Now > Convert.ToDateTime(ExpiredTime)%>
										，已过期
										<%If String.Equals(Kind, "Host") && Guid.Equals(ServerID, Guid.Empty)%>
										，已删除
										<%EndIf%>
									<%Else%>
										，<%=Convert.ToDateTime(ExpiredTime).Subtract(DateTime.Now).Days + 1%>天后过期
									<%EndIf%>
								<%EndIf%>
							</td>
							<td>
								【<a href="feedback.aspx?ID=<%=InnerID%>">反馈</a>】

								<%If !Convert.ToBoolean(OnTrial) && Int32.Equals(DeliveredAmount, 0) && Guid.Equals(ParentID, Guid.Empty) && Guid.Equals(ServerID, Guid.Empty)%>
									<ilghar:List Object="Product" Page="1" PageSize="1" Condition="ID=ProductID">
										<ilghar:Record>
											<%If Convert.ToBoolean(CanTry)%>
												【<a id="Try<%=List[InnerID]%>">试用</a>】
											<%EndIf%>
										</ilghar:Record>
									</ilghar:List>
								<%EndIf%>

								<%If !Convert.IsDBNull(ExpiredTime) && Int32.Equals(DeliveredAmount, Amount) && (!String.Equals(Kind, "Host") || !Guid.Equals(ServerID, Guid.Empty))%>
									【<a id="Update<%=InnerID%>">续费</a>】
								<%EndIf%>
								
								<%If String.Equals(Kind, "Host") && !Guid.Equals(ServerID, Guid.Empty)%>
									<%If !Convert.ToBoolean(OnTrial)%>
										【<a href="host.aspx?ID=<%=InnerID%>">管理</a>】
									<%EndIf%>
									<ilghar:List Source="Manager.SplitToTable(ServerBindings)">
										<ilghar:Record>
											<a href="http://<%=[0]%>" target="_blank" style="display:block">http://<%=[0]%></a>
										</ilghar:Record>
									</ilghar:List>								
								<%EndIf%>
								
								<%If String.Equals(Kind, "WebSite") && !String.Equals(Convert.ToString(File), String.Empty)%>
									【<a href="<%=File%>" target="_blank">下载</a>】
									【<a id="Install<%=InnerID%>">安装</a>】
								<%EndIf%>
							</td>
						</tr>
					</ilghar:Record>
				</ilghar:List>
			</tbody>
		</table>
		<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ilghar:FirstPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif" alt="首页" />
							<img src="<%=ImagePath%>pagination/previous_page_off.gif" alt="上一页" />
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif" alt="首页" /></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif" alt="上一页" /></a>
						</ilghar:No>
					</ilghar:FirstPage>
					<ilghar:CurrentPage Range="5">
						<ilghar:Yes>
							<span class="Current"><%=Index%></span>						
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ilghar:No>
					</ilghar:CurrentPage>
					<ilghar:LastPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif" alt="下一页" />
							<img src="<%=ImagePath%>pagination/last_page_off.gif" alt="尾页" />
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif" alt="下一页" /></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif" alt="尾页" /></a>
						</ilghar:No>
					</ilghar:LastPage>
				</div>
			</div>
		</ilghar:Pagination>
	</div>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<%If PageLang == "UYG" || PageLang == "KZA" || PageLang == "KGA"%>
	<script type="text/javascript" src="<%=CommonPath%>IlgharIme.js"></script>
<%EndIf%>
<script type="text/javascript" src="<%=JsPath%>common.js"></script>
<script type="text/javascript" src="<%=JsPath%>host.js"></script>
</body>
</html>