﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.MemberPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否回收
	string isRecycled = Request.QueryString["IsRecycled"];
	if (isRecycled == null)
		condition.Append(Alias.Download.IsDeleted + "=false");
	else if (isRecycled != String.Empty)
		condition.Append(Alias.Download.IsDeleted + "=" + isRecycled);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否审核
	string isChecked = Request.QueryString["IsChecked"];
	if (isChecked == null)
		condition.Append(and + Alias.Download.IsChecked + "=true");
	else if (isChecked != String.Empty)
		condition.Append(and + Alias.Download.IsChecked + "=" + isChecked);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否推荐
	string isRecommended = Request.QueryString["IsRecommended"];
	if (!String.IsNullOrEmpty(isRecommended))
		condition.Append(and + Alias.Download.IsRecommended + "=" + isRecommended);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否置顶
	string isHeld = Request.QueryString["IsHeld"];
	if (!String.IsNullOrEmpty(isHeld))
		condition.Append(and + Alias.Download.IsHeld + "=" + isHeld);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 平台
	string platformID = Request.QueryString["PlatformID"];
	if (!String.IsNullOrEmpty(platformID))
	{
		if (platformID == "0")
			condition.Append(and + Alias.Download.PlatformPageIDs + " IS NULL");
		else
			condition.Append(and + Alias.Download.PlatformPageIDs + " LIKE '%" + platformID + "%'");
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 授权
	string licenseID = Request.QueryString["LicenseID"];
	if (!String.IsNullOrEmpty(licenseID))
	{
		if (licenseID == "0")
			condition.Append(and + Alias.Download.LicenseID + " IS NULL");
		else
			condition.Append(and + Alias.Download.LicenseID + "=" + licenseID);
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 类型
	string typeID = Request.QueryString["TypeID"];
	if (!String.IsNullOrEmpty(typeID))
	{
		if (typeID == "0")
			condition.Append(and + Alias.Download.TypeID + " IS NULL");
		else
			condition.Append(and + Alias.Download.TypeID + "=" + typeID);
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 语言
	string languageID = Request.QueryString["LanguageID"];
	if (!String.IsNullOrEmpty(languageID))
	{
		if (languageID == "0")
			condition.Append(and + Alias.Download.LanguageID + " IS NULL");
		else
			condition.Append(and + Alias.Download.LanguageID + "=" + languageID);
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 类别
	string categoryID = Request.QueryString["CategoryID"];
	if (!String.IsNullOrEmpty(categoryID))
	{
		if (Convert.ToBoolean(Request.QueryString["IncludeSubCategory"]))
		{
			condition.Append(and + Alias.Download.IncludeSubCategory + "=" + categoryID);
		}
		else
		{
			if (categoryID == "0")
				condition.Append(and + Alias.Download.CategoryID + " IS NULL");
			else
				condition.Append(and + Alias.Download.CategoryID + "=" + categoryID);
		}
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + Alias.Download.Name + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Download.UpdateTime + " DESC";
			break;
		case "2":
			sort = Alias.Download.UpdateTime + " ASC";
			break;
		case "3":
			sort = Alias.Download.HitCount + " DESC";
			break;
		case "4":
			sort = Alias.Download.HitCount + " ASC";
			break;
		case "5":
			sort = Alias.Download.Recommend + " DESC";
			break;
		case "6":
			sort = Alias.Download.Recommend + " ASC";
			break;
		case "7":
			sort = Alias.Download.Hold + " DESC";
			break;
		case "8":
			sort = Alias.Download.Hold + " ASC";
			break;
		case "9":
			sort = Alias.Download.InnerID + " DESC";
			break;
		case "10":
			sort = Alias.Download.InnerID + " ASC";
			break;
		case "11":
			sort = Alias.Download.Up + " DESC";
			break;
		case "12":
			sort = Alias.Download.Up + " ASC";
			break;
		case "13":
			sort = Alias.Download.Down + " DESC";
			break;
		case "14":
			sort = Alias.Download.Down + " ASC";
			break;
		case "15":
			sort = Alias.Download.Error + " DESC";
			break;
		case "16":
			sort = Alias.Download.Error + " ASC";
			break;
		case "17":
			sort = Alias.Download.DownCount + " DESC";
			break;
		case "18":
			sort = Alias.Download.DownCount + " ASC";
			break;
		default:
			sort = Alias.Download.UpdateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
	<thead>
		<tr>
			<th width="40">选择</th>
			<th>名称</th>
			<th width="115">更新日期</th>
			<th width="40">下载</th>
			<th width="40">人气</th>
			<th width="40">顶</th>
			<th width="40">踩</th>
			<th width="40">错误</th>
			<th width="60">地址列表</th>
		</tr>
	</thead>
	<tbody>
		<ilghar:List ID="List" Object="Download" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
			<ilghar:Record>
				<tr id="Row<%=InnerID%>">
					<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
					<td class="<%=PageLang%>Font"><a href="edit.aspx?ID=<%=InnerID%>"><%=Name%></a></td>
					<td><%=UpdateTime%></td>
					<td><%=DownCount%></td>
					<td><%=HitCount%></td>
					<td><%=Up%></td>
					<td><%=Down%></td>
					<td><%=Error%></td>
					<td><a href="url/list.aspx?DownloadID=<%=InnerID%>">地址列表</a></td>
				</tr>
			</ilghar:Record>
		</ilghar:List>
	</tbody>
</table>
<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ilghar:FirstPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:FirstPage>
			<ilghar:CurrentPage Range="5">
				<ilghar:Yes>
					<span class="Current"><%=Index%></span>						
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ilghar:No>
			</ilghar:CurrentPage>
			<ilghar:LastPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:LastPage>
		</div>
	</div>
</ilghar:Pagination>
