﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.MemberPageBase" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>文章列表</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否回收
	string isRecycled = Request.QueryString["IsRecycled"];
	if (isRecycled == null)
		condition.Append(Alias.Article.IsDeleted + "=false");
	else if (isRecycled != String.Empty)
		condition.Append(Alias.Article.IsDeleted + "=" + isRecycled);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否审核
	string isChecked = Request.QueryString["IsChecked"];
	if (isChecked == null)
		condition.Append(and + Alias.Article.IsChecked + "=true");
	else if (isChecked != String.Empty)
		condition.Append(and + Alias.Article.IsChecked + "=" + isChecked);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否推荐
	string isRecommended = Request.QueryString["IsRecommended"];
	if (!String.IsNullOrEmpty(isRecommended))
		condition.Append(and + Alias.Article.IsRecommended + "=" + isRecommended);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否置顶
	string isHeld = Request.QueryString["IsHeld"];
	if (!String.IsNullOrEmpty(isHeld))
		condition.Append(and + Alias.Article.IsHeld + "=" + isHeld);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 类别
	string categoryID = Request.QueryString["CategoryID"];
	if (!String.IsNullOrEmpty(categoryID))
	{
		if (Convert.ToBoolean(Request.QueryString["IncludeSubCategory"]))
		{
			condition.Append(and + Alias.Article.IncludeSubCategory + "=" + categoryID);
		}
		else
		{
			if (categoryID == "0")
				condition.Append(and + Alias.Article.CategoryID + " IS NULL");
			else
				condition.Append(and + Alias.Article.CategoryID + "=" + categoryID);
		}
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 类型
	string type = Request.QueryString["Type"];
	if (!String.IsNullOrEmpty(type))
		condition.Append(and + Alias.Article.Type + "='" + type + "'");
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Title")
			condition.Append(and + Alias.Article.Title + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "Content")
			condition.Append(and + Alias.Article.Content + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Article.UpdateTime + " DESC";
			break;
		case "2":
			sort = Alias.Article.UpdateTime + " ASC";
			break;
		case "3":
			sort = Alias.Article.HitCount + " DESC";
			break;
		case "4":
			sort = Alias.Article.HitCount + " ASC";
			break;
		case "5":
			sort = Alias.Article.Recommend + " DESC";
			break;
		case "6":
			sort = Alias.Article.Recommend + " ASC";
			break;
		case "7":
			sort = Alias.Article.Hold + " DESC";
			break;
		case "8":
			sort = Alias.Article.Hold + " ASC";
			break;
		case "9":
			sort = Alias.Article.InnerID + " DESC";
			break;
		case "10":
			sort = Alias.Article.InnerID + " ASC";
			break;
		case "11":
			sort = Alias.Article.Up + " DESC";
			break;
		case "12":
			sort = Alias.Article.Up + " ASC";
			break;
		case "13":
			sort = Alias.Article.Down + " DESC";
			break;
		case "14":
			sort = Alias.Article.Down + " ASC";
			break;
		default:
			sort = Alias.Article.UpdateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<script type="text/javascript">
var _page = "article_list";
var _webPath = "<%=WebPath%>";
var _isLocked = <%=Convert.ToString(User["IsLocked"]).ToLower()%>;
var _lang_locked = "你被锁定，不能操作！";
var _lang_working = "正在操作...";
var _lang_operation_success = "操作成功！";
var _lang_operation_fail = "操作失败！";
var _lang_selection_empty = "没有任何项被选择！";
var _lang_confirm_delete = "真的要删除吗？";
var _lang_recycle = "回收";
var _lang_delete = "删除";
var _lang_recover = "还原";
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame_flipCHS.gif" alt="关闭侧栏导航" /></div>
	<div class="Title">文章列表</div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left Selected"></li>
		<li class="Middle Selected">文章列表</li>
		<li class="Right Selected"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="add.aspx">添加文章</a></li>
		<li class="Right"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<select id="IsRecycled">
			<option value="">是否回收</option>
			<option value="false" selected="selected">未回收</option>
			<option value="true">已回收</option>
		</select>
		<select id="IsChecked">
			<option value="">是否审核</option>
			<option value="false">未审核</option>
			<option value="true" selected="selected">已审核</option>
		</select>
		<select id="IsRecommended">
			<option value="">是否推荐</option>
			<option value="false">未推荐</option>
			<option value="true">已推荐</option>
		</select>
		<select id="IsHeld">
			<option value="">是否置顶</option>
			<option value="false">未置顶</option>
			<option value="true">已置顶</option>
		</select>
		<select id="CategoryID">
			<option value="">所有类别</option>
			<option value="0">未指定</option>
			<ilghar:Tree Object="ArticleCategory">
				<ilghar:Control>
					<ilghar:Space>&nbsp;&nbsp;</ilghar:Space>
					<ilghar:Line>│</ilghar:Line>
					<ilghar:TopOpen>┌</ilghar:TopOpen>
					<ilghar:Top>┌</ilghar:Top>
					<ilghar:MiddleOpen>├</ilghar:MiddleOpen>
					<ilghar:Middle>├</ilghar:Middle>
					<ilghar:BottomOpen>└</ilghar:BottomOpen>
					<ilghar:Bottom>└</ilghar:Bottom>
				</ilghar:Control>
				<ilghar:Record>
					<option value="<%=ID%>"><%=Control%><%=Name%></option>
					<%=ChildRecords%>
				</ilghar:Record>
			</ilghar:Tree>
		</select>
		<input type="checkbox" id="IncludeSubCategory" /><label for="IncludeSubCategory">包括子类</label>
		<select id="Type">
			<option value="">所有类型</option>
			<option value="Text">文本</option>
			<option value="Picture">图片</option>
			<option value="Audio">音频</option>
			<option value="Video">视频</option>
			<option value="Flash">Flash</option>
			<option value="File">文件</option>
		</select>
	</div>
	<div class="ToolBar">
		<select id="Sort">
			<option value="1">更新日期↓</option>
			<option value="2">更新日期↑</option>
			<option value="3">人气↓</option>
			<option value="4">人气↑</option>
			<option value="5">推荐↓</option>
			<option value="6">推荐↑</option>
			<option value="7">置顶↓</option>
			<option value="8">置顶↑</option>
			<option value="9">编号↓</option>
			<option value="10">编号↑</option>
			<option value="11">顶↓</option>
			<option value="12">顶↑</option>
			<option value="13">踩↓</option>
			<option value="14">踩↑</option>
		</select>
		<input id="Keyword" class="Text <%=PageLang%>Font" />
		<select id="KeywordType">
			<option value="Title">标题</option>
			<option value="Content">内容</option>
		</select>
		<input type="button" id="Search" value="搜索" class="Button" />
		<input type="button" id="SelectAll" value="全选" class="Button" />
		<input type="button" id="ReverseSelect" value="反选" class="Button" />
		<span id="ExtraButton"></span>
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1">
			<thead>
				<tr>
					<th width="40">选择</th>
					<th>标题</th>
					<th width="115">更新时间</th>
					<th width="40">点击</th>
					<th width="40">顶</th>
					<th width="40">踩</th>
				</tr>
			</thead>
			<tbody>
				<ilghar:List ID="List" Object="Article" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
					<ilghar:Record>
						<tr id="Row<%=InnerID%>">
							<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
							<td><a href="edit.aspx?ID=<%=InnerID%>"><%=Title%></a></td>
							<td><%=UpdateTime%></td>
							<td><%=HitCount%></td>
							<td><%=Up%></td>
							<td><%=Down%></td>
						</tr>
					</ilghar:Record>
				</ilghar:List>
			</tbody>
		</table>
		<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ilghar:FirstPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif" alt="首页" />
							<img src="<%=ImagePath%>pagination/previous_page_off.gif" alt="上一页" />
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif" alt="首页" /></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif" alt="上一页" /></a>
						</ilghar:No>
					</ilghar:FirstPage>
					<ilghar:CurrentPage Range="5">
						<ilghar:Yes>
							<span class="Current"><%=Index%></span>						
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ilghar:No>
					</ilghar:CurrentPage>
					<ilghar:LastPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif" alt="下一页" />
							<img src="<%=ImagePath%>pagination/last_page_off.gif" alt="尾页" />
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif" alt="下一页" /></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif" alt="尾页" /></a>
						</ilghar:No>
					</ilghar:LastPage>
				</div>
			</div>
		</ilghar:Pagination>
	</div>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<%If PageLang == "UYG" || PageLang == "KZA" || PageLang == "KGA"%>
	<script type="text/javascript" src="<%=CommonPath%>IlgharIme.js"></script>
<%EndIf%>
<script type="text/javascript" src="<%=JsPath%>common.js"></script>
<script type="text/javascript" src="<%=JsPath%>article.js"></script>
</body>
</html>