﻿using System;
using System.Data;
using System.Xml;
using System.Collections.Generic;
using System.Collections;
using System.Text;
using System.Web;
using IlgharCMS;
using IlgharCMS.ArticleModule;
public partial class CIlgharCMS : IlgharCMS.Lib.AdminPageBase
{
public CIlgharCMS()
: base("IlgharCMS.ArticleModule/article/ajax_list.dwt.aspx")
{}
protected XmlDocument _xmlTemplate;
protected override void OnInit(EventArgs e)
{
base.OnInit(e);
_xmlTemplate = XmlData.GetXmlDocument();
if (!String.IsNullOrEmpty(Request.QueryString["GetPageCount"]))
                            {
                                Response.Write(t5774);
                                Response.End();
                            }
                        
}

protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否回收
	string isRecycled = Request.QueryString["IsRecycled"];
	if (isRecycled == null)
		condition.Append(Alias.Article.IsDeleted + "=false");
	else if (isRecycled != String.Empty)
		condition.Append(Alias.Article.IsDeleted + "=" + isRecycled);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否审核
	string isChecked = Request.QueryString["IsChecked"];
	if (isChecked == null)
		condition.Append(and + Alias.Article.IsChecked + "=true");
	else if (isChecked != String.Empty)
		condition.Append(and + Alias.Article.IsChecked + "=" + isChecked);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否推荐
	string isRecommended = Request.QueryString["IsRecommended"];
	if (!String.IsNullOrEmpty(isRecommended))
		condition.Append(and + Alias.Article.IsRecommended + "=" + isRecommended);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否置顶
	string isHeld = Request.QueryString["IsHeld"];
	if (!String.IsNullOrEmpty(isHeld))
		condition.Append(and + Alias.Article.IsHeld + "=" + isHeld);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 类别
	string categoryID = Request.QueryString["CategoryID"];
	if (!String.IsNullOrEmpty(categoryID))
	{
		if (Convert.ToBoolean(Request.QueryString["IncludeSubCategory"]))
		{
			condition.Append(and + Alias.Article.IncludeSubCategory + "=" + categoryID);
		}
		else
		{
			if (categoryID == "0")
				condition.Append(and + Alias.Article.CategoryID + " IS NULL");
			else
				condition.Append(and + Alias.Article.CategoryID + "=" + categoryID);
		}
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 类型
	string type = Request.QueryString["Type"];
	if (!String.IsNullOrEmpty(type))
		condition.Append(and + Alias.Article.Type + "='" + type + "'");
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Title")
			condition.Append(and + Alias.Article.Title + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "Content")
			condition.Append(and + Alias.Article.Content + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "SpecialName")
			condition.Append(and + Alias.Article.SpecialName + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "SpecialID")
			condition.Append(and + Alias.Article.SpecialID + "=" + keyword);
		else if (Request.QueryString["KeywordType"] == "Creator")
			condition.Append(and + Alias.Article.Creator + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Article.UpdateTime + " DESC";
			break;
		case "2":
			sort = Alias.Article.UpdateTime + " ASC";
			break;
		case "3":
			sort = Alias.Article.HitCount + " DESC";
			break;
		case "4":
			sort = Alias.Article.HitCount + " ASC";
			break;
		case "5":
			sort = Alias.Article.Recommend + " DESC";
			break;
		case "6":
			sort = Alias.Article.Recommend + " ASC";
			break;
		case "7":
			sort = Alias.Article.Hold + " DESC";
			break;
		case "8":
			sort = Alias.Article.Hold + " ASC";
			break;
		case "9":
			sort = Alias.Article.InnerID + " DESC";
			break;
		case "10":
			sort = Alias.Article.InnerID + " ASC";
			break;
		case "11":
			sort = Alias.Article.Up + " DESC";
			break;
		case "12":
			sort = Alias.Article.Up + " ASC";
			break;
		case "13":
			sort = Alias.Article.Down + " DESC";
			break;
		case "14":
			sort = Alias.Article.Down + " ASC";
			break;
		default:
			sort = Alias.Article.UpdateTime + " DESC";
			break;
	}
	
	return sort;
}

protected bool Move
{
	get
	{
		if (Request.QueryString["Sort"] == "5" || Request.QueryString["Sort"] == "6")
			return Request.QueryString["IsRecommended"] == "true";
		else if (Request.QueryString["Sort"] == "7" || Request.QueryString["Sort"] == "8")
			return Request.QueryString["IsHeld"] == "true";
		else
			return false;
	}
}

                        protected int ListRecordCount
                        {
                            get
                            {
                                int instanceID;
instanceID = InstanceID;
                                using (IlgharCMS.ArticleModule.IArticle bll = (IlgharCMS.ArticleModule.IArticle)Manager.CreateObject("Article", instanceID, ContentLang, false))
                                {
                                    string condition = null;
condition += Condition();


                                    return bll.GetRecordCount(condition);
                                }
                            }
                        }
                        
                            protected int ListCounter = 0;
                            protected object ListRecord = null;
                            private DataTable ListData;
                            protected DataTable List
                            {
                                get
                                {
                                    if (ListData != null)
                                        return ListData;

                                    ListData = List_;
                                    return ListData;
                                }
                            }
                        
                                private DataTable List_
                                {
                                    get
                                    {
                                        string condition = null;
condition += Condition();


                                        string sort = null;sort = Sort();

                                        int instanceID;
instanceID = InstanceID;

                                        using (IlgharCMS.ArticleModule.IArticle bll = (IlgharCMS.ArticleModule.IArticle)Manager.CreateObject("Article", instanceID, ContentLang, false))
                                        {
                                            ListData = bll.List(Convert.ToInt32(PageNumber), 20, condition, sort);
                                        }

                                        return ListData;
                                    }
                                }
                            
                            protected string t5093
                            {
                                get
                                {
                                    XmlNode node = _xmlTemplate.SelectSingleNode("//t5093");
                                    Dictionary<string, object> replacementPair = new Dictionary<string, object>();
                                    
                                        replacementPair["{#t5313#}"] = new CustomBuild(
                                                                        delegate(DataRow record, int index)
                                                                        {string t5313 = String.Empty;
if (Move)
{t5313 = _xmlTemplate.SelectSingleNode("/" + "/t5313/If").InnerText;object t5397 = ImagePath;
t5313 = t5313.Replace("{#t5397#}",t5397 == null ? "" : t5397.ToString());
}

                                                                            return t5313;
                                                                        }
                                                                        );
                                                
                                        replacementPair[@"{#ContentLang#}"] = new CustomBuild(
                                                                        delegate(DataRow record, int index)
                                                                        {
                                                                            object t5462 = ContentLang;
                                                                            if (t5462 != null)
                                                                                return t5462.ToString();
                                                                            else
                                                                                return String.Empty;
                                                                        }
                                                                        );
                                                replacementPair["{#InnerID#}"] = IlgharCMS.ArticleModule.Alias.Article.InnerID;replacementPair["{#Title#}"] = IlgharCMS.ArticleModule.Alias.Article.Title;replacementPair["{#Creator#}"] = IlgharCMS.ArticleModule.Alias.Article.Creator;replacementPair["{#UpdateTime#}"] = IlgharCMS.ArticleModule.Alias.Article.UpdateTime;replacementPair["{#HitCount#}"] = IlgharCMS.ArticleModule.Alias.Article.HitCount;replacementPair["{#Up#}"] = IlgharCMS.ArticleModule.Alias.Article.Up;replacementPair["{#Down#}"] = IlgharCMS.ArticleModule.Alias.Article.Down;
                                    StringBuilder all = Manager.Build(node, List_, replacementPair, ref ListRecord, ref ListCounter);
                                    
                                    
                                    
                                    return all.ToString();
                                }
                            }
                          
                            
                        private string t5774URL_ = null;
                        private string t5774URL
                        {
                            get
                            {
                                if (t5774URL_ != null)
                                    return t5774URL_;

                                StringBuilder result = new StringBuilder("?Page={Page}");
                                for (int i = 0; i < Request.QueryString.Count; i++)
                                {
                                    if (Request.QueryString.GetKey(i).ToLower() == "page")
                                        continue;

                                    result.Append("&amp;" + Request.QueryString.GetKey(i) + "=" + Server.UrlEncode(Request.QueryString[i]));
                                }

                                t5774URL_ = result.ToString();
                                return t5774URL_;
                            }
                        }
                        
                            private int t5774Page;
                            private int t5774PageCount;
                            private int t5774RecordCount;
                            private int t5774PageSize;
                            private int t5774Index;
                            protected string t5774
                            {
                                get
                                {
                                    t5774Page = Convert.ToInt32(PageNumber);
                                    if (t5774Page <= 0)
                                        t5774Page = 1;
                                    t5774PageSize = 20;
                                    t5774RecordCount = Convert.ToInt32(ListRecordCount);

                                    XmlNode node = _xmlTemplate.SelectSingleNode("//t5774");

                                    StringBuilder all = new StringBuilder(node.SelectSingleNode("All").InnerText);

                                    t5774PageCount = t5774RecordCount / t5774PageSize;
                                    if (t5774RecordCount % t5774PageSize > 0)
                                        t5774PageCount += 1;

                                    if (!String.IsNullOrEmpty(Request.QueryString["GetPageCount"]))
                                        return t5774PageCount.ToString();

                                    //--------------------------------------
                                    //Start : FirstPage
                                    StringBuilder firstPage = new StringBuilder();
                                    string firstPageYesTpl = node.SelectSingleNode("FirstPage/Yes").InnerText;
                                    string firstPageNoTpl = node.SelectSingleNode("FirstPage/No").InnerText;
                                    if (t5774Page > 1)
                                    {
                                        firstPage.Append(firstPageNoTpl);
                                        object t6266 = ImagePath;
firstPage.Replace("{#t6266#}", t6266 == null ? "" : t6266.ToString());
object t6345 = PageNumber;
firstPage.Replace("{#t6345#}", t6345 == null ? "" : t6345.ToString());
object t6391 = ImagePath;
firstPage.Replace("{#t6391#}", t6391 == null ? "" : t6391.ToString());

                                    }
                                    else
                                    {
                                        firstPage.Append(firstPageYesTpl);
                                        object t6074 = ImagePath;
firstPage.Replace("{#t6074#}", t6074 == null ? "" : t6074.ToString());
object t6137 = ImagePath;
firstPage.Replace("{#t6137#}", t6137 == null ? "" : t6137.ToString());

                                    }
                                    all.Replace("{#FirstPage#}", firstPage.ToString());
                                    //End : FirstPage
                                    //--------------------------------------

                                    //--------------------------------------
                                    //Start : CurrentPage
                                    StringBuilder currentPage = new StringBuilder();

                                    if (t5774PageCount > 1)
                                    {
                                        string currentPageYesTpl = node.SelectSingleNode("CurrentPage/Yes").InnerText;
                                        string currentPageNoTpl = node.SelectSingleNode("CurrentPage/No").InnerText;

                                        bool isAll = false;
                                        int pageEnd = 0;
                                        if (isAll)
                                        {
                                            t5774Index = 1;
                                            pageEnd = t5774PageCount;
                                        }
                                        else
                                        {
                                            t5774Index = t5774Page - 5;
                                            if (t5774Index <= 0)
                                                t5774Index = 1;

                                            pageEnd = t5774Page + 5;
                                            if (pageEnd > t5774PageCount)
                                                pageEnd = t5774PageCount;
                                        }

                                        while (t5774Index <= pageEnd)
                                        {
                                            if (t5774Index == t5774Page)
                                            {
                                                currentPage.Append(currentPageYesTpl);
                                                object t6567 = t5774Index;
currentPage.Replace("{#t6567#}", t6567 == null ? "" : t6567.ToString());

                                            }
                                            else
                                            {
                                                currentPage.Append(currentPageNoTpl);
                                                object t6656 = t5774Index;
currentPage.Replace("{#t6656#}", t6656 == null ? "" : t6656.ToString());
object t6670 = t5774Index;
currentPage.Replace("{#t6670#}", t6670 == null ? "" : t6670.ToString());

                                            }
                                            t5774Index++;
                                        }
                                    }
                                    all.Replace("{#CurrentPage#}", currentPage.ToString());
                                    //End : CurrentPage
                                    //--------------------------------------

                                    //--------------------------------------
                                    //Start : LastPage
                                    StringBuilder lastPage = new StringBuilder();

                                    string lastPageYesTpl = node.SelectSingleNode("LastPage/Yes").InnerText;
                                    string lastPageNoTpl = node.SelectSingleNode("LastPage/No").InnerText;

                                    if (t5774Page < t5774PageCount)
                                    {
                                        lastPage.Append(lastPageNoTpl);
                                        object t6959 = PageNumber;
lastPage.Replace("{#t6959#}", t6959 == null ? "" : t6959.ToString());
object t7005 = ImagePath;
lastPage.Replace("{#t7005#}", t7005 == null ? "" : t7005.ToString());
object t7083 = t5774PageCount;
lastPage.Replace("{#t7083#}", t7083 == null ? "" : t7083.ToString());
object t7110 = ImagePath;
lastPage.Replace("{#t7110#}", t7110 == null ? "" : t7110.ToString());

                                    }
                                    else
                                    {
                                        lastPage.Append(lastPageYesTpl);
                                        object t6786 = ImagePath;
lastPage.Replace("{#t6786#}", t6786 == null ? "" : t6786.ToString());
object t6848 = ImagePath;
lastPage.Replace("{#t6848#}", t6848 == null ? "" : t6848.ToString());

                                    }
                                    all.Replace("{#LastPage#}", lastPage.ToString());
                                    //End : LastPage
                                    //--------------------------------------

                                    object t5908 = t5774RecordCount;
all.Replace("{#t5908#}", t5908 == null ? "" : t5908.ToString());
object t5933 = PageNumber;
all.Replace("{#t5933#}", t5933 == null ? "" : t5933.ToString());
object t5953 = (t5774Page - 1) * t5774PageSize + 1;
all.Replace("{#t5953#}", t5953 == null ? "" : t5953.ToString());
object t5969 = t5774RecordCount < t5774Page * t5774PageSize ? t5774RecordCount : t5774Page * t5774PageSize;
all.Replace("{#t5969#}", t5969 == null ? "" : t5969.ToString());


                                    return all.ToString();
                                }
                            }
                          }
