/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0014B\u001f\b\u0002\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\rH\u0096\u0002R\u001e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0005X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lokio/Options;", "Ljava/util/AbstractList;", "Lokio/ByteString;", "Ljava/util/RandomAccess;", "byteStrings", "", "trie", "", "([Lokio/ByteString;[I)V", "getByteStrings$jvm", "()[Lokio/ByteString;", "[Lokio/ByteString;", "size", "", "getSize", "()I", "getTrie$jvm", "()[I", "get", "index", "Companion", "jvm"})
public final class Options
extends AbstractList<ByteString>
implements RandomAccess {
    @NotNull
    private final ByteString[] byteStrings;
    @NotNull
    private final int[] trie;
    public static final Companion Companion = new Companion(null);

    public int getSize() {
        return this.byteStrings.length;
    }

    @Override
    @NotNull
    public ByteString get(int index) {
        return this.byteStrings[index];
    }

    @NotNull
    public final ByteString[] getByteStrings$jvm() {
        return this.byteStrings;
    }

    @NotNull
    public final int[] getTrie$jvm() {
        return this.trie;
    }

    private Options(ByteString[] byteStrings, int[] trie) {
        this.byteStrings = byteStrings;
        this.trie = trie;
    }

    public /* synthetic */ Options(@NotNull ByteString[] byteStrings, @NotNull int[] trie, DefaultConstructorMarker $constructor_marker) {
        this(byteStrings, trie);
    }

    @JvmStatic
    @NotNull
    public static final Options of(ByteString ... byteStrings) {
        return Companion.of(byteStrings);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JT\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\r2\b\b\u0002\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002J!\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0016\"\u00020\u0010H\u0007\u00a2\u0006\u0002\u0010\u0017R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lokio/Options$Companion;", "", "()V", "intCount", "", "Lokio/Buffer;", "getIntCount", "(Lokio/Buffer;)J", "buildTrieRecursive", "", "nodeOffset", "node", "byteStringOffset", "", "byteStrings", "", "Lokio/ByteString;", "fromIndex", "toIndex", "indexes", "of", "Lokio/Options;", "", "([Lokio/ByteString;)Lokio/Options;", "jvm"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Options of(ByteString ... byteStrings) {
            Object item$iv$iv;
            int n;
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)byteStrings, (String)"byteStrings");
            ByteString[] byteStringArray = byteStrings;
            if (byteStringArray.length == 0) {
                return new Options(new ByteString[0], new int[]{0, -1}, null);
            }
            List list = ArraysKt.toMutableList((Object[])byteStrings);
            CollectionsKt.sort((List)list);
            Object $receiver$iv = byteStrings;
            ByteString[] byteStringArray2 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(((ByteString[])$receiver$iv).length);
            int n2 = ((void)$receiver$iv$iv).length;
            for (n = 0; n < n2; ++n) {
                item$iv$iv = $receiver$iv$iv[n];
                void var10_18 = item$iv$iv;
                Collection collection = destination$iv$iv;
                Integer n3 = -1;
                collection.add(n3);
            }
            $receiver$iv = (List)destination$iv$iv;
            Object thisCollection$iv = $receiver$iv;
            Integer[] integerArray = thisCollection$iv.toArray(new Integer[0]);
            if (integerArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            List indexes = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(integerArray, integerArray.length));
            $receiver$iv = byteStrings;
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void byteString;
                int n4 = index$iv++;
                item$iv$iv = item$iv;
                int callerIndex = n4;
                int sortedIndex = CollectionsKt.binarySearch$default((List)list, (Comparable)((Comparable)byteString), (int)0, (int)0, (int)6, null);
                indexes.set(sortedIndex, callerIndex);
            }
            boolean bl = $receiver$iv = ((ByteString)list.get(0)).size() > 0;
            if (!$receiver$iv) {
                String $i$f$toTypedArray = "the empty byte string is not a supported option";
                throw (Throwable)new IllegalArgumentException($i$f$toTypedArray.toString());
            }
            for (int a = 0; a < list.size(); ++a) {
                ByteString byteString;
                ByteString prefix = (ByteString)list.get(a);
                int b = a + 1;
                while (b < list.size() && (byteString = (ByteString)list.get(b)).startsWith(prefix)) {
                    int n5 = n = byteString.size() != prefix.size() ? 1 : 0;
                    if (n == 0) {
                        String string = "duplicate option: " + byteString;
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    if (((Number)indexes.get(b)).intValue() > ((Number)indexes.get(a)).intValue()) {
                        list.remove(b);
                        indexes.remove(b);
                        continue;
                    }
                    ++b;
                }
            }
            Buffer trieBytes = new Buffer();
            okio.Options$Companion.buildTrieRecursive$default(this, 0L, trieBytes, 0, list, 0, 0, indexes, 53, null);
            int[] trie = new int[(int)this.getIntCount(trieBytes)];
            int i = 0;
            while (!trieBytes.exhausted()) {
                trie[i++] = trieBytes.readInt();
            }
            return new Options((ByteString[])byteStrings.clone(), trie, null);
        }

        /*
         * WARNING - void declaration
         */
        private final void buildTrieRecursive(long nodeOffset, Buffer node, int byteStringOffset, List<? extends ByteString> byteStrings, int fromIndex, int toIndex, List<Integer> indexes) {
            int n;
            int n2 = n = fromIndex < toIndex ? 1 : 0;
            if (n == 0) {
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            n = fromIndex;
            int n3 = toIndex;
            while (n < n3) {
                void i;
                boolean bl;
                boolean bl2 = bl = byteStrings.get((int)i).size() >= byteStringOffset;
                if (!bl) {
                    String string = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                ++i;
            }
            int fromIndex2 = fromIndex;
            ByteString from = byteStrings.get(fromIndex2);
            ByteString to = byteStrings.get(toIndex - 1);
            int prefixIndex = -1;
            if (byteStringOffset == from.size()) {
                prefixIndex = ((Number)indexes.get(fromIndex2)).intValue();
                from = byteStrings.get(++fromIndex2);
            }
            if (from.getByte(byteStringOffset) != to.getByte(byteStringOffset)) {
                int other$iv;
                byte rangeByte;
                int selectChoiceCount = 1;
                int n4 = fromIndex2 + 1;
                int n5 = toIndex;
                while (n4 < n5) {
                    void i;
                    if (byteStrings.get((int)(i - true)).getByte(byteStringOffset) != byteStrings.get((int)i).getByte(byteStringOffset)) {
                        ++selectChoiceCount;
                    }
                    ++i;
                }
                long childNodesOffset = nodeOffset + this.getIntCount(node) + (long)2 + (long)(selectChoiceCount * 2);
                node.writeInt(selectChoiceCount);
                node.writeInt(prefixIndex);
                int n6 = fromIndex2;
                int n7 = toIndex;
                while (n6 < n7) {
                    void i;
                    rangeByte = byteStrings.get((int)i).getByte(byteStringOffset);
                    if (i == fromIndex2 || rangeByte != byteStrings.get((int)(i - true)).getByte(byteStringOffset)) {
                        void $receiver$iv;
                        byte by = rangeByte;
                        int n8 = 255;
                        Buffer buffer = node;
                        int n9 = $receiver$iv & other$iv;
                        buffer.writeInt(n9);
                    }
                    ++i;
                }
                Buffer childNodes = new Buffer();
                int rangeStart = fromIndex2;
                while (rangeStart < toIndex) {
                    rangeByte = byteStrings.get(rangeStart).getByte(byteStringOffset);
                    int rangeEnd = toIndex;
                    other$iv = rangeStart + 1;
                    int n10 = toIndex;
                    while (other$iv < n10) {
                        void i;
                        if (rangeByte != byteStrings.get((int)i).getByte(byteStringOffset)) {
                            rangeEnd = i;
                            break;
                        }
                        ++i;
                    }
                    if (rangeStart + 1 == rangeEnd && byteStringOffset + 1 == byteStrings.get(rangeStart).size()) {
                        node.writeInt(((Number)indexes.get(rangeStart)).intValue());
                    } else {
                        node.writeInt(-1 * (int)(childNodesOffset + this.getIntCount(childNodes)));
                        this.buildTrieRecursive(childNodesOffset, childNodes, byteStringOffset + 1, byteStrings, rangeStart, rangeEnd, indexes);
                    }
                    rangeStart = rangeEnd;
                }
                node.writeAll(childNodes);
            } else {
                int i;
                void i2;
                int scanByteCount = 0;
                int childNodesOffset = byteStringOffset;
                int childNodes = from.size();
                int n11 = to.size();
                int n12 = Math.min(childNodes, n11);
                while (childNodesOffset < n12 && from.getByte((int)i2) == to.getByte((int)i2)) {
                    ++scanByteCount;
                    ++i2;
                }
                long childNodesOffset2 = nodeOffset + this.getIntCount(node) + (long)2 + (long)scanByteCount + 1L;
                node.writeInt(-scanByteCount);
                node.writeInt(prefixIndex);
                childNodes = byteStringOffset;
                n11 = byteStringOffset + scanByteCount;
                while (childNodes < n11) {
                    void other$iv;
                    void $receiver$iv;
                    byte rangeByte = from.getByte(i);
                    int rangeEnd = 255;
                    Buffer buffer = node;
                    int n13 = $receiver$iv & other$iv;
                    buffer.writeInt(n13);
                    ++i;
                }
                if (fromIndex2 + 1 == toIndex) {
                    int n14 = i = byteStringOffset + scanByteCount == byteStrings.get(fromIndex2).size() ? 1 : 0;
                    if (i == 0) {
                        String string = "Check failed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    node.writeInt(((Number)indexes.get(fromIndex2)).intValue());
                } else {
                    Buffer childNodes2 = new Buffer();
                    node.writeInt(-1 * (int)(childNodesOffset2 + this.getIntCount(childNodes2)));
                    this.buildTrieRecursive(childNodesOffset2, childNodes2, byteStringOffset + scanByteCount, byteStrings, fromIndex2, toIndex, indexes);
                    node.writeAll(childNodes2);
                }
            }
        }

        static /* bridge */ /* synthetic */ void buildTrieRecursive$default(Companion companion, long l, Buffer buffer, int n, List list, int n2, int n3, List list2, int n4, Object object) {
            if ((n4 & 1) != 0) {
                l = 0L;
            }
            if ((n4 & 4) != 0) {
                n = 0;
            }
            if ((n4 & 0x10) != 0) {
                n2 = 0;
            }
            if ((n4 & 0x20) != 0) {
                n3 = list.size();
            }
            companion.buildTrieRecursive(l, buffer, n, list, n2, n3, list2);
        }

        private final long getIntCount(@NotNull Buffer $receiver) {
            return $receiver.size() / (long)4;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

