/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.-Util;
import okio.Buffer;
import okio.Segment;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u0004J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\rJ\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\rJ\u0012\u0010\u000f\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0014J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\tH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lokio/AsyncTimeout;", "Lokio/Timeout;", "()V", "inQueue", "", "next", "timeoutAt", "", "enter", "", "exit", "Ljava/io/IOException;", "cause", "exit$jvm", "throwOnTimeout", "newTimeoutException", "remainingNanos", "now", "sink", "Lokio/Sink;", "source", "Lokio/Source;", "timedOut", "Companion", "Watchdog", "jvm"})
public class AsyncTimeout
extends Timeout {
    private boolean inQueue;
    private AsyncTimeout next;
    private long timeoutAt;
    private static final int TIMEOUT_WRITE_SIZE = 65536;
    private static final long IDLE_TIMEOUT_MILLIS;
    private static final long IDLE_TIMEOUT_NANOS;
    private static AsyncTimeout head;
    public static final Companion Companion;

    public final void enter() {
        boolean bl;
        boolean bl2 = bl = !this.inQueue;
        if (!bl) {
            String string = "Unbalanced enter/exit";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        long timeoutNanos = this.timeoutNanos();
        boolean hasDeadline = this.hasDeadline();
        if (timeoutNanos == 0L && !hasDeadline) {
            return;
        }
        this.inQueue = true;
        AsyncTimeout.Companion.scheduleTimeout(this, timeoutNanos, hasDeadline);
    }

    public final boolean exit() {
        if (!this.inQueue) {
            return false;
        }
        this.inQueue = false;
        return AsyncTimeout.Companion.cancelScheduledTimeout(this);
    }

    private final long remainingNanos(long now) {
        return this.timeoutAt - now;
    }

    protected void timedOut() {
    }

    @NotNull
    public final Sink sink(@NotNull Sink sink2) {
        Intrinsics.checkParameterIsNotNull((Object)sink2, (String)"sink");
        return new Sink(this, sink2){
            final /* synthetic */ AsyncTimeout this$0;
            final /* synthetic */ Sink $sink;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(@NotNull Buffer source2, long byteCount) {
                Intrinsics.checkParameterIsNotNull((Object)source2, (String)"source");
                -Util.checkOffsetAndCount(source2.size(), 0L, byteCount);
                long remaining = byteCount;
                while (remaining > 0L) {
                    long toWrite = 0L;
                    if (source2.head == null) {
                        Intrinsics.throwNpe();
                    }
                    while (toWrite < (long)65536) {
                        Segment s;
                        int segmentSize = s.limit - s.pos;
                        if ((toWrite += (long)segmentSize) >= remaining) {
                            toWrite = remaining;
                            break;
                        }
                        if (s.next != null) continue;
                        Intrinsics.throwNpe();
                    }
                    boolean throwOnTimeout = false;
                    this.this$0.enter();
                    try {
                        this.$sink.write(source2, toWrite);
                        remaining -= toWrite;
                        throwOnTimeout = true;
                    }
                    catch (IOException e) {
                        throw (Throwable)this.this$0.exit$jvm(e);
                    }
                    finally {
                        this.this$0.exit$jvm(throwOnTimeout);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void flush() {
                boolean throwOnTimeout = false;
                this.this$0.enter();
                try {
                    this.$sink.flush();
                    throwOnTimeout = true;
                }
                catch (IOException e) {
                    throw (Throwable)this.this$0.exit$jvm(e);
                }
                finally {
                    this.this$0.exit$jvm(throwOnTimeout);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() {
                boolean throwOnTimeout = false;
                this.this$0.enter();
                try {
                    this.$sink.close();
                    throwOnTimeout = true;
                }
                catch (IOException e) {
                    throw (Throwable)this.this$0.exit$jvm(e);
                }
                finally {
                    this.this$0.exit$jvm(throwOnTimeout);
                }
            }

            @NotNull
            public AsyncTimeout timeout() {
                return this.this$0;
            }

            @NotNull
            public String toString() {
                return "AsyncTimeout.sink(" + this.$sink + ')';
            }
            {
                this.this$0 = $outer;
                this.$sink = $captured_local_variable$1;
            }
        };
    }

    @NotNull
    public final Source source(@NotNull Source source2) {
        Intrinsics.checkParameterIsNotNull((Object)source2, (String)"source");
        return new Source(this, source2){
            final /* synthetic */ AsyncTimeout this$0;
            final /* synthetic */ Source $source;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long read(@NotNull Buffer sink2, long byteCount) {
                Intrinsics.checkParameterIsNotNull((Object)sink2, (String)"sink");
                boolean throwOnTimeout = false;
                this.this$0.enter();
                try {
                    long result = this.$source.read(sink2, byteCount);
                    throwOnTimeout = true;
                    long l = result;
                    return l;
                }
                catch (IOException e) {
                    throw (Throwable)this.this$0.exit$jvm(e);
                }
                finally {
                    this.this$0.exit$jvm(throwOnTimeout);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() {
                boolean throwOnTimeout = false;
                try {
                    this.$source.close();
                    throwOnTimeout = true;
                }
                catch (IOException e) {
                    throw (Throwable)this.this$0.exit$jvm(e);
                }
                finally {
                    this.this$0.exit$jvm(throwOnTimeout);
                }
            }

            @NotNull
            public AsyncTimeout timeout() {
                return this.this$0;
            }

            @NotNull
            public String toString() {
                return "AsyncTimeout.source(" + this.$source + ')';
            }
            {
                this.this$0 = $outer;
                this.$source = $captured_local_variable$1;
            }
        };
    }

    public final void exit$jvm(boolean throwOnTimeout) {
        boolean timedOut = this.exit();
        if (timedOut && throwOnTimeout) {
            throw (Throwable)this.newTimeoutException(null);
        }
    }

    @NotNull
    public final IOException exit$jvm(@NotNull IOException cause) {
        Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
        return !this.exit() ? cause : this.newTimeoutException(cause);
    }

    @NotNull
    protected IOException newTimeoutException(@Nullable IOException cause) {
        InterruptedIOException e = new InterruptedIOException("timeout");
        if (cause != null) {
            e.initCause(cause);
        }
        return e;
    }

    static {
        Companion = new Companion(null);
        IDLE_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(60L);
        IDLE_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(IDLE_TIMEOUT_MILLIS);
    }

    public static final /* synthetic */ long access$getTimeoutAt$p(AsyncTimeout $this) {
        return $this.timeoutAt;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lokio/AsyncTimeout$Watchdog;", "Ljava/lang/Thread;", "()V", "run", "", "jvm"})
    private static final class Watchdog
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    AsyncTimeout timedOut = null;
                    Class<AsyncTimeout> clazz = AsyncTimeout.class;
                    synchronized (clazz) {
                        timedOut = Companion.awaitTimeout$jvm();
                        if (timedOut == head) {
                            head = (AsyncTimeout)null;
                            return;
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    AsyncTimeout asyncTimeout = timedOut;
                    if (asyncTimeout != null) {
                        asyncTimeout.timedOut();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        public Watchdog() {
            super("Okio Watchdog");
            this.setDaemon(true);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\n\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lokio/AsyncTimeout$Companion;", "", "()V", "IDLE_TIMEOUT_MILLIS", "", "IDLE_TIMEOUT_NANOS", "TIMEOUT_WRITE_SIZE", "", "head", "Lokio/AsyncTimeout;", "awaitTimeout", "awaitTimeout$jvm", "cancelScheduledTimeout", "", "node", "scheduleTimeout", "", "timeoutNanos", "hasDeadline", "jvm"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void scheduleTimeout(AsyncTimeout node, long timeoutNanos, boolean hasDeadline) {
            Class<AsyncTimeout> clazz = AsyncTimeout.class;
            synchronized (clazz) {
                if (head == null) {
                    head = new AsyncTimeout();
                    new Watchdog().start();
                }
                long now = System.nanoTime();
                if (timeoutNanos != 0L && hasDeadline) {
                    long l = timeoutNanos;
                    long l2 = node.deadlineNanoTime() - now;
                    long l3 = now;
                    AsyncTimeout asyncTimeout = node;
                    long l4 = Math.min(l, l2);
                    asyncTimeout.timeoutAt = l3 + l4;
                } else if (timeoutNanos != 0L) {
                    node.timeoutAt = now + timeoutNanos;
                } else if (hasDeadline) {
                    node.timeoutAt = node.deadlineNanoTime();
                } else {
                    throw (Throwable)((Object)new AssertionError());
                }
                long remainingNanos = node.remainingNanos(now);
                AsyncTimeout asyncTimeout = head;
                if (asyncTimeout == null) {
                    Intrinsics.throwNpe();
                }
                AsyncTimeout prev = asyncTimeout;
                while (true) {
                    block17: {
                        block16: {
                            if (prev.next == null) break block16;
                            AsyncTimeout asyncTimeout2 = prev.next;
                            if (asyncTimeout2 == null) {
                                Intrinsics.throwNpe();
                            }
                            if (remainingNanos >= asyncTimeout2.remainingNanos(now)) break block17;
                        }
                        node.next = prev.next;
                        prev.next = node;
                        if (prev != head) break;
                        ((Object)AsyncTimeout.class).notify();
                        break;
                    }
                    if (prev.next != null) continue;
                    Intrinsics.throwNpe();
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final boolean cancelScheduledTimeout(AsyncTimeout node) {
            Class<AsyncTimeout> clazz = AsyncTimeout.class;
            synchronized (clazz) {
                AsyncTimeout prev = head;
                while (prev != null) {
                    if (prev.next == node) {
                        prev.next = node.next;
                        node.next = (AsyncTimeout)null;
                        return false;
                    }
                    prev = prev.next;
                }
                return true;
            }
        }

        @Nullable
        public final AsyncTimeout awaitTimeout$jvm() throws InterruptedException {
            AsyncTimeout node;
            AsyncTimeout asyncTimeout = head;
            if (asyncTimeout == null) {
                Intrinsics.throwNpe();
            }
            if ((node = asyncTimeout.next) == null) {
                long startNanos = System.nanoTime();
                ((Object)AsyncTimeout.class).wait(IDLE_TIMEOUT_MILLIS);
                AsyncTimeout asyncTimeout2 = head;
                if (asyncTimeout2 == null) {
                    Intrinsics.throwNpe();
                }
                return asyncTimeout2.next == null && System.nanoTime() - startNanos >= IDLE_TIMEOUT_NANOS ? head : null;
            }
            long waitNanos = node.remainingNanos(System.nanoTime());
            if (waitNanos > 0L) {
                long waitMillis = waitNanos / 1000000L;
                ((Object)AsyncTimeout.class).wait(waitMillis, (int)(waitNanos -= waitMillis * 1000000L));
                return null;
            }
            AsyncTimeout asyncTimeout3 = head;
            if (asyncTimeout3 == null) {
                Intrinsics.throwNpe();
            }
            asyncTimeout3.next = node.next;
            node.next = (AsyncTimeout)null;
            return node;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

