//
//  SwiftStringEncoding.swift
//  iina
//
//  Created by Collider LI on 4/3/2020.
//  Copyright © 2020 lhc. All rights reserved.
//

import Foundation

fileprivate let externalStringEncodings = [
  "ANSEL": CFStringEncodings.ANSEL.rawValue,
  "big5": CFStringEncodings.big5.rawValue,
  "big5_E": CFStringEncodings.big5_E.rawValue,
  "big5_HKSCS_1999": CFStringEncodings.big5_HKSCS_1999.rawValue,
  "CNS_11643_92_P1": CFStringEncodings.CNS_11643_92_P1.rawValue,
  "CNS_11643_92_P2": CFStringEncodings.CNS_11643_92_P2.rawValue,
  "CNS_11643_92_P3": CFStringEncodings.CNS_11643_92_P3.rawValue,
  "dosArabic": CFStringEncodings.dosArabic.rawValue,
  "dosBalticRim": CFStringEncodings.dosBalticRim.rawValue,
  "dosCanadianFrench": CFStringEncodings.dosCanadianFrench.rawValue,
  "dosChineseSimplif": CFStringEncodings.dosChineseSimplif.rawValue,
  "dosChineseTrad": CFStringEncodings.dosChineseTrad.rawValue,
  "dosCyrillic": CFStringEncodings.dosCyrillic.rawValue,
  "dosGreek": CFStringEncodings.dosGreek.rawValue,
  "dosGreek1": CFStringEncodings.dosGreek1.rawValue,
  "dosGreek2": CFStringEncodings.dosGreek2.rawValue,
  "dosHebrew": CFStringEncodings.dosHebrew.rawValue,
  "dosIcelandic": CFStringEncodings.dosIcelandic.rawValue,
  "dosJapanese": CFStringEncodings.dosJapanese.rawValue,
  "dosKorean": CFStringEncodings.dosKorean.rawValue,
  "dosLatin1": CFStringEncodings.dosLatin1.rawValue,
  "dosLatin2": CFStringEncodings.dosLatin2.rawValue,
  "dosLatinUS": CFStringEncodings.dosLatinUS.rawValue,
  "dosNordic": CFStringEncodings.dosNordic.rawValue,
  "dosPortuguese": CFStringEncodings.dosPortuguese.rawValue,
  "dosRussian": CFStringEncodings.dosRussian.rawValue,
  "dosThai": CFStringEncodings.dosThai.rawValue,
  "dosTurkish": CFStringEncodings.dosTurkish.rawValue,
  "EBCDIC_CP037": CFStringEncodings.EBCDIC_CP037.rawValue,
  "EBCDIC_US": CFStringEncodings.EBCDIC_US.rawValue,
  "EUC_CN": CFStringEncodings.EUC_CN.rawValue,
  "EUC_JP": CFStringEncodings.EUC_JP.rawValue,
  "EUC_KR": CFStringEncodings.EUC_KR.rawValue,
  "EUC_TW": CFStringEncodings.EUC_TW.rawValue,
  "GBK_95": CFStringEncodings.GBK_95.rawValue,
  "GB_18030_2000": CFStringEncodings.GB_18030_2000.rawValue,
  "GB_2312_80": CFStringEncodings.GB_2312_80.rawValue,
  "HZ_GB_2312": CFStringEncodings.HZ_GB_2312.rawValue,
  "isoLatin10": CFStringEncodings.isoLatin10.rawValue,
  "isoLatin2": CFStringEncodings.isoLatin2.rawValue,
  "isoLatin3": CFStringEncodings.isoLatin3.rawValue,
  "isoLatin4": CFStringEncodings.isoLatin4.rawValue,
  "isoLatin5": CFStringEncodings.isoLatin5.rawValue,
  "isoLatin6": CFStringEncodings.isoLatin6.rawValue,
  "isoLatin7": CFStringEncodings.isoLatin7.rawValue,
  "isoLatin8": CFStringEncodings.isoLatin8.rawValue,
  "isoLatin9": CFStringEncodings.isoLatin9.rawValue,
  "isoLatinArabic": CFStringEncodings.isoLatinArabic.rawValue,
  "isoLatinCyrillic": CFStringEncodings.isoLatinCyrillic.rawValue,
  "isoLatinGreek": CFStringEncodings.isoLatinGreek.rawValue,
  "isoLatinHebrew": CFStringEncodings.isoLatinHebrew.rawValue,
  "isoLatinThai": CFStringEncodings.isoLatinThai.rawValue,
  "ISO_2022_CN": CFStringEncodings.ISO_2022_CN.rawValue,
  "ISO_2022_CN_EXT": CFStringEncodings.ISO_2022_CN_EXT.rawValue,
  "ISO_2022_JP": CFStringEncodings.ISO_2022_JP.rawValue,
  "ISO_2022_JP_1": CFStringEncodings.ISO_2022_JP_1.rawValue,
  "ISO_2022_JP_2": CFStringEncodings.ISO_2022_JP_2.rawValue,
  "ISO_2022_JP_3": CFStringEncodings.ISO_2022_JP_3.rawValue,
  "ISO_2022_KR": CFStringEncodings.ISO_2022_KR.rawValue,
  "JIS_C6226_78": CFStringEncodings.JIS_C6226_78.rawValue,
  "JIS_X0201_76": CFStringEncodings.JIS_X0201_76.rawValue,
  "JIS_X0208_83": CFStringEncodings.JIS_X0208_83.rawValue,
  "JIS_X0208_90": CFStringEncodings.JIS_X0208_90.rawValue,
  "JIS_X0212_90": CFStringEncodings.JIS_X0212_90.rawValue,
  "KOI8_R": CFStringEncodings.KOI8_R.rawValue,
  "KOI8_U": CFStringEncodings.KOI8_U.rawValue,
  "KSC_5601_87": CFStringEncodings.KSC_5601_87.rawValue,
  "ksc_5601_92_Johab": CFStringEncodings.ksc_5601_92_Johab.rawValue,
  "macArabic": CFStringEncodings.macArabic.rawValue,
  "macArmenian": CFStringEncodings.macArmenian.rawValue,
  "macBengali": CFStringEncodings.macBengali.rawValue,
  "macBurmese": CFStringEncodings.macBurmese.rawValue,
  "macCeltic": CFStringEncodings.macCeltic.rawValue,
  "macCentralEurRoman": CFStringEncodings.macCentralEurRoman.rawValue,
  "macChineseSimp": CFStringEncodings.macChineseSimp.rawValue,
  "macChineseTrad": CFStringEncodings.macChineseTrad.rawValue,
  "macCroatian": CFStringEncodings.macCroatian.rawValue,
  "macCyrillic": CFStringEncodings.macCyrillic.rawValue,
  "macDevanagari": CFStringEncodings.macDevanagari.rawValue,
  "macDingbats": CFStringEncodings.macDingbats.rawValue,
  "macEthiopic": CFStringEncodings.macEthiopic.rawValue,
  "macExtArabic": CFStringEncodings.macExtArabic.rawValue,
  "macFarsi": CFStringEncodings.macFarsi.rawValue,
  "macGaelic": CFStringEncodings.macGaelic.rawValue,
  "macGeorgian": CFStringEncodings.macGeorgian.rawValue,
  "macGreek": CFStringEncodings.macGreek.rawValue,
  "macGujarati": CFStringEncodings.macGujarati.rawValue,
  "macGurmukhi": CFStringEncodings.macGurmukhi.rawValue,
  "macHFS": CFStringEncodings.macHFS.rawValue,
  "macHebrew": CFStringEncodings.macHebrew.rawValue,
  "macIcelandic": CFStringEncodings.macIcelandic.rawValue,
  "macInuit": CFStringEncodings.macInuit.rawValue,
  "macJapanese": CFStringEncodings.macJapanese.rawValue,
  "macKannada": CFStringEncodings.macKannada.rawValue,
  "macKhmer": CFStringEncodings.macKhmer.rawValue,
  "macKorean": CFStringEncodings.macKorean.rawValue,
  "macLaotian": CFStringEncodings.macLaotian.rawValue,
  "macMalayalam": CFStringEncodings.macMalayalam.rawValue,
  "macMongolian": CFStringEncodings.macMongolian.rawValue,
  "macOriya": CFStringEncodings.macOriya.rawValue,
  "macRomanLatin1": CFStringEncodings.macRomanLatin1.rawValue,
  "macRomanian": CFStringEncodings.macRomanian.rawValue,
  "macSinhalese": CFStringEncodings.macSinhalese.rawValue,
  "macSymbol": CFStringEncodings.macSymbol.rawValue,
  "macTamil": CFStringEncodings.macTamil.rawValue,
  "macTelugu": CFStringEncodings.macTelugu.rawValue,
  "macThai": CFStringEncodings.macThai.rawValue,
  "macTibetan": CFStringEncodings.macTibetan.rawValue,
  "macTurkish": CFStringEncodings.macTurkish.rawValue,
  "macUkrainian": CFStringEncodings.macUkrainian.rawValue,
  "macVT100": CFStringEncodings.macVT100.rawValue,
  "macVietnamese": CFStringEncodings.macVietnamese.rawValue,
  "nextStepJapanese": CFStringEncodings.nextStepJapanese.rawValue,
  "shiftJIS": CFStringEncodings.shiftJIS.rawValue,
  "shiftJIS_X0213": CFStringEncodings.shiftJIS_X0213.rawValue,
  "shiftJIS_X0213_MenKuTen": CFStringEncodings.shiftJIS_X0213_MenKuTen.rawValue,
  "UTF7": CFStringEncodings.UTF7.rawValue,
  "UTF7_IMAP": CFStringEncodings.UTF7_IMAP.rawValue,
  "VISCII": CFStringEncodings.VISCII.rawValue,
  "windowsArabic": CFStringEncodings.windowsArabic.rawValue,
  "windowsBalticRim": CFStringEncodings.windowsBalticRim.rawValue,
  "windowsCyrillic": CFStringEncodings.windowsCyrillic.rawValue,
  "windowsGreek": CFStringEncodings.windowsGreek.rawValue,
  "windowsHebrew": CFStringEncodings.windowsHebrew.rawValue,
  "windowsKoreanJohab": CFStringEncodings.windowsKoreanJohab.rawValue,
  "windowsLatin2": CFStringEncodings.windowsLatin2.rawValue,
  "windowsLatin5": CFStringEncodings.windowsLatin5.rawValue,
  "windowsVietnamese": CFStringEncodings.windowsVietnamese.rawValue,
]

fileprivate let swiftStringEncodings = [
  "ascii": String.Encoding.ascii,
  "iso2022JP": String.Encoding.iso2022JP,
  "isoLatin1": String.Encoding.isoLatin1,
  "isoLatin2": String.Encoding.isoLatin2,
  "japaneseEUC": String.Encoding.japaneseEUC,
  "macOSRoman": String.Encoding.macOSRoman,
  "nextstep": String.Encoding.nextstep,
  "nonLossyASCII": String.Encoding.nonLossyASCII,
  "shiftJIS": String.Encoding.shiftJIS,
  "symbol": String.Encoding.symbol,
  "unicode": String.Encoding.unicode,
  "utf16": String.Encoding.utf16,
  "utf16BigEndian": String.Encoding.utf16BigEndian,
  "utf16LittleEndian": String.Encoding.utf16LittleEndian,
  "utf32": String.Encoding.utf32,
  "utf32BigEndian": String.Encoding.utf32BigEndian,
  "utf32LittleEndian": String.Encoding.utf32LittleEndian,
  "utf8": String.Encoding.utf8,
  "windowsCP1250": String.Encoding.windowsCP1250,
  "windowsCP1251": String.Encoding.windowsCP1251,
  "windowsCP1252": String.Encoding.windowsCP1252,
  "windowsCP1253": String.Encoding.windowsCP1253,
  "windowsCP1254": String.Encoding.windowsCP1254,
]

func stringEncodingFromName(_ name: String) -> String.Encoding? {
  if let encoding = swiftStringEncodings[name] {
    return encoding
  }
  if let cfEncoding = externalStringEncodings[name] {
    let encoding = CFStringConvertEncodingToNSStringEncoding(CFStringEncoding(cfEncoding))
    return String.Encoding(rawValue: encoding)
  }
  return nil
}
