import Foundation

/// Named constants for  mpv [properties](https://mpv.io/manual/stable/#properties).
///
/// This file was generated by the script `other/parse_doc.rb`. Should any changes be needed to this source the
/// generator script must be updated and this source file must then be regenerated.
///
/// This source is normally regenerated when IINA updates the version of libmpv being used so that this source
/// correctly reflects the mpv client API supported by the version of the library in use.
///
/// - Attention: **DO NOT DIRECTLY MODIFY THIS GENERATED FILE FOR ANY REASON WHATSOEVER**
struct MPVProperty {
  /** audio-speed-correction */
  static let audioSpeedCorrection = "audio-speed-correction"
  /** video-speed-correction */
  static let videoSpeedCorrection = "video-speed-correction"
  /** display-sync-active */
  static let displaySyncActive = "display-sync-active"
  /** filename */
  static let filename = "filename"
  /** filename/no-ext */
  static let filenameNoExt = "filename/no-ext"
  /** file-size */
  static let fileSize = "file-size"
  /** estimated-frame-count */
  static let estimatedFrameCount = "estimated-frame-count"
  /** estimated-frame-number */
  static let estimatedFrameNumber = "estimated-frame-number"
  /** pid */
  static let pid = "pid"
  /** path */
  static let path = "path"
  /** stream-open-filename */
  static let streamOpenFilename = "stream-open-filename"
  /** media-title */
  static let mediaTitle = "media-title"
  /** file-format */
  static let fileFormat = "file-format"
  /** current-demuxer */
  static let currentDemuxer = "current-demuxer"
  /** stream-path */
  static let streamPath = "stream-path"
  /** stream-pos */
  static let streamPos = "stream-pos"
  /** stream-end */
  static let streamEnd = "stream-end"
  /** duration */
  static let duration = "duration"
  /** duration/full */
  static let durationFull = "duration/full"
  /** avsync */
  static let avsync = "avsync"
  /** total-avsync-change */
  static let totalAvsyncChange = "total-avsync-change"
  /** decoder-frame-drop-count */
  static let decoderFrameDropCount = "decoder-frame-drop-count"
  /** frame-drop-count */
  static let frameDropCount = "frame-drop-count"
  /** mistimed-frame-count */
  static let mistimedFrameCount = "mistimed-frame-count"
  /** vsync-ratio */
  static let vsyncRatio = "vsync-ratio"
  /** vo-delayed-frame-count */
  static let voDelayedFrameCount = "vo-delayed-frame-count"
  /** percent-pos */
  static let percentPos = "percent-pos"
  /** time-pos */
  static let timePos = "time-pos"
  /** time-pos/full */
  static let timePosFull = "time-pos/full"
  /** time-start */
  static let timeStart = "time-start"
  /** time-remaining */
  static let timeRemaining = "time-remaining"
  /** time-remaining/full */
  static let timeRemainingFull = "time-remaining/full"
  /** audio-pts */
  static let audioPts = "audio-pts"
  /** audio-pts/full */
  static let audioPtsFull = "audio-pts/full"
  /** playtime-remaining */
  static let playtimeRemaining = "playtime-remaining"
  /** playtime-remaining/full */
  static let playtimeRemainingFull = "playtime-remaining/full"
  /** playback-time */
  static let playbackTime = "playback-time"
  /** playback-time/full */
  static let playbackTimeFull = "playback-time/full"
  /** chapter */
  static let chapter = "chapter"
  /** edition */
  static let edition = "edition"
  /** current-edition */
  static let currentEdition = "current-edition"
  /** chapters */
  static let chapters = "chapters"
  /** editions */
  static let editions = "editions"
  /** edition-list */
  static let editionList = "edition-list"
  /** edition-list/count */
  static let editionListCount = "edition-list/count"
  /** edition-list/N/id */
  static func editionListNId(_ n: Int) -> String {
    return "edition-list/\(n)/id"
  }
  /** edition-list/N/default */
  static func editionListNDefault(_ n: Int) -> String {
    return "edition-list/\(n)/default"
  }
  /** edition-list/N/title */
  static func editionListNTitle(_ n: Int) -> String {
    return "edition-list/\(n)/title"
  }
  /** metadata */
  static let metadata = "metadata"
  /** metadata/list/count */
  static let metadataListCount = "metadata/list/count"
  /** metadata/list/N/key */
  static func metadataListNKey(_ n: Int) -> String {
    return "metadata/list/\(n)/key"
  }
  /** metadata/list/N/value */
  static func metadataListNValue(_ n: Int) -> String {
    return "metadata/list/\(n)/value"
  }
  /** filtered-metadata */
  static let filteredMetadata = "filtered-metadata"
  /** chapter-metadata */
  static let chapterMetadata = "chapter-metadata"
  /** deinterlace-active */
  static let deinterlaceActive = "deinterlace-active"
  /** idle-active */
  static let idleActive = "idle-active"
  /** core-idle */
  static let coreIdle = "core-idle"
  /** cache-speed */
  static let cacheSpeed = "cache-speed"
  /** demuxer-cache-duration */
  static let demuxerCacheDuration = "demuxer-cache-duration"
  /** demuxer-cache-time */
  static let demuxerCacheTime = "demuxer-cache-time"
  /** demuxer-cache-idle */
  static let demuxerCacheIdle = "demuxer-cache-idle"
  /** demuxer-cache-state */
  static let demuxerCacheState = "demuxer-cache-state"
  /** demuxer-via-network */
  static let demuxerViaNetwork = "demuxer-via-network"
  /** demuxer-start-time */
  static let demuxerStartTime = "demuxer-start-time"
  /** paused-for-cache */
  static let pausedForCache = "paused-for-cache"
  /** cache-buffering-state */
  static let cacheBufferingState = "cache-buffering-state"
  /** eof-reached */
  static let eofReached = "eof-reached"
  /** seeking */
  static let seeking = "seeking"
  /** mixer-active */
  static let mixerActive = "mixer-active"
  /** ao-volume */
  static let aoVolume = "ao-volume"
  /** ao-mute */
  static let aoMute = "ao-mute"
  /** audio-params */
  static let audioParams = "audio-params"
  /** audio-params/format */
  static let audioParamsFormat = "audio-params/format"
  /** audio-params/samplerate */
  static let audioParamsSamplerate = "audio-params/samplerate"
  /** audio-params/channels */
  static let audioParamsChannels = "audio-params/channels"
  /** audio-params/hr-channels */
  static let audioParamsHrChannels = "audio-params/hr-channels"
  /** audio-params/channel-count */
  static let audioParamsChannelCount = "audio-params/channel-count"
  /** audio-out-params */
  static let audioOutParams = "audio-out-params"
  /** colormatrix */
  static let colormatrix = "colormatrix"
  /** colormatrix-input-range */
  static let colormatrixInputRange = "colormatrix-input-range"
  /** colormatrix-primaries */
  static let colormatrixPrimaries = "colormatrix-primaries"
  /** hwdec */
  static let hwdec = "hwdec"
  /** hwdec-current */
  static let hwdecCurrent = "hwdec-current"
  /** hwdec-interop */
  static let hwdecInterop = "hwdec-interop"
  /** width */
  static let width = "width"
  /** height */
  static let height = "height"
  /** video-params */
  static let videoParams = "video-params"
  /** video-params/pixelformat */
  static let videoParamsPixelformat = "video-params/pixelformat"
  /** video-params/hw-pixelformat */
  static let videoParamsHwPixelformat = "video-params/hw-pixelformat"
  /** video-params/average-bpp */
  static let videoParamsAverageBpp = "video-params/average-bpp"
  /** video-params/w */
  static let videoParamsW = "video-params/w"
  /** video-params/h */
  static let videoParamsH = "video-params/h"
  /** video-params/dw */
  static let videoParamsDw = "video-params/dw"
  /** video-params/dh */
  static let videoParamsDh = "video-params/dh"
  /** video-params/crop-x */
  static let videoParamsCropX = "video-params/crop-x"
  /** video-params/crop-y */
  static let videoParamsCropY = "video-params/crop-y"
  /** video-params/crop-w */
  static let videoParamsCropW = "video-params/crop-w"
  /** video-params/crop-h */
  static let videoParamsCropH = "video-params/crop-h"
  /** video-params/aspect */
  static let videoParamsAspect = "video-params/aspect"
  /** video-params/aspect-name */
  static let videoParamsAspectName = "video-params/aspect-name"
  /** video-params/par */
  static let videoParamsPar = "video-params/par"
  /** video-params/sar */
  static let videoParamsSar = "video-params/sar"
  /** video-params/sar-name */
  static let videoParamsSarName = "video-params/sar-name"
  /** video-params/colormatrix */
  static let videoParamsColormatrix = "video-params/colormatrix"
  /** video-params/colorlevels */
  static let videoParamsColorlevels = "video-params/colorlevels"
  /** video-params/primaries */
  static let videoParamsPrimaries = "video-params/primaries"
  /** video-params/gamma */
  static let videoParamsGamma = "video-params/gamma"
  /** video-params/sig-peak */
  static let videoParamsSigPeak = "video-params/sig-peak"
  /** video-params/light */
  static let videoParamsLight = "video-params/light"
  /** video-params/chroma-location */
  static let videoParamsChromaLocation = "video-params/chroma-location"
  /** video-params/rotate */
  static let videoParamsRotate = "video-params/rotate"
  /** video-params/stereo-in */
  static let videoParamsStereoIn = "video-params/stereo-in"
  /** video-params/alpha */
  static let videoParamsAlpha = "video-params/alpha"
  /** video-params/min-luma */
  static let videoParamsMinLuma = "video-params/min-luma"
  /** video-params/max-luma */
  static let videoParamsMaxLuma = "video-params/max-luma"
  /** video-params/max-cll */
  static let videoParamsMaxCll = "video-params/max-cll"
  /** video-params/max-fall */
  static let videoParamsMaxFall = "video-params/max-fall"
  /** video-params/scene-max-r */
  static let videoParamsSceneMaxR = "video-params/scene-max-r"
  /** video-params/scene-max-g */
  static let videoParamsSceneMaxG = "video-params/scene-max-g"
  /** video-params/scene-max-b */
  static let videoParamsSceneMaxB = "video-params/scene-max-b"
  /** video-params/max-pq-y */
  static let videoParamsMaxPqY = "video-params/max-pq-y"
  /** video-params/avg-pq-y */
  static let videoParamsAvgPqY = "video-params/avg-pq-y"
  /** dwidth */
  static let dwidth = "dwidth"
  /** dheight */
  static let dheight = "dheight"
  /** video-dec-params */
  static let videoDecParams = "video-dec-params"
  /** video-out-params */
  static let videoOutParams = "video-out-params"
  /** video-target-params */
  static let videoTargetParams = "video-target-params"
  /** video-frame-info */
  static let videoFrameInfo = "video-frame-info"
  /** video-frame-info/picture-type */
  static let videoFrameInfoPictureType = "video-frame-info/picture-type"
  /** video-frame-info/interlaced */
  static let videoFrameInfoInterlaced = "video-frame-info/interlaced"
  /** video-frame-info/tff */
  static let videoFrameInfoTff = "video-frame-info/tff"
  /** video-frame-info/repeat */
  static let videoFrameInfoRepeat = "video-frame-info/repeat"
  /** container-fps */
  static let containerFps = "container-fps"
  /** estimated-vf-fps */
  static let estimatedVfFps = "estimated-vf-fps"
  /** window-scale */
  static let windowScale = "window-scale"
  /** current-window-scale */
  static let currentWindowScale = "current-window-scale"
  /** focused */
  static let focused = "focused"
  /** display-names */
  static let displayNames = "display-names"
  /** display-fps */
  static let displayFps = "display-fps"
  /** estimated-display-fps */
  static let estimatedDisplayFps = "estimated-display-fps"
  /** vsync-jitter */
  static let vsyncJitter = "vsync-jitter"
  /** display-width */
  static let displayWidth = "display-width"
  /** display-height */
  static let displayHeight = "display-height"
  /** display-hidpi-scale */
  static let displayHidpiScale = "display-hidpi-scale"
  /** osd-width */
  static let osdWidth = "osd-width"
  /** osd-height */
  static let osdHeight = "osd-height"
  /** osd-par */
  static let osdPar = "osd-par"
  /** osd-dimensions */
  static let osdDimensions = "osd-dimensions"
  /** osd-dimensions/w */
  static let osdDimensionsW = "osd-dimensions/w"
  /** osd-dimensions/h */
  static let osdDimensionsH = "osd-dimensions/h"
  /** osd-dimensions/par */
  static let osdDimensionsPar = "osd-dimensions/par"
  /** osd-dimensions/aspect */
  static let osdDimensionsAspect = "osd-dimensions/aspect"
  /** osd-dimensions/mt */
  static let osdDimensionsMt = "osd-dimensions/mt"
  /** osd-dimensions/mb */
  static let osdDimensionsMb = "osd-dimensions/mb"
  /** osd-dimensions/ml */
  static let osdDimensionsMl = "osd-dimensions/ml"
  /** osd-dimensions/mr */
  static let osdDimensionsMr = "osd-dimensions/mr"
  /** term-size */
  static let termSize = "term-size"
  /** term-size/w */
  static let termSizeW = "term-size/w"
  /** term-size/h */
  static let termSizeH = "term-size/h"
  /** window-id */
  static let windowId = "window-id"
  /** mouse-pos */
  static let mousePos = "mouse-pos"
  /** mouse-pos/x */
  static let mousePosX = "mouse-pos/x"
  /** mouse-pos/y */
  static let mousePosY = "mouse-pos/y"
  /** mouse-pos/hover */
  static let mousePosHover = "mouse-pos/hover"
  /** sub-ass-extradata */
  static let subAssExtradata = "sub-ass-extradata"
  /** sub-text */
  static let subText = "sub-text"
  /** sub-text-ass */
  static let subTextAss = "sub-text-ass"
  /** secondary-sub-text */
  static let secondarySubText = "secondary-sub-text"
  /** sub-start */
  static let subStart = "sub-start"
  /** secondary-sub-start */
  static let secondarySubStart = "secondary-sub-start"
  /** sub-end */
  static let subEnd = "sub-end"
  /** secondary-sub-end */
  static let secondarySubEnd = "secondary-sub-end"
  /** playlist-pos */
  static let playlistPos = "playlist-pos"
  /** playlist-pos-1 */
  static let playlistPos1 = "playlist-pos-1"
  /** playlist-current-pos */
  static let playlistCurrentPos = "playlist-current-pos"
  /** playlist-playing-pos */
  static let playlistPlayingPos = "playlist-playing-pos"
  /** playlist-count */
  static let playlistCount = "playlist-count"
  /** playlist-path */
  static let playlistPath = "playlist-path"
  /** playlist */
  static let playlist = "playlist"
  /** playlistCount1 */
  static let playlistCount1 = "playlistCount1"
  /** playlist/N/filename */
  static func playlistNFilename(_ n: Int) -> String {
    return "playlist/\(n)/filename"
  }
  /** playlist/N/playing */
  static func playlistNPlaying(_ n: Int) -> String {
    return "playlist/\(n)/playing"
  }
  /** playlist/N/current */
  static func playlistNCurrent(_ n: Int) -> String {
    return "playlist/\(n)/current"
  }
  /** playlist/N/title */
  static func playlistNTitle(_ n: Int) -> String {
    return "playlist/\(n)/title"
  }
  /** playlist/N/id */
  static func playlistNId(_ n: Int) -> String {
    return "playlist/\(n)/id"
  }
  /** playlist/N/playlist-path */
  static func playlistNPlaylistPath(_ n: Int) -> String {
    return "playlist/\(n)/playlist-path"
  }
  /** track-list */
  static let trackList = "track-list"
  /** track-list/count */
  static let trackListCount = "track-list/count"
  /** track-list/N/id */
  static func trackListNId(_ n: Int) -> String {
    return "track-list/\(n)/id"
  }
  /** track-list/N/type */
  static func trackListNType(_ n: Int) -> String {
    return "track-list/\(n)/type"
  }
  /** track-list/N/src-id */
  static func trackListNSrcId(_ n: Int) -> String {
    return "track-list/\(n)/src-id"
  }
  /** track-list/N/title */
  static func trackListNTitle(_ n: Int) -> String {
    return "track-list/\(n)/title"
  }
  /** track-list/N/lang */
  static func trackListNLang(_ n: Int) -> String {
    return "track-list/\(n)/lang"
  }
  /** track-list/N/image */
  static func trackListNImage(_ n: Int) -> String {
    return "track-list/\(n)/image"
  }
  /** track-list/N/albumart */
  static func trackListNAlbumart(_ n: Int) -> String {
    return "track-list/\(n)/albumart"
  }
  /** track-list/N/default */
  static func trackListNDefault(_ n: Int) -> String {
    return "track-list/\(n)/default"
  }
  /** track-list/N/forced */
  static func trackListNForced(_ n: Int) -> String {
    return "track-list/\(n)/forced"
  }
  /** track-list/N/codec */
  static func trackListNCodec(_ n: Int) -> String {
    return "track-list/\(n)/codec"
  }
  /** track-list/N/codec-desc */
  static func trackListNCodecDesc(_ n: Int) -> String {
    return "track-list/\(n)/codec-desc"
  }
  /** track-list/N/codec-profile */
  static func trackListNCodecProfile(_ n: Int) -> String {
    return "track-list/\(n)/codec-profile"
  }
  /** track-list/N/external */
  static func trackListNExternal(_ n: Int) -> String {
    return "track-list/\(n)/external"
  }
  /** track-list/N/external-filename */
  static func trackListNExternalFilename(_ n: Int) -> String {
    return "track-list/\(n)/external-filename"
  }
  /** track-list/N/selected */
  static func trackListNSelected(_ n: Int) -> String {
    return "track-list/\(n)/selected"
  }
  /** track-list/N/main-selection */
  static func trackListNMainSelection(_ n: Int) -> String {
    return "track-list/\(n)/main-selection"
  }
  /** track-list/N/ff-index */
  static func trackListNFfIndex(_ n: Int) -> String {
    return "track-list/\(n)/ff-index"
  }
  /** track-list/N/decoder-desc */
  static func trackListNDecoderDesc(_ n: Int) -> String {
    return "track-list/\(n)/decoder-desc"
  }
  /** track-list/N/demux-w */
  static func trackListNDemuxW(_ n: Int) -> String {
    return "track-list/\(n)/demux-w"
  }
  /** track-list/N/demux-h */
  static func trackListNDemuxH(_ n: Int) -> String {
    return "track-list/\(n)/demux-h"
  }
  /** track-list/N/demux-crop-x */
  static func trackListNDemuxCropX(_ n: Int) -> String {
    return "track-list/\(n)/demux-crop-x"
  }
  /** track-list/N/demux-crop-y */
  static func trackListNDemuxCropY(_ n: Int) -> String {
    return "track-list/\(n)/demux-crop-y"
  }
  /** track-list/N/demux-crop-w */
  static func trackListNDemuxCropW(_ n: Int) -> String {
    return "track-list/\(n)/demux-crop-w"
  }
  /** track-list/N/demux-crop-h */
  static func trackListNDemuxCropH(_ n: Int) -> String {
    return "track-list/\(n)/demux-crop-h"
  }
  /** track-list/N/demux-channel-count */
  static func trackListNDemuxChannelCount(_ n: Int) -> String {
    return "track-list/\(n)/demux-channel-count"
  }
  /** track-list/N/demux-channels */
  static func trackListNDemuxChannels(_ n: Int) -> String {
    return "track-list/\(n)/demux-channels"
  }
  /** track-list/N/demux-samplerate */
  static func trackListNDemuxSamplerate(_ n: Int) -> String {
    return "track-list/\(n)/demux-samplerate"
  }
  /** track-list/N/demux-fps */
  static func trackListNDemuxFps(_ n: Int) -> String {
    return "track-list/\(n)/demux-fps"
  }
  /** track-list/N/demux-bitrate */
  static func trackListNDemuxBitrate(_ n: Int) -> String {
    return "track-list/\(n)/demux-bitrate"
  }
  /** track-list/N/demux-rotation */
  static func trackListNDemuxRotation(_ n: Int) -> String {
    return "track-list/\(n)/demux-rotation"
  }
  /** track-list/N/demux-par */
  static func trackListNDemuxPar(_ n: Int) -> String {
    return "track-list/\(n)/demux-par"
  }
  /** track-list/N/format-name */
  static func trackListNFormatName(_ n: Int) -> String {
    return "track-list/\(n)/format-name"
  }
  /** track-list/N/audio-channels */
  static func trackListNAudioChannels(_ n: Int) -> String {
    return "track-list/\(n)/audio-channels"
  }
  /** track-list/N/replaygain-track-peak */
  static func trackListNReplaygainTrackPeak(_ n: Int) -> String {
    return "track-list/\(n)/replaygain-track-peak"
  }
  /** track-list/N/replaygain-track-gain */
  static func trackListNReplaygainTrackGain(_ n: Int) -> String {
    return "track-list/\(n)/replaygain-track-gain"
  }
  /** track-list/N/replaygain-album-peak */
  static func trackListNReplaygainAlbumPeak(_ n: Int) -> String {
    return "track-list/\(n)/replaygain-album-peak"
  }
  /** track-list/N/replaygain-album-gain */
  static func trackListNReplaygainAlbumGain(_ n: Int) -> String {
    return "track-list/\(n)/replaygain-album-gain"
  }
  /** current-tracks/audio/id */
  static let currentTracksAudioId = "current-tracks/audio/id"
  /** current-tracks/video/id */
  static let currentTracksVideoId = "current-tracks/video/id"
  /** current-tracks/sub/id */
  static let currentTracksSubId = "current-tracks/sub/id"
  /** current-tracks/sub2/id */
  static let currentTracksSub2Id = "current-tracks/sub2/id"
  /** current-tracks/audio/type */
  static let currentTracksAudioType = "current-tracks/audio/type"
  /** current-tracks/video/type */
  static let currentTracksVideoType = "current-tracks/video/type"
  /** current-tracks/sub/type */
  static let currentTracksSubType = "current-tracks/sub/type"
  /** current-tracks/sub2/type */
  static let currentTracksSub2Type = "current-tracks/sub2/type"
  /** current-tracks/audio/src-id */
  static let currentTracksAudioSrcId = "current-tracks/audio/src-id"
  /** current-tracks/video/src-id */
  static let currentTracksVideoSrcId = "current-tracks/video/src-id"
  /** current-tracks/sub/src-id */
  static let currentTracksSubSrcId = "current-tracks/sub/src-id"
  /** current-tracks/sub2/src-id */
  static let currentTracksSub2SrcId = "current-tracks/sub2/src-id"
  /** current-tracks/audio/title */
  static let currentTracksAudioTitle = "current-tracks/audio/title"
  /** current-tracks/video/title */
  static let currentTracksVideoTitle = "current-tracks/video/title"
  /** current-tracks/sub/title */
  static let currentTracksSubTitle = "current-tracks/sub/title"
  /** current-tracks/sub2/title */
  static let currentTracksSub2Title = "current-tracks/sub2/title"
  /** current-tracks/audio/lang */
  static let currentTracksAudioLang = "current-tracks/audio/lang"
  /** current-tracks/video/lang */
  static let currentTracksVideoLang = "current-tracks/video/lang"
  /** current-tracks/sub/lang */
  static let currentTracksSubLang = "current-tracks/sub/lang"
  /** current-tracks/sub2/lang */
  static let currentTracksSub2Lang = "current-tracks/sub2/lang"
  /** current-tracks/audio/image */
  static let currentTracksAudioImage = "current-tracks/audio/image"
  /** current-tracks/video/image */
  static let currentTracksVideoImage = "current-tracks/video/image"
  /** current-tracks/sub/image */
  static let currentTracksSubImage = "current-tracks/sub/image"
  /** current-tracks/sub2/image */
  static let currentTracksSub2Image = "current-tracks/sub2/image"
  /** current-tracks/audio/albumart */
  static let currentTracksAudioAlbumart = "current-tracks/audio/albumart"
  /** current-tracks/video/albumart */
  static let currentTracksVideoAlbumart = "current-tracks/video/albumart"
  /** current-tracks/sub/albumart */
  static let currentTracksSubAlbumart = "current-tracks/sub/albumart"
  /** current-tracks/sub2/albumart */
  static let currentTracksSub2Albumart = "current-tracks/sub2/albumart"
  /** current-tracks/audio/default */
  static let currentTracksAudioDefault = "current-tracks/audio/default"
  /** current-tracks/video/default */
  static let currentTracksVideoDefault = "current-tracks/video/default"
  /** current-tracks/sub/default */
  static let currentTracksSubDefault = "current-tracks/sub/default"
  /** current-tracks/sub2/default */
  static let currentTracksSub2Default = "current-tracks/sub2/default"
  /** current-tracks/audio/forced */
  static let currentTracksAudioForced = "current-tracks/audio/forced"
  /** current-tracks/video/forced */
  static let currentTracksVideoForced = "current-tracks/video/forced"
  /** current-tracks/sub/forced */
  static let currentTracksSubForced = "current-tracks/sub/forced"
  /** current-tracks/sub2/forced */
  static let currentTracksSub2Forced = "current-tracks/sub2/forced"
  /** current-tracks/audio/codec */
  static let currentTracksAudioCodec = "current-tracks/audio/codec"
  /** current-tracks/video/codec */
  static let currentTracksVideoCodec = "current-tracks/video/codec"
  /** current-tracks/sub/codec */
  static let currentTracksSubCodec = "current-tracks/sub/codec"
  /** current-tracks/sub2/codec */
  static let currentTracksSub2Codec = "current-tracks/sub2/codec"
  /** current-tracks/audio/codec-desc */
  static let currentTracksAudioCodecDesc = "current-tracks/audio/codec-desc"
  /** current-tracks/video/codec-desc */
  static let currentTracksVideoCodecDesc = "current-tracks/video/codec-desc"
  /** current-tracks/sub/codec-desc */
  static let currentTracksSubCodecDesc = "current-tracks/sub/codec-desc"
  /** current-tracks/sub2/codec-desc */
  static let currentTracksSub2CodecDesc = "current-tracks/sub2/codec-desc"
  /** current-tracks/audio/codec-profile */
  static let currentTracksAudioCodecProfile = "current-tracks/audio/codec-profile"
  /** current-tracks/video/codec-profile */
  static let currentTracksVideoCodecProfile = "current-tracks/video/codec-profile"
  /** current-tracks/sub/codec-profile */
  static let currentTracksSubCodecProfile = "current-tracks/sub/codec-profile"
  /** current-tracks/sub2/codec-profile */
  static let currentTracksSub2CodecProfile = "current-tracks/sub2/codec-profile"
  /** current-tracks/audio/external */
  static let currentTracksAudioExternal = "current-tracks/audio/external"
  /** current-tracks/video/external */
  static let currentTracksVideoExternal = "current-tracks/video/external"
  /** current-tracks/sub/external */
  static let currentTracksSubExternal = "current-tracks/sub/external"
  /** current-tracks/sub2/external */
  static let currentTracksSub2External = "current-tracks/sub2/external"
  /** current-tracks/audio/external-filename */
  static let currentTracksAudioExternalFilename = "current-tracks/audio/external-filename"
  /** current-tracks/video/external-filename */
  static let currentTracksVideoExternalFilename = "current-tracks/video/external-filename"
  /** current-tracks/sub/external-filename */
  static let currentTracksSubExternalFilename = "current-tracks/sub/external-filename"
  /** current-tracks/sub2/external-filename */
  static let currentTracksSub2ExternalFilename = "current-tracks/sub2/external-filename"
  /** current-tracks/audio/selected */
  static let currentTracksAudioSelected = "current-tracks/audio/selected"
  /** current-tracks/video/selected */
  static let currentTracksVideoSelected = "current-tracks/video/selected"
  /** current-tracks/sub/selected */
  static let currentTracksSubSelected = "current-tracks/sub/selected"
  /** current-tracks/sub2/selected */
  static let currentTracksSub2Selected = "current-tracks/sub2/selected"
  /** current-tracks/audio/main-selection */
  static let currentTracksAudioMainSelection = "current-tracks/audio/main-selection"
  /** current-tracks/video/main-selection */
  static let currentTracksVideoMainSelection = "current-tracks/video/main-selection"
  /** current-tracks/sub/main-selection */
  static let currentTracksSubMainSelection = "current-tracks/sub/main-selection"
  /** current-tracks/sub2/main-selection */
  static let currentTracksSub2MainSelection = "current-tracks/sub2/main-selection"
  /** current-tracks/audio/ff-index */
  static let currentTracksAudioFfIndex = "current-tracks/audio/ff-index"
  /** current-tracks/video/ff-index */
  static let currentTracksVideoFfIndex = "current-tracks/video/ff-index"
  /** current-tracks/sub/ff-index */
  static let currentTracksSubFfIndex = "current-tracks/sub/ff-index"
  /** current-tracks/sub2/ff-index */
  static let currentTracksSub2FfIndex = "current-tracks/sub2/ff-index"
  /** current-tracks/audio/decoder-desc */
  static let currentTracksAudioDecoderDesc = "current-tracks/audio/decoder-desc"
  /** current-tracks/video/decoder-desc */
  static let currentTracksVideoDecoderDesc = "current-tracks/video/decoder-desc"
  /** current-tracks/sub/decoder-desc */
  static let currentTracksSubDecoderDesc = "current-tracks/sub/decoder-desc"
  /** current-tracks/sub2/decoder-desc */
  static let currentTracksSub2DecoderDesc = "current-tracks/sub2/decoder-desc"
  /** current-tracks/audio/demux-w */
  static let currentTracksAudioDemuxW = "current-tracks/audio/demux-w"
  /** current-tracks/video/demux-w */
  static let currentTracksVideoDemuxW = "current-tracks/video/demux-w"
  /** current-tracks/sub/demux-w */
  static let currentTracksSubDemuxW = "current-tracks/sub/demux-w"
  /** current-tracks/sub2/demux-w */
  static let currentTracksSub2DemuxW = "current-tracks/sub2/demux-w"
  /** current-tracks/audio/demux-h */
  static let currentTracksAudioDemuxH = "current-tracks/audio/demux-h"
  /** current-tracks/video/demux-h */
  static let currentTracksVideoDemuxH = "current-tracks/video/demux-h"
  /** current-tracks/sub/demux-h */
  static let currentTracksSubDemuxH = "current-tracks/sub/demux-h"
  /** current-tracks/sub2/demux-h */
  static let currentTracksSub2DemuxH = "current-tracks/sub2/demux-h"
  /** current-tracks/audio/demux-crop-x */
  static let currentTracksAudioDemuxCropX = "current-tracks/audio/demux-crop-x"
  /** current-tracks/video/demux-crop-x */
  static let currentTracksVideoDemuxCropX = "current-tracks/video/demux-crop-x"
  /** current-tracks/sub/demux-crop-x */
  static let currentTracksSubDemuxCropX = "current-tracks/sub/demux-crop-x"
  /** current-tracks/sub2/demux-crop-x */
  static let currentTracksSub2DemuxCropX = "current-tracks/sub2/demux-crop-x"
  /** current-tracks/audio/demux-crop-y */
  static let currentTracksAudioDemuxCropY = "current-tracks/audio/demux-crop-y"
  /** current-tracks/video/demux-crop-y */
  static let currentTracksVideoDemuxCropY = "current-tracks/video/demux-crop-y"
  /** current-tracks/sub/demux-crop-y */
  static let currentTracksSubDemuxCropY = "current-tracks/sub/demux-crop-y"
  /** current-tracks/sub2/demux-crop-y */
  static let currentTracksSub2DemuxCropY = "current-tracks/sub2/demux-crop-y"
  /** current-tracks/audio/demux-crop-w */
  static let currentTracksAudioDemuxCropW = "current-tracks/audio/demux-crop-w"
  /** current-tracks/video/demux-crop-w */
  static let currentTracksVideoDemuxCropW = "current-tracks/video/demux-crop-w"
  /** current-tracks/sub/demux-crop-w */
  static let currentTracksSubDemuxCropW = "current-tracks/sub/demux-crop-w"
  /** current-tracks/sub2/demux-crop-w */
  static let currentTracksSub2DemuxCropW = "current-tracks/sub2/demux-crop-w"
  /** current-tracks/audio/demux-crop-h */
  static let currentTracksAudioDemuxCropH = "current-tracks/audio/demux-crop-h"
  /** current-tracks/video/demux-crop-h */
  static let currentTracksVideoDemuxCropH = "current-tracks/video/demux-crop-h"
  /** current-tracks/sub/demux-crop-h */
  static let currentTracksSubDemuxCropH = "current-tracks/sub/demux-crop-h"
  /** current-tracks/sub2/demux-crop-h */
  static let currentTracksSub2DemuxCropH = "current-tracks/sub2/demux-crop-h"
  /** current-tracks/audio/demux-channel-count */
  static let currentTracksAudioDemuxChannelCount = "current-tracks/audio/demux-channel-count"
  /** current-tracks/video/demux-channel-count */
  static let currentTracksVideoDemuxChannelCount = "current-tracks/video/demux-channel-count"
  /** current-tracks/sub/demux-channel-count */
  static let currentTracksSubDemuxChannelCount = "current-tracks/sub/demux-channel-count"
  /** current-tracks/sub2/demux-channel-count */
  static let currentTracksSub2DemuxChannelCount = "current-tracks/sub2/demux-channel-count"
  /** current-tracks/audio/demux-channels */
  static let currentTracksAudioDemuxChannels = "current-tracks/audio/demux-channels"
  /** current-tracks/video/demux-channels */
  static let currentTracksVideoDemuxChannels = "current-tracks/video/demux-channels"
  /** current-tracks/sub/demux-channels */
  static let currentTracksSubDemuxChannels = "current-tracks/sub/demux-channels"
  /** current-tracks/sub2/demux-channels */
  static let currentTracksSub2DemuxChannels = "current-tracks/sub2/demux-channels"
  /** current-tracks/audio/demux-samplerate */
  static let currentTracksAudioDemuxSamplerate = "current-tracks/audio/demux-samplerate"
  /** current-tracks/video/demux-samplerate */
  static let currentTracksVideoDemuxSamplerate = "current-tracks/video/demux-samplerate"
  /** current-tracks/sub/demux-samplerate */
  static let currentTracksSubDemuxSamplerate = "current-tracks/sub/demux-samplerate"
  /** current-tracks/sub2/demux-samplerate */
  static let currentTracksSub2DemuxSamplerate = "current-tracks/sub2/demux-samplerate"
  /** current-tracks/audio/demux-fps */
  static let currentTracksAudioDemuxFps = "current-tracks/audio/demux-fps"
  /** current-tracks/video/demux-fps */
  static let currentTracksVideoDemuxFps = "current-tracks/video/demux-fps"
  /** current-tracks/sub/demux-fps */
  static let currentTracksSubDemuxFps = "current-tracks/sub/demux-fps"
  /** current-tracks/sub2/demux-fps */
  static let currentTracksSub2DemuxFps = "current-tracks/sub2/demux-fps"
  /** current-tracks/audio/demux-bitrate */
  static let currentTracksAudioDemuxBitrate = "current-tracks/audio/demux-bitrate"
  /** current-tracks/video/demux-bitrate */
  static let currentTracksVideoDemuxBitrate = "current-tracks/video/demux-bitrate"
  /** current-tracks/sub/demux-bitrate */
  static let currentTracksSubDemuxBitrate = "current-tracks/sub/demux-bitrate"
  /** current-tracks/sub2/demux-bitrate */
  static let currentTracksSub2DemuxBitrate = "current-tracks/sub2/demux-bitrate"
  /** current-tracks/audio/demux-rotation */
  static let currentTracksAudioDemuxRotation = "current-tracks/audio/demux-rotation"
  /** current-tracks/video/demux-rotation */
  static let currentTracksVideoDemuxRotation = "current-tracks/video/demux-rotation"
  /** current-tracks/sub/demux-rotation */
  static let currentTracksSubDemuxRotation = "current-tracks/sub/demux-rotation"
  /** current-tracks/sub2/demux-rotation */
  static let currentTracksSub2DemuxRotation = "current-tracks/sub2/demux-rotation"
  /** current-tracks/audio/demux-par */
  static let currentTracksAudioDemuxPar = "current-tracks/audio/demux-par"
  /** current-tracks/video/demux-par */
  static let currentTracksVideoDemuxPar = "current-tracks/video/demux-par"
  /** current-tracks/sub/demux-par */
  static let currentTracksSubDemuxPar = "current-tracks/sub/demux-par"
  /** current-tracks/sub2/demux-par */
  static let currentTracksSub2DemuxPar = "current-tracks/sub2/demux-par"
  /** current-tracks/audio/format-name */
  static let currentTracksAudioFormatName = "current-tracks/audio/format-name"
  /** current-tracks/video/format-name */
  static let currentTracksVideoFormatName = "current-tracks/video/format-name"
  /** current-tracks/sub/format-name */
  static let currentTracksSubFormatName = "current-tracks/sub/format-name"
  /** current-tracks/sub2/format-name */
  static let currentTracksSub2FormatName = "current-tracks/sub2/format-name"
  /** current-tracks/audio/audio-channels */
  static let currentTracksAudioAudioChannels = "current-tracks/audio/audio-channels"
  /** current-tracks/video/audio-channels */
  static let currentTracksVideoAudioChannels = "current-tracks/video/audio-channels"
  /** current-tracks/sub/audio-channels */
  static let currentTracksSubAudioChannels = "current-tracks/sub/audio-channels"
  /** current-tracks/sub2/audio-channels */
  static let currentTracksSub2AudioChannels = "current-tracks/sub2/audio-channels"
  /** current-tracks/audio/replaygain-track-peak */
  static let currentTracksAudioReplaygainTrackPeak = "current-tracks/audio/replaygain-track-peak"
  /** current-tracks/video/replaygain-track-peak */
  static let currentTracksVideoReplaygainTrackPeak = "current-tracks/video/replaygain-track-peak"
  /** current-tracks/sub/replaygain-track-peak */
  static let currentTracksSubReplaygainTrackPeak = "current-tracks/sub/replaygain-track-peak"
  /** current-tracks/sub2/replaygain-track-peak */
  static let currentTracksSub2ReplaygainTrackPeak = "current-tracks/sub2/replaygain-track-peak"
  /** current-tracks/audio/replaygain-track-gain */
  static let currentTracksAudioReplaygainTrackGain = "current-tracks/audio/replaygain-track-gain"
  /** current-tracks/video/replaygain-track-gain */
  static let currentTracksVideoReplaygainTrackGain = "current-tracks/video/replaygain-track-gain"
  /** current-tracks/sub/replaygain-track-gain */
  static let currentTracksSubReplaygainTrackGain = "current-tracks/sub/replaygain-track-gain"
  /** current-tracks/sub2/replaygain-track-gain */
  static let currentTracksSub2ReplaygainTrackGain = "current-tracks/sub2/replaygain-track-gain"
  /** current-tracks/audio/replaygain-album-peak */
  static let currentTracksAudioReplaygainAlbumPeak = "current-tracks/audio/replaygain-album-peak"
  /** current-tracks/video/replaygain-album-peak */
  static let currentTracksVideoReplaygainAlbumPeak = "current-tracks/video/replaygain-album-peak"
  /** current-tracks/sub/replaygain-album-peak */
  static let currentTracksSubReplaygainAlbumPeak = "current-tracks/sub/replaygain-album-peak"
  /** current-tracks/sub2/replaygain-album-peak */
  static let currentTracksSub2ReplaygainAlbumPeak = "current-tracks/sub2/replaygain-album-peak"
  /** current-tracks/audio/replaygain-album-gain */
  static let currentTracksAudioReplaygainAlbumGain = "current-tracks/audio/replaygain-album-gain"
  /** current-tracks/video/replaygain-album-gain */
  static let currentTracksVideoReplaygainAlbumGain = "current-tracks/video/replaygain-album-gain"
  /** current-tracks/sub/replaygain-album-gain */
  static let currentTracksSubReplaygainAlbumGain = "current-tracks/sub/replaygain-album-gain"
  /** current-tracks/sub2/replaygain-album-gain */
  static let currentTracksSub2ReplaygainAlbumGain = "current-tracks/sub2/replaygain-album-gain"
  /** chapter-list */
  static let chapterList = "chapter-list"
  /** chapter-list/count */
  static let chapterListCount = "chapter-list/count"
  /** chapter-list/N/title */
  static func chapterListNTitle(_ n: Int) -> String {
    return "chapter-list/\(n)/title"
  }
  /** chapter-list/N/time */
  static func chapterListNTime(_ n: Int) -> String {
    return "chapter-list/\(n)/time"
  }
  /** af */
  static let af = "af"
  /** vf */
  static let vf = "vf"
  /** seekable */
  static let seekable = "seekable"
  /** partially-seekable */
  static let partiallySeekable = "partially-seekable"
  /** playback-abort */
  static let playbackAbort = "playback-abort"
  /** cursor-autohide */
  static let cursorAutohide = "cursor-autohide"
  /** osd-sym-cc */
  static let osdSymCc = "osd-sym-cc"
  /** osd-ass-cc */
  static let osdAssCc = "osd-ass-cc"
  /** vo-configured */
  static let voConfigured = "vo-configured"
  /** vo-passes */
  static let voPasses = "vo-passes"
  /** vo-passes/TYPE/count */
  static let voPassesTYPECount = "vo-passes/TYPE/count"
  /** vo-passes/TYPE/N/desc */
  static func voPassesTYPENDesc(_ n: Int) -> String {
    return "vo-passes/TYPE/\(n)/desc"
  }
  /** vo-passes/TYPE/N/last */
  static func voPassesTYPENLast(_ n: Int) -> String {
    return "vo-passes/TYPE/\(n)/last"
  }
  /** vo-passes/TYPE/N/avg */
  static func voPassesTYPENAvg(_ n: Int) -> String {
    return "vo-passes/TYPE/\(n)/avg"
  }
  /** vo-passes/TYPE/N/peak */
  static func voPassesTYPENPeak(_ n: Int) -> String {
    return "vo-passes/TYPE/\(n)/peak"
  }
  /** vo-passes/TYPE/N/count */
  static func voPassesTYPENCount(_ n: Int) -> String {
    return "vo-passes/TYPE/\(n)/count"
  }
  /** vo-passes/TYPE/N/samples/M */
  static func voPassesTYPENSamplesM(_ n: Int) -> String {
    return "vo-passes/TYPE/\(n)/samples/M"
  }
  /** perf-info */
  static let perfInfo = "perf-info"
  /** video-bitrate */
  static let videoBitrate = "video-bitrate"
  /** audio-bitrate */
  static let audioBitrate = "audio-bitrate"
  /** sub-bitrate */
  static let subBitrate = "sub-bitrate"
  /** packet-video-bitrate */
  static let packetVideoBitrate = "packet-video-bitrate"
  /** packet-audio-bitrate */
  static let packetAudioBitrate = "packet-audio-bitrate"
  /** packet-sub-bitrate */
  static let packetSubBitrate = "packet-sub-bitrate"
  /** audio-device-list */
  static let audioDeviceList = "audio-device-list"
  /** audio-device */
  static let audioDevice = "audio-device"
  /** current-vo */
  static let currentVo = "current-vo"
  /** current-gpu-context */
  static let currentGpuContext = "current-gpu-context"
  /** current-ao */
  static let currentAo = "current-ao"
  /** user-data */
  static let userData = "user-data"
  /** menu-data */
  static let menuData = "menu-data"
  /** working-directory */
  static let workingDirectory = "working-directory"
  /** protocol-list */
  static let protocolList = "protocol-list"
  /** decoder-list */
  static let decoderList = "decoder-list"
  /** encoder-list */
  static let encoderList = "encoder-list"
  /** demuxer-lavf-list */
  static let demuxerLavfList = "demuxer-lavf-list"
  /** input-key-list */
  static let inputKeyList = "input-key-list"
  /** mpv-version */
  static let mpvVersion = "mpv-version"
  /** mpv-configuration */
  static let mpvConfiguration = "mpv-configuration"
  /** ffmpeg-version */
  static let ffmpegVersion = "ffmpeg-version"
  /** libass-version */
  static let libassVersion = "libass-version"
  /** platform */
  static let platform = "platform"
  /** options/<name> */
  static func options(_ name: String) -> String {
    return "options/\(name)"
  }
  /** file-local-options/<name> */
  static func fileLocalOptions(_ name: String) -> String {
    return "file-local-options/\(name)"
  }
  /** option-info/<name> */
  static func optionInfo(_ name: String) -> String {
    return "option-info/\(name)"
  }
  /** option-info/<name>/name */
  static func optionInfoName(_ name: String) -> String {
    return "option-info/\(name)/name"
  }
  /** option-info/<name>/type */
  static func optionInfoType(_ name: String) -> String {
    return "option-info/\(name)/type"
  }
  /** option-info/<name>/set-from-commandline */
  static func optionInfoSetFromCommandline(_ name: String) -> String {
    return "option-info/\(name)/set-from-commandline"
  }
  /** option-info/<name>/set-locally */
  static func optionInfoSetLocally(_ name: String) -> String {
    return "option-info/\(name)/set-locally"
  }
  /** option-info/<name>/default-value */
  static func optionInfoDefaultValue(_ name: String) -> String {
    return "option-info/\(name)/default-value"
  }
  /** option-info/<name>/min */
  static func optionInfoMin(_ name: String) -> String {
    return "option-info/\(name)/min"
  }
  /** option-info/<name>/max */
  static func optionInfoMax(_ name: String) -> String {
    return "option-info/\(name)/max"
  }
  /** option-info/<name>/choices */
  static func optionInfoChoices(_ name: String) -> String {
    return "option-info/\(name)/choices"
  }
  /** property-list */
  static let propertyList = "property-list"
  /** profile-list */
  static let profileList = "profile-list"
  /** command-list */
  static let commandList = "command-list"
  /** input-bindings */
  static let inputBindings = "input-bindings"
}
