"use strict";

const { extract } = require("./index");

/**
 * @module DataParser/parishes
 *
 * Writes parishes.json to stdout
 *
 * Notes:
 * - Manually add 4 missing GSS parish codes
 */

const CODE_OFFSET = 0;
const VALUE_OFFSET = 1;

const transform = (row) => {
  const code = row[CODE_OFFSET];
  const value = row[VALUE_OFFSET];
  if (value === "PAR21CD") return []; // Escape if header
  return [code, value];
};

const parseOptions = { delimiter: "," };

const appendMissing = {
  E43000234: "Three Rivers, unparished area",
  E43000097: "Lancaster, unparished area",
  E43000135: "Waveney, unparished area",
  E43000245: "Swindon, unparished area",
  E43000001: "Hartlepool, unparished area",
  E43000002: "Middlesbrough, unparished area",
  E43000003: "Redcar and Cleveland, unparished area",
  E43000004: "Stockton-on-Tees, unparished area",
  E43000006: "Halton, unparished area",
  E43000007: "Warrington, unparished area",
  E43000008: "Blackburn with Darwen, unparished area",
  E43000009: "Blackpool, unparished area",
  E43000010: "Kingston upon Hull, City of, unparished area",
  E43000011: "North East Lincolnshire, unparished area",
  E43000012: "North Lincolnshire, unparished area",
  E43000013: "York, unparished area",
  E43000014: "Derby, unparished area",
  E43000015: "Leicester, unparished area",
  E43000016: "Nottingham, unparished area",
  E43000017: "Stoke-on-Trent, unparished area",
  E43000018: "Bath and North East Somerset, unparished area",
  E43000019: "Bristol, City of, unparished area",
  E43000020: "South Gloucestershire, unparished area",
  E43000021: "Plymouth, unparished area",
  E43000022: "Torbay, unparished area",
  E43000026: "Peterborough, unparished area",
  E43000027: "Luton, unparished area",
  E43000028: "Southend-on-Sea, unparished area",
  E43000029: "Thurrock, unparished area",
  E43000030: "Medway, unparished area",
  E43000031: "Reading, unparished area",
  E43000034: "Brighton and Hove, unparished area",
  E43000035: "Portsmouth, unparished area",
  E43000036: "Southampton, unparished area",
  E43000042: "Cambridge, unparished area",
  E43000043: "Barrow-in-Furness, unparished area",
  E43000044: "Carlisle, unparished area",
  E43000047: "Amber Valley, unparished area",
  E43000048: "Chesterfield, unparished area",
  E43000049: "Erewash, unparished area",
  E43000050: "High Peak, unparished area",
  E43000051: "South Derbyshire, unparished area",
  E43000052: "Exeter, unparished area",
  E43000055: "Eastbourne, unparished area",
  E43000056: "Hastings, unparished area",
  E43000057: "Rother, unparished area",
  E43000058: "Basildon, unparished area",
  E43000060: "Brentwood, unparished area",
  E43000061: "Castle Point, unparished area",
  E43000062: "Chelmsford, unparished area",
  E43000064: "Harlow, unparished area",
  E43000067: "Gloucester, unparished area",
  E43000069: "Eastleigh, unparished area",
  E43000070: "Fareham, unparished area",
  E43000071: "Gosport, unparished area",
  E43000072: "Havant, unparished area",
  E43000073: "Rushmoor, unparished area",
  E43000074: "Winchester, unparished area",
  E43000075: "Broxbourne, unparished area",
  E43000076: "Dacorum, unparished area",
  E43000077: "Hertsmere, unparished area",
  E43000079: "St Albans, unparished area",
  E43000080: "Stevenage, unparished area",
  E43000082: "Watford, unparished area",
  E43000083: "Welwyn Hatfield, unparished area",
  E43000087: "Gravesham, unparished area",
  E43000088: "Maidstone, unparished area",
  E43000091: "Tonbridge and Malling, unparished area",
  E43000092: "Tunbridge Wells, unparished area",
  E43000093: "Burnley, unparished area",
  E43000094: "Chorley, unparished area",
  E43000095: "Fylde, unparished area",
  E43000096: "Hyndburn, unparished area",
  E43000097: "Lancaster, unparished area",
  E43000099: "Rossendale, unparished area",
  E43000100: "South Ribble, unparished area",
  E43000101: "West Lancashire, unparished area",
  E43000102: "Wyre, unparished area",
  E43000104: "Harborough, unparished area",
  E43000105: "Hinckley and Bosworth, unparished area",
  E43000106: "Melton, unparished area",
  E43000107: "North West Leicestershire, unparished area",
  E43000108: "Oadby and Wigston, unparished area",
  E43000109: "Boston, unparished area",
  E43000110: "Lincoln, unparished area",
  E43000111: "South Holland, unparished area",
  E43000112: "South Kesteven, unparished area",
  E43000113: "Great Yarmouth, unparished area",
  E43000115: "Norwich, unparished area",
  E43000116: "Corby, unparished area",
  E43000117: "Kettering, unparished area",
  E43000119: "Wellingborough, unparished area",
  E43000121: "Scarborough, unparished area",
  E43000122: "Ashfield, unparished area",
  E43000123: "Bassetlaw, unparished area",
  E43000124: "Broxtowe, unparished area",
  E43000125: "Gedling, unparished area",
  E43000126: "Mansfield, unparished area",
  E43000127: "Rushcliffe, unparished area",
  E43000128: "Oxford, unparished area",
  E43000130: "Cannock Chase, unparished area",
  E43000131: "Newcastle-under-Lyme, unparished area",
  E43000132: "Stafford, unparished area",
  E43000133: "Tamworth, unparished area",
  E43000134: "Ipswich, unparished area",
  E43000135: "Waveney, unparished area",
  E43000136: "Elmbridge, unparished area",
  E43000137: "Epsom and Ewell, unparished area",
  E43000138: "Guildford, unparished area",
  E43000139: "Mole Valley, unparished area",
  E43000140: "Reigate and Banstead, unparished area",
  E43000141: "Runnymede, unparished area",
  E43000142: "Spelthorne, unparished area",
  E43000143: "Surrey Heath, unparished area",
  E43000144: "Woking, unparished area",
  E43000145: "Nuneaton and Bedworth, unparished area",
  E43000147: "Adur, unparished area",
  E43000148: "Crawley, unparished area",
  E43000149: "Horsham, unparished area",
  E43000150: "Worthing, unparished area",
  E43000151: "Bromsgrove, unparished area",
  E43000152: "Redditch, unparished area",
  E43000153: "Worcester, unparished area",
  E43000155: "Bolton, unparished area",
  E43000156: "Bury, unparished area",
  E43000157: "Manchester, unparished area",
  E43000158: "Oldham, unparished area",
  E43000159: "Rochdale, unparished area",
  E43000160: "Salford, unparished area",
  E43000161: "Stockport, unparished area",
  E43000162: "Tameside, unparished area",
  E43000163: "Trafford, unparished area",
  E43000164: "Wigan, unparished area",
  E43000166: "Liverpool, unparished area",
  E43000167: "St. Helens, unparished area",
  E43000168: "Sefton, unparished area",
  E43000169: "Wirral, unparished area",
  E43000171: "Doncaster, unparished area",
  E43000172: "Rotherham, unparished area",
  E43000173: "Sheffield, unparished area",
  E43000176: "North Tyneside, unparished area",
  E43000177: "South Tyneside, unparished area",
  E43000178: "Sunderland, unparished area",
  E43000181: "Dudley, unparished area",
  E43000182: "Sandwell, unparished area",
  E43000184: "Walsall, unparished area",
  E43000185: "Wolverhampton, unparished area",
  E43000187: "Calderdale, unparished area",
  E43000188: "Kirklees, unparished area",
  E43000190: "Wakefield, unparished area",
  E43000191: "City of London, unparished area",
  E43000192: "Barking and Dagenham, unparished area",
  E43000193: "Barnet, unparished area",
  E43000194: "Bexley, unparished area",
  E43000195: "Brent, unparished area",
  E43000196: "Bromley, unparished area",
  E43000197: "Camden, unparished area",
  E43000198: "Croydon, unparished area",
  E43000199: "Ealing, unparished area",
  E43000200: "Enfield, unparished area",
  E43000201: "Greenwich, unparished area",
  E43000202: "Hackney, unparished area",
  E43000203: "Hammersmith and Fulham, unparished area",
  E43000204: "Haringey, unparished area",
  E43000205: "Harrow, unparished area",
  E43000206: "Havering, unparished area",
  E43000207: "Hillingdon, unparished area",
  E43000208: "Hounslow, unparished area",
  E43000209: "Islington, unparished area",
  E43000210: "Kensington and Chelsea, unparished area",
  E43000211: "Kingston upon Thames, unparished area",
  E43000212: "Lambeth, unparished area",
  E43000213: "Lewisham, unparished area",
  E43000214: "Merton, unparished area",
  E43000215: "Newham, unparished area",
  E43000216: "Redbridge, unparished area",
  E43000217: "Richmond upon Thames, unparished area",
  E43000218: "Southwark, unparished area",
  E43000219: "Sutton, unparished area",
  E43000220: "Tower Hamlets, unparished area",
  E43000221: "Waltham Forest, unparished area",
  E43000222: "Wandsworth, unparished area",
  E43000224: "Basingstoke and Deane, unparished area",
  E43000225: "Preston, unparished area",
  E43000228: "Colchester, unparished area",
  E43000229: "Gateshead, unparished area",
  E43000230: "King's Lynn and West Norfolk, unparished area",
  E43000232: "North Hertfordshire, unparished area",
  E43000234: "Three Rivers, unparished area",
  E43000235: "Slough, unparished area",
  E43000236: "Westminster, unparished area",
  E43000237: "Rugby, unparished area",
  E43000241: "Thanet, unparished area",
  E43000243: "Knowsley, unparished area",
  E43000245: "Swindon, unparished area",
  E43000246: "Coventry, unparished area",
  E43000248: "Harrogate, unparished area",
  E43000249: "Darlington, unparished area",
  E43000250: "Birmingham, unparished area",
  E43000251: "Barnsley, unparished area",
  E43000252: "Three Rivers, unparished area",
  E43000253: "Lancaster, unparished area",
  E43000254: "County Durham, unparished area",
  E43000255: "Cheltenham, unparished area",
  E43000258: "Tendring, unparished area",
  E43000259: "Windsor and Maidenhead, unparished area",
  E43000261: "Bournemouth, Christchurch and Poole, unparished area",
  E43000262: "Dorset, unparished area",
  E43000263: "Somerset West and Taunton, unparished area",
  E43000264: "Charnwood, unparished area",
  E43000265: "Solihull, unparished area",
  E43000266: "Dartford, unparished area",
  E43000267: "Braintree, unparished area",
  E43000268: "Swale, unparished area",
  E43000269: "Canterbury, unparished area",
  E43000270: "Newcastle upon Tyne, unparished area",
  E43000271: "Ashford, unparished area",
  E43000272: "Cheshire West and Chester, unparished area",
  E43000273: "Bedford, unparished area",
  E43000274: "Bradford, unparished area",
  E43000275: "Buckinghamshire, unparished area",
  E43000276: "Leeds, unparished area",
  E43000279: "Blackburn with Darwen, unparished area",
  E43000278: "St. Helens, unparished area",
  E43000280: "North Northamptonshire, unparished area",
  E43000290: "St Albans, unparished area",
  E04013285: "London Colney",
  E04013252: "South Mimms and Ridge",
  E04013288: "St Stephen",
  E04013250: "Aldenham",
  E04013287: "St Michael",
  E04013286: "Sandridge",
  E04013289: "Wheathampstead",
  E04013284: "Harpenden Town",
  E04013283: "Colney Heath",
  E04013157: "Yeovilton and District",
  E04013238: "Barnoldswick",
  E04013239: "Salterforth",
  E43000294: "Leeds, unparished area",
  E43000293: "Calderdale, unparished area",
  E04013297: "Cross Roads",
  E04013298: "Haworth and Stanbury",
  E04013339: "Almondsbury",
  E04013343: "Kingswood",
  E04013346: "Siston",
  E04013347: "Staple Hill and Mangotsfield",
  E04013349: "Stoke Park and Cheswick",
  E04013341: "Emersons Green",
  E04013345: "Pucklechurch",
  E04013344: "Patchway",
  E04013348: "Stoke Gifford",
  E04013340: "Charlton Hayes",
  E04013342: "Horton",
  E43000295: "Cumberland, unparished area",
  E04013154: "Great Chesterford",
  E04013156: "Little Chesterford",
  E04013155: "Henham",
  E04013139: "Babraham",
  E04013140: "Sawston",
  E04013229: "Burrough Green",
  E04013230: "Westley Waterless",
  E04013225: "Wickhambrook",
  E04013222: "Denston",
  E04013221: "Dalham",
  E04013223: "Ousden",
  W04001039: "Pontypridd Town",
  W04001041: "Trehafod",
  W04001040: "Trealaw",
  W04001038: "Llwyn-y-pia",
  W04001042: "Ystrad",
  E43000285: "Chelmsford, unparished area",
  E04013168: "Chelmer",
  E04013167: "Broomfield",
  E04013169: "Chelmsford Garden",
  E04013172: "Springfield",
  E43000282: "Basildon, unparished area",
  E04013166: "Boreham",
  E04013170: "Great Baddow",
  E04013153: "Elsenham",
  E04013171: "Little Waltham",
  E04013186: "Haslington",
  E04013182: "Weston and Crewe Green",
  E04013175: "Alsager",
  E04013194: "Middlewich",
  E04013197: "Moston",
  E04013202: "Sandbach",
  E04013177: "Brereton",
  E04013181: "Congleton",
  E04013184: "Eaton",
  E04013204: "Somerford",
  E04013203: "Shavington cum Gresty",
  E04013201: "Rope",
  E04013188: "Hough and Chorlton",
  E04013183: "Doddington and District",
  E04013198: "Nantwich",
  E04013179: "Burland and Acton",
  E04013206: "Stoke and Hurleston",
  E04013209: "Worleston",
  E04013205: "Stapeley and District",
  E04013176: "Baddiley",
  E04013174: "Alpraham and Calveley",
  E04013178: "Bulkeley and Ridley",
  E43000286: "Dartford, unparished area",
  E04013212: "Swanscombe and Greenhithe",
  E04013320: "Fradley",
  E04013274: "South Darley",
  E04013273: "Matlock Town",
  E04013278: "Cossall",
  E43000284: "Bassetlaw, unparished area",
  E04013158: "Weymouth",
  E43000288: "Hertsmere, unparished area",
  E04013275: "Colyford",
  E04013276: "Colyton",
  E04013325: "Halberton",
  E04013327: "Uffculme",
  E04013328: "Willand",
  E04013324: "Crediton Hamlets",
  E04013323: "Colebrooke",
  E04013322: "Cheriton Bishop",
  E04013326: "Hittisleigh",
  W04001076: "Monmouth",
  E04013268: "Maisemore",
  E04013265: "Highnam",
  E04013267: "Longford",
  E04013266: "Innsworth",
  E04013264: "Churchdown",
  E04013313: "Dumbleton",
  E04013272: "Wheatpieces",
  E04013261: "Ashchurch Rural",
  E04013262: "Badgeworth",
  E04013302: "Birdlip",
  E04013329: "Brimpsfield",
  E04013263: "Bishop's Cleeve",
  E04013269: "Southam",
  E04013304: "Coberley",
  E04013305: "Cowley",
  E04013306: "Withington",
  E04013270: "Stanway",
  E04013271: "Toddington",
  E04013303: "Cirencester",
  E04013253: "Ampney Crucis",
  E04013254: "Ampney St. Mary",
  E04013301: "Baunton",
  E04013255: "Driffield",
  E04013258: "Sandhurst",
  E04013260: "Winkfield",
  E04013319: "Stainland and District",
  E43000296: "North Yorkshire, unparished area",
  E04013249: "Woodbridge",
  E04013242: "Melton",
  E04013247: "Waldringfield",
  E04013241: "Martlesham",
  E04013248: "Wickham Market",
  E04013243: "Pettistree",
  E04013245: "Saxmundham",
  E04013240: "Benhall",
  E04013163: "Thetford",
  E04013162: "Croxton",
  E04013224: "Red Lodge",
  E04013226: "Worlington",
  E04013227: "Bury St Edmunds",
  E04013228: "Rushbrooke with Rougham",
  E04013210: "East Horsley",
  E04013211: "Effingham",
  E04013220: "Barrow",
  E43000281: "Harborough, unparished area",
  E04013141: "Lubenham",
  E04013143: "Kibworth Beauchamp",
  E04013144: "Kibworth Harcourt",
  E04013146: "Saddington",
  E04013142: "Fleckney",
  W04001056: "Caia Park",
  W04001055: "Abenbury",
  W04001046: "Rhos-on-Sea",
  W04001045: "Colwyn Bay",
  E04013207: "Styal",
  E43000289: "Broxtowe, unparished area",
  E04013291: "Radcliffe on Trent",
  E04013290: "Cropwell Butler",
  E04013292: "Upper Saxondale",
  E04013279: "Greasley",
  E04013280: "Kimberley",
  E04013277: "Awsworth",
  E04013165: "Norton, Cuckney, Holbeck and Welbeck",
  E04013148: "Newark",
  E04013147: "Balderton",
  E04013149: "Winthorpe",
  E04013282: "Trowell",
  E04013281: "Stapleford",
  E04013338: "Stanion",
  E04013159: "Corby",
  E04013337: "Little Stanion",
  W04001049: "Rogerstone",
  W04001047: "Graig",
  W04001072: "Llantrisant Fawr",
  W04001078: "Raglan",
  W04001062: "Devauden",
  W04001070: "Llangybi",
  W04001066: "Llanarth",
  W04001067: "Llanbadoc",
  W04001080: "Shirenewton",
  W04001064: "Goetre Fawr",
  W04001075: "Mitchel Troy",
  W04001084: "Whitecastle",
  W04001060: "Chepstow",
  W04001074: "Mathern",
  W04001082: "St. Arvans",
  W04001083: "Trellech United",
  W04001058: "Caerwent",
  W04001085: "Wye Valley",
  W04001050: "Stow Hill",
  W04001048: "Pillgwenlly",
  W04001068: "Llanelly",
  W04001043: "Beaufort",
  W04001044: "Garnlydan",
  W04001079: "Rogiet",
  W04001073: "Magor with Undy",
  W04001059: "Caldicot",
  W04001077: "Portskewett",
  W04001069: "Llanfoist Fawr",
  W04001057: "Abergavenny",
  W04001071: "Llantilio Pertholey",
  W04001061: "Crucorney",
  W04001065: "Grosmont",
  W04001081: "Skenfrith",
  W04001063: "Gobion Fawr",
  E04013160: "Attleborough",
  E04013161: "Great Ellingham",
  E04013246: "Shadingfield",
  E04013244: "Redisham",
  E04013296: "South Hinksey",
  E04013295: "Kennington",
  E04013315: "Harwell",
  E04013316: "Western Valley",
  E04013333: "Blackthorn",
  E04013331: "Ambrosden",
  E04013332: "Bicester",
  E04013335: "Chesterton",
  E04013334: "Bucknell",
  E04013336: "Launton",
  E04013300: "Whiteley",
  E04013256: "Bracknell",
  E04013259: "Warfield",
  E04013257: "Crowthorne",
  E04013294: "Henley-on-Thames",
  E04013293: "Bix and Assendon",
  E04013309: "Burgess Hill",
  E04013308: "Ansty and Staplefield",
  E04013164: "Carlton in Lindrick",
  W04001033: "Castle",
  W04001036: "Waterfront",
  W04001034: "Cockett",
  W04001035: "St Thomas",
  W04001053: "Dyffryn Clydach",
  W04001051: "Blaenhonddan",
  W04001052: "Cymer and Glyncorrwg",
  W04001054: "Gwynfi and Croeserw",
  W04001037: "Waunarlwydd",
  E04013192: "Macclesfield",
  E04013187: "Henbury",
  E04013173: "Adlington",
  E04013189: "Kettleshulme and Lyme Handley",
  E04013199: "Peover Superior and Snelson",
  E04013200: "Poynton with Worth",
  E04013185: "Handforth",
  E04013196: "Mobberley",
  E04012334: "Britwell",
  E04001211: "Wexham Court",
  E04013318: "Romsey",
  E04013299: "Curdridge",
  E04013317: "Awbridge",
  E04013150: "Wickford",
  E04013180: "Church Lawton",
  E04013193: "Marbury and District",
  E04013217: "Taunton",
  E04013218: "Trull",
  E04013213: "Bishop's Hull",
  E04013216: "Norton Fitzwarren",
  E04013215: "Kingston St. Mary",
  E04013214: "Cheddon Fitzpaine",
  E04013219: "West Monkton",
  E04013231: "Biddenden",
  E43000287: "Ashford, unparished area",
  E04013235: "Sevington with Finberry",
  E04013232: "Boughton Aluph",
  E04013234: "Mersham",
  E04013233: "High Halden",
  E04013236: "Newton Abbot",
  E04013237: "Ogwell",
  E43000291: "Middlesbrough, unparished area",
  E04013152: "Wynyard",
  E04013151: "Elwick",
  E04013312: "Greatham",
  E43000292: "Hartlepool, unparished area",
  E04013307: "Nunthorpe",
  E04013191: "Little Bollington with Agden",
  E04013195: "Millington and Rostherne",
  E04013190: "Knutsford",
  E04013208: "Tabley Superior",
  E04013251: "Hertsmere Meriden",
  E04013314: "Wormington",
  E04013321: "Streethay",
  E04013311: "Stamford Bridge",
  E04013310: "Skirpenbeck",
};

const configs = [
  {
    file: "Parish_NCP names and codes EW as at 12_21.csv",
    transform,
    parseOptions,
  },
];

extract({ configs, appendMissing });
