<?php

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * Type:     modifier
 * Name:    _print_var
 * Purpose:  formats variable contents for display in the console
 * -------------------------------------------------------------
 */
function tpl_modifier_print_var($var, $depth = 0, $length = 40)
{
    if (is_array($var)) {
        $results = "<b>Array (" . count($var) . ")</b>";
        foreach ($var as $curr_key => $curr_val) {
            $return = tpl_modifier_print_var($curr_val, $depth + 1, $length);
            $results .= "<br>&nbsp;&nbsp;&nbsp;&nbsp;" . str_repeat('&nbsp;&nbsp;', $depth * 2) . "<b>$curr_key</b> =&gt; $return";
        }
        return $results;
    } else if (is_object($var)) {
        $object_vars = get_object_vars($var);
        $results = "<b>" . get_class($var) . " Object (" . count($object_vars) . ")</b>";
        foreach ($object_vars as $curr_key => $curr_val) {
            $return = tpl_modifier_print_var($curr_val, $depth + 1, $length);
            $results .= '<br>&nbsp;&nbsp;&nbsp;&nbsp;' . str_repeat('&nbsp;&nbsp;', $depth * 2) . "<b>$curr_key</b> =&gt; $return";
        }
        return $results;
    } else {
        if (empty($var) && $var != "0") {
            return '<i>empty</i>';
        }
        if (strlen($var) > $length) {
            $results = substr($var, 0, $length) . '...';
        } else {
            $results = $var;
        }
        $results = preg_replace("![\r\t\n]!", " ", $results);
        $results = htmlspecialchars($results);
        return $results;
    }
}
