<?php

/**
 * iCMS - i Content Management System
 * Copyright (c) 2007-2017 iCMSdev.com. All rights reserved.
 *
 * @author icmsdev <master@icmsdev.com>
 * @site https://www.icmsdev.com
 * @licence https://www.icmsdev.com/LICENSE.html
 */

class FormsPackage
{
    public static $zipName = null;
    public static $zipFile = null;
    public static $next = false;
    public static $test = false;
    public static $msg_mode = null;
    public static $app_id = null;
    public static $app_name = null;
    public static $app_data = false;

    public static function install()
    {
        $zipFile = self::$zipFile;
        if (!file_exists($zipFile)) {
            return self::msg("安装包不存在", false);
        }

        Vendor::run('PclZip'); //加载zip操作类
        $zip = new PclZip($zipFile);
        if (false == ($archive_files = $zip->extract(PCLZIP_OPT_EXTRACT_AS_STRING))) {
            return self::msg("ZIP包错误", false);
        }

        if (0 == count($archive_files)) {
            return self::msg("空的ZIP文件", false);
        }
        $msg = null;
        //安装表单数据
        $setup_msg = self::setup_data($archive_files);
        if ($setup_msg === true) {
            $msg .= self::msg('表单数据安装完成', true);
        } else {
            return self::msg($setup_msg . '安装出错', false);
        }
        //创建表单表
        if (self::setup_table($archive_files)) {
            $msg .= self::msg('表单表创建完成', true);
        }

        self::$test or File::rm(self::$zipFile);
        $msg .= self::msg('表单安装完成', true);
        return $msg;
    }

    public static function setup_data(&$archive_files)
    {
        foreach ($archive_files as $key => $file) {
            $filename = basename($file['filename']);
            if ($filename == "iCMS.APP.DATA.php") {
                $content = get_php_content($file['content']);
                $content = base64_decode($content);
                // $array   = unserialize($content);
                if (substr($content, 0, 2) == 'a:') {
                    $array = unserialize($content);
                } else {
                    $array = json_decode($content, true);
                }
                $check = FormsModel::check(['app' => $array['app']]);

                if ($check) {
                    $_msg = self::msg('检测表单是否存在', false);
                    return self::msg($_msg . '该表单已经存在', false);
                }

                if ($array['table']) {
                    $tableArray = AppsTable::items($array['table']);
                    foreach ($tableArray as $value) {
                        if (DB::hasTable($value['table'])) {
                            $_msg = self::msg('检测表单表是否存在', false);
                            return self::msg($_msg . '[' . $value['table'] . ']数据表已经存在');
                        }
                    }
                }
                $array['addtime'] = time();
                self::$test or self::$app_id = FormsModel::create($array, true);
                unset($archive_files[$key]);
                self::$app_data = $array;
                self::$app_name = $array['name'];
                return true;
            }
        }
        return false;
    }
    public static function setup_table(&$archive_files)
    {
        foreach ($archive_files as $key => $file) {
            $filename = basename($file['filename']);
            if ($filename == "iCMS.APP.TABLE.php") {
                $content = get_php_content($file['content']);
                if (!self::$test) {
                    $content && AppsTable::query($content);
                }
                unset($archive_files[$key]);
                return true;
            }
        }
        return false;
    }
    public static function msg($text, $s = 0)
    {
        $text = Security::filterPath($text);
        if (self::$msg_mode == 'alert') {
            $s or Script::alert($text);
        } else {
            return str_pad($text, 80, '.') . Script::check($s) . '<iCMS>';
        }
    }
    //获取本地安装包
    public static function getLocalPkg($format = "%s%s.FORMS.*-v*.*.*.%s")
    {
        $path = sprintf($format, iPHP_PATH, iPHP_APP, Apps::PKG_EXT);
        return glob($path);
    }
}
