/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.internals.BufferPool;
import org.apache.kafka.clients.producer.internals.FutureRecordMetadata;
import org.apache.kafka.clients.producer.internals.RecordBatch;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.CopyOnWriteMap;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RecordAccumulator {
    private static final Logger log = LoggerFactory.getLogger(RecordAccumulator.class);
    private volatile boolean closed = false;
    private final AtomicInteger flushesInProgress = new AtomicInteger(0);
    private final AtomicInteger appendsInProgress = new AtomicInteger(0);
    private final int batchSize;
    private final CompressionType compression;
    private final long lingerMs;
    private final long retryBackoffMs;
    private final BufferPool free;
    private final Time time;
    private final ConcurrentMap<TopicPartition, Deque<RecordBatch>> batches;
    private final IncompleteRecordBatches incomplete;
    private final Set<TopicPartition> muted;
    private int drainIndex = 0;

    public RecordAccumulator(int batchSize, long totalSize, CompressionType compression, long lingerMs, long retryBackoffMs, Metrics metrics, Time time) {
        this.batchSize = batchSize;
        this.compression = compression;
        this.lingerMs = lingerMs;
        this.retryBackoffMs = retryBackoffMs;
        this.batches = new CopyOnWriteMap<TopicPartition, Deque<RecordBatch>>();
        String metricGrpName = "producer-metrics";
        this.free = new BufferPool(totalSize, batchSize, metrics, time, metricGrpName);
        this.incomplete = new IncompleteRecordBatches();
        this.muted = new HashSet<TopicPartition>();
        this.time = time;
        this.registerMetrics(metrics, metricGrpName);
    }

    private void registerMetrics(Metrics metrics, String metricGrpName) {
        MetricName metricName = metrics.metricName("waiting-threads", metricGrpName, "The number of user threads blocked waiting for buffer memory to enqueue their records");
        Measurable waitingThreads = new Measurable(){

            @Override
            public double measure(MetricConfig config, long now) {
                return RecordAccumulator.this.free.queued();
            }
        };
        metrics.addMetric(metricName, waitingThreads);
        metricName = metrics.metricName("buffer-total-bytes", metricGrpName, "The maximum amount of buffer memory the client can use (whether or not it is currently used).");
        Measurable totalBytes = new Measurable(){

            @Override
            public double measure(MetricConfig config, long now) {
                return RecordAccumulator.this.free.totalMemory();
            }
        };
        metrics.addMetric(metricName, totalBytes);
        metricName = metrics.metricName("buffer-available-bytes", metricGrpName, "The total amount of buffer memory that is not being used (either unallocated or in the free list).");
        Measurable availableBytes = new Measurable(){

            @Override
            public double measure(MetricConfig config, long now) {
                return RecordAccumulator.this.free.availableMemory();
            }
        };
        metrics.addMetric(metricName, availableBytes);
        Sensor bufferExhaustedRecordSensor = metrics.sensor("buffer-exhausted-records");
        metricName = metrics.metricName("buffer-exhausted-rate", metricGrpName, "The average per-second number of record sends that are dropped due to buffer exhaustion");
        bufferExhaustedRecordSensor.add(metricName, new Rate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public RecordAppendResult append(TopicPartition tp, long timestamp, byte[] key, byte[] value, Callback callback, long maxTimeToBlock) throws InterruptedException {
        ByteBuffer buffer;
        Deque<RecordBatch> dq;
        block13: {
            block12: {
                RecordAppendResult recordAppendResult;
                this.appendsInProgress.incrementAndGet();
                try {
                    Deque<RecordBatch> deque = dq = this.getOrCreateDeque(tp);
                    // MONITORENTER : deque
                    if (this.closed) {
                        throw new IllegalStateException("Cannot send after the producer is closed.");
                    }
                    RecordAppendResult appendResult = this.tryAppend(timestamp, key, value, callback, dq);
                    if (appendResult == null) break block12;
                    recordAppendResult = appendResult;
                    // MONITOREXIT : deque
                    this.appendsInProgress.decrementAndGet();
                }
                catch (Throwable throwable) {
                    this.appendsInProgress.decrementAndGet();
                    throw throwable;
                }
                return recordAppendResult;
            }
            // MONITOREXIT : deque
            int size = Math.max(this.batchSize, 12 + Record.recordSize(key, value));
            log.trace("Allocating a new {} byte message buffer for topic {} partition {}", new Object[]{size, tp.topic(), tp.partition()});
            buffer = this.free.allocate(size, maxTimeToBlock);
            Deque<RecordBatch> deque = dq;
            // MONITORENTER : deque
            if (this.closed) {
                throw new IllegalStateException("Cannot send after the producer is closed.");
            }
            RecordAppendResult appendResult = this.tryAppend(timestamp, key, value, callback, dq);
            if (appendResult == null) break block13;
            this.free.deallocate(buffer);
            RecordAppendResult recordAppendResult = appendResult;
            // MONITOREXIT : deque
            this.appendsInProgress.decrementAndGet();
            return recordAppendResult;
        }
        MemoryRecordsBuilder recordsBuilder = MemoryRecords.builder(buffer, this.compression, TimestampType.CREATE_TIME, this.batchSize);
        RecordBatch batch = new RecordBatch(tp, recordsBuilder, this.time.milliseconds());
        FutureRecordMetadata future = Utils.notNull(batch.tryAppend(timestamp, key, value, callback, this.time.milliseconds()));
        dq.addLast(batch);
        this.incomplete.add(batch);
        RecordAppendResult recordAppendResult = new RecordAppendResult(future, dq.size() > 1 || batch.isFull(), true);
        // MONITOREXIT : deque
        this.appendsInProgress.decrementAndGet();
        return recordAppendResult;
    }

    private RecordAppendResult tryAppend(long timestamp, byte[] key, byte[] value, Callback callback, Deque<RecordBatch> deque) {
        RecordBatch last = deque.peekLast();
        if (last != null) {
            FutureRecordMetadata future = last.tryAppend(timestamp, key, value, callback, this.time.milliseconds());
            if (future == null) {
                last.close();
            } else {
                return new RecordAppendResult(future, deque.size() > 1 || last.isFull(), false);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecordBatch> abortExpiredBatches(int requestTimeout, long now) {
        ArrayList<RecordBatch> expiredBatches = new ArrayList<RecordBatch>();
        int count = 0;
        for (Map.Entry entry : this.batches.entrySet()) {
            Deque dq = (Deque)entry.getValue();
            TopicPartition tp = (TopicPartition)entry.getKey();
            if (this.muted.contains(tp)) continue;
            Deque deque = dq;
            synchronized (deque) {
                RecordBatch lastBatch = (RecordBatch)dq.peekLast();
                Iterator batchIterator = dq.iterator();
                while (batchIterator.hasNext()) {
                    boolean isFull;
                    RecordBatch batch = (RecordBatch)batchIterator.next();
                    boolean bl = isFull = batch != lastBatch || batch.isFull();
                    if (!batch.maybeExpire(requestTimeout, this.retryBackoffMs, now, this.lingerMs, isFull)) break;
                    expiredBatches.add(batch);
                    ++count;
                    batchIterator.remove();
                }
            }
        }
        if (!expiredBatches.isEmpty()) {
            log.trace("Expired {} batches in accumulator", (Object)count);
            for (RecordBatch batch : expiredBatches) {
                batch.expirationDone();
                this.deallocate(batch);
            }
        }
        return expiredBatches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reenqueue(RecordBatch batch, long now) {
        Deque<RecordBatch> deque;
        ++batch.attempts;
        batch.lastAttemptMs = now;
        batch.lastAppendTime = now;
        batch.setRetry();
        Deque<RecordBatch> deque2 = deque = this.getOrCreateDeque(batch.topicPartition);
        synchronized (deque2) {
            deque.addFirst(batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadyCheckResult ready(Cluster cluster, long nowMs) {
        HashSet<Node> readyNodes = new HashSet<Node>();
        long nextReadyCheckDelayMs = Long.MAX_VALUE;
        HashSet<String> unknownLeaderTopics = new HashSet<String>();
        boolean exhausted = this.free.queued() > 0;
        for (Map.Entry entry : this.batches.entrySet()) {
            TopicPartition part = (TopicPartition)entry.getKey();
            Deque deque = (Deque)entry.getValue();
            Node leader = cluster.leaderFor(part);
            Deque deque2 = deque;
            synchronized (deque2) {
                RecordBatch batch;
                if (leader == null && !deque.isEmpty()) {
                    unknownLeaderTopics.add(part.topic());
                } else if (!readyNodes.contains(leader) && !this.muted.contains(part) && (batch = (RecordBatch)deque.peekFirst()) != null) {
                    boolean sendable;
                    boolean backingOff = batch.attempts > 0 && batch.lastAttemptMs + this.retryBackoffMs > nowMs;
                    long waitedTimeMs = nowMs - batch.lastAttemptMs;
                    long timeToWaitMs = backingOff ? this.retryBackoffMs : this.lingerMs;
                    long timeLeftMs = Math.max(timeToWaitMs - waitedTimeMs, 0L);
                    boolean full = deque.size() > 1 || batch.isFull();
                    boolean expired = waitedTimeMs >= timeToWaitMs;
                    boolean bl = sendable = full || expired || exhausted || this.closed || this.flushInProgress();
                    if (sendable && !backingOff) {
                        readyNodes.add(leader);
                    } else {
                        nextReadyCheckDelayMs = Math.min(timeLeftMs, nextReadyCheckDelayMs);
                    }
                }
            }
        }
        return new ReadyCheckResult(readyNodes, nextReadyCheckDelayMs, unknownLeaderTopics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUnsent() {
        for (Map.Entry entry : this.batches.entrySet()) {
            Deque deque;
            Deque deque2 = deque = (Deque)entry.getValue();
            synchronized (deque2) {
                if (!deque.isEmpty()) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, List<RecordBatch>> drain(Cluster cluster, Set<Node> nodes, int maxSize, long now) {
        if (nodes.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, List<RecordBatch>> batches = new HashMap<Integer, List<RecordBatch>>();
        for (Node node : nodes) {
            int size = 0;
            List<PartitionInfo> parts = cluster.partitionsForNode(node.id());
            ArrayList<RecordBatch> ready = new ArrayList<RecordBatch>();
            int start = this.drainIndex %= parts.size();
            do {
                Deque<RecordBatch> deque;
                PartitionInfo part;
                TopicPartition tp;
                if (!this.muted.contains(tp = new TopicPartition((part = parts.get(this.drainIndex)).topic(), part.partition())) && (deque = this.getDeque(new TopicPartition(part.topic(), part.partition()))) != null) {
                    Deque<RecordBatch> deque2 = deque;
                    synchronized (deque2) {
                        RecordBatch first = deque.peekFirst();
                        if (first != null) {
                            boolean backoff;
                            boolean bl = backoff = first.attempts > 0 && first.lastAttemptMs + this.retryBackoffMs > now;
                            if (!backoff) {
                                if (size + first.sizeInBytes() > maxSize && !ready.isEmpty()) {
                                    break;
                                }
                                RecordBatch batch = deque.pollFirst();
                                batch.close();
                                size += batch.sizeInBytes();
                                ready.add(batch);
                                batch.drainedMs = now;
                            }
                        }
                    }
                }
                this.drainIndex = (this.drainIndex + 1) % parts.size();
            } while (start != this.drainIndex);
            batches.put(node.id(), ready);
        }
        return batches;
    }

    private Deque<RecordBatch> getDeque(TopicPartition tp) {
        return (Deque)this.batches.get(tp);
    }

    private Deque<RecordBatch> getOrCreateDeque(TopicPartition tp) {
        ArrayDeque<RecordBatch> d = (ArrayDeque<RecordBatch>)this.batches.get(tp);
        if (d != null) {
            return d;
        }
        d = new ArrayDeque<RecordBatch>();
        Deque previous = this.batches.putIfAbsent(tp, d);
        if (previous == null) {
            return d;
        }
        return previous;
    }

    public void deallocate(RecordBatch batch) {
        this.incomplete.remove(batch);
        this.free.deallocate(batch.buffer(), batch.initialCapacity());
    }

    boolean flushInProgress() {
        return this.flushesInProgress.get() > 0;
    }

    Map<TopicPartition, Deque<RecordBatch>> batches() {
        return Collections.unmodifiableMap(this.batches);
    }

    public void beginFlush() {
        this.flushesInProgress.getAndIncrement();
    }

    private boolean appendsInProgress() {
        return this.appendsInProgress.get() > 0;
    }

    public void awaitFlushCompletion() throws InterruptedException {
        try {
            for (RecordBatch batch : this.incomplete.all()) {
                batch.produceFuture.await();
            }
        }
        finally {
            this.flushesInProgress.decrementAndGet();
        }
    }

    public void abortIncompleteBatches() {
        do {
            this.abortBatches();
        } while (this.appendsInProgress());
        this.abortBatches();
        this.batches.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortBatches() {
        for (RecordBatch batch : this.incomplete.all()) {
            Deque<RecordBatch> dq;
            Deque<RecordBatch> deque = dq = this.getDeque(batch.topicPartition);
            synchronized (deque) {
                batch.close();
                dq.remove(batch);
            }
            batch.done(-1L, -1L, new IllegalStateException("Producer is closed forcefully."));
            this.deallocate(batch);
        }
    }

    public void mutePartition(TopicPartition tp) {
        this.muted.add(tp);
    }

    public void unmutePartition(TopicPartition tp) {
        this.muted.remove(tp);
    }

    public void close() {
        this.closed = true;
    }

    private static final class IncompleteRecordBatches {
        private final Set<RecordBatch> incomplete = new HashSet<RecordBatch>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(RecordBatch batch) {
            Set<RecordBatch> set = this.incomplete;
            synchronized (set) {
                this.incomplete.add(batch);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(RecordBatch batch) {
            Set<RecordBatch> set = this.incomplete;
            synchronized (set) {
                boolean removed = this.incomplete.remove(batch);
                if (!removed) {
                    throw new IllegalStateException("Remove from the incomplete set failed. This should be impossible.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterable<RecordBatch> all() {
            Set<RecordBatch> set = this.incomplete;
            synchronized (set) {
                return new ArrayList<RecordBatch>(this.incomplete);
            }
        }
    }

    public static final class ReadyCheckResult {
        public final Set<Node> readyNodes;
        public final long nextReadyCheckDelayMs;
        public final Set<String> unknownLeaderTopics;

        public ReadyCheckResult(Set<Node> readyNodes, long nextReadyCheckDelayMs, Set<String> unknownLeaderTopics) {
            this.readyNodes = readyNodes;
            this.nextReadyCheckDelayMs = nextReadyCheckDelayMs;
            this.unknownLeaderTopics = unknownLeaderTopics;
        }
    }

    public static final class RecordAppendResult {
        public final FutureRecordMetadata future;
        public final boolean batchIsFull;
        public final boolean newBatchCreated;

        public RecordAppendResult(FutureRecordMetadata future, boolean batchIsFull, boolean newBatchCreated) {
            this.future = future;
            this.batchIsFull = batchIsFull;
            this.newBatchCreated = newBatchCreated;
        }
    }
}

