# Contribution Guide

## Bug Reports

To encourage active collaboration, iSPA Element strongly encourages pull requests, not just bug reports. "Bug reports" may also be sent in the form of a pull request containing a failing test.

However, if you file a bug report, your issue should contain a title and a clear description of the issue. You should also include as much relevant information as possible and a code sample that demonstrates the issue. The goal of a bug report is to make it easy for yourself - and others - to replicate the bug and develop a fix.

Remember, bug reports are created in the hope that others with the same problem will be able to collaborate with you on solving it. Do not expect that the bug report will automatically see any activity or that others will jump to fix it. Creating a bug report serves to help yourself and others start on the path of fixing the problem. If you want to chip in, you can help out by fixing any bugs listed in our issue trackers. You must be authenticated with GitHub to view all of iSPA Element's issues.

## Support Questions

iSPA Element's GitHub issue trackers are not intended to provide iSPA Element help or support. Instead, use one of the following channels:

- [GitHub Discussions](https://github.com/malayvuong/ispa-element/discussions)
- [Discord](https://discord.gg/fjGhjJX25j)

## Which Branch?

All bug fixes should be sent to the latest stable branch or to the current LTS branch. Bug fixes should never be sent to the master branch unless they fix features that exist only in the upcoming release.

Minor features that are fully backward compatible with the current release may be sent to the latest stable branch.

Major new features should always be sent to the master branch, which contains the upcoming release.

If you are unsure if your feature qualifies as a major or minor, please ask Malayvuong in the `#internals` channel of the iSPA Element Discord server.

## Core Development Discussion

You may propose new features or improvements of existing iSPA Element behavior in the iSPA Element Ideas [issue board](https://github.com/malayvuong/ispa-element/issues). If you propose a new feature, please be willing to implement at least some of the code that would be needed to complete the feature.

Informal discussion regarding bugs, new features, and implementation of existing features takes place in the #internals channel of the iSPA Element Discord server. Malayvuong, the maintainer of iSPA Element, is typically present in the channel on weekdays from 8am-4:30pm (UTC+07:00 or Asia/Ho Chi Minh), and sporadically present in the channel at other times.
