#include <stdint.h>
#include <SoftwareSerial.h>

#include "e32_radio.h"
#include "routing.h"
#include "packet.h"

#define M0   7
#define M1   8
#define AUX 12
#define SOFT_TX 11
#define SOFT_RX 10

#define TIMEOUT               5000  // timeout in ms
#define TIMER_START(ts)       ts = millis();
#define TIMER_EXPIRED(ts,to)  (millis()-ts > to)

char txBuf[64];
char rxBuf[64];

SoftwareSerial SoftSerial(SOFT_RX,SOFT_TX);

E32Radio lora1(SoftSerial,
  M0,M1,AUX,
  txBuf,sizeof(txBuf),
  rxBuf,sizeof(rxBuf)
);

Routing rt(lora1);
  
void setup() {
//  pinMode(13,OUTPUT);
  SoftSerial.begin(9600);
  Serial.begin(9600);
//  lora1.init(0x0001,E32Radio::TX_POWER_21DBM);
  lora1.init(0x0002,E32Radio::TX_POWER_21DBM);
//  lora1.init(0x0003,E32Radio::TX_POWER_21DBM);
  Serial.println("LORA initialized");
}

void loop() {
  static uint32_t ts = 0;
  static uint8_t count = 0;

  lora1.loop();
  rt.loop();

  // Receiving packet
  if (rt.available())
  {
    E32Radio::Address src;
    char buf[100];
    uint8_t len;
//    lora1.recv(&src,buf,&len);
    rt.recv(buf, &len);
    src = rt.getSrc();
        
    Serial.print("Recv from 0x");
    Serial.print(src,HEX);
    Serial.print(": ");
    for (uint8_t i=0; i<len; i++)
    {
      char tmp[8];
      sprintf(tmp,"%02x ",(uint8_t)buf[i]);
      Serial.print(tmp);
    }
    Serial.println();
//    Packet pkt;
//    pkt.seqno = count++;
//    pkt.timer = millis();
//    delay(500);
//    rt.send(src,&pkt);
//    Serial.println("*** Replying to source");
  }

  // Node 1 Sending Packet 
//  if (lora1.getNodeAddr() == 0x0001 && TIMER_EXPIRED(ts,TIMEOUT))
  if (TIMER_EXPIRED(ts,TIMEOUT))
  {
//    digitalWrite(13,!digitalRead(13));

    Packet pkt;
    pkt.seqno = count++;
    pkt.timer = millis();
//    lora1.send(0xFFFF,(char*)&pkt,sizeof(pkt));
//    rt.send(0x0012, (char*)&pkt);
    rt.send(0xFFFF, &pkt);
    Serial.print("Transmitted seq:");
    Serial.print(pkt.seqno);
    Serial.print(" timer:");
    Serial.print(pkt.timer);
    Serial.println();
    TIMER_START(ts);
  }
}
