# EasyTipper

**EasyTipper** is a simple and intuitive app built with **.NET MAUI** to help users calculate tips, split bills, and round amounts effortlessly. Designed with a user-friendly interface, it simplifies dining experiences and ensures accuracy.

## Features

- **Calculate Tip Amounts**: Choose from predefined percentages (15%, 18%, 20%, 25%) or input a custom tip percentage
- **Split the Bill**: Divide the total amount among any number of people
- **Round Up Option**: Round the tip amount to the nearest whole number for convenience
- **Real-Time Calculations**: View updated totals instantly as you adjust inputs
- **Responsive UI**: Optimized for mobile and desktop platforms

## Screenshots

![EasyTipper Demo](https://raw.githubusercontent.com/iNoles/EasyTipper/main/screenshots/maui-desktop.png)

## Technologies Used

- **.NET MAUI:** Cross-platform framework for building mobile applications.
- **C#:** Programming language used for app development.
- **XAML:** Used for designing the user interface.

## Installation

To get started with **EasyTipper**, follow these steps:

- [.NET SDK](https://dotnet.microsoft.com/download)
- [Visual Studio 2022 or later](https://visualstudio.microsoft.com/vs/) with the .NET MAUI workload

### Steps to Run

1. Clone the Repository
```bash
git clone https://github.com/iNoles/EasyTipper.git
cd EasyTipper
```
2. Open the EasyTipperApp project in Visual Studio
3. Set the target platform (Android, iOS, Windows, etc.) in the solution configuration
4. Build and run the app on your emulator, simulator, or physical device

## Usage

1. Enter the bill amount in the designated field
2. Select a tip percentage or input a custom tip value
3. Specify the number of people to split the bill (optional)
4. Enable the "Round Up" option for simplified rounding (optional)
5. Instantly view the calculated tip, total bill, and per-person split

## Testing

Thorough unit tests ensure the reliability of the EasyTipper app. To run tests:
1. Open the EasyTipper.Tests project in Visual Studio
2. Run the test cases using the built-in test explorer
3. Validate the results to ensure all features work as expected

## Contributing

Contributions are welcome! Please feel free to submit a pull request or open an issue to discuss changes.
