# Hack-October

A repository for beginner contributors in Hacktoberfest '22. You can create a file , upload a new project and create a pull/merge request. Make sure the program is error free and well commented. Multiple languages allowed

This is a good project for beginners to get some hands-on experience

<div  align="center"> 
  <img src=https://blog.tooljet.com/content/images/2022/09/Screenshot-2022-09-27-at-08.03.21.png width=70%>
</div>

<p align="center">
    <a href="https://hacktoberfest.com/">
        Link To HacktoberFest 2022
    </a>
</p>

---

## Event details :

- Hacktoberfest is a **month-long** challenge. It happens every year in the month of October.
- Hacktoberfest is open to everyone and it marks the celebration of Open Source. It's the biggest Open Source event that encourages newbies to participate in Open Source and create their 1st meaningful PR.
- Hacktoberfest will be hosted by Digital Ocean for the 9th year in a row in partnership with GitHub and other companies.
- Hacktoberfest® is **open to everyone** in our global community. Whether you’re a developer, student learning to code, event host, or company of any size, you can help drive growth of open source and make positive contributions to an ever-growing community.
- All backgrounds and skill levels are encouraged to complete the challenge.
- Hacktoberfest is a celebration open to everyone in our global community.
- You can sign up **anytime between September 26 and October 31**.

---

## How can you Join?

### Step - 1:

Create a GitHub account, if you don't already have one.

### Step - 2:

Register for Hacktoberfest: Navigate to the [Hacktoberfest registration page](https://hacktoberfest.com/) and follow the instructions. But, read the rules carefully before you do and then sign In using your GitHub credentials.

### Step - 3:

Find good projects worth contributing on the GitHub page. You can type `label:hactoberfest is:issue is:open`

You can add a language label of your choice to filter open issues. If you are a beginner and can’t find good issues then there’s tag `label:good first issue` which filters out issues for beginners who want to contribute.

### Step - 4:

Submit PRs: Try and submit at least **_4 PRs_** and wait for it to be verified. Make sure to submit quality PRs.

---

## HacktoberFest Rules :

- To earn your Hacktoberfest tee or tree reward, you must **register** and make **four valid pull requests** (PRs) between October 1-31 (in any time zone).
- Pull requests can be made in any participating GitHub or GitLab hosted repository/project. Look for the `hacktoberfest` topic to know if a repository/project is participating in Hacktoberfest.
- Pull requests must be approved by a maintainer of the repository/project to count.
- If a maintainer reports your pull request as spam or behavior not in line with the project’s code of conduct, you will be ineligible to participate.
- This year, the first **40,000** participants who successfully complete the challenge will be eligible to receive a prize.

### For your PR to count it must be:

- Submitted in a public repo, AND the PR is labelled as `hacktoberfest-accepted` by a maintainer. or
- Submitted in a repo labelled `hacktoberfest` , AND Merged, OR Approved
- You can opt not to receive a t-shirt and stickers and you can choose to have a tree planted in your name and help make Hacktoberfest 2022 more carbon neutral.

---

<h3 align="center"> Whether it’s your first or fiftieth pull request, there’s always more to learn! We’ve put together a few resources that can help you create quality pull requests, keep your repositories pristine, and build on your open source knowledge. </h3>

---

# Guidelines for contributions
Go through [CONTRIBUTING.md](https://github.com/i-aka5h/Hack-October/blob/master/CONTRIBUTING.md) for how to start contributing.

## Rules To Contribute To This Repo

- Create an issue and then do a pull request
- Add at least two problems-solution to the code.
- Write good-quality code with comments also.
- If you work on web dev then can add its code file too.
- Projects in every language are invited (Javascript, python, java, kotlin,etc)
- Projects using framework also invited (React,Angular,Flutter,Android,)
- Basic ML models are also invited.
- Create new folder if not already exists (ex. if you want to create project in Flutter and no folder exists then create a new folder.)

## Steps For Contribution

    1. Star this repo
    2. Fork this repo
    3. Find or Make an Issue and get assigned
    3. Add a file inside appropriate folder
    4. Commit the code
    5. Make pull request

---

## How to make changes?

```
1. Fork this repository and clone that to your local machine
2. Create a new Branch and work on it
3. Do the needful changes and create a Pull Request
4. Add a meaningful message to the PR’s and also mention the solved issue topic
```

---



## FEATURES

1. Beginner-friendly
2. Targeted for developers, content writers, and programming enthusiasts.
3. Would also help participants who are not familiar with development but are eager to participate in open source.

---

```javascript

  _____ _                 _     __   __
 |_   _| |__   __ _ _ __ | | __ \ \ / /__  _   _
   | | | '_ \ / _` | '_ \| |/ /  \ V / _ \| | | |
   | | | | | | (_| | | | |   <    | | (_) | |_| |
   |_| |_| |_|\__,_|_| |_|_|\_\   |_|\___/ \__,_|


```

---
