/*
 * Copyright (c) 2001-2003 Swedish Institute of Computer Science.
 * All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 *
 * This file is part of the lwIP TCP/IP stack.
 * 
 * Author: Adam Dunkels <adam@sics.se>
 *
 */
#ifndef __LWIPOPTS_H__
#define __LWIPOPTS_H__

#include <xbook/config.h>

#define NO_SYS                     0
#define LWIP_SOCKET               (NO_SYS==0)
#define LWIP_NETCONN              (NO_SYS==0)

#define MEM_ALIGNMENT           4
#define MEM_SIZE               10240

#define TCP_SND_BUF             2048

/* use os's timeval */
#define LWIP_TIMEVAL_PRIVATE 0

#define LWIP_DNS    1

#ifdef CONFIG_NET_DHCP
#define LWIP_DHCP    1
#endif

#define LWIP_ARP 1
#define DHCP_DOES_ARP_CHECK 0

#include <xbook/schedule.h>
/* tcpip core thread prio is usr  prio in xbook kernel
the thread is won't be blocked by func, so it must can't
rt prio！
 */
#define TCPIP_THREAD_PRIO TASK_PRIO_LEVEL_NORMAL    

/* 不打开lwip的socket, connect等宏 */
#define LWIP_COMPAT_SOCKETS 0

/* 使用系统的内存分配 */
#define MEM_LIBC_MALLOC 1

#define MEMP_NUM_NETCONN 10 //能够同时激活的超时连接数目(NO_SYS==0有戏)

#define LWIP_NETIF_LOOPBACK 1
#define LWIP_LOOPBACK_MAX_PBUFS 4
#define LWIP_NETIF_LOOPBACK_MULTITHREADING 1
#define LWIP_HAVE_LOOPIF 1

#define SO_REUSE 1
#define LWIP_SO_RCVBUF 1

#endif /* __LWIPOPTS_H__ */
