//
// HypnoticOS
// Copyright (C) 2020  jk30
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <stdlib.h>
#include <string.h>
#include <hypnoticos/dispatcher.h>

void DispatcherProcessDone(DispatcherProcess_t *p) {
  uint8_t found_pid = 0;
  uint64_t i;

  // TODO Free all memory associated with the process

  DispatcherIndexLockCheck(p);

  for(i = 0; DispatcherProcesses[i] != NULL; i++) {
    if(found_pid) {
      DispatcherProcesses[i - 1] = DispatcherProcesses[i];
    } else if(DispatcherProcesses[i]->pid == p->pid) {
      found_pid = 1;
    }
  }

  if(found_pid) {
    DispatcherProcesses = realloc(DispatcherProcesses, sizeof(DispatcherProcess_t *) * (i + 1));
    DispatcherProcesses[i - 1] = NULL;
  }

  free(p);
}
