//
// HypnoticOS
// Copyright (C) 2019  jk30
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <hypnoticos/cpu.h>
#include <hypnoticos/keyboard-codes.h>
#include <hypnoticos/hypnoticos.h>

#define KEYBOARD_BUFFER_SIZE          40

uint8_t KeyboardPresent = 0;
uint8_t KeyboardState = 0;
uint8_t *KeyboardBuffer = NULL;

void KeyboardInitBuffer();
uint8_t inline KeyboardGetData();
void inline KeyboardLEDsOff();
void KeyboardBufferQueue(uint8_t key);

void inline KeyboardLEDsOff() {
  IoPort8Out(0x64, 0xED);
  IoPort8Out(0x60, 0x00);
}

void KeyboardInit() {
  uint8_t i;

  KeyboardLEDsOff();

  // Check response (5 attempts if requested to re-send)
  for(i = 0; i < 5; i++) {
    switch(KeyboardGetData()) {
      case 0xFA:
      KeyboardPresent = 1;
      KeyboardInitBuffer();
      return;

      case 0xFE:
      KeyboardLEDsOff();
      break;

      default:
      return;
    }
  }

  return;
}

uint8_t inline KeyboardGetData() {
  return IoPort8In(0x60);
}

void KeyboardInitBuffer() {
  KeyboardBuffer = malloc(KEYBOARD_BUFFER_SIZE + 1);
  memset(KeyboardBuffer, 0, KEYBOARD_BUFFER_SIZE + 1);
}

void KeyboardBufferQueue(uint8_t key) {
  uint32_t i;

  for(i = 0; KeyboardBuffer[i] != KEY_EMPTY && i < KEYBOARD_BUFFER_SIZE; i++);

  if(i == KEYBOARD_BUFFER_SIZE) {
    // Buffer is full, discard this key
    WARNING();
    return;
  }

  KeyboardBuffer[i] = key;
}

uint8_t KeyboardBufferGet() {
  uint8_t key = KeyboardBuffer[0], i;

  for(i = 1; i < KEYBOARD_BUFFER_SIZE; i++) {
    KeyboardBuffer[i - 1] = KeyboardBuffer[i];
  }
  KeyboardBuffer[KEYBOARD_BUFFER_SIZE] = 0;

  return key;
}

uint8_t KeyboardBufferGet_Keep() {
  return KeyboardBuffer[0];
}

void KeyboardIrq() {
  uint8_t key[6] = {0, 0, 0, 0, 0, 0};

  key[0] = KeyboardGetData();
  if(key[0] == 0xE0 || key[0] == 0xE1) {
    if((key[1] = KeyboardGetData()) == 0x1D && (key[2] = KeyboardGetData()) == 0x45 && (key[3] = KeyboardGetData()) == 0xE1 && (key[4] = KeyboardGetData()) == 0x9D) {
        key[5] = KeyboardGetData();
    }
  }

  // TODO Record key states

  CHECK_KEY_IF_1(0x01, KEY_ESC | KEY_PRESSED);
  CHECK_KEY_IF_1(0x81, KEY_ESC | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x0E, KEY_BACKSPACE | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x8E, KEY_BACKSPACE | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x0F, KEY_TAB | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x8F, KEY_TAB | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x1C, KEY_RETURN | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x9C, KEY_RETURN | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_2(0xE0, 0x1C, KEY_KEYPAD_RETURN | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_2(0xE0, 0x9C, KEY_KEYPAD_RETURN | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x1D, KEY_CTRL_LEFT | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x9D, KEY_CTRL_LEFT | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_2(0xE0, 0x1D, KEY_CTRL_RIGHT | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_2(0xE0, 0x9D, KEY_CTRL_RIGHT | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x2A, KEY_SHIFT_LEFT | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xAA, KEY_SHIFT_LEFT | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x36, KEY_SHIFT_RIGHT | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xB6, KEY_SHIFT_RIGHT | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x38, KEY_ALT_LEFT | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xB8, KEY_ALT_LEFT | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_2(0xE0, 0x38, KEY_ALT_RIGHT | KEY_PRESSED); // May also send Ctrl (left) and Alt (left) at the same time
  CHECK_KEY_ELSE_IF_2(0xE0, 0xB8, KEY_ALT_RIGHT | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x39, KEY_SPACE | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xB9, KEY_SPACE | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x3A, KEY_LOCK_CAPS | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xBA, KEY_LOCK_CAPS | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x45, KEY_LOCK_NUM | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xC5, KEY_LOCK_NUM | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x46, KEY_LOCK_SCROLL | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xC6, KEY_LOCK_SCROLL | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_6(0xE1, 0x1D, 0x45, 0xE1, 0x9D, 0xC5, KEY_PAUSE | KEY_PRESSED);

  CHECK_KEY_ELSE_IF_1(0x3B, KEY_F1 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xBB, KEY_F1 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x3C, KEY_F2 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xBC, KEY_F2 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x3D, KEY_F3 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xBD, KEY_F3 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x3E, KEY_F4 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xBE, KEY_F4 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x3F, KEY_F5 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xBF, KEY_F5 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x40, KEY_F6 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xC0, KEY_F6 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x41, KEY_F7 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xC1, KEY_F7 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x42, KEY_F8 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xC2, KEY_F8 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x43, KEY_F9 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xC3, KEY_F9 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x44, KEY_F10 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xC4, KEY_F10 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x57, KEY_F11 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xD7, KEY_F11 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x58, KEY_F12 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xD8, KEY_F12 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_2(0xE0, 0x52, KEY_INSERT | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_2(0xE0, 0xD2, KEY_INSERT | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_2(0xE0, 0x53, KEY_DELETE | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_2(0xE0, 0xD3, KEY_DELETE | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_2(0xE0, 0x47, KEY_HOME | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_2(0xE0, 0xC7, KEY_HOME | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_2(0xE0, 0x4F, KEY_END | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_2(0xE0, 0xCF, KEY_END | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_2(0xE0, 0x49, KEY_PAGE_UP | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_2(0xE0, 0xC9, KEY_PAGE_UP | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_2(0xE0, 0x51, KEY_PAGE_DOWN | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_2(0xE0, 0xD1, KEY_PAGE_DOWN | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_2(0xE0, 0x48, KEY_ARROW_UP | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_2(0xE0, 0xC8, KEY_ARROW_UP | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_2(0xE0, 0x50, KEY_ARROW_DOWN | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_2(0xE0, 0xD0, KEY_ARROW_DOWN | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_2(0xE0, 0x4B, KEY_ARROW_LEFT | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_2(0xE0, 0xCB, KEY_ARROW_LEFT | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_2(0xE0, 0x4D, KEY_ARROW_RIGHT | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_2(0xE0, 0xCD, KEY_ARROW_RIGHT | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_4(0xE0, 0x2A, 0xE0, 0x37, KEY_PRINT_SCREEN | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_4(0xE0, 0xB7, 0xE0, 0xAA, KEY_PRINT_SCREEN | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x02, KEY_MAIN_1 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x82, KEY_MAIN_1 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x03, KEY_MAIN_2 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x83, KEY_MAIN_2 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x04, KEY_MAIN_3 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x84, KEY_MAIN_3 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x05, KEY_MAIN_4 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x85, KEY_MAIN_4 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x06, KEY_MAIN_5 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x86, KEY_MAIN_5 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x07, KEY_MAIN_6 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x87, KEY_MAIN_6 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x08, KEY_MAIN_7 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x88, KEY_MAIN_7 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x09, KEY_MAIN_8 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x89, KEY_MAIN_8 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x0A, KEY_MAIN_9 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x8A, KEY_MAIN_9 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x0B, KEY_MAIN_0 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x8B, KEY_MAIN_0 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x29, KEY_RIGHT_QUOTE | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xA9, KEY_RIGHT_QUOTE | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x0C, KEY_MAIN_HYPHEN | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x8C, KEY_MAIN_HYPHEN | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x0D, KEY_EQUALS | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x8D, KEY_EQUALS | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x2B, KEY_BACKSLASH | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xAB, KEY_BACKSLASH | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x35, KEY_MAIN_FORWARDSLASH | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xB5, KEY_MAIN_FORWARDSLASH | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x34, KEY_MAIN_PERIOD | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xB4, KEY_MAIN_PERIOD | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x33, KEY_COMMA | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xB3, KEY_COMMA | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x1A, KEY_LEFT_SQUARE | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x9A, KEY_LEFT_SQUARE | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x1B, KEY_RIGHT_SQUARE | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x9B, KEY_RIGHT_SQUARE | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x52, KEY_KEYPAD_0 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xD2, KEY_KEYPAD_0 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x4F, KEY_KEYPAD_1 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xCF, KEY_KEYPAD_1 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x50, KEY_KEYPAD_2 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xD0, KEY_KEYPAD_2 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x51, KEY_KEYPAD_3 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xD1, KEY_KEYPAD_3 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x4B, KEY_KEYPAD_4 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xCB, KEY_KEYPAD_4 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x4C, KEY_KEYPAD_5 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xCC, KEY_KEYPAD_5 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x4D, KEY_KEYPAD_6 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xCD, KEY_KEYPAD_6 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x47, KEY_KEYPAD_7 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xC7, KEY_KEYPAD_7 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x48, KEY_KEYPAD_8 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xC8, KEY_KEYPAD_8 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x49, KEY_KEYPAD_9 | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xC9, KEY_KEYPAD_9 | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x4A, KEY_KEYPAD_HYPHEN | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xCA, KEY_KEYPAD_HYPHEN | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x4E, KEY_KEYPAD_PLUS | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xCE, KEY_KEYPAD_PLUS | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x37, KEY_KEYPAD_ASTERICKS | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xB7, KEY_KEYPAD_ASTERICKS | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_2(0xE0, 0x35, KEY_KEYPAD_FORWARDSLASH | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_2(0xE0, 0xB5, KEY_KEYPAD_FORWARDSLASH | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x10, KEY_Q | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x90, KEY_Q | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x11, KEY_W | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x91, KEY_W | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x12, KEY_E | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x92, KEY_E | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x13, KEY_R | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x93, KEY_R | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x14, KEY_T | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x94, KEY_T | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x15, KEY_Y | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x95, KEY_Y | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x16, KEY_U | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x96, KEY_U | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x17, KEY_I | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x97, KEY_I | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x18, KEY_O | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x98, KEY_O | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x19, KEY_P | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x99, KEY_P | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x1E, KEY_A | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x9E, KEY_A | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x1F, KEY_S | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0x9F, KEY_S | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x20, KEY_D | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xA0, KEY_D | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x21, KEY_F | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xA1, KEY_F | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x22, KEY_G | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xA2, KEY_G | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x23, KEY_H | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xA3, KEY_H | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x24, KEY_J | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xA4, KEY_J | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x25, KEY_K | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xA5, KEY_K | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x26, KEY_L | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xA6, KEY_L | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x2C, KEY_Z | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xAC, KEY_Z | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x2D, KEY_X | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xAD, KEY_X | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x2E, KEY_C | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xAE, KEY_C | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x2F, KEY_V | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xAF, KEY_V | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x30, KEY_B | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xB0, KEY_B | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x31, KEY_N | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xB1, KEY_N | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x32, KEY_M | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xB2, KEY_M | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x27, KEY_SEMICOLON | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xA7, KEY_SEMICOLON | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x28, KEY_HASH | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xA8, KEY_HASH | KEY_RELEASED);

  CHECK_KEY_ELSE_IF_1(0x53, KEY_KEYPAD_PERIOD | KEY_PRESSED);
  CHECK_KEY_ELSE_IF_1(0xD3, KEY_KEYPAD_PERIOD | KEY_RELEASED);
}
