//
// HypnoticOS
// Copyright (C) 2020  jk30
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#ifndef _HYPNOTICOS_KERNEL

#include <stddef.h>
#include <stdlib.h>
#include <directory.h>
#include <hypnoticos/fs.h>
#include <hypnoticos/interface.h>
#include <hypnoticos/function-codes.h>

Directory_t *DirectoryGet(const char *path) {
  uint64_t id;
  Directory_t *ptr;

  if((id = KernelFunctionInterface((uint64_t) path, 0, 0, 0, 0, KERNEL_FUNCTION_DIRECTORY_GET)) == 0) {
    return NULL;
  }

  ptr = malloc(sizeof(Directory_t));
  ptr->id = id;
  ptr->offset = 0;

  return ptr;
}

#endif
