//
// HypnoticOS
// Copyright (C) 2019, 2024  jk30
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#ifndef UNISTD_H
#define UNISTD_H

#include <sys/types.h>

#define STDIN_FILENO      1
#define STDOUT_FILENO     2
#define STDERR_FILENO     3

#ifndef _HYPNOTICOS_KERNEL
unsigned int sleep(unsigned int s);
#endif

int chdir(const char *new_dir);
char *getcwd(char *buffer, size_t size);
ssize_t read(int fd, void *buffer, size_t count);
ssize_t write(int fd, const void *buffer, size_t count);

#endif
