# Related work

Links to software related to Hyperopt, and Bayesian Optimization in general.

## Software using Hyperopt

* [hyperopt-sklearn](https://github.com/hyperopt/hyperopt-sklearn) - using hyperopt to optimize across [sklearn](http://scikit-learn.org) estimators.
* [hyperopt-convnet](https://github.com/hyperopt/hyperopt-convnet) - optimize convolutional architectures for image classification
  * used in Bergstra, Yamins, and Cox in (ICML 2013).
* [hyperopt-dbn](https://github.com/hyperopt/hyperopt-nnet) - optimize Deep Belief Networks (Coming Soon)
  * used in [Bergstra, Bardenet, Bengio, and Kegl (NIPS 2011)](http://www.eng.uwaterloo.ca/~jbergstr/files/pub/11_nips_hyperopt.pdf)
  * used in [Bergstra and Bengio (JMLR 2012)](http://www.jmlr.org/papers/volume13/bergstra12a/bergstra12a.pdf)
* [hyperas](https://github.com/maxpumperla/hyperas) - hyperopt wrapper for [keras](https://keras.io)

## Other Software for Bayesian Optimization

* [SMAC](http://www.cs.ubc.ca/labs/beta/Projects/SMAC/#software) - Sequential Model-based Algorithm Configuration (based on regression trees).
* [Spearmint](http://www.cs.toronto.edu/~jasper/software.html) - Gaussian-process SMBO in Python.
* [BayesOpt](http://rmcantin.bitbucket.org/html/) - Bayesian optimization toolbox

Should other software be listed here? File a github issue to add it.
