# Working with union types in Hygraph

[Join our Slack](https://slack.hygraph.com)

Hygraph supports [polymorphic relations](https://hygraph.com/docs/guides/concepts/relations/#union-types-polymorphism), also known as [GraphQL union types](https://graphql.org/learn/schema/#union-types). This example demonstrates how you can build a product marketing page using a schema consisting of polymorphic relations.

This example is built with [Next.js](https://nextjs.org), [`graphql-request`](https://github.com/prisma-labs/graphql-request) and [Tailwind CSS](https://tailwindcss.com).

• [Demo](https://hygraph-using-union-types.vercel.app)

[![Deploy with Vercel](https://vercel.com/button)](https://vercel.com/import/project?template=https://github.com/hygraph/hygraph-examples/tree/master/using-union-types)

## How to Use

### Download Manually

```bash
npx degit hygraph/hygraph-examples/using-union-types using-union-types
```

Install & Run:

```bash
cd using-union-types
npm install
npm run dev
# or
cd using-union-types
yarn
yarn dev
```

### Run on Codesandbox

[![Develop with Codesandbox](https://codesandbox.io/static/img/play-codesandbox.svg)](https://codesandbox.io/s/github/hygraph/hygraph-examples/tree/master/using-union-types)
