---
sidebar_position: 5
---

# Flashcards

Flashcard studying is one of the core features of Scholarsome. It allows repetition of cards to memorize their contents.

To access the flashcards feature, view a set and click the "Flashcards" button. This will take you to a menu where you can configure your flashcard studying session.

## Configuring flashcards

Once clicking the button, you will be taken to a menu where you can configure this individual studying session. This does not save between reloads - each time you enter this menu, you are able to configure it differently.

Three options are available in this menu: type, answer with, and enable shuffling.

### Type

Type refers to the studying method used.

Traditional is a digitized form of how flashcards are physically studied. The card can be flipped, the set can be navigated with arrow buttons, etc. It is on the user to utilize the presented cards in a meaningful way.

Progressive is an alternative way to study cards. Cards are shown, and the user is asked after revealing the answer whether they knew it or not. If they did, the card is not shown again. If the card was not known, it is shown again after the user has reached the end of the set. This repeats until all cards are known.

An additional mode, a spaced repetition system, will be available in the future. This will differ from the existing modes as its progress will save between study sessions.

### Answer with

This refers to whether the answer to the card is the term or the definition. If the definition is selected as the "answer with" value, then the term is presented first, and vice versa.

### Enable shuffling

If selected as "yes", the set will have the order of its cards randomized before the flashcards start. Otherwise, the cards will be presented in the same order as shown in the set.

## Using flashcards

The current shown card can be flipped by clicking on the card or using the spacebar or using the up and down arrow keys.

Sets can be navigated using the left and right arrow keys, or using the buttons. In progressive mode, the "Don't know" and "Know" buttons are used to signify whether the currently shown card was known.

In traditional mode, arrow keys move the set forward or back one card. In progressive mode, an arrow key to the left will signify that the current card isn't known, and an arrow key to the right signifies that the card was known.

To return to the configuration screen, click the arrow button in the bottom left. Note that the current progress in the study session will not be saved after navigating away.
