# siri-gpt
Talk to ChatGPT through voice on your iOS or macOS device. It saves your conversation logs into the Notes app and remembers your last prompt/response to allow for continuous conversations.

For mobile users, I highly recommend using this while on the go, as you no longer need to use your eyes to type. At the end of every response you need to press 'yes' or 'no' to continue the conversation. Other than that, you just talk to it. Don't crash your car using this. 

### Activating it via voice is glitchy, so I'd recommend making an icon on your homescreen to activate it.

## Setup
1. Import one of the shortcuts into your iOS device from the links below. 
2. You'll be prompted for an OpenAI API key when your first import the shortcut. [Get your key here.](https://platform.openai.com/account/api-keys)
3. Create a bookmark to the shortcut on your homescreen or as a complication on your Apple Watch.

### [GPT-3.5](https://www.icloud.com/shortcuts/ef38caf11c374a9f9630899ee63c5ffb)
(Everyone can access and it's fast)


### [GPT-4](https://www.icloud.com/shortcuts/21d82ba4eeb24b588ec7a85a25330543) 
(Limited access and slow, but smarter)


### [Apple Watch version](https://www.icloud.com/shortcuts/559ca54453ce446193a3c580403d90d1) `NEW`
(I took out the logging function, so it can work on watches. Add it as a complication on your watch face. It uses GPT-3.5 by default and should work on any other iOS or macOS device.)



## Credit
[The original idea](https://twitter.com/mckaywrigley/status/1640414764852711425) 
(I added logging and memory)

## "Source code"
![siri-gpt-pics1](https://user-images.githubusercontent.com/123516285/228938982-7f3cc933-71c1-478f-ad7e-02f773755d7e.png)

![siri-gpt-pics2](https://user-images.githubusercontent.com/123516285/228939028-06129caa-9b68-47d5-b61c-8badcb7e5036.png)

![siri-gpt-pics3](https://user-images.githubusercontent.com/123516285/228939049-b76b23b8-be3d-4041-a018-4be1e65292c2.png)
