---
sidebar_position: 3
title: Question 21 - 30
comment: true
tags:
  - Javascript
---

### Q21. What's the value of sum?

```javascript
const sum = eval('10*10+5');
```

- A: 105
- B: "105"
- C: TypeError
- D: "10\*10+5"

<details>
    <summary>
    <b>💡 Answer</b>
    </summary>

**_Answer: A_**

`eval` evaluates codes that's passed as a string. If it's an expression, like in this case, it evaluates the expression. The expression is `10 * 10 + 5`. This returns the number `105`.

</details>

### Q22. How long is cool_secret accessible?

```javascript
sessionStorage.setItem('cool_secret', 123);
```

- A: Forever, the data doesn't get lost.
- B: When the user closes the tab.
- C: When the user closes the entire browser, not only the tab.
- D: When the user shuts off their computer.

<details>
        <summary>
        <b>💡 Answer</b>
    </summary>

**_Answer: B_**

The data stored in `sessionStorage` is removed after closing the _tab_.

If you used `localStorage`, the data would've been there forever, unless for example `localStorage.clear()` is invoked.

</details>

### Q23. What's the output?

```javascript
var num = 8;
var num = 10;

console.log(num);
```

- A: 8
- B: 10
- C: SyntaxError
- D: ReferenceError

<details>
        <summary>
        <b>💡 Answer</b>
    </summary>

**_Answer: B_**

With the `var` keyword, you can declare multiple variables with the same name. The variable will then hold the latest value.

You cannot do this with `let` or `const` since they're block-scoped.

</details>

### Q24. What's the output?

```javascript
const obj = { 1: 'a', 2: 'b', 3: 'c' };
const set = new Set([1, 2, 3, 4, 5]);

obj.hasOwnProperty('1');
obj.hasOwnProperty(1);
set.has('1');
set.has(1);
```

- A: false true false true
- B: false true true true
- C: true true false true
- D: true true true true

<details>
       <summary>
        <b>💡 Answer</b>
    </summary>

**_Answer: C_**

All object keys (excluding Symbols) are strings under the hood, even if you don't type it yourself as a string. This is why `obj.hasOwnProperty('1')` also returns true.

It doesn't work that way for a set. There is no `'1'` in our set: `set.has('1')` returns `false`. It has the numeric type `1`, `set.has(1)` returns `true`.

</details>

### Q25. What's the output?

```javascript
const obj = { a: 'one', b: 'two', a: 'three' };
console.log(obj);
```

- {'A: { a: "one", b: "two" }'}
- {'B: { b: "two", a: "three" }'}
- {'C: { a: "three", b: "two" }'}
- {'D: SyntaxError'}

<details>
           <summary>
        <b>💡 Answer</b>
    </summary>

**_Answer: C_**

If you have two keys with the same name, the key will be replaced. It will still be in its first position, but with the last specified value.

</details>

### Q26. The JavaScript global execution context creates two things for you: the global object, and the "this" keyword.

- A: true
- B: false
- C: it depends
- D: 'SyntaxError'

<details>
  <summary>
        <b>💡 Answer</b>
    </summary>

**_Answer: A_**

The base execution context is the global execution context: it's what's accessible everywhere in your code.

</details>

### Q27. What's the output?

```javascript
for (let i = 1; i < 5; i++) {
  if (i === 3) continue;
  console.log(i);
}
```

- A: 1, 2
- B: 1, 2, 3
- C: 1, 2, 4
- D: 1, 3, 4

<details>
  <summary>
        <b>💡 Answer</b>
    </summary>

**_Answer: C_**

The `continue` statement skips an iteration if a certain condition returns `true`.

</details>

### Q28. What's the output?

```javascript
String.prototype.giveLydiaPizza = () => {
  return 'Just give Lydia pizza already!';
};

const name = 'Lydia';

console.log(name.giveLydiaPizza());
```

- A: "Just give Lydia pizza already!"
- B: TypeError: not a function
- C: SyntaxError
- D: undefined

<details>
    <summary>
        <b>💡 Answer</b>
    </summary>

**_Answer: A_**

`String` is a built-in constructor, which we can add properties to. I just added a method to its prototype. Primitive strings are automatically converted into a string object, generated by the string prototype function. So, all strings (string objects) have access to that method!

</details>

### Q29. What's the output?

```javascript
const a = {};
const b = { key: 'b' };
const c = { key: 'c' };

a[b] = 123;
a[c] = 456;

console.log(a[b]);
```

- A: 123
- B: 456
- C: undefined
- D: ReferenceError

<details>
   <summary>
        <b>💡 Answer</b>
    </summary>

**_Answer: B_**

Object keys are automatically converted into strings. We are trying to set an object as a key to object `a`, with the value of `123`.

However, when we stringify an object, it becomes `"[object Object]"`. So what we are saying here, is that `a["[object Object]"] = 123`. Then, we can try to do the same again. `c` is another object that we are implicitly stringifying. So then, `a["[object Object]"] = 456`.

Then, we log `a[b]`, which is actually `a["[object Object]"]`. We just set that to `456`, so it returns `456`.

</details>

### Q30. What's the output?

```javascript
const foo = () => console.log('First');
const bar = () => setTimeout(() => console.log('Second'));
const baz = () => console.log('Third');

bar();
foo();
baz();
```

- A: First, Second, Third
- B: First, Third, Second
- C: Second, First, Third
- D: Second, Third, First

<details>
  <summary>
        <b>💡 Answer</b>
    </summary>

**_Answer: B_**

We have a `setTimeout` function and invoked it first. Yet, it was logged last.

This is because in browsers, we don't just have the runtime engine, we also have something called a `WebAPI`. The `WebAPI` gives us the `setTimeout` function to start with, and for example the DOM.

After the _callback_ is pushed to the WebAPI, the `setTimeout` function itself (but not the callback!) is popped off the stack.

<img src="https://i.imgur.com/X5wsHOg.png" width="200" />

Now, `foo` gets invoked, and `"First"` is being logged.

<img src="https://i.imgur.com/Pvc0dGq.png" width="200" />

`foo` is popped off the stack, and `baz` gets invoked. `"Third"` gets logged.

<img src="https://i.imgur.com/WhA2bCP.png" width="200" />

The WebAPI can't just add stuff to the stack whenever it's ready. Instead, it pushes the callback function to something called the _queue_.

<img src="https://i.imgur.com/NSnDZmU.png" width="200" />

This is where an event loop starts to work. An **event loop** looks at the stack and task queue. If the stack is empty, it takes the first thing on the queue and pushes it onto the stack.

<img src="https://i.imgur.com/uyiScAI.png" width="200" />

`bar` gets invoked, `"Second"` gets logged, and it's popped off the stack.

</details>
