/*! For license information please see ea1922c2.0115ee35.js.LICENSE.txt */
"use strict";(self.webpackChunkweb_totals=self.webpackChunkweb_totals||[]).push([[5436],{35446:(e,t,n)=>{n.r(t),n.d(t,{assets:()=>a,contentTitle:()=>l,default:()=>d,frontMatter:()=>r,metadata:()=>c,toc:()=>i});var o=n(85893),s=n(11151);const r={sidebar_position:2,title:"Compound Pattern",comment:!0,tags:["Reactjs"],last_update:{date:"05/05/2023",author:"hunghg255"}},l="Compound Pattern",c={id:"reactjs/compound-pattern",title:"Compound Pattern",description:"Create multiple components that work together to perform a single task",source:"@site/docs/reactjs/compound-pattern.mdx",sourceDirName:"reactjs",slug:"/reactjs/compound-pattern",permalink:"/docs/reactjs/compound-pattern",draft:!1,unlisted:!1,editUrl:"https://github.com/hunghg255/web-totals/tree/main/docs/reactjs/compound-pattern.mdx",tags:[{label:"Reactjs",permalink:"/docs/tags/reactjs"}],version:"current",lastUpdatedBy:"hunghg255",lastUpdatedAt:1683219600,formattedLastUpdatedAt:"May 4, 2023",sidebarPosition:2,frontMatter:{sidebar_position:2,title:"Compound Pattern",comment:!0,tags:["Reactjs"],last_update:{date:"05/05/2023",author:"hunghg255"}},sidebar:"tutorialSidebar",previous:{title:"Higher-Order Components",permalink:"/docs/reactjs/hoc-pattern"},next:{title:"State Managers",permalink:"/docs/reactjs/state-managers"}},a={},i=[{value:"Overview",id:"overview",level:3},{value:"Implementation",id:"implementation",level:3},{value:"Provider",id:"provider",level:4},{value:"<code>React.Children.map</code>",id:"reactchildrenmap",level:4}];function u(e){const t={code:"code",h1:"h1",h3:"h3",h4:"h4",hr:"hr",li:"li",p:"p",pre:"pre",ul:"ul",...(0,s.a)(),...e.components},{Stackblitz:n}=t;return n||function(e,t){throw new Error("Expected "+(t?"component":"object")+" `"+e+"` to be defined: you likely forgot to import, pass, or provide it.")}("Stackblitz",!0),(0,o.jsxs)(o.Fragment,{children:[(0,o.jsx)(t.h1,{id:"compound-pattern",children:"Compound Pattern"}),"\n",(0,o.jsx)(t.p,{children:"Create multiple components that work together to perform a single task"}),"\n",(0,o.jsx)(t.hr,{}),"\n",(0,o.jsx)(t.h3,{id:"overview",children:"Overview"}),"\n",(0,o.jsx)(t.p,{children:"With the Compound Pattern, we can create multiple components that work together to perform one single task."}),"\n",(0,o.jsxs)(t.p,{children:["Let's say for example that we have a ",(0,o.jsx)(t.code,{children:"Search"})," input component. When a user clicks on the search input, we show a ",(0,o.jsx)(t.code,{children:"SearchPopup"})," component that shows some popular locations."]}),"\n",(0,o.jsx)("video",{src:"https://res.cloudinary.com/hunghg255/video/upload/v1677959548/blog/compound_ma17je.mov",loop:!0,muted:!0,controls:!0,autoplay:!0}),"\n",(0,o.jsxs)(t.p,{children:["To create this behavior, we can create a ",(0,o.jsx)(t.code,{children:"FlyOut"})," compound component."]}),"\n",(0,o.jsx)("video",{src:"https://res.cloudinary.com/hunghg255/video/upload/v1677959548/blog/compound2_tjldah.mov",loop:!0,muted:!0,controls:!0,autoplay:!0}),"\n",(0,o.jsxs)(t.p,{children:["This ",(0,o.jsx)(t.code,{children:"FlyOut"})," component is an example of a compound component, as it also exposes some sub-components that all work together to toggle and render the ",(0,o.jsx)(t.code,{children:"FlyOut"})," component."]}),"\n",(0,o.jsx)(t.pre,{children:(0,o.jsx)(t.code,{className:"language-js",children:"import React from 'react';\nimport { FlyOut } from './FlyOut';\n\nexport default function SearchInput() {\n  return (\n    <FlyOut>\n      <FlyOut.Input placeholder='Enter an address, city, or ZIP code' />\n      <FlyOut.List>\n        <FlyOut.ListItem value='San Francisco, CA'>San Francisco, CA</FlyOut.ListItem>\n        <FlyOut.ListItem value='Seattle, WA'>Seattle, WA</FlyOut.ListItem>\n        <FlyOut.ListItem value='Austin, TX'>Austin, TX</FlyOut.ListItem>\n        <FlyOut.ListItem value='Miami, FL'>Miami, FL</FlyOut.ListItem>\n        <FlyOut.ListItem value='Boulder, CO'>Boulder, CO</FlyOut.ListItem>\n      </FlyOut.List>\n    </FlyOut>\n  );\n}\n"})}),"\n",(0,o.jsxs)(t.p,{children:["The ",(0,o.jsx)(t.code,{children:"FlyOut"})," compound component is a stateful component - which means we don't have to add the stateful logic to the ",(0,o.jsx)(t.code,{children:"SearchInput"})," component."]}),"\n",(0,o.jsx)(t.hr,{}),"\n",(0,o.jsx)(t.h3,{id:"implementation",children:"Implementation"}),"\n",(0,o.jsxs)(t.p,{children:["We can implement the Compound pattern using either a Provider, or ",(0,o.jsx)(t.code,{children:"React.Children.map"}),"."]}),"\n",(0,o.jsx)(t.h4,{id:"provider",children:"Provider"}),"\n",(0,o.jsxs)(t.p,{children:["The ",(0,o.jsx)(t.code,{children:"FlyOut"})," compound component consists of:"]}),"\n",(0,o.jsxs)(t.ul,{children:["\n",(0,o.jsxs)(t.li,{children:[(0,o.jsx)(t.code,{children:"FlyoutContext"})," to keep track of the visbility state of ",(0,o.jsx)(t.code,{children:"FlyOut"})]}),"\n",(0,o.jsxs)(t.li,{children:[(0,o.jsx)(t.code,{children:"Input"})," to toggle the ",(0,o.jsx)(t.code,{children:"FlyOut"}),"'s ",(0,o.jsx)(t.code,{children:"List"})," component's visibility"]}),"\n",(0,o.jsxs)(t.li,{children:[(0,o.jsx)(t.code,{children:"List"})," to render the ",(0,o.jsx)(t.code,{children:"FlyOut"}),"'s ",(0,o.jsx)(t.code,{children:"ListItems"}),"s"]}),"\n",(0,o.jsxs)(t.li,{children:[(0,o.jsx)(t.code,{children:"ListItem"})," that gets rendered within the ",(0,o.jsx)(t.code,{children:"List"}),"."]}),"\n"]}),"\n",(0,o.jsx)(t.pre,{children:(0,o.jsx)(t.code,{className:"language-js",children:"const FlyOutContext = React.createContext();\n\nexport function FlyOut(props) {\n  const [open, setOpen] = React.useState(false);\n  const [value, setValue] = React.useState('');\n  const toggle = React.useCallback(() => setOpen((state) => !state), []);\n\n  return (\n    <FlyOutContext.Provider value={{ open, toggle, value, setValue }}>\n      <div>{props.children}</div>\n    </FlyOutContext.Provider>\n  );\n}\n\nfunction Input(props) {\n  const { value, toggle } = React.useContext(FlyOutContext);\n\n  return <input onFocus={toggle} onBlur={toggle} value={value} {...props} />;\n}\n\nfunction List({ children }) {\n  const { open } = React.useContext(FlyOutContext);\n\n  return open && <ul>{children}</ul>;\n}\n\nfunction ListItem({ children, value }) {\n  const { setValue } = React.useContext(FlyOutContext);\n\n  return <li onMouseDown={() => setValue(value)}>{children}</li>;\n}\n\nFlyOut.Input = Input;\nFlyOut.List = List;\nFlyOut.ListItem = ListItem;\n"})}),"\n",(0,o.jsxs)(t.p,{children:["Although we didn't have to name our compound component's sub-components ",(0,o.jsx)(t.code,{children:"FlyOut.<ComponentName>"}),", it's an easy way to identify compound components, and only requires a single import."]}),"\n",(0,o.jsx)(t.hr,{}),"\n",(0,o.jsx)(t.h4,{id:"reactchildrenmap",children:(0,o.jsx)(t.code,{children:"React.Children.map"})}),"\n",(0,o.jsxs)(t.p,{children:["Another way to implement the Compound pattern, is to use ",(0,o.jsx)(t.code,{children:"React.Children.map"})," in combination with ",(0,o.jsx)(t.code,{children:"React.cloneElement"}),". Instead of having to use the Context API like in the previous example, we now have access to these two values through ",(0,o.jsx)(t.code,{children:"props"}),"."]}),"\n",(0,o.jsx)(t.pre,{children:(0,o.jsx)(t.code,{className:"language-js",children:"export function FlyOut(props) {\n  const [open, setOpen] = React.useState(false);\n  const [value, setValue] = React.useState('');\n  const toggle = React.useCallback(() => setOpen((state) => !state), []);\n\n  return (\n    <div>\n      {React.Children.map(props.children, (child) =>\n        React.cloneElement(child, { open, toggle, value, setValue }),\n      )}\n    </div>\n  );\n}\n\nfunction Input(props) {\n  const { value, toggle } = React.useContext(FlyOutContext);\n\n  return <input onFocus={toggle} onBlur={toggle} value={value} {...props} />;\n}\n\nfunction List({ children }) {\n  const { open } = React.useContext(FlyOutContext);\n\n  return open && <ul>{children}</ul>;\n}\n\nfunction ListItem({ children, value }) {\n  const { setValue } = React.useContext(FlyOutContext);\n\n  return <li onMouseDown={() => setValue(value)}>{children}</li>;\n}\n\nFlyOut.Input = Input;\nFlyOut.List = List;\nFlyOut.ListItem = ListItem;\n"})}),"\n",(0,o.jsxs)(t.p,{children:["All children components are cloned, and passed the value of ",(0,o.jsx)(t.code,{children:"open"}),", ",(0,o.jsx)(t.code,{children:"toggle"}),", ",(0,o.jsx)(t.code,{children:"value"})," and ",(0,o.jsx)(t.code,{children:"setValue"}),"."]}),"\n",(0,o.jsx)(n,{name:"react-ts-pmdkzr"})]})}function d(e={}){const{wrapper:t}={...(0,s.a)(),...e.components};return t?(0,o.jsx)(t,{...e,children:(0,o.jsx)(u,{...e})}):u(e)}},75251:(e,t,n)=>{var o=n(67294),s=Symbol.for("react.element"),r=Symbol.for("react.fragment"),l=Object.prototype.hasOwnProperty,c=o.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED.ReactCurrentOwner,a={key:!0,ref:!0,__self:!0,__source:!0};function i(e,t,n){var o,r={},i=null,u=null;for(o in void 0!==n&&(i=""+n),void 0!==t.key&&(i=""+t.key),void 0!==t.ref&&(u=t.ref),t)l.call(t,o)&&!a.hasOwnProperty(o)&&(r[o]=t[o]);if(e&&e.defaultProps)for(o in t=e.defaultProps)void 0===r[o]&&(r[o]=t[o]);return{$$typeof:s,type:e,key:i,ref:u,props:r,_owner:c.current}}t.Fragment=r,t.jsx=i,t.jsxs=i},85893:(e,t,n)=>{e.exports=n(75251)},11151:(e,t,n)=>{n.d(t,{Z:()=>c,a:()=>l});var o=n(67294);const s={},r=o.createContext(s);function l(e){const t=o.useContext(r);return o.useMemo((function(){return"function"==typeof e?e(t):{...t,...e}}),[t,e])}function c(e){let t;return t=e.disableParentContext?"function"==typeof e.components?e.components(s):e.components||s:l(e.components),o.createElement(r.Provider,{value:t},e.children)}}}]);