"use strict";(self.webpackChunkweb_totals=self.webpackChunkweb_totals||[]).push([[1477],{30010:n=>{n.exports=JSON.parse('{"blogPosts":[{"id":"/svg-icon-with-pure-css","metadata":{"permalink":"/blog/svg-icon-with-pure-css","editUrl":"https://github.com/hunghg255/web-totals/tree/main/blog/svg-icon-with-pure-css.md","source":"@site/blog/svg-icon-with-pure-css.md","title":"SVG icon with pure css","description":"SVG icon with pure css","date":"2023-12-20T03:47:58.126Z","formattedDate":"December 20, 2023","tags":[{"label":"svg","permalink":"/blog/tags/svg"},{"label":"icon","permalink":"/blog/tags/icon"},{"label":"css","permalink":"/blog/tags/css"}],"readingTime":2.76,"hasTruncateMarker":true,"authors":[{"name":"Gia Hung","title":"Creator of Web totals","url":"https://github.com/hunghg255","email":"giahung197bg@gmail.com","imageURL":"https://res.cloudinary.com/hunghg255/image/upload/v1654956015/Screen_Shot_2022-06-07_at_11.25.34_bpnymt.png","key":"hunghg"}],"frontMatter":{"title":"SVG icon with pure css","authors":"hunghg","tags":["svg","icon","css"]},"unlisted":false,"nextItem":{"title":"React Provider Hell","permalink":"/blog/react-provider-hell"}},"content":"## SVG icon with pure css\\n\\n\x3c!--truncate--\x3e\\n\\n- C\xe1ch c\u01a1 b\u1ea3n: D\xf9ng svg qua th\u1ebb `img` ho\u1eb7c l\xe0 d\xf9ng content c\u1ee7a svg trong html\\n\\n- C\xe1ch ti\u1ebfp c\u1eadn ti\u1ebfp theo l\xe0 chuy\u1ec3n h\u1ebft svg icon th\xe0nh m\u1ed9t b\u1ed9 font r\u1ed3i load b\u1ed9 font,css \u0111\xf3 v\xe0o source code, s\u1eed d\xf9ng b\xean html ch\u1ec9 c\u1ea7n th\xeam class c\u1ee7a icon.\\n\\n  - C\xe1ch n\xe0y s\u1ebd c\xf3 nh\u01b0\u1ee3c \u0111i\xeam l\xe0 kh\xf4ng convert \u0111\u01b0\u1ee3c icon multilplechrome\\n\\n- C\xe1ch ti\u1ebfp theo l\xe0 ch\u1ec9 c\u1ea7n chuy\u1ec3n svg th\xe0nh dataURI r\u1ed3i d\xf9ng trong css, b\xean html s\u1ebd th\xeam class icon\\n\\n  - C\u0169ng c\xf3 m\u1ed9t source h\u1ecd d\u1ef1ng svg d\xf9ng v\u1edbi css [css.gg](https://css.gg/) nh\u01b0ng b\u1ecb gi\u1edbi h\u1ea1n icon v\xe0 c\xe1ch h\u1ecd x\u1eed l\xfd c\u0169ng ph\u1ee9c t\u1ea1p.\\n\\n- HTML\\n\\n```html\\n<div class=\\"my-icon\\"></div>\\n```\\n\\n- CSS\\n\\n```css\\n.my-icon {\\n  background: url(data:...) no-repeat center;\\n  background-color: transparent;\\n  background-size: 16px 16px;\\n  height: 16px;\\n  width: 16px;\\n  display: inline-block;\\n}\\n```\\n\\n- \u0110\u1ec3 convert svg string sang dataURI\\n\\n```js\\nconst svg = `<svg>...</svg>`;\\nconst dataUri = `data:image/svg+xml;base64,${Buffer.from(svg).toString(\'base64\')}`;\\n```\\n\\n- N\u1ebfu chuy\u1ec3n sang URI th\xec \u0111\u1ec1u ch\u1ecdn l\xe0 base64. nh\u01b0ng nh\u01b0\u1ee3c \u0111i\u1ec3m l\xe0 s\u1ebd n\u1eb7ng khi t\u1ea3i, th\u1ef1c t\u1ebf base64 \u0111\u1ec3 encode data binary nh\u01b0 \u1ea3nh sang base64 \u0111\u1ec3 d\xf9ng trong file text nh\u01b0 css.\\n\\n- V\u1edbi svg th\u1ef1c t\u1ebf n\xf3 \u0111\xe3 l\xe0 text r\u1ed3i v\xec th\u1ebf m\xecnh kh\xf4ng c\u1ea7n chuy\u1ec3n sang d\u1ea1ng base64 n\u1eefa, mn c\xf3 th\u1ec3 \u0111oc th\xeam v\u1ec1 2 b\xe0i n\xe0y [probably-dont-base64-svg](https://css-tricks.com/probably-dont-base64-svg/), [optimizing-svgs-in-data-uris](https://codepen.io/Tigt/post/optimizing-svgs-in-data-uris)\\n\\n- C\xf3 m\u1ed9t c\xe1ch kh\xe1c \u0111\u1ec3 chuy\u1ec3n svg sang dataURI nh\u01b0 sau\\n\\n```js\\n// https://bl.ocks.org/jennyknuth/222825e315d45a738ed9d6e04c7a88d0\\nfunction encodeSvg(svg: string) {\\n  return svg\\n    .replace(\'<svg\', ~svg.indexOf(\'xmlns\') ? \'<svg\' : \'<svg xmlns=\\"http://www.w3.org/2000/svg\\"\')\\n    .replace(/\\"/g, \\"\'\\")\\n    .replace(/%/g, \'%25\')\\n    .replace(/#/g, \'%23\')\\n    .replace(/{/g, \'%7B\')\\n    .replace(/}/g, \'%7D\')\\n    .replace(/</g, \'%3C\')\\n    .replace(/>/g, \'%3E\');\\n}\\n\\nconst dataUri = `data:image/svg+xml;utf8,${encodeSvg(svg)}`;\\n```\\n\\n- V\u1ec1 k\xedch th\u01b0\u1edbc. ta ch\u1ec9 c\u1ea7n d\xf9ng \u0111\u01a1n v\u1ecb `em` trong css\\n\\n```css\\n.my-icon {\\n  background: url(data:...) no-repeat center;\\n  background-color: transparent;\\n  background-size: 100% 100%;\\n  height: 1em;\\n  width: 1em;\\n}\\n```\\n\\n- V\u1ec1 m\xe0u. v\u1edbi svg ta ch\u1ec9 c\u1ea7n d\xf9ng `fill=currentColor` ([svg currentcolor](https://www.w3.org/TR/css-color-3/#currentcolor)). C\xe1ch n\xe0y svg s\u1ebd fill theo m\xe0u c\u1ee7a text, nh\u01b0ng c\xf3 m\u1ed9t \u0111i\u1ec3m l\xe0 n\u1ebfu ta d\xf9ng `background` th\xec m\xe0u s\u1ebd kh\xf4ng \u0103n v\u1edbi icon. C\u0169ng c\xf3 1 b\xe0i x\u1eed l\xfd v\u1ea5n \u0111\u1ec1 fill m\xe0u cho \u1ea3nh d\xf9ng css filter ([solved-with-css-colorizing-svg-backgrounds](https://css-tricks.com/solved-with-css-colorizing-svg-backgrounds/)) nh\u01b0ng c\u1ea7n t\xednh to\xe1n matrix \u0111\u1ec3 thay \u0111\u1ed5i m\xe0u. n\xf3 c\u0169ng kh\xe1 ph\u1ee9c t\u1ea1p n\u1ebfu d\xf9ng c\xe1ch n\xe0y. m\xecnh ch\u1ec9 mu\u1ed1n d\xf9ng v\u1edbi css thu\u1ea7n.\\n\\n  - C\xf3 v\u1ebb nh\u01b0 \u0111\xe3 kh\xf4ng c\xf3 c\xe1ch n\xe0o nh\u01b0ng \u0111\xe3 c\xf3 m\u1ed9t b\xe0i n\xf3i v\u1ec1 fill m\xe0u cho image d\xf9ng css [coloring-svgs-in-css-background-images](https://codepen.io/noahblon/post/coloring-svgs-in-css-background-images). b\xe0i vi\u1ebft n\xf3i v\u1ec1 d\xf9ng css mask ([css mask](https://developer.mozilla.org/en-US/docs/Web/CSS/mask)) thu\u1ed9c t\xednh m\xecnh c\xf2n ch\u01b0a nghe \u0111\u1ebfn tr\u01b0\u1edbc \u0111\xe2y\\n\\n```css\\n.my-icon {\\n  background-color: currentColor;\\n  mask-image: url(icon.svg);\\n}\\n```\\n\\n- Nh\u01b0 v\u1eady v\u1ea5n \u0111\u1ec1 fill m\xe0u cho icon monochrome \u0111\xe3 \u0111\u01b0\u1ee3c gi\u1ea3i quy\u1ebft, c\xf2n icon multiplechorme th\xec sao.\\n- \u0110\u01a1n gi\u1ea3n m\xecnh ch\u1ec9 c\u1ea7n check xem icon \u0111\xf3 c\xf3 ph\u1ea3i l\xe0 multiplechrome hay kh\xf4ng th\xf4i v\xe0 gi\u1eef nguy\xean m\xe0u n\u1ebfu l\xe0 multiplechrome\\n\\n```js\\n// if an SVG icon have the `currentColor` value,\\n// it\'s very likely to be a monochrome icon\\nconst isMonochrome = checkMonochrome(svg);\\n\\nconst uri = `url(\\"data:image/svg+xml;utf8,${encodeSvg(svg)}\\")`;\\n\\n// monochrome\\nif (isMonochrome) {\\n  return {\\n    mask: `${uri} no-repeat`,\\n    \'mask-size\': \'100% 100%\',\\n    \'background-color\': \'currentColor\',\\n    height: \'1em\',\\n    width: \'1em\',\\n  };\\n}\\n// colored\\nelse {\\n  return {\\n    background: `${uri} no-repeat`,\\n    \'background-size\': \'100% 100%\',\\n    \'background-color\': \'transparent\',\\n    height: \'1em\',\\n    width: \'1em\',\\n  };\\n}\\n```\\n\\n\u0110\xe2y l\xe0 trang demo: https://svg-to-css.surge.sh/"},{"id":"/react-provider-hell","metadata":{"permalink":"/blog/react-provider-hell","editUrl":"https://github.com/hunghg255/web-totals/tree/main/blog/react-provider-hell.md","source":"@site/blog/react-provider-hell.md","title":"React Provider Hell","description":"React Provider Hell","date":"2023-09-19T19:28:57.000Z","formattedDate":"September 19, 2023","tags":[{"label":"react","permalink":"/blog/tags/react"},{"label":"provider","permalink":"/blog/tags/provider"}],"readingTime":1.18,"hasTruncateMarker":true,"authors":[{"name":"Gia Hung","title":"Creator of Web totals","url":"https://github.com/hunghg255","email":"giahung197bg@gmail.com","imageURL":"https://res.cloudinary.com/hunghg255/image/upload/v1654956015/Screen_Shot_2022-06-07_at_11.25.34_bpnymt.png","key":"hunghg"}],"frontMatter":{"title":"React Provider Hell","authors":"hunghg","tags":["react","provider"],"image":"https://res.cloudinary.com/practicaldev/image/fetch/s--HOQYtEP_--/c_imagga_scale,f_auto,fl_progressive,h_900,q_auto,w_1600/https://dev-to-uploads.s3.amazonaws.com/uploads/articles/kj81kq4qurtf84xrvtm8.png"},"unlisted":false,"prevItem":{"title":"SVG icon with pure css","permalink":"/blog/svg-icon-with-pure-css"},"nextItem":{"title":"Example Callstack And Event loop","permalink":"/blog/event-loop-call-stack-example"}},"content":"React Provider Hell\\n\\n\x3c!--truncate--\x3e\\n\\n## Issue\\n\\n```jsx live noInline\\nconst context1 = createContext({});\\nconst context2 = createContext({});\\nconst context3 = createContext({});\\nconst context4 = createContext({});\\n\\nconst ChildApp = () => {\\n  const v1 = useContext(context1);\\n  const v2 = useContext(context2);\\n  const v3 = useContext(context3);\\n  const v4 = useContext(context4);\\n\\n  return (\\n    <>\\n      <h2>ChildApp</h2>\\n      {v1.v}\\n      {v2.v}\\n      {v3.v}\\n      {v4.v}\\n    </>\\n  );\\n};\\n\\nconst App = () => {\\n  return (\\n    <>\\n      <context1.Provider value={{ v: 1 }}>\\n        <context2.Provider value={{ v: 2 }}>\\n          <context3.Provider value={{ v: 3 }}>\\n            <context4.Provider value={{ v: 4 }}>\\n              <ChildApp />\\n            </context4.Provider>\\n          </context3.Provider>\\n        </context2.Provider>\\n      </context1.Provider>\\n    </>\\n  );\\n};\\n\\nrender(<App />);\\n```\\n\\n## Solution\\n\\n```jsx live noInline\\nconst context1 = createContext({});\\nconst context2 = createContext({});\\nconst context3 = createContext({});\\nconst context4 = createContext({});\\n\\nconst ChildApp = () => {\\n  const v1 = useContext(context1);\\n  const v2 = useContext(context2);\\n  const v3 = useContext(context3);\\n  const v4 = useContext(context4);\\n\\n  return (\\n    <>\\n      <h2>ChildApp</h2>\\n      {v1.v}\\n      {v2.v}\\n      {v3.v}\\n      {v4.v}\\n    </>\\n  );\\n};\\n\\nconst buildProvidersTree = (componentWithProps = []) => {\\n  return ({ children }) => {\\n    return componentWithProps.reduceRight((acc, [Provider, props]) => {\\n      return <Provider {...props}>{acc}</Provider>;\\n    }, children);\\n  };\\n};\\n\\nconst ProvidersTree = buildProvidersTree([\\n  [context1.Provider, { value: { v: 1 } }],\\n  [context2.Provider, { value: { v: 2 } }],\\n  [context3.Provider, { value: { v: 3 } }],\\n  [context4.Provider, { value: { v: 4 } }],\\n]);\\n\\nconst App = () => {\\n  return (\\n    <>\\n      <ProvidersTree>\\n        <ChildApp />\\n      </ProvidersTree>\\n    </>\\n  );\\n};\\n\\nrender(<App />);\\n```"},{"id":"/event-loop-call-stack-example","metadata":{"permalink":"/blog/event-loop-call-stack-example","editUrl":"https://github.com/hunghg255/web-totals/tree/main/blog/event-loop-call-stack-example.md","source":"@site/blog/event-loop-call-stack-example.md","title":"Example Callstack And Event loop","description":"Example callstack and event loop","date":"2023-09-05T04:54:37.000Z","formattedDate":"September 5, 2023","tags":[{"label":"javascript","permalink":"/blog/tags/javascript"},{"label":"callstack","permalink":"/blog/tags/callstack"},{"label":"event loop","permalink":"/blog/tags/event-loop"}],"readingTime":0.835,"hasTruncateMarker":true,"authors":[{"name":"Gia Hung","title":"Creator of Web totals","url":"https://github.com/hunghg255","email":"giahung197bg@gmail.com","imageURL":"https://res.cloudinary.com/hunghg255/image/upload/v1654956015/Screen_Shot_2022-06-07_at_11.25.34_bpnymt.png","key":"hunghg"}],"frontMatter":{"title":"Example Callstack And Event loop","authors":"hunghg","tags":["javascript","callstack","event loop"],"image":"https://cdn.hashnode.com/res/hashnode/image/upload/v1644518372680/XWZCTFGrJ.png?auto=compress,format&format=webp"},"unlisted":false,"prevItem":{"title":"React Provider Hell","permalink":"/blog/react-provider-hell"},"nextItem":{"title":"Centering in CSS","permalink":"/blog/center-css"}},"content":"Example callstack and event loop\\n\\n\x3c!--truncate--\x3e\\n\\n## Example\\n\\n```js\\nasync function abc() {\\n  console.log(8);\\n  await Promise.resolve(2).then(console.log);\\n  console.log(3); // same .then(() => console.log(3))\\n}\\n\\nsetTimeout(() => console.log(1), 0);\\nabc();\\nPromise.resolve(4).then(console.log);\\nconsole.log(6);\\n```\\n\\n## Information\\n\\n:::info\\n\\n- `Macrotasks`: setTimeout , setInterval , setImmediate , requestAnimationFrame , I / O , giao di\u1ec7n ng\u01b0\u1eddi d\xf9ng render\\n\\n- `Microtasks`: process.nextTick , Promises , queueMicrotask , MutationObserver\\n\\n:::\\n\\n![](https://res.cloudinary.com/hunghg255/image/upload/v1693889526/js-microtask-macro-task_gre5dw.webp)\\n\\n## Explain\\n\\n```md\\n1. Ch\u1ea1y `setTimeout` => push `log(1)` v\xe0o `MacroTask Queue`\\n\\n2. Ch\u1ea1y func `abc` => `log(8)` => push `log(2)` v\xe0o `MicroTask Queue` => `await`\\n   `Output: 8`\\n\\n3. push `log(4)` v\xe0o `MicroTask Queue`\\n\\n4. `log(6)`\\n   `Output: 8 6`\\n\\n5. Th\u1ef1c thi `MicroTask Queue` c\xf3 2 callback `log(2)` v\xe0 `log(4)`\\n   `log(2)` => coi `log(3) l\xe0 .then(() => log(3))` push `log(3)` v\xe0o `MicroTask Queue`\\n   `log(4)` => `log(3)`\\n\\n   `Output: 8 6 2 4 3`\\n\\n6. `MicroTask Queue` \u0111\xe3 r\u1ed7ng k\u1ebft th\xfac turn => b\u1eaft \u0111\u1ea7u 1 turn m\u1edbi th\u1ef1c thi `MacroTask Queue` c\xf3 1 callback `log(1)`\\n   `log(1)`\\n   `Output: 8 6 2 4 3 1`\\n```"},{"id":"/center-css","metadata":{"permalink":"/blog/center-css","editUrl":"https://github.com/hunghg255/web-totals/tree/main/blog/center-css.md","source":"@site/blog/center-css.md","title":"Centering in CSS","description":"1. Content Center","date":"2023-05-12T04:20:35.000Z","formattedDate":"May 12, 2023","tags":[{"label":"html","permalink":"/blog/tags/html"},{"label":"css","permalink":"/blog/tags/css"},{"label":"tips","permalink":"/blog/tags/tips"}],"readingTime":0.685,"hasTruncateMarker":true,"authors":[{"name":"Gia Hung","title":"Creator of Web totals","url":"https://github.com/hunghg255","email":"giahung197bg@gmail.com","imageURL":"https://res.cloudinary.com/hunghg255/image/upload/v1654956015/Screen_Shot_2022-06-07_at_11.25.34_bpnymt.png","key":"hunghg"}],"frontMatter":{"title":"Centering in CSS","authors":"hunghg","tags":["html","css","tips"],"image":"https://res.cloudinary.com/hunghg255/image/upload/v1683865180/css-center_m1zi5l.png"},"unlisted":false,"prevItem":{"title":"Example Callstack And Event loop","permalink":"/blog/event-loop-call-stack-example"},"nextItem":{"title":"Vscode extensions useful","permalink":"/blog/vscode-extensions-useful"}},"content":"\x3c!--truncate--\x3e\\n\\n## 1. Content Center\\n\\n```html title=HTML\\n<div class=\\"content-center\\">...</div>\\n```\\n\\n```css title=CSS\\n.content-center {\\n  display: grid;\\n  place-content: center;\\n  gap: 1ch;\\n}\\n```\\n\\n## 2. Gentle Flex\\n\\n```html title=HTML\\n<div class=\\"gentle-flex\\">...</div>\\n```\\n\\n```css title=CSS\\n.gentle-flex {\\n  display: flex;\\n  flex-direction: column;\\n  align-items: center;\\n  justify-content: center;\\n  gap: 1ch;\\n}\\n```\\n\\n## 3. Autobot\\n\\n```html title=HTML\\n<div class=\\"autobot\\">...</div>\\n```\\n\\n```css title=CSS\\n.autobot {\\n  display: flex;\\n}\\n.autobot > * {\\n  margin: auto;\\n}\\n```\\n\\n## 4. Fluffy Center\\n\\n```html title=HTML\\n<div class=\\"fluffy-center\\">...</div>\\n```\\n\\n```css title=CSS\\n.fluffy-center {\\n  padding: 10ch;\\n}\\n```\\n\\n## 5. Pop & Plop\\n\\n```html title=HTML\\n<div class=\\"parent\\">\\n  <div class=\\"pop-plop\\">...</div>\\n</div>\\n```\\n\\n```css title=CSS\\n.parent {\\n  position: relative;\\n}\\n\\n/* Option 1 */\\n.pop-plop {\\n  position: absolute;\\n  left: 50%;\\n  top: 50%;\\n  transform: translate(-50%, -50%);\\n}\\n\\n/* Option 2 */\\n.pop-plop {\\n  position: absolute;\\n  inset: 0;\\n  margin: auto;\\n}\\n```"},{"id":"/vscode-extensions-useful","metadata":{"permalink":"/blog/vscode-extensions-useful","editUrl":"https://github.com/hunghg255/web-totals/tree/main/blog/vscode-extensions-useful.md","source":"@site/blog/vscode-extensions-useful.md","title":"Vscode extensions useful","description":"Extensions useful on vscode","date":"2023-04-24T17:21:54.000Z","formattedDate":"April 24, 2023","tags":[{"label":"vscode","permalink":"/blog/tags/vscode"},{"label":"extensions","permalink":"/blog/tags/extensions"},{"label":"css","permalink":"/blog/tags/css"},{"label":"tips","permalink":"/blog/tags/tips"}],"readingTime":0.135,"hasTruncateMarker":true,"authors":[{"name":"Gia Hung","title":"Creator of Web totals","url":"https://github.com/hunghg255","email":"giahung197bg@gmail.com","imageURL":"https://res.cloudinary.com/hunghg255/image/upload/v1654956015/Screen_Shot_2022-06-07_at_11.25.34_bpnymt.png","key":"hunghg"}],"frontMatter":{"title":"Vscode extensions useful","authors":"hunghg","tags":["vscode","extensions","css","tips"],"image":"https://upload.wikimedia.org/wikipedia/commons/thumb/9/9a/Visual_Studio_Code_1.35_icon.svg/1200px-Visual_Studio_Code_1.35_icon.svg.png"},"unlisted":false,"prevItem":{"title":"Centering in CSS","permalink":"/blog/center-css"},"nextItem":{"title":"Convert svgs file to jsx by one script","permalink":"/blog/convert-svgs-to-jsx"}},"content":"Extensions useful on vscode\\n\\n\x3c!--truncate--\x3e\\n\\n## 1. Agile CSS Suggestion\\n\\n[Agile CSS Suggestion](https://marketplace.visualstudio.com/items?itemName=AgileCssSuggestion.agile-css-suggestion)\\n\\n## Result\\n\\n![](https://res.cloudinary.com/hunghg255/image/upload/v1682245314/agile-css-suggestion_jxh0ys.png)\\n\\n## 2. CSS to Tailwindcss\\n\\n[CSS to Tailwindcss](https://marketplace.visualstudio.com/items?itemName=hunghg255.css-2-tailwindcss)\\n\\n## Result\\n\\n![](https://res.cloudinary.com/hunghg255/image/upload/v1685594372/css2tailwindcss-demo_lzpyfi.gif)"},{"id":"/convert-svgs-to-jsx","metadata":{"permalink":"/blog/convert-svgs-to-jsx","editUrl":"https://github.com/hunghg255/web-totals/tree/main/blog/convert-svgs-to-jsx.md","source":"@site/blog/convert-svgs-to-jsx.md","title":"Convert svgs file to jsx by one script","description":"Run this script on terminal","date":"2023-04-24T17:13:15.000Z","formattedDate":"April 24, 2023","tags":[{"label":"svg","permalink":"/blog/tags/svg"},{"label":"jsx","permalink":"/blog/tags/jsx"},{"label":"reactjs","permalink":"/blog/tags/reactjs"},{"label":"scripts","permalink":"/blog/tags/scripts"},{"label":"generate","permalink":"/blog/tags/generate"}],"readingTime":0.94,"hasTruncateMarker":true,"authors":[{"name":"Gia Hung","title":"Creator of Web totals","url":"https://github.com/hunghg255","email":"giahung197bg@gmail.com","imageURL":"https://res.cloudinary.com/hunghg255/image/upload/v1654956015/Screen_Shot_2022-06-07_at_11.25.34_bpnymt.png","key":"hunghg"}],"frontMatter":{"title":"Convert svgs file to jsx by one script","authors":"hunghg","tags":["svg","jsx","reactjs","scripts","generate"],"image":"https://upload.wikimedia.org/wikipedia/commons/thumb/a/a7/React-icon.svg/1200px-React-icon.svg.png"},"unlisted":false,"prevItem":{"title":"Vscode extensions useful","permalink":"/blog/vscode-extensions-useful"},"nextItem":{"title":"HTML Input Type","permalink":"/blog/html-input"}},"content":"\x3c!--truncate--\x3e\\n\\n## Run this script on terminal\\n\\n[npm link](https://www.npmjs.com/package/agile-svg2jsx)\\n\\n## CLI\\n\\n<NpxConvert packageBinCli=\\"agile-svg2jsx --i $PATH_SVGS_FOLDER --o $PATH_REACT_FOLDER\\"/>\\n\\n## setup at `package.json`\\n\\n```json\\n\\"scripts\\": {\\n  ...\\n  \\"gen-icon\\": \\"npx agile-svg2jsx --i $PATH_SVGS_FOLDER --o $PATH_REACT_FOLDER\\"\\n},\\n```\\n\\n## Demo\\n\\n[Github](https://github.com/hunghg255/react-generate-svg-2-icon)\\n\\n![](https://res.cloudinary.com/hunghg255/image/upload/v1682355827/svg2jsx_bbivgm.gif)\\n\\n## Live code\\n\\n```jsx live noInline\\nconst IconAccountBook = (props) => {\\n  return (\\n    <span {...props}>\\n      <svg\\n        xmlns=\'http://www.w3.org/2000/svg\'\\n        className=\'icon\'\\n        viewBox=\'0 0 1024 1024\'\\n        fill=\'currentColor\'\\n        width=\'1em\'\\n        height=\'1em\'\\n      >\\n        <path d=\'M880 184H712v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H384v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H144c-17.7 0-32 14.3-32 32v664c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V216c0-17.7-14.3-32-32-32zM648.3 426.8l-87.7 161.1h45.7c5.5 0 10 4.5 10 10v21.3c0 5.5-4.5 10-10 10h-63.4v29.7h63.4c5.5 0 10 4.5 10 10v21.3c0 5.5-4.5 10-10 10h-63.4V752c0 5.5-4.5 10-10 10h-41.3c-5.5 0-10-4.5-10-10v-51.8h-63.1c-5.5 0-10-4.5-10-10v-21.3c0-5.5 4.5-10 10-10h63.1v-29.7h-63.1c-5.5 0-10-4.5-10-10v-21.3c0-5.5 4.5-10 10-10h45.2l-88-161.1c-2.6-4.8-.9-10.9 4-13.6 1.5-.8 3.1-1.2 4.8-1.2h46c3.8 0 7.2 2.1 8.9 5.5l72.9 144.3 73.2-144.3a10 10 0 0 1 8.9-5.5h45c5.5 0 10 4.5 10 10 .1 1.7-.3 3.3-1.1 4.8z\' />\\n      </svg>\\n    </span>\\n  );\\n};\\n\\nconst App = () => (\\n  <>\\n    <IconAccountBook\\n      onClick={() => alert(\'Hello\')}\\n      style={{\\n        fontSize: 50,\\n        color: \'red\',\\n      }}\\n    />\\n\\n    <IconAccountBook\\n      onClick={() => alert(\'Hello\')}\\n      style={{\\n        fontSize: 50,\\n        color: \'green\',\\n      }}\\n    />\\n\\n    <IconAccountBook\\n      onClick={() => alert(\'Hello\')}\\n      style={{\\n        fontSize: 50,\\n        color: \'blue\',\\n      }}\\n    />\\n  </>\\n);\\n\\nrender(<App />);\\n```"},{"id":"/html-input","metadata":{"permalink":"/blog/html-input","editUrl":"https://github.com/hunghg255/web-totals/tree/main/blog/html-input.md","source":"@site/blog/html-input.md","title":"HTML Input Type","description":"All input type html!","date":"2023-04-13T10:15:25.000Z","formattedDate":"April 13, 2023","tags":[{"label":"Html","permalink":"/blog/tags/html"}],"readingTime":0.89,"hasTruncateMarker":true,"authors":[{"name":"Gia Hung","title":"Creator of Web totals","url":"https://github.com/hunghg255","email":"giahung197bg@gmail.com","imageURL":"https://res.cloudinary.com/hunghg255/image/upload/v1654956015/Screen_Shot_2022-06-07_at_11.25.34_bpnymt.png","key":"hunghg"}],"frontMatter":{"title":"HTML Input Type","authors":"hunghg","tags":["Html"],"image":"https://upload.wikimedia.org/wikipedia/commons/thumb/8/80/HTML5_logo_resized.svg/1200px-HTML5_logo_resized.svg.png"},"unlisted":false,"prevItem":{"title":"Convert svgs file to jsx by one script","permalink":"/blog/convert-svgs-to-jsx"},"nextItem":{"title":"Scroll Restoration in Nextjs","permalink":"/blog/scroll-restoration-nextjs"}},"content":"## All input type html!\\n\\n\x3c!--truncate--\x3e\\n\\n```jsx live\\nfunction App() {\\n  return (\\n    <div>\\n      <div>\\n        Button: <input type=\'button\' value=\'Click Me!\' />\\n      </div>\\n      <div>\\n        Checkbox: <input type=\'checkbox\' />\\n      </div>\\n      <div>\\n        Color: <input type=\'color\' />\\n      </div>\\n      <div>\\n        Date: <input type=\'date\' />\\n      </div>\\n      <div>\\n        Date Local: <input type=\'datetime-local\' />\\n      </div>\\n      <div>\\n        Email: <input type=\'email\' />\\n      </div>\\n      <div>\\n        File: <input type=\'file\' />\\n      </div>\\n      <div>\\n        Hidden: <input type=\'hidden\' />\\n      </div>\\n      <div>\\n        Image: <input type=\'image\' />\\n      </div>\\n      <div>\\n        Number: <input type=\'number\' />\\n      </div>\\n      <div>\\n        Number + decimal: <input type=\'number\' inputmode=\'decimal\' />\\n      </div>\\n      <div>\\n        Number + numeric: <input type=\'number\' inputmode=\'numeric\' />\\n      </div>\\n      <div>\\n        Password: <input type=\'password\' />\\n      </div>\\n      <div>\\n        Radio: <input type=\'radio\' />\\n      </div>\\n      <div>\\n        Range: <input type=\'range\' />\\n      </div>\\n      <div>\\n        Reset: <input type=\'reset\' />\\n      </div>\\n      <div>\\n        Search: <input type=\'search\' />\\n      </div>\\n      <div>\\n        Submit: <input type=\'submit\' />\\n      </div>\\n      <div>\\n        Tel: <input type=\'tel\' />\\n      </div>\\n      <div>\\n        Text: <input type=\'text\' />\\n      </div>\\n      <div>\\n        Time: <input type=\'time\' />\\n      </div>\\n      <div>\\n        Url: <input type=\'url\' />\\n      </div>\\n      <div>\\n        Week: <input type=\'week\' />\\n      </div>\\n      <div>\\n        Month: <input type=\'month\' />\\n      </div>\\n    </div>\\n  );\\n}\\n```\\n\\n:::note Reference\\n1: https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input\\n\\n2: https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/inputmode\\n:::"},{"id":"/scroll-restoration-nextjs","metadata":{"permalink":"/blog/scroll-restoration-nextjs","editUrl":"https://github.com/hunghg255/web-totals/tree/main/blog/scroll-restoration-nextjs.md","source":"@site/blog/scroll-restoration-nextjs.md","title":"Scroll Restoration in Nextjs","description":"Experimental scroll restoration flag","date":"2023-04-07T11:04:02.000Z","formattedDate":"April 7, 2023","tags":[{"label":"Nextjs","permalink":"/blog/tags/nextjs"},{"label":"Scroll Restoration","permalink":"/blog/tags/scroll-restoration"}],"readingTime":1.345,"hasTruncateMarker":true,"authors":[{"name":"Gia Hung","title":"Creator of Web totals","url":"https://github.com/hunghg255","email":"giahung197bg@gmail.com","imageURL":"https://res.cloudinary.com/hunghg255/image/upload/v1654956015/Screen_Shot_2022-06-07_at_11.25.34_bpnymt.png","key":"hunghg"}],"frontMatter":{"title":"Scroll Restoration in Nextjs","authors":"hunghg","tags":["Nextjs","Scroll Restoration"],"image":"https://decodenatura.com/static/fb8aa1bb70c9925ce1ae22dc2711b343/nextjs-logo.png"},"unlisted":false,"prevItem":{"title":"HTML Input Type","permalink":"/blog/html-input"},"nextItem":{"title":"X\u1eed l\xfd form v\u1edbi Ant Design (Ph\u1ea7n 1)","permalink":"/blog/handle-form-antd-part-1"}},"content":"## Experimental scroll restoration flag\\n\\nLuckily, Next.js has an [experimental scrollRestoration flag](https://github.com/vercel/next.js/commit/38bd1a024cb25923d8ea15f269a7294d073684d8) that you can enable to automatically restore the scroll positions.\\n\\n\x3c!--truncate--\x3e\\n\\nYou can enable it in your `next.config.js` file this way:\\n\\n```js title=next.config.js\\nmodule.exports = {\\n  experimental: {\\n    scrollRestoration: true,\\n  },\\n};\\n```\\n\\n## next-router-scroll\\n\\nThere are some cases where you need to take control of how your application scroll is handled; namely, you may want to restore scroll when the user is navigating within your application pages, but you need to do extra work before or after the page has changed, either by using some sort of page transition or any other feature.\\nIn these cases, I\u2019d suggest you give `@moxy/next-router-scroll` a try: This package is built on top of [scroll-behavior](https://www.npmjs.com/package/scroll-behavior) and it actively listens to Next.js router events, writing the scroll values associated with the current location in the Session Storage and reading these values whenever `updateScroll()` is called.\\n\\n## Completely disabling scroll restoration\\n\\nThere\u2019s one inconsistency I noticed around not making scroll restoration work automatically in Next.js: by default, scroll restoration doesn\u2019t work when the navigation logic is being handled by JavaScript, but it works fine when it\u2019s handled by the browser (e.g.: on a full-refresh or while navigating with JavaScript disabled).\\n\\nSo, in the rare occasions where you want to fully disable scroll restoration, remember to add this snippet to the `<head>` of your project:\\n\\n```tsx\\nimport Head from \'next/head\';\\n\\nexport default function ScrollRestorationDisabler() {\\n  return (\\n    <Head>\\n      {/* Tell the browser to never restore the scroll position on load */}\\n      <script\\n        dangerouslySetInnerHTML={{\\n          __html: `history.scrollRestoration = \\"manual\\"`,\\n        }}\\n      />\\n    </Head>\\n  );\\n}\\n```"},{"id":"/handle-form-antd-part-1","metadata":{"permalink":"/blog/handle-form-antd-part-1","editUrl":"https://github.com/hunghg255/web-totals/tree/main/blog/handle-form-antd-part-1.md","source":"@site/blog/handle-form-antd-part-1.md","title":"X\u1eed l\xfd form v\u1edbi Ant Design (Ph\u1ea7n 1)","description":"C\xe1ch x\u1eed l\xfd form trong Ant Design sao cho \u0111\xfang.","date":"2023-03-19T10:54:44.000Z","formattedDate":"March 19, 2023","tags":[{"label":"Reactjs","permalink":"/blog/tags/reactjs"},{"label":"Ant Design","permalink":"/blog/tags/ant-design"}],"readingTime":6.16,"hasTruncateMarker":true,"authors":[{"name":"Gia Hung","title":"Creator of Web totals","url":"https://github.com/hunghg255","email":"giahung197bg@gmail.com","imageURL":"https://res.cloudinary.com/hunghg255/image/upload/v1654956015/Screen_Shot_2022-06-07_at_11.25.34_bpnymt.png","key":"hunghg"}],"frontMatter":{"title":"X\u1eed l\xfd form v\u1edbi Ant Design (Ph\u1ea7n 1)","authors":"hunghg","tags":["Reactjs","Ant Design"],"image":"https://gw.alipayobjects.com/zos/rmsportal/KDpgvguMpGfqaHPjicRK.svg"},"unlisted":false,"prevItem":{"title":"Scroll Restoration in Nextjs","permalink":"/blog/scroll-restoration-nextjs"},"nextItem":{"title":"The Most Popular Build Tools for Front-end Developers in 2023","permalink":"/blog/build-tools-frontend-2023"}},"content":"C\xe1ch x\u1eed l\xfd form trong Ant Design sao cho \u0111\xfang.\\n\\n\x3c!--truncate--\x3e\\n\\n## 1. C\u01a1 ch\u1ebf ho\u1ea1t \u0111\u1ed9ng\\n\\nTa x\xe9t m\u1ed9t v\xed d\u1ee5 \u0111\u01a1n gi\u1ea3n nh\u01b0 sau:\\n\\n```tsx\\nimport { Button, Checkbox, Form, Input } from \'antd\';\\n\\nconst onFinish = (values) => {\\n  console.log(\'Success:\', values);\\n};\\n\\nconst App = () => (\\n  <Form onFinish={onFinish}>\\n    <Form.Item name=\'username\'>\\n      <Input />\\n    </Form.Item>\\n\\n    <Button type=\'primary\' htmlType=\'submit\'>\\n      Submit\\n    </Button>\\n  </Form>\\n);\\n```\\n\\n![Demo 1](https://res.cloudinary.com/hunghg255/image/upload/v1679199291/blog/Screenshot_2023-03-19_at_11.14.37_lp70zv.png)\\n\\nNh\u01b0 ta th\u1ea5y khi \u0111\u1eb7t component `Input` trong `Form.Item` v\u1edbi `name` l\xe0 `username` th\xec khi submit s\u1ebd nh\u1eadn \u0111\u01b0\u1ee3c m\u1ed9t object v\u1edbi key l\xe0 `username` v\xe0 value l\xe0 gi\xe1 tr\u1ecb c\u1ee7a input.\\n\\nV\u1eady c\xf3 ph\u1ea3i c\u1ee9 \u0111\u1eb7t `Input` b\xean trong `Form.Item` l\xe0 ta s\u1ebd l\u1ea5y \u0111\u01b0\u1ee3c value c\u1ee7a Input khi submit kh\xf4ng?\\nM\xecnh s\u1ebd custom x\xedu l\xe0 th\xeam c\xe1i label ho\u1eb7c c\u1ea7n tu\u1ef3 bi\u1ebfn input th\xeam prefix ho\u1eb7c suffix icon,...\\n\\n```tsx\\n<Form.Item name=\'username\'>\\n  <Row>\\n    <label>Username</label>\\n    <Input />\\n  </Row>\\n</Form.Item>\\n```\\n\\n![Demo 2](https://res.cloudinary.com/hunghg255/image/upload/v1679200848/blog/Screenshot_2023-03-19_at_11.40.41_onm9lw.png)\\n\\nV\u1eabn cho m\xecnh c\xf9ng k\u1ebft qu\u1ea3. n\u1ebfu ta mu\u1ed1n d\xf9ng nhi\u1ec1u n\u01a1i th\xec ph\u1ea3i copy sang nhi\u1ec1u ch\u1ed7 kh\xe1c nhau. v\u1eady m\xecnh s\u1ebd t\xe1ch th\xe0nh m\u1ed9t component \u0111\u1ec3 sau c\xf3 th\u1ec3 t\xe1i s\u1eed d\u1ee5ng\\n\\n```tsx\\nconst CustomInput = () => {\\n  return (\\n    <Row>\\n      <label>Username</label>\\n      <Input />\\n    </Row>\\n  );\\n};\\n\\n<Form.Item name=\'username\'>\\n  <CustomInput />\\n</Form.Item>;\\n```\\n\\n![Demo 3](https://res.cloudinary.com/hunghg255/image/upload/v1679200637/blog/Screenshot_2023-03-19_at_11.37.10_ixmjsf.png)\\n\\nM\xecnh ki\u1ec3m tra l\u1ea1i k\u1ebft qu\u1ea3 xem sao. Ops k\u1ebft qu\u1ea3 kh\xf4ng nh\u01b0 ta mong \u0111\u1ee3i. Khi t\xe1ch th\xe0nh component \u0111\u1ec3 c\xf3 th\u1ec3 t\xe1i s\u1eed d\u1ee5ng th\xec kh\xf4ng c\xf2n l\u1ea5y \u0111\u01b0\u1ee3c value c\u1ee7a `input` n\u1eefa. V\u1eady chuy\u1ec7n g\xec \u0111\xe3 x\u1ea3y ra m\xe0 khi \u0111\u1eb7t trong `Form.Item` th\xec c\xf3 k\u1ebft qu\u1ea3 v\xe0 m\xecnh mu\u1ed1n t\xe1ch ra c\xf3 th\u1ec3 t\xe1i s\u1eed d\u1ee5ng l\u1ea1i kh\xf4ng ho\u1ea1t \u0111\u1ed9ng.\\n\\nM\xecnh s\u1ebd ki\u1ec3m tra `props` c\u1ee7a `CustomInput` xem c\xf3 g\xec b\u1ea5t th\u01b0\u1eddng kh\xf4ng nh\xe9 =)))\\n\\n![props](https://res.cloudinary.com/hunghg255/image/upload/v1679201545/blog/Screenshot_2023-03-19_at_11.52.18_byltfn.png)\\n\\n:::note\\nNh\u01b0 ta th\u1ea5y `props` c\u1ee7a `CustomInput` l\xe0 m\u1ed9t object ch\u1ee9a `id`, `value`, `onChange`. T\u1ee9c l\xe0 khi ta \u0111\u1eb7t Input ngay b\xean trong `Form.Item` th\xec n\xf3 t\u1ef1 \u0111\u1ed9ng pass props \u0111\xf3 v\xe0o cho `Input` v\xec v\u1eady ta s\u1ebd l\u1ea5y \u0111\u01b0\u1ee3c value c\u1ee7a Input.\\n\\nKhi m\xecnh t\xe1ch ra th\xe0nh m\u1ed9t component \u0111\u1ec3 t\xe1i s\u1eed d\u1ee5ng th\xec `value` v\xe0 `onChange` s\u1ebd kh\xf4ng \u0111\u01b0\u1ee3c pass v\xe0o Input n\u1eefa n\xean ta s\u1ebd kh\xf4ng l\u1ea5y \u0111\u01b0\u1ee3c value c\u1ee7a Input\\n:::\\n\\nOk. v\u1eady m\xecnh s\u1ebd th\u1eed fix b\u1eb1ng c\xe1ch pass `value` v\xe0 `onChange` v\xe0o Input xem sao.\\n\\n![fix](https://res.cloudinary.com/hunghg255/image/upload/v1679202119/blog/Screenshot_2023-03-19_at_12.01.50_lk5yyg.png)\\n\\nOh. Hihi k\u1ebft qu\u1ea3 nh\u01b0 mong \u0111\u1ee3i\\n\\n:::note\\nK\u1ebft lu\u1eadn: Khi ta mu\u1ed1n truy\u1ec1n value t\u1eeb component b\u1ea5t k\xec l\xean `Form.Item` ta ch\u1ec9 c\u1ea7n d\xf9ng h\xe0m `onChange` t\u1eeb `Form.Item` c\xe1i m\xe0 \u0111\u01b0\u1ee3c truy\u1ec1n xu\u1ed1ng props khi \u0111\u1eb7t component trong `Form.Item`\\n:::\\n\\n## 2. C\u01a1 ch\u1ebf ho\u1ea1t \u0111\u1ed9ng `dependencies`, `shouldUpdate` v\xe0 `useWatch`\\n\\n### a. Dependencies\\n\\nM\xecnh c\xf3 m\u1ed9t v\xed d\u1ee5 \u0111\u01a1n gi\u1ea3n nh\u01b0 sau: c\xf3 3 select g\u1ed3m t\u1ec9nh, huy\u1ec7n, x\xe3.\\nY\xeau c\u1ea7u: Khi ch\u1ecdn t\u1ec9nh th\xec s\u1ebd t\u1ea3i danh s\xe1ch huy\u1ec7n, khi ch\u1ecdn huy\u1ec7n th\xec s\u1ebd t\u1ea3i danh s\xe1ch x\xe3.\\n\\nS\u1ebd c\xf3 nhi\u1ec1u c\xe1ch x\u1eed l\xfd b\xe0i to\xe1n n\xe0y. nh\u01b0 m\u1ed9t s\u1ed1 anh em s\u1ebd x\u1eed l\xfd b\u1eb1ng c\xe1ch d\xf9ng state l\u01b0u l\u1ea1i gi\xe1 tr\u1ecb t\u1ec9nh, huy\u1ec7n, x\xe3. c\xf3 thay \u0111\u1ed5i v\u1ec1 state th\xec l\u1eafng nghe trong `useEffect` \u0111\u1ec3 t\u1ea3i list huy\u1ec7n, x\xe3. C\xe1ch n\xe0y s\u1ebd \u1ea3nh h\u01b0\u1edfng \u0111\u1ebfn performance n\u1ebfu m\xe0 form c\xf3 nhi\u1ec1u field.\\n\\n\u1ede \u0111\xe2y m\xecnh s\u1ebd ch\u1ecdn c\xe1ch gi\u1ea3i quy\u1ebft b\u0103ng c\xe1ch d\xf9ng `dependencies`\\n\\n\u0110\u1ea7u ti\xean m\xecnh s\u1ebd t\u1ea1o custom select t\u1ec9nh, huy\u1ec7n, x\xe3:\\n\\nB\xecnh th\u01b0\u1eddng data s\u1ebd \u0111\u01b0\u1ee3c l\u1ea5y t\u1eeb API nh\u01b0ng trong v\xed d\u1ee5 n\xe0y m\xecnh s\u1ebd t\u1ea3i v\u1ec1 s\u1eb5n lu\xf4n.\\n\\n```tsx\\n// L\u1ea5y data c\xe1c t\u1ec9nh t\u1eeb API\\nconst SelectProvince = (props) => {\\n  const { value, onChange } = props;\\n\\n  return (\\n    <Select\\n      placeholder=\'Ch\u1ecdn T\u1ec9nh\'\\n      value={value}\\n      onChange={onChange}\\n      options={provinces.map((provinceItem) => {\\n        return {\\n          label: provinceItem.name_with_type,\\n          value: provinceItem.code,\\n        };\\n      })}\\n    />\\n  );\\n};\\n```\\n\\n```tsx\\n// L\u1ea5y data c\xe1c huy\u1ec7n ph\u1ee5 thu\u1ed9c v\xe0o t\u1ec9nh \u0111\xe3 ch\u1ecdn t\u1eeb API\\nconst SelectDistrict = (props) => {\\n  const { value, onChange, province } = props;\\n\\n  const districtsData = React.useMemo(() => {\\n    if (!province) return [];\\n\\n    return districts.filter((districtItem) => {\\n      return districtItem.parent_code === province;\\n    });\\n  }, [province]);\\n\\n  return (\\n    <Select\\n      placeholder=\'Ch\u1ecdn Huy\u1ec7n\'\\n      value={value}\\n      onChange={onChange}\\n      options={districtsData.map((districtItem) => {\\n        return {\\n          label: districtItem.name_with_type,\\n          value: districtItem.code,\\n        };\\n      })}\\n    />\\n  );\\n};\\n```\\n\\n```tsx\\n// L\u1ea5y data c\xe1c x\xe3 ph\u1ee5 thu\u1ed9c v\xe0o huy\u1ec7n \u0111\xe3 ch\u1ecdn t\u1eeb API\\nconst SelectWard = (props) => {\\n  const { value, onChange, district } = props;\\n\\n  const wardsData = React.useMemo(() => {\\n    if (!district) return [];\\n\\n    return wards.filter((wardItem) => {\\n      return wardItem.parent_code === district;\\n    });\\n  }, [district]);\\n\\n  return (\\n    <Select\\n      placeholder=\'Ch\u1ecdn X\xe3\'\\n      value={value}\\n      onChange={onChange}\\n      options={wardsData.map((wardItem) => {\\n        return {\\n          label: wardItem.name_with_type,\\n          value: wardItem.code,\\n        };\\n      })}\\n    />\\n  );\\n};\\n```\\n\\nFile App c\u1ee7a m\xecnh\\n\\n```tsx\\nconst App = () => {\\n  const onFinish = (values) => {\\n    console.log(\'Success:\', values);\\n  };\\n\\n  return (\\n    <Form onFinish={onFinish}>\\n      <Form.Item name=\'province\'>\\n        <SelectProvince />\\n      </Form.Item>\\n\\n      <Form.Item name=\'district\'>\\n        <SelectDistrict />\\n      </Form.Item>\\n\\n      <Form.Item name=\'ward\'>\\n        <SelectWard />\\n      </Form.Item>\\n\\n      <Button type=\'primary\' htmlType=\'submit\'>\\n        Submit\\n      </Button>\\n    </Form>\\n  );\\n};\\n```\\n\\nK\u1ebft qu\u1ea3:\\n\\n![demo4](https://res.cloudinary.com/hunghg255/image/upload/v1679220579/blog/Screenshot_2023-03-19_at_17.09.29_lqob6e.png)\\n\\nHi\u1ec7n t\u1ea1i th\xec b\u1ea1n \u0111\xe3 th\u1ea5y l\xe0 ch\u01b0a th\u1ec3 ch\u1ecdn \u0111\u01b0\u1ee3c huy\u1ec7n v\xe0 x\xe3. gi\u1edd m\xecnh s\u1ebd th\xeam `dependencies` \u0111\u1ec3 m\u1ed7i khi ch\u1ecdn xong t\u1ec9nh th\xec huy\u1ec7n s\u1ebd update l\u1ea1i\\n\\n```tsx\\n<Form.Item dependencies={[\'province\']} noStyle>\\n  {(props) => {\\n    return (\\n      <Form.Item name=\'district\'>\\n        <SelectDistrict province={props.getFieldValue(\'province\')} />\\n      </Form.Item>\\n    );\\n  }}\\n</Form.Item>\\n```\\n\\n```tsx\\n<Form.Item dependencies={[\'district\']} noStyle>\\n  {(props) => {\\n    return (\\n      <Form.Item name=\'ward\'>\\n        <SelectWard district={props.getFieldValue(\'district\')} />\\n      </Form.Item>\\n    );\\n  }}\\n</Form.Item>\\n```\\n\\nM\xecnh s\u1ebd wrap b\u1eb1ng 1 `Form.Item` n\u1eefa v\xe0 th\xeam `dependencies` l\xe0 m\u1ea3ng name c\u1ee7a item m\xe0 m\xecnh s\u1ebd mu\u1ed1n xem s\u1ef1 thay \u0111\u1ed5i. Log props \u1edf tr\xean ra th\xec m\xecnh s\u1ebd th\u1ea5y \u0111\u01b0\u1ee3c c\xe1c method c\u1ee7a form instance\\n\\n![demo](https://res.cloudinary.com/hunghg255/image/upload/v1679221251/blog/Screenshot_2023-03-19_at_17.20.43_uj4n9d.png)\\n\\nV\u1edbi `SelectDistrict` m\xecnh c\u1ea7n truy\u1ec1n th\xeam prop `province`\\n\\nV\u1edbi `SelectWard` m\xecnh c\u1ea7n truy\u1ec1n th\xeam prop `district`\\n\\n\u0110\xe2y l\xe0 k\u1ebft qu\u1ea3 \u0111\u1ea1t \u0111\u01b0\u1ee3c:\\n\\n<Stackblitz name={\'react-ts-3nasfc\'} />\\n\\n:::danger\\nM\u1ed9t \u0111i\u1ec1u n\u1eefa l\xe0 m\xecnh c\u1ea7n l\xe0m l\xe0 reset field \u0111\xe3 ch\u1ecdn khi m\xecnh thay \u0111\u1ed5i t\u1ec9nh ho\u1eb7c huy\u1ec7n kh\xe1c =))))\\nB\u1ea1n c\xf3 th\u1ec3 gi\xfap m\xecnh l\xe0m c\xe1i n\xe0y \u0111\xfang kh\xf4ng xD\\n:::\\n\\n### b. shouldUpdate\\n\\n```tsx\\n<Form.Item shouldUpdate noStyle>\\n  {(props) => {\\n    return (\\n      <Form.Item name=\'district\'>\\n        <SelectDistrict province={props.getFieldValue(\'province\')} />\\n      </Form.Item>\\n    );\\n  }}\\n</Form.Item>\\n```\\n\\n```tsx\\n<Form.Item shouldUpdate noStyle>\\n  {(props) => {\\n    return (\\n      <Form.Item name=\'ward\'>\\n        <SelectWard district={props.getFieldValue(\'district\')} />\\n      </Form.Item>\\n    );\\n  }}\\n</Form.Item>\\n```\\n\\n:::tip\\nV\u1edbi `shouldUpdate` th\xec c\u0169ng s\u1ebd t\u01b0\u01a1ng t\u1ef1 nh\u01b0 `dependencies` nh\u01b0ng n\u1ebfu \u0111\u1ec3 `shouldUpdate` l\xe0 true th\xec m\u1ed7i khi field n\xe0o trong form thay \u0111\u1ed5i th\xec component c\u1ee7a m\xecnh s\u1ebd re-render l\u1ea1i,\\n\u0111\u1ec3 tr\xe1nh re-render th\xec m\xecnh s\u1ebd truy\u1ec1n v\xe0o 1 callback function \u0111\u1ec3 ki\u1ec3m tra field n\xe0o m\xecnh mu\u1ed1n ki\u1ec3m tra s\u1ef1 thay \u0111\u1ed5i\\n:::\\n\\n```tsx\\n<Form.Item\\n  shouldUpdate={(prevValue, nextValue) => prevValue.province !== nextValue.province}\\n  noStyle\\n>\\n  {(props) => {\\n    return (\\n      <Form.Item name=\'district\'>\\n        <SelectDistrict province={props.getFieldValue(\'province\')} />\\n      </Form.Item>\\n    );\\n  }}\\n</Form.Item>\\n```\\n\\n```tsx\\n<Form.Item\\n  shouldUpdate={(prevValue, nextValue) => prevValue.district !== nextValue.district}\\n  noStyle\\n>\\n  {(props) => {\\n    return (\\n      <Form.Item name=\'ward\'>\\n        <SelectWard district={props.getFieldValue(\'district\')} />\\n      </Form.Item>\\n    );\\n  }}\\n</Form.Item>\\n```\\n\\nK\u1ebft qu\u1ea3 c\u0169ng t\u01b0\u01a1ng t\u1ef1 nh\u01b0 d\xf9ng `dependencies`\\n\\n<Stackblitz name={\'react-ts-2nfddq\'} />\\n\\n### c. useWatch\\n\\n`useWatch` l\xe0 m\u1ed9t hook \u0111\u01b0\u1ee3c cung c\u1ea5p b\u1edbi form antd, d\xf9ng \u0111\u1ec3 l\u1eafng nghe nh\u1eefng field m\xe0 c\xf3 thay \u0111\u1ed5i\\n\\nM\xecnh s\u1ebd update l\u1ea1i 2 component select c\u1ee7a m\xecnh nh\u01b0 sau: Thay v\xec truy\u1ec1n t\u1eeb props xu\u1ed1ng th\xec m\xecnh d\xf9ng `useWatch` \u0111\u1ec3 l\u1ea5y data m\u1edbi nh\u1ea5t khi c\xf3 thay \u0111\u1ed5i\\n\\n```tsx\\nconst SelectDistrict = (props) => {\\n  const { value, onChange } = props;\\n  const province = Form.useWatch([\'province\']);\\n\\n  ...\\n};\\n```\\n\\n```tsx\\nconst SelectWard = (props) => {\\n  const { value, onChange } = props;\\n  const province = Form.useWatch([\'district\']);\\n\\n  ...\\n};\\n```\\n\\nK\u1ebft qu\u1ea3 v\u1eabn nh\u01b0 m\xecnh mong \u0111\u1ee3i:\\n\\n<Stackblitz name={\'react-ts-xdx9id\'} />"},{"id":"/build-tools-frontend-2023","metadata":{"permalink":"/blog/build-tools-frontend-2023","editUrl":"https://github.com/hunghg255/web-totals/tree/main/blog/build-tools-frontend-2023.md","source":"@site/blog/build-tools-frontend-2023.md","title":"The Most Popular Build Tools for Front-end Developers in 2023","description":"Build tools are software applications that automate the process of building, testing, and deploying front-end code, helping developers to streamline their workflows and ensure consistent, high-quality results. In this article, we will explore some of the most popular build tools for front-end developers and discuss their key features and benefits.","date":"2023-03-19T10:54:37.000Z","formattedDate":"March 19, 2023","tags":[{"label":"Frontend","permalink":"/blog/tags/frontend"},{"label":"Build tools","permalink":"/blog/tags/build-tools"},{"label":"2023","permalink":"/blog/tags/2023"}],"readingTime":2.225,"hasTruncateMarker":true,"authors":[{"name":"Gia Hung","title":"Creator of Web totals","url":"https://github.com/hunghg255","email":"giahung197bg@gmail.com","imageURL":"https://res.cloudinary.com/hunghg255/image/upload/v1654956015/Screen_Shot_2022-06-07_at_11.25.34_bpnymt.png","key":"hunghg"}],"frontMatter":{"title":"The Most Popular Build Tools for Front-end Developers in 2023","authors":"hunghg","tags":["Frontend","Build tools","2023"],"image":"https://res.cloudinary.com/hunghg255/image/upload/v1679049199/blog/Build-Tools-for-Front-end-Developers_kbidno.png"},"unlisted":false,"prevItem":{"title":"X\u1eed l\xfd form v\u1edbi Ant Design (Ph\u1ea7n 1)","permalink":"/blog/handle-form-antd-part-1"}},"content":"Build tools are software applications that automate the process of building, testing, and deploying front-end code, helping developers to streamline their workflows and ensure consistent, high-quality results. In this article, we will explore some of the most popular build tools for front-end developers and discuss their key features and benefits.\\n\\n\x3c!--truncate--\x3e\\n\\n![Build tools 2023](https://res.cloudinary.com/hunghg255/image/upload/v1679049199/blog/Build-Tools-for-Front-end-Developers_kbidno.png)\\n\\nSo, what are build tools, exactly? Well, they\'re a set of tools that help you automate repetitive tasks, optimize your code, and improve your workflow. There are three main categories of build tools: <b>task runners</b>, <b>bundlers</b>, and <b>compilers</b>.\\n\\nTask runners are tools that automate repetitive tasks such as testing, linting, and minifying code. Bundlers allow developers to bundle multiple files into one file, reducing load times and improving performance. Compilers enable developers to write code in one language and compile it into another, such as using TypeScript to write JavaScript code.\\n\\nUsing build tools has several benefits to improve the development workflow, including reducing development time, improving code quality, and streamlining the deployment process.\\n\\nBy automating repetitive tasks, optimizing code, and providing real-time feedback on errors and code quality, build tools help improve the overall developer experience and make development less stressful.\\n\\nLet\'s look at the currently most popular build tools that front-end developers are using:\\n\\n| Rank | Tool                                                                                                            | Description                                                                                                                                                                                          | Stars                                                                                 |\\n| ---- | --------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------- |\\n| 1    | [Vite](https://github.com/vitejs/vite)                                                                          | Next generation frontend tooling. It\'s fast!                                                                                                                                                         | ![npm](https://img.shields.io/npm/dw/vite?color=white&label=%20&style=flat-square)    |\\n| 2    | [Turbo](https://github.com/vercel/turbo)                                                                        | Incremental bundler and build system optimized for JavaScript and TypeScript, written in Rust \u2013 including Turbopack and Turborepo.                                                                   | ![npm](https://img.shields.io/npm/dw/turbo?color=white&label=%20&style=flat-square)   |\\n| 3    | [swc](https://github.com/swc-project/swc)                                                                       | SWC is a super-fast TypeScript / JavaScript compiler written in Rust.                                                                                                                                | ![npm](https://img.shields.io/npm/dw/swc?color=white&label=%20&style=flat-square)     |\\n| 4    | [Nx](https://github.com/nrwl/nx)                                                                                | Nx is a next generation build system with first class monorepo support and powerful integrations.                                                                                                    | ![npm](https://img.shields.io/npm/dw/nx?color=white&label=%20&style=flat-square)      |\\n| 5    | [Rome](https://github.com/rome/tools)                                                                           | Rome is a formatter, linter, bundler, and more for JavaScript, TypeScript, JSON, HTML, Markdown, and CSS.                                                                                            | ![npm](https://img.shields.io/npm/dw/rome?color=white&label=%20&style=flat-square)    |\\n| 6    | [esbuild](https://github.com/evanw/esbuild)                                                                     | An extremely fast bundler for the web                                                                                                                                                                | ![npm](https://img.shields.io/npm/dw/esbuild?color=white&label=%20&style=flat-square) |\\n| 7    | [Lerna](https://github.com/lerna/lerna)                                                                         | Lerna is a fast, modern build system for managing and publishing multiple JavaScript/TypeScript packages from the same repository.                                                                   | ![npm](https://img.shields.io/npm/dw/lerna?color=white&label=%20&style=flat-square)   |\\n| 8    | [Webpack](https://github.com/webpack/webpack)                                                                   | Webpack is a module bundler. Its main purpose is to bundle JavaScript files for usage in a browser, yet it is also capable of transforming, bundling, or packaging just about any resource or asset. | ![npm](https://img.shields.io/npm/dw/webpack?color=white&label=%20&style=flat-square) |\\n| 9    | [Parcel](https://stackdiary.com/build-tools-for-web-development/#:~:text=9-,Parcel,-The%20zero%20configuration) | The zero configuration build tool for the web.                                                                                                                                                       | ![npm](https://img.shields.io/npm/dw/parcel?color=white&label=%20&style=flat-square)  |\\n| 10   | [Rollup](https://github.com/rollup/rollup)                                                                      | Next-generation ES module bundler                                                                                                                                                                    | ![npm](https://img.shields.io/npm/dw/rollup?color=white&label=%20&style=flat-square)  |"}]}')}}]);