---
title: HTML Input Type
authors: hunghg
tags: [Html]
image: https://upload.wikimedia.org/wikipedia/commons/thumb/8/80/HTML5_logo_resized.svg/1200px-HTML5_logo_resized.svg.png
---

## All input type html!

<!--truncate-->

```jsx live
function App() {
  return (
    <div>
      <div>
        Button: <input type='button' value='Click Me!' />
      </div>
      <div>
        Checkbox: <input type='checkbox' />
      </div>
      <div>
        Color: <input type='color' />
      </div>
      <div>
        Date: <input type='date' />
      </div>
      <div>
        Date Local: <input type='datetime-local' />
      </div>
      <div>
        Email: <input type='email' />
      </div>
      <div>
        File: <input type='file' />
      </div>
      <div>
        Hidden: <input type='hidden' />
      </div>
      <div>
        Image: <input type='image' />
      </div>
      <div>
        Number: <input type='number' />
      </div>
      <div>
        Number + decimal: <input type='number' inputmode='decimal' />
      </div>
      <div>
        Number + numeric: <input type='number' inputmode='numeric' />
      </div>
      <div>
        Password: <input type='password' />
      </div>
      <div>
        Radio: <input type='radio' />
      </div>
      <div>
        Range: <input type='range' />
      </div>
      <div>
        Reset: <input type='reset' />
      </div>
      <div>
        Search: <input type='search' />
      </div>
      <div>
        Submit: <input type='submit' />
      </div>
      <div>
        Tel: <input type='tel' />
      </div>
      <div>
        Text: <input type='text' />
      </div>
      <div>
        Time: <input type='time' />
      </div>
      <div>
        Url: <input type='url' />
      </div>
      <div>
        Week: <input type='week' />
      </div>
      <div>
        Month: <input type='month' />
      </div>
    </div>
  );
}
```

:::note Reference
1: https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input

2: https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/inputmode
:::
