#!/bin/bash
##===----------------------------------------------------------------------===##
##
## This source file is part of the SwiftNIO open source project
##
## Copyright (c) 2017-2018 Apple Inc. and the SwiftNIO project authors
## Licensed under Apache License v2.0
##
## See LICENSE.txt for license information
## See CONTRIBUTORS.txt for the list of SwiftNIO project authors
##
## SPDX-License-Identifier: Apache-2.0
##
##===----------------------------------------------------------------------===##

#set -eux
here="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
CONTRIBUTORS=""
BRANCH="main"

embed_newline()
{
   local p="$1"
   shift
   for i in "$@"
   do
      p="$p\n$i"         # Append
   done
   echo -e "$p"          # Use -e
}

get_contributors() {
    PROJECT=$1
    TEMP_DIR=$(mktemp -d)

    git clone -b "$BRANCH" https://github.com/hummingbird-project/"$PROJECT" "$TEMP_DIR"
    cp .mailmap "$TEMP_DIR"
    CONTRIBUTORS=$(embed_newline "$CONTRIBUTORS" "$(cd "$TEMP_DIR" && git shortlog -es | cut -f2 | sed -e 's/^/- /')")
    rm -rf "$TEMP_DIR"
}

get_contributors hummingbird
get_contributors hummingbird-auth
get_contributors hummingbird-fluent
get_contributors hummingbird-lambda
get_contributors hummingbird-mustache
get_contributors hummingbird-redis
get_contributors hummingbird-postgres
get_contributors hummingbird-websocket
get_contributors hummingbird-examples


CONTRIBUTORS=$(awk '!a[$0]++' <<< """$CONTRIBUTORS""")

cat > "$here/../CONTRIBUTORS.txt" <<- EOF
For the purpose of tracking copyright, this is the list of individuals and
organizations who have contributed source code to Hummingbird and its
related projects.

For employees of an organization/company where the copyright of work done
by employees of that company is held by the company itself, only the company
needs to be listed here.

## COPYRIGHT HOLDERS

### Contributors
$CONTRIBUTORS

**Updating this list**

Please do not edit this file manually. It is generated using \`./scripts/generate-contributors-list.sh\`. If a name is misspelled or appearing multiple times: add an entry in \`./.mailmap\`
EOF
