/*
Copyright © 2020 NAME HERE <EMAIL ADDRESS>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package cmd

import (
	"fmt"

	"github.com/huhu/golang/crawler/pkg/db"

	"github.com/spf13/cobra"
)

var (
	initdb bool
	dbPath string
)

// dbCmd represents the db command
var dbCmd = &cobra.Command{
	Use:   "db",
	Short: "",
	Long:  ``,
	Run: func(cmd *cobra.Command, args []string) {
		fmt.Println("init db ")
		if initdb {
			db.GetDB(dbPath).InitDB()
		}
	},
}

func init() {
	rootCmd.AddCommand(dbCmd)

	// Here you will define your flags and configuration settings.

	// Cobra supports Persistent Flags which will work for this command
	// and all subcommands, e.g.:
	dbCmd.PersistentFlags().StringVarP(&dbPath, "dbpath", "dp", "./test.db", "The path to db.")

	// Cobra supports local flags which will only run when this command
	// is called directly, e.g.:
	dbCmd.Flags().BoolVarP(&initdb, "init", "i", false, "Init db.")

}
