import type { SVGProps } from 'react'

export function Signature(props: SVGProps<SVGSVGElement>) {
  return (
    <svg
      version="1.0"
      xmlns="http://www.w3.org/2000/svg"
      width="1242"
      height="676"
      viewBox="0 0 1242 676"
      {...props}
    >
      <g transform="translate(0,676) scale(0.1,-0.1)" fill="currentColor" stroke="none">
        <path
          d="M3607 6714 c-3 -4 -64 -6 -134 -5 -160 1 -400 -28 -573 -68 -25 -6
-83 -18 -130 -26 -47 -8 -101 -19 -120 -25 -19 -5 -47 -10 -61 -10 -15 0 -52
-13 -84 -30 -31 -16 -78 -36 -104 -44 -27 -8 -57 -19 -67 -24 -11 -5 -32 -16
-49 -23 -16 -8 -41 -24 -55 -37 -14 -13 -47 -35 -74 -49 -27 -13 -77 -47 -112
-74 -35 -27 -66 -49 -70 -49 -9 0 -52 -45 -88 -92 -16 -21 -35 -38 -42 -38 -8
0 -14 -6 -14 -13 0 -7 -11 -24 -24 -38 -32 -35 -57 -154 -44 -211 5 -23 8 -48
7 -57 -5 -30 31 -180 48 -206 7 -11 13 -30 13 -43 0 -13 14 -50 30 -84 16 -33
30 -67 30 -77 0 -15 5 -26 37 -86 6 -11 37 -73 68 -138 32 -66 73 -135 92
-155 35 -38 127 -214 139 -267 4 -16 23 -51 43 -77 20 -26 44 -59 54 -73 10
-14 22 -25 27 -25 17 0 10 94 -10 139 -11 24 -20 57 -20 75 0 24 -8 36 -36 55
-29 20 -35 30 -33 55 1 17 -3 43 -9 58 -6 15 -18 53 -27 85 -19 70 -53 149
-77 182 -10 13 -18 35 -18 49 0 14 -10 36 -21 48 -12 13 -28 48 -35 78 -8 31
-21 82 -29 113 -7 32 -23 76 -34 98 -30 61 -41 113 -45 200 -3 69 0 88 22 135
14 30 36 70 51 89 26 35 111 104 162 132 16 9 49 30 72 45 104 71 180 106 287
132 47 11 120 30 163 41 43 12 82 19 86 17 4 -3 17 1 27 9 10 8 37 15 59 15
21 0 57 6 80 14 173 61 594 95 745 60 30 -7 93 -18 140 -24 47 -7 105 -21 129
-31 24 -11 52 -19 61 -19 10 0 38 -8 62 -19 102 -43 144 -62 160 -71 10 -6 25
-10 34 -10 9 0 33 -16 52 -36 19 -19 40 -33 47 -31 6 3 19 -2 27 -11 8 -10 54
-41 101 -70 47 -30 87 -61 89 -70 3 -10 18 -24 34 -32 38 -20 274 -265 274
-285 0 -17 99 -97 111 -89 10 6 12 57 3 67 -6 6 -43 105 -64 172 -5 17 -41 61
-79 98 -39 37 -73 76 -76 85 -8 20 -196 191 -233 211 -14 7 -37 24 -51 37 -14
13 -30 24 -34 24 -5 0 -27 16 -50 35 -53 45 -317 175 -356 175 -20 0 -70 15
-116 35 -16 7 -50 16 -75 20 -25 4 -67 16 -95 27 -27 11 -61 17 -74 15 -14 -3
-45 1 -70 9 -25 8 -46 14 -47 14 0 0 -3 -3 -7 -6z"
        />
        <path
          d="M6995 6166 c-19 -19 -25 -36 -26 -68 0 -79 -7 -126 -22 -160 -23 -50
-30 -78 -32 -133 -4 -78 -13 -123 -45 -216 -15 -48 -33 -111 -39 -140 -5 -30
-28 -92 -50 -139 -23 -46 -41 -92 -41 -101 0 -9 -6 -22 -14 -28 -8 -7 -17 -24
-21 -39 -11 -45 -54 -129 -68 -135 -8 -3 -18 -23 -22 -44 -13 -74 -73 -225
-136 -345 -5 -10 -9 -23 -9 -29 0 -6 -20 -53 -45 -105 -25 -51 -45 -98 -45
-103 0 -6 -4 -19 -9 -29 -5 -9 -12 -24 -15 -32 -3 -8 -19 -37 -35 -65 -16 -27
-30 -56 -30 -63 -1 -14 -41 -106 -67 -154 -8 -14 -14 -34 -14 -44 0 -10 -16
-50 -35 -90 l-35 -71 -82 -28 c-46 -15 -112 -29 -148 -32 -91 -6 -103 -9 -133
-37 -36 -34 -37 -87 -2 -122 14 -14 25 -28 25 -33 0 -8 81 -51 97 -51 5 0 22
-14 39 -31 20 -21 28 -38 26 -57 -6 -51 -35 -137 -67 -202 -18 -36 -39 -87
-45 -115 -7 -27 -21 -66 -30 -85 -10 -19 -25 -61 -34 -92 -9 -32 -21 -58 -26
-58 -16 0 -12 -93 5 -117 8 -11 35 -26 61 -32 l47 -12 49 48 c77 75 147 205
116 215 -15 5 14 55 44 76 25 18 23 31 -7 42 -32 12 -33 49 -2 87 13 15 31 50
41 77 10 27 31 62 45 78 l26 30 52 -26 c28 -14 59 -26 69 -27 11 0 33 -9 49
-19 17 -11 46 -28 65 -38 19 -10 67 -36 105 -59 39 -22 87 -48 108 -58 22 -10
41 -24 44 -31 2 -7 10 -11 17 -8 15 6 113 -70 201 -155 96 -93 95 -91 101
-172 4 -40 9 -82 13 -94 14 -38 -2 -115 -23 -115 -7 0 -31 -9 -54 -20 -22 -11
-47 -20 -55 -20 -7 0 -22 -7 -33 -15 -10 -8 -33 -15 -50 -15 -17 0 -41 -9 -54
-20 -13 -11 -31 -20 -40 -20 -10 0 -39 -8 -66 -19 -160 -62 -195 -74 -216 -76
-14 -2 -45 -12 -71 -24 -25 -12 -60 -21 -77 -21 -17 0 -43 -9 -58 -19 -15 -11
-44 -22 -64 -25 -20 -4 -50 -13 -65 -21 -15 -8 -39 -15 -51 -15 -13 0 -36 -8
-50 -19 -15 -10 -44 -21 -66 -25 -21 -4 -46 -11 -55 -16 -31 -18 -94 -40 -112
-40 -11 0 -36 -9 -56 -20 -21 -11 -51 -20 -68 -20 -17 0 -40 -7 -52 -15 -11
-8 -42 -22 -69 -30 -27 -9 -58 -20 -69 -25 -43 -18 -122 -42 -155 -47 -19 -3
-39 -12 -43 -19 -5 -8 -25 -14 -49 -14 -22 0 -57 -9 -77 -19 -45 -24 -127 -51
-156 -51 -11 0 -30 -7 -42 -15 -12 -8 -45 -20 -75 -26 -29 -6 -57 -15 -63 -19
-5 -4 -26 -11 -45 -14 -73 -14 -135 -30 -145 -37 -26 -18 -152 -62 -198 -69
-60 -9 -117 -29 -189 -66 -39 -20 -68 -26 -127 -28 -66 -2 -83 -7 -125 -34
-38 -24 -61 -32 -97 -32 -26 0 -50 -4 -54 -9 -3 -6 -25 -13 -50 -17 -24 -3
-50 -12 -56 -20 -6 -8 -26 -14 -43 -14 -17 0 -44 -7 -60 -15 -15 -8 -36 -15
-45 -15 -9 0 -21 -4 -27 -9 -11 -11 -131 -41 -159 -40 -23 1 -76 -16 -119 -39
-30 -15 -50 -21 -176 -47 -72 -15 -140 -38 -173 -59 -12 -8 -58 -22 -102 -31
-44 -10 -91 -23 -105 -29 -14 -7 -52 -18 -85 -25 -33 -7 -80 -22 -105 -33 -24
-11 -62 -22 -84 -24 -22 -2 -44 -8 -50 -14 -5 -5 -29 -10 -53 -10 -24 0 -43
-4 -43 -10 0 -5 -6 -10 -13 -10 -7 0 -32 -9 -55 -20 -22 -11 -46 -20 -52 -20
-5 0 -29 -9 -53 -19 -48 -22 -124 -41 -160 -41 -14 0 -30 -7 -37 -15 -7 -8
-27 -15 -44 -15 -37 -1 -112 -21 -142 -37 -12 -7 -24 -10 -27 -7 -3 3 -27 -2
-53 -11 -26 -9 -53 -14 -60 -11 -7 3 -22 -4 -34 -14 -13 -12 -36 -18 -63 -18
-25 1 -58 -8 -82 -21 -22 -11 -53 -21 -70 -21 -16 -1 -41 -7 -55 -15 -14 -8
-46 -14 -72 -15 -43 0 -200 -43 -273 -74 -72 -32 -88 -36 -131 -36 -24 0 -61
-7 -81 -15 -19 -8 -56 -15 -82 -15 -26 0 -51 -4 -57 -10 -5 -5 -41 -16 -79
-24 -39 -8 -84 -22 -100 -30 -17 -8 -67 -21 -111 -29 -114 -20 -157 -55 -156
-129 1 -43 29 -74 97 -107 22 -10 50 -31 62 -45 13 -14 29 -26 36 -26 8 0 33
-14 55 -30 23 -16 46 -30 51 -30 5 0 14 -7 21 -15 19 -22 64 -18 93 9 31 28
130 42 148 19 6 -7 16 -9 23 -5 6 4 133 7 281 8 265 0 311 3 487 25 48 7 96 9
107 6 12 -3 28 1 36 10 10 9 25 13 40 9 13 -3 35 -2 49 4 14 5 54 12 88 15 35
3 86 10 113 15 70 15 101 20 170 26 33 3 65 10 71 15 6 5 22 8 35 8 13 -1 69
8 124 20 55 12 106 21 115 19 8 -1 26 2 39 6 13 5 40 10 60 12 87 9 115 14
125 24 5 5 25 10 42 10 18 0 35 4 38 9 3 4 34 11 68 14 151 16 216 26 262 42
27 9 63 15 80 12 17 -2 44 2 60 10 16 8 40 13 55 10 14 -3 34 -1 45 5 10 6 41
12 68 14 28 1 56 8 64 15 8 6 27 9 43 6 19 -4 44 1 69 13 27 13 54 18 83 16
24 -3 52 0 63 6 10 6 42 12 70 13 56 3 159 22 191 35 36 14 214 42 225 35 6
-4 26 0 44 9 21 10 46 14 64 10 17 -3 40 0 53 7 13 7 42 14 64 16 22 1 55 5
74 8 19 2 42 0 51 -5 13 -7 21 -5 30 5 7 8 25 15 41 15 15 0 32 6 36 13 14 23
302 61 321 43 3 -4 -2 -46 -11 -94 -29 -152 -32 -223 -12 -276 26 -67 54 -86
130 -86 56 0 63 -2 73 -25 7 -16 9 -53 5 -103 -5 -65 -3 -81 11 -95 30 -30 51
-21 77 35 13 29 23 55 22 59 -2 7 29 83 68 165 10 22 19 47 19 55 0 8 4 19 8
24 5 6 21 51 36 100 16 50 36 108 46 130 10 22 24 60 30 85 8 32 24 57 58 88
45 43 94 74 109 70 11 -2 64 11 83 21 8 4 44 9 80 10 35 1 76 9 92 17 15 8 47
14 71 14 24 0 78 9 120 19 42 11 84 20 94 20 21 -1 171 17 263 31 36 6 83 11
105 13 22 1 58 8 80 14 22 7 101 19 175 28 74 9 164 21 200 26 36 6 85 12 110
14 25 3 63 7 85 10 22 3 60 8 85 11 25 3 59 9 75 14 17 4 68 11 115 14 47 4
99 9 115 12 17 3 54 7 84 9 30 3 70 10 90 17 20 6 44 11 54 9 10 -1 59 3 110
10 51 6 106 13 122 14 110 8 207 17 250 25 28 5 88 11 135 14 47 2 108 9 135
15 28 6 91 13 140 15 50 3 144 12 210 20 65 9 155 16 198 16 43 0 87 5 98 11
11 6 62 13 112 16 240 14 404 27 410 33 1 1 38 4 82 6 44 2 94 6 110 8 190 25
1041 41 1305 24 69 -5 157 -10 195 -12 167 -10 325 -25 337 -33 7 -4 27 -9 43
-10 49 -2 305 -76 305 -88 0 -16 44 -53 76 -65 16 -6 52 -13 79 -16 65 -5 86
11 95 73 7 45 6 49 -27 79 -39 36 -132 84 -162 84 -11 0 -22 4 -25 9 -3 5 -18
12 -33 15 -27 6 -67 24 -125 53 -14 7 -50 13 -80 13 -30 0 -59 5 -65 11 -7 7
-17 8 -28 1 -12 -6 -32 -5 -64 5 -66 21 -333 53 -496 60 -170 7 -911 6 -1039
-2 -50 -3 -118 -7 -151 -9 -33 -2 -112 -7 -175 -11 -63 -4 -135 -8 -160 -10
-25 -1 -45 -4 -45 -5 0 -2 -48 -4 -107 -5 -59 -2 -111 -5 -116 -8 -10 -7 -77
-13 -277 -27 -77 -5 -178 -15 -225 -21 -47 -5 -106 -10 -132 -9 -26 0 -55 -4
-65 -9 -19 -11 -140 -26 -338 -41 -66 -5 -136 -12 -155 -16 -19 -4 -57 -8 -85
-10 -141 -10 -180 -15 -216 -24 -22 -6 -44 -8 -49 -5 -11 7 -158 -12 -205 -26
-16 -4 -70 -11 -120 -14 -49 -3 -115 -10 -145 -15 -30 -5 -73 -9 -95 -9 -22 1
-74 -7 -115 -16 -41 -9 -133 -23 -205 -31 -71 -8 -141 -17 -155 -19 -14 -3
-77 -11 -140 -18 -64 -7 -122 -17 -128 -21 -7 -4 -36 -9 -65 -12 -73 -6 -87
-9 -130 -23 -20 -7 -43 -11 -50 -8 -6 2 -22 1 -34 -4 -12 -4 -59 -10 -105 -13
-46 -3 -110 -11 -143 -17 -33 -7 -78 -12 -100 -13 -37 -1 -40 1 -37 24 5 43 2
73 -7 84 -5 6 -12 29 -15 52 -8 45 -34 64 -118 86 -37 9 -54 9 -87 -2 -47 -15
-102 -66 -126 -116 -9 -19 -19 -34 -23 -34 -4 0 -25 -30 -47 -66 -65 -107 -80
-122 -132 -130 -54 -8 -69 6 -48 46 8 15 19 48 26 74 6 26 20 52 30 59 9 7 23
25 30 39 l12 27 40 -26 40 -25 19 23 c13 17 17 33 12 58 -4 27 0 39 19 60 35
38 43 77 17 91 -11 6 -24 9 -29 6 -5 -3 -11 10 -14 30 -7 41 -41 73 -79 74
-19 0 -35 -10 -55 -35 -15 -19 -34 -35 -40 -35 -7 0 -13 -4 -13 -9 0 -5 -20
-33 -45 -63 -25 -30 -45 -64 -45 -74 0 -17 -81 -160 -99 -174 -20 -17 -49 -71
-55 -104 -11 -56 -33 -86 -65 -86 -15 0 -35 -6 -46 -14 -19 -13 -65 -21 -163
-29 -23 -2 -53 -9 -65 -15 -12 -6 -48 -14 -79 -17 -32 -4 -60 -11 -64 -16 -3
-5 -10 -7 -15 -3 -5 3 -16 0 -25 -6 -9 -8 -30 -11 -58 -7 -31 5 -73 -2 -151
-23 -59 -16 -139 -32 -179 -36 -39 -3 -96 -14 -126 -24 -30 -10 -82 -21 -115
-25 -69 -7 -191 -25 -220 -32 -37 -10 -140 -24 -181 -27 -23 -1 -48 -7 -56
-13 -7 -7 -51 -16 -96 -22 -45 -6 -91 -15 -102 -21 -10 -5 -39 -10 -65 -10
-25 0 -91 -11 -147 -25 -56 -14 -122 -25 -148 -25 -26 0 -66 -7 -89 -15 -23
-8 -65 -17 -94 -21 -29 -4 -61 -13 -72 -19 -11 -7 -49 -13 -85 -14 -35 0 -78
-5 -95 -10 -16 -5 -52 -13 -80 -17 -27 -4 -57 -8 -65 -10 -25 -4 -152 -32
-192 -42 -20 -5 -52 -8 -71 -6 -20 3 -38 0 -42 -6 -3 -5 -16 -10 -28 -10 -21
0 -140 -30 -202 -51 -45 -15 -146 -28 -280 -34 -66 -3 -136 -8 -155 -11 -118
-18 -307 -20 -410 -6 -49 7 -75 6 -105 -4 -25 -8 -43 -10 -50 -4 -7 6 -14 7
-18 4 -3 -3 -40 -7 -82 -9 -43 -2 -82 -8 -88 -14 -19 -19 -44 -12 -77 20 -20
21 -37 29 -50 26 -11 -3 -23 0 -27 6 -11 19 35 44 94 52 32 4 66 14 75 22 9 8
21 13 25 10 14 -9 96 14 122 35 13 10 38 18 55 18 17 0 55 9 85 20 29 12 56
19 58 16 3 -2 35 7 71 20 37 13 74 24 82 24 9 0 33 9 55 20 22 11 47 20 56 20
9 0 39 6 65 14 101 30 173 46 292 67 67 11 125 25 127 30 6 8 71 29 110 34 11
2 37 10 57 19 21 9 50 16 65 16 15 0 41 7 57 15 15 8 35 15 43 15 9 0 30 8 47
19 17 10 65 26 106 36 41 9 104 26 140 36 36 10 74 19 84 19 10 0 34 7 54 16
21 9 51 23 69 30 17 8 39 14 50 14 10 0 31 7 47 15 15 8 40 15 55 15 15 0 37
7 49 16 13 9 44 18 68 20 25 3 55 11 67 19 12 8 41 17 65 21 23 4 45 11 48 15
3 5 16 9 29 9 14 0 41 9 60 20 20 11 40 18 45 15 8 -5 73 13 168 46 29 11 63
19 75 19 12 0 35 7 51 15 16 9 46 20 65 25 20 5 63 18 95 29 33 12 69 21 80
21 12 0 32 6 46 13 14 8 41 17 59 20 18 4 54 17 79 29 26 12 58 23 72 24 62 7
119 24 171 51 31 17 70 30 85 31 16 0 54 10 84 21 30 11 78 25 105 32 28 6 58
18 67 26 9 8 32 17 50 19 65 7 163 28 176 37 7 5 48 22 92 37 43 16 85 32 92
36 7 5 33 9 57 11 26 1 53 10 65 21 12 10 53 24 91 31 39 8 90 22 115 31 25
10 61 21 80 24 64 10 78 14 98 34 10 10 37 22 60 26 23 3 45 12 49 20 4 7 33
16 66 19 35 3 67 13 82 25 14 11 45 23 68 27 23 4 47 12 54 17 7 5 17 7 23 3
6 -4 22 1 36 9 13 9 41 18 62 20 20 2 56 13 79 24 23 12 49 22 58 22 9 0 33 9
55 20 22 11 50 20 63 20 14 0 30 7 37 15 7 8 25 15 39 15 15 0 36 7 47 15 10
8 33 15 51 15 17 0 34 4 38 9 3 6 25 13 49 16 24 4 59 17 77 28 19 12 41 22
49 22 35 1 100 17 106 26 3 5 12 9 20 9 8 0 33 9 54 19 22 10 62 24 90 31 27
7 53 16 56 21 3 5 16 9 30 9 13 0 32 4 42 9 34 17 147 51 162 47 8 -1 28 -8
44 -15 40 -16 64 -5 74 32 7 28 13 32 48 35 21 2 43 8 48 13 6 5 22 9 37 9 15
0 32 7 39 15 7 9 19 14 26 11 8 -3 26 1 41 8 76 38 122 56 142 56 12 0 34 6
49 14 15 7 45 17 66 20 22 4 51 16 64 27 14 10 40 19 58 19 34 0 71 13 113 39
13 8 31 16 40 17 33 3 156 39 159 46 2 5 12 8 22 8 10 0 34 9 52 19 18 11 50
23 71 26 20 4 40 11 43 17 3 5 14 6 25 3 11 -4 33 2 52 14 17 10 66 28 107 39
91 25 133 39 185 62 22 10 56 21 75 25 19 4 60 20 91 36 31 16 72 32 90 35 19
4 41 12 49 19 24 19 98 45 131 45 17 0 32 6 35 15 4 8 11 15 16 15 6 0 24 6
41 14 18 7 61 24 97 36 36 12 69 26 75 31 5 5 17 9 27 9 10 0 26 4 36 9 76 39
131 61 153 61 14 0 34 7 45 15 10 8 28 15 39 15 11 0 29 6 40 13 11 7 36 19
55 27 32 12 165 72 200 90 9 4 31 11 50 15 19 4 72 25 118 46 45 21 89 39 97
39 8 0 32 9 52 20 21 11 47 20 58 20 11 0 37 9 58 20 20 11 46 20 58 20 11 0
35 11 53 25 18 14 38 25 45 25 12 0 127 60 196 102 17 10 36 18 43 18 7 0 31
14 54 30 22 17 51 30 64 30 13 0 26 5 29 10 9 15 72 53 115 70 45 18 120 69
120 81 0 5 6 9 13 9 19 0 72 52 85 83 21 49 15 105 -15 147 -32 44 -88 80
-126 80 -14 0 -54 7 -89 15 -35 8 -77 14 -93 13 -34 -1 -122 8 -204 21 -31 5
-92 9 -135 10 -44 1 -84 5 -89 8 -6 3 -60 7 -121 8 -61 1 -169 9 -241 19 -209
27 -293 35 -415 41 -63 4 -130 10 -147 16 -18 5 -48 14 -66 19 -18 6 -43 10
-56 10 -12 0 -49 9 -82 20 -62 21 -206 53 -319 72 -36 5 -80 16 -97 24 -18 7
-39 11 -46 8 -7 -2 -27 0 -43 7 -16 6 -47 15 -69 20 -70 13 -189 49 -199 59
-6 6 -23 10 -38 10 -16 0 -36 4 -46 10 -80 44 -400 57 -502 20 -63 -23 -83
-54 -82 -125 5 -209 2 -390 -7 -417 -5 -18 -18 -60 -27 -93 -9 -33 -23 -67
-30 -75 -7 -8 -12 -29 -12 -46 1 -17 -6 -46 -16 -64 -9 -18 -16 -40 -16 -49 1
-23 -63 -170 -75 -175 -14 -5 -115 11 -140 23 -63 30 -141 50 -224 56 -100 8
-146 22 -173 52 -15 16 -16 29 -7 108 18 168 25 399 22 710 -4 464 -11 598
-32 707 -19 102 -42 318 -35 330 10 16 32 8 48 -17 13 -20 25 -25 58 -25 l41
0 -6 58 c-9 86 -29 123 -102 190 -54 50 -69 70 -79 109 -23 85 -37 102 -99
117 -21 5 -33 1 -52 -18z m5 -953 c-1 -32 -8 -89 -16 -128 -8 -38 -17 -83 -20
-100 -3 -16 -12 -44 -20 -62 -8 -18 -16 -55 -18 -83 -2 -28 -10 -57 -17 -66
-17 -21 -49 -112 -49 -141 0 -12 -4 -25 -10 -28 -5 -3 -10 -19 -10 -35 0 -16
-10 -45 -22 -66 -26 -45 -66 -153 -79 -214 -5 -25 -12 -53 -15 -62 -3 -12 0
-18 9 -18 21 0 44 31 51 70 3 20 15 43 26 53 11 9 23 35 26 57 4 22 13 45 20
51 8 6 14 18 14 27 0 8 10 29 23 46 40 52 87 157 87 192 0 18 6 37 14 41 8 4
14 17 13 28 -1 14 5 21 20 23 18 3 21 -2 21 -35 0 -21 2 -126 3 -233 2 -107
-1 -286 -5 -398 -10 -224 -9 -221 -77 -221 -200 -1 -411 -11 -428 -21 -12 -6
-50 -14 -86 -17 -57 -5 -68 -3 -79 13 -12 16 -11 23 10 53 12 20 30 59 40 86
9 28 19 52 23 55 4 3 13 25 20 50 17 56 19 61 30 80 5 8 21 40 34 70 14 30 57
122 96 203 39 81 71 151 71 155 0 4 12 24 26 45 14 21 36 68 49 105 23 68 45
121 92 222 14 30 32 76 39 102 8 26 19 50 24 53 6 3 10 17 10 31 0 13 9 29 20
36 11 7 20 18 20 25 0 7 5 13 10 13 6 0 10 -26 10 -57z m1295 -543 c3 -5 28
-10 55 -10 27 0 69 -6 92 -14 24 -7 72 -19 108 -27 36 -7 103 -28 150 -46 47
-18 93 -33 103 -33 10 0 52 -7 93 -16 42 -8 88 -17 102 -19 15 -3 54 -14 86
-25 55 -20 92 -26 186 -33 20 -1 56 -12 80 -24 77 -38 233 -76 315 -76 17 0
73 -4 125 -8 52 -5 138 -11 190 -14 52 -3 120 -9 150 -15 70 -12 196 -20 430
-26 228 -7 251 -8 273 -18 9 -5 27 -6 40 -3 12 4 49 1 82 -4 33 -6 74 -10 90
-10 17 0 41 -8 55 -19 l25 -19 -23 -24 c-12 -13 -52 -39 -88 -57 -36 -18 -85
-54 -112 -82 -28 -30 -73 -62 -112 -80 -36 -18 -76 -40 -90 -50 -14 -10 -65
-32 -112 -48 -48 -16 -103 -41 -124 -55 -20 -14 -45 -25 -55 -25 -10 0 -21 -5
-24 -10 -4 -6 -10 -8 -15 -5 -5 3 -17 -6 -26 -20 -9 -14 -26 -25 -39 -25 -12
0 -43 -11 -69 -25 -26 -14 -56 -25 -66 -25 -11 0 -35 -9 -55 -20 -20 -11 -47
-20 -61 -20 -13 0 -35 -6 -47 -14 -12 -8 -42 -17 -67 -20 -25 -4 -59 -15 -75
-26 -17 -11 -39 -20 -51 -20 -11 0 -42 -11 -70 -24 -27 -13 -58 -26 -69 -29
-42 -12 -93 -33 -107 -45 -9 -7 -35 -16 -59 -21 -52 -10 -134 -45 -143 -60 -4
-6 -17 -11 -29 -11 -24 0 -93 -22 -103 -33 -4 -4 -14 -7 -22 -7 -15 0 -59 -18
-125 -51 -22 -10 -48 -19 -58 -19 -17 0 -83 -25 -130 -50 -9 -5 -34 -12 -55
-15 -22 -4 -59 -17 -84 -30 -25 -12 -69 -30 -97 -40 -29 -9 -55 -21 -59 -26
-4 -6 -10 -6 -17 0 -8 6 -26 3 -52 -9 -56 -26 -266 -100 -283 -100 -7 0 -31
-9 -54 -20 -22 -11 -44 -17 -49 -14 -4 2 -23 -2 -41 -9 -18 -8 -51 -17 -73
-21 -22 -4 -47 -13 -55 -20 -8 -7 -37 -18 -65 -24 -27 -7 -61 -21 -75 -31 -32
-23 -145 -61 -181 -61 -15 0 -56 -13 -91 -30 -34 -16 -70 -30 -78 -30 -14 0
-89 -26 -155 -54 -53 -23 -156 -39 -169 -26 -14 14 -13 113 1 117 6 2 18 9 28
17 16 12 16 15 -4 57 -21 41 -22 58 -20 239 0 107 5 236 10 285 6 50 12 143
14 208 2 64 7 122 11 128 7 11 162 2 179 -11 6 -4 26 -10 45 -13 64 -12 167
-42 182 -55 9 -7 26 -11 39 -10 37 4 38 -48 1 -119 -32 -61 -38 -83 -52 -173
-10 -69 -13 -80 -28 -107 -18 -32 -15 -84 7 -119 26 -43 80 -52 125 -21 17 12
32 22 33 23 6 2 65 170 65 184 0 8 14 47 30 85 17 39 34 79 38 90 26 73 33 94
39 130 9 45 47 174 66 220 7 17 20 64 30 105 9 41 24 89 32 105 8 17 17 50 20
75 4 25 15 59 25 75 11 19 18 49 18 81 0 27 5 55 10 60 6 6 11 81 12 178 1
102 6 170 13 175 24 20 149 28 160 11z m2433 -792 c-6 -18 -28 -21 -28 -4 0 9
7 16 16 16 9 0 14 -5 12 -12z m-3717 -171 c6 -9 7 -45 4 -80 -9 -106 -14 -206
-20 -372 l-5 -160 -28 -3 c-21 -2 -40 9 -85 51 -32 29 -75 62 -95 73 -20 10
-41 24 -47 30 -23 24 -85 64 -162 103 -45 23 -87 48 -93 56 -7 8 -21 15 -31
15 -11 0 -29 11 -41 25 -12 14 -28 25 -35 25 -7 0 -13 4 -13 9 0 5 -29 23 -65
40 -37 18 -65 37 -65 46 0 17 30 85 45 101 25 27 65 38 135 39 81 2 202 14
210 22 3 3 90 3 193 1 169 -3 190 -5 198 -21z m-1203 -2525 c-3 -25 -7 -27
-55 -30 -59 -3 -73 15 -29 36 13 6 32 22 42 35 18 24 19 24 32 6 7 -11 12 -32
10 -47z m-514 -348 c5 -17 0 -33 -14 -51 -11 -14 -20 -33 -20 -42 0 -9 -11
-47 -25 -86 -13 -38 -25 -80 -25 -93 0 -13 -4 -32 -10 -42 -12 -22 -95 -70
-122 -70 -18 0 -19 5 -14 73 3 39 10 90 15 111 5 22 7 44 4 49 -16 26 75 147
110 147 9 0 19 5 22 10 4 6 10 8 15 5 5 -3 11 -1 15 5 12 20 43 10 49 -16z"
        />
        <path
          d="M6696 4174 c-4 -10 -1 -14 6 -12 15 5 23 28 10 28 -5 0 -13 -7 -16
-16z"
        />
        <path
          d="M3462 5928 c-6 -6 -12 -21 -12 -33 0 -12 -5 -26 -11 -32 -11 -11 -22
-128 -21 -223 2 -127 10 -248 16 -258 4 -6 1 -31 -5 -57 -9 -34 -9 -64 0 -121
9 -58 8 -80 0 -91 -7 -8 -12 -43 -11 -81 4 -233 0 -298 -23 -366 -18 -52 -18
-56 -2 -74 18 -20 22 -42 8 -42 -5 0 -12 -19 -16 -42 -4 -24 -9 -52 -11 -63
-2 -11 -9 -51 -15 -90 -6 -38 -17 -82 -25 -96 -7 -14 -13 -42 -12 -61 1 -19
-1 -39 -4 -44 -3 -5 -9 -56 -13 -114 -4 -64 -12 -111 -20 -120 -10 -11 -11
-20 -3 -34 7 -13 7 -29 -1 -55 -9 -31 -17 -98 -34 -281 -2 -19 -9 -57 -15 -85
-27 -123 -55 -285 -58 -338 -2 -33 -8 -64 -13 -71 -6 -7 -13 -41 -17 -77 -3
-35 -12 -80 -19 -99 -8 -19 -16 -53 -20 -75 -4 -22 -10 -44 -15 -50 -4 -5 -15
-46 -25 -90 -10 -44 -24 -94 -31 -112 -8 -17 -17 -46 -20 -65 -13 -79 -12 -78
-50 -78 -42 0 -49 -13 -39 -75 5 -36 12 -48 35 -60 16 -8 35 -13 42 -11 7 2
25 7 40 10 58 13 113 84 138 178 7 23 18 50 25 58 6 8 17 38 23 65 6 28 21 84
33 125 11 41 25 94 30 117 4 24 14 55 22 70 15 32 37 127 67 293 34 193 41
254 35 287 -4 21 -1 36 9 46 10 9 17 46 21 105 3 50 10 106 16 124 15 50 47
314 48 391 1 38 6 88 11 113 6 24 11 90 11 146 1 58 7 114 14 128 18 37 26
170 10 170 -7 0 -19 7 -26 16 -11 14 -10 18 10 33 21 16 22 20 11 83 -11 60
-10 69 9 107 18 33 19 44 9 60 -9 15 -9 28 2 59 9 29 10 51 3 79 -5 22 -6 74
-2 125 5 49 4 101 -1 119 -7 22 -6 37 2 46 7 9 9 37 5 81 -5 46 -2 87 7 123 8
30 17 84 21 122 8 71 0 83 -32 52 -14 -14 -17 -14 -34 1 -19 17 -33 61 -34
109 0 32 -22 44 -43 23z"
        />
        <path
          d="M5334 3660 c-42 -27 -98 -81 -112 -107 -7 -13 -19 -20 -29 -17 -23 5
-46 -13 -67 -54 -9 -18 -35 -46 -58 -63 -51 -37 -78 -75 -78 -112 0 -17 -10
-37 -26 -52 -28 -26 -58 -114 -47 -141 8 -22 86 -54 132 -54 52 0 111 28 111
52 0 10 -4 18 -8 18 -17 0 -62 46 -62 63 0 11 13 24 34 32 28 12 38 25 61 82
15 37 37 82 49 98 13 17 33 49 44 72 12 22 25 43 30 45 4 1 27 28 50 59 64 85
51 127 -24 79z"
        />
      </g>
    </svg>
  )
}
