# Ownership

Ownership은 영어로 '소유'를 의미합니다.

Rust에서는 변수가 값을 '소유'해서 그 값과 연결되어 있습니다.

## 규칙

### 규칙 # 1

각 값은 변수가 소유하고 있습니다.

```rust
a = 3.14159; // 3.14159를 소유하고 있는 a라는 변수
b = 26535; // 26535를 소유하고 있는 b라는 변수
c = 3979; // 3979를 소유하고 있는 c라는 변수
```

### 규칙 # 2

각 값에 대해 한 변수만 소유할 수 있습니다.

두 변수가 동시에 한 값을 소유한다면 `Panic`(에러)가 생깁니다.

### 규칙 # 3

값을 소유하고 있는 변수를 사용할 수 있는 범위에서 벗어나면 변수를 사용할 수 없습니다.

즉, 그 변수는 이제 번위 밖에서는 존재하지 않습니다.

```rust
fn main() {
  let a = 3;

  {
    a = 4;
    println!("괄호 안에서 a = {}", a); // 4
  }

  println!("괄호 밖에서 a = {}", a); // 3
}
```

변수 범위, 즉, 변수를 사용할 수 있는 범위는 `{}` 괄호 안입니다.

위의 코드의 결과는 `4`와 `3`인데 그 이유는 `{}` 안에서는 값을 바꾸어서 값이 4이고 밖에서는 그 원래 값이 바뀌지 않아서 아직 `3`입니다.

즉, 괄호 안에서만 `4`이지 밖에서는 아직 `3`입니다.

## 사용

변수를 사용하고 그 변수의 값을 새로운 변수에 저장할 때 두 가지 상황이 있습니다.

1. 복사한다 (copy)
2. 움직인다 (move)
