# 클로져

클로져도 함수입니다.

함수와 똑같은 기능을 하지만 조금 다릅니다.

함수는 선언하고 나중에 이를 실행합니다.

클로져는 선언하고 바로 사용하거나 아니면 이를 함수의 매개변수로 전달하고 실행합니다.

다른 프로그래밍 언어에서는 '익명 함수', '화살표 함수'라고도 합니다.

```rust
|val| val + x
```

## 클로져와 함수 비교

두 수를 더하는 함수는 다음과 같습니다.

```rust
fn add(x: i32, y: i32) -> i32 {
  x + y
}

fn main() {
  println!("{}", add(1, 2));
}
```

클로져를 사용하면 변수처럼 함수를 저장합니다.

```rust
fn main() {
  let add = |x: i32, y: i32| -> i32 { x + y };
  println!("{}", add(1, 2));
}
```

이와 같이 사용하면 클로져와 함수는 매우 비슷합니다.
