# 함수

함수란 값을 입력하면 새로운 값을 반환하는 것을 말합니다.

'반환'이란 돌려준다는 뜻입니다.

프로그래밍에서는 일부 코드를 묶은 것을 함수라고도 합니다.

:::note 함수의 좋은 예시는 아래와 같습니다.

1. 일부 코드가 너무 복잡함
2. 반복해서 실행해야할 코드
3. 따로 직접 사용하지 않고 나중에 가서 사용해야 될 때

:::

## 종류

### `main()` 함수

`main()` 함수는 특별한 것 없이 최상단에 놓고 실행할 코드를 감싸고 있습니다.

```rust
fn main() {
    println!("Hello, world!");
}
```

### 사용자 정의 함수

사용자가 스스로 정의해서 만들 수 있는 함수입니다.

함수는 `fn`을 사용해 만들고 실행

```rust
fn my_function() {
    println!("Hello, world!");
}

fn main() {
  my_function();
}
```

즉, `my_function()`을 실행하면 그 안에 있는 코드인 `println!("Hello, world!")`가 실행됩니다.
