# 정수

숫자형 데이터 형태란 숫자를 저장할 수 있는 변수를 뜻합니다.

숫자형 데이터에는 정수와 소수를 저장가 있습니다.

정수란 -2, -1, 0, 1, 2 등의 숫자입니다.

## 일반 정수

`i`와 `u` 뒤에 8, 16, 32, 64, 128의 뜻은 숫자를 담을 수 있는 메모리의 크기를 뜻합니다.

예를 들면, u8은 8비트(28)를 사용하는 메모리를 저장할 수 있는 변수를 뜻합니다.

그래서 0을 포함해서 28 - 1(255)까지 저장할 수 있습니다.

| 이름 | 설명 |
| :-- | :-- |
| `i8` | -128 ~ 127 |
| `i16` | -32768 ~ 32767 |
| `i32` | -2147483648 ~ 2147483647 |
| `i64` | -9223372036854775808 ~ 9223372036854775807 |
| `i128` | -170141183460469231731687303715884105728 ~ 170141183460469231731687303715884105727 |

## unsigned 정수

`unsigned` 정수 변수는 양수만 저장할 수 있는 것을 뜻합니다.

양수란 0보다 큰 수를 뜻합니다 (예: 1, 2, 3).

| 정수형 변수 이름 | 범위                                        |
| :--------------- | :------------------------------------------ |
| `u8`             | 0 ~ 255                                     |
| `u16`            | 0 ~ 65535                                   |
| `u32`            | 0 ~ 4294967295                              |
| `u64`            | 0 ~ 18446744073709551615                    |
| `u128`           | 0 ~ 340282366920938463463374607431768211455 |

## 정수 형태의 MIN, MAX 구하기

MIN은 최소값을 뜻하고, MAX는 최대값을 뜻합니다.

```
(숫자형태)::MIN
(숫자형태)::MAX
```

`MIN`을 출력하면 숫자형태의 최소값을 출력합니다 (예: `i8`, `i16` 등)

`MAX`를 출력하면 숫자형태의 최댓값을 출력합니다 (예: `i8`, `i16` 등)

<iframe
  loading="lazy"
  title="Rust IDLE"
  src="https://play.rust-lang.org/?version=stable&mode=debug&edition=2021&code=fn%20main()%20%7B%0D%0A%20%20%20%20let%20test_integer%3A%20i8%20%3D%20123%3B%0D%0A%20%20%20%20%0D%0A%20%20%20%20println!(%22%7Btest_integer%7D%22)%3B%0D%0A%20%20%20%20%0D%0A%20%20%20%20println!(%22i8%EC%9D%98%20%EC%B5%9C%EC%86%8C%EA%B0%92%3A%20%7B%7D%22%2C%20i8%3A%3AMIN)%3B%0D%0A%20%20%20%20println!(%22i8%EC%9D%98%20%EC%B5%9C%EB%8C%93%EA%B0%92%3A%20%7B%7D%22%2C%20i8%3A%3AMAX)%3B%0D%0A%7D%0D%0A"
  height="400"
/>
