# Rust

Rust는 다른 프로그래밍 언어와 달리 매우 "안전하고, 효율적이고, 유용한" 프로그래밍 언어입니다.

하지만 Rust는 코딩을 처음 배우는 사람에게는 매우 어렵고 복잡할 수 있기 때문에 [파이썬](/docs/python/start/python)을 먼저 배우는 것을 권장합니다.

![Rust](https://doc.rust-lang.org/book/img/ferris/does_not_compile.svg)

## 프로그래밍 언어란?

프로그래밍 언어란 사람들과 기계가 소통하기 위하여 만든 언어입니다.

한국 사람들은 한국어를 사용하듯이 컴퓨터는 프로그래밍 언어를 사용합니다.

기계는 이진수 (0과 1)만 이해할 수 있어서 인간과의 대화가 매우 어렵습니다.

코딩 언어를 사용한다면 코딩 언어를 이진수로 자동으로 바꿀 수 있으므로 사람들이 어려운 이진수를 배우지 않고도컴퓨터에게 명령을 할 수 있습니다.

```
01001000 01100101 01101100 01101100 01101111 00100001
```

위의 이진수는 'Hello World'라는 뜻입니다.

## Rust의 특징

Rust를 설명하기 위해서는 딱 3가지 단어만 필요합니다. "안전, 효율, 유용"

Rust는 처음 프로그램을 만들 때 조금이라도 불안하거나 비효율적인 코드를 자동으로 제거헤서 매우 안전합니다.

또한, C/C++ 코딩언어처럼 매우 빠르고 메모리 처리 속도가 다른 프로그래밍 언어와 비교도 않됩니다.

마지막으로 Rust는 모든 코딩 분야에서 사용할 수 있어서 유용합니다.

## Rust의 단점

1. Rust는 매우 복잡합니다. 기능도 복잡하고 코드를 짜다보면 코드가 복잡해 질 수 있습니다.
2. 아직 Rust는 다른 언어에 비해 최근에 만들어져서 조금 "어린" 프로그래밍 언어입니다.
3. Rust는 매우 배우기가 어렵습니다. 다른 프로그래밍 언어에 비해 배워야할 것도 많습니다.
