# 조건문

"너 오늘 보는 시험에서 100점 맞으면 동영상 게임 2시간 할 수 있게 해줄께" - 엄마 -

위의 예시에서 만일 시험 점수가 100 점이라면 게임 2시간을 할 수 있고 그렇지 않다면 게임을 할 수 없습니다.

파이썬에서도 어떤 조건에 맞다면 어떤 코드를 실행할 수 있는 기능이 있습니다.

<iframe
  loading="lazy"
  className="youtube"
  src="https://www.youtube.com/embed/DzDnLTtrDQk"
  title="YouTube video player"
  allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
/>

## 조건문이란?

영어로 '만일'은 'if'입니다.

```mermaid
graph TD;
    조건-->참;
    조건-->거짓;
```

파이썬에서 조건문 기본 형태는 (if + 조건)과 코드입니다.

```py
if 조건:
    코드
```

위 코드에 들여쓰기(띄어쓰기)가 된 부분은 if 문 안의 부분입니다.

만일 파이썬 조건문에서 코드를 들여쓰지 않는다면 에러가 생깁니다.

그 이유는 파이썬에서 항상 어떤 코드가 조건문 안에 있다면 항상 들여쓰기를 기준으로 삼고 있기 때문입니다.

## 논리연산자

조건문에서 두 가지 조건을 모두 만족했을 때 실행을 시키고 싶다면, `and` 연산자를 이용하면 됩니다 `and`는 모든 조건이 참일 때만 실행을 시킵니다.

`or`는 하나라도 참이면 참입니다.

만일 두 조건 중 하나라도 참이면 어떤 코드를 실행하고 싶다면 `or` 논리연산자를 사용하세요.

<iframe
  loading="lazy"
  title="Python IDLE Trinket"
  src="https://trinket.io/embed/python3/9e178be286"
  height="400"
/>

## 다양한 형태

### if - else

if - else 문은 만일 어떤 조건이 맞다면 어떤 코드를 실행하고 그렇지 않다면 마지막 코드를 실행하는 조건문입니다.

### if - elif

if - elif는 첫 번째 조건에 맞다면 첫 번째 코드를 실행하고 그렇지 않다면 다음 조건에 맞는지 확인합니다.

만일 두 번째 조건에 맞다면 두 번째 코드를 실행하고 그렇지 않다면 else를 실행합니다.

문이 없기 때문에 아무 코드도 실행하지 않고 넘어갑니다.

### if - elif - else

if - elif - else는 첫 번째 조건에 맞는 지의 여부를 확인하고 그렇다면 첫 번째 코드를 실행하고 그렇지 않다면 넘어갑니다.

그리고 elif 조건이 맞다면 elif 문의 코드를 실행하고 넘어갑니다.

마지막으로 모든 elif 문의 조건이 맞지 않다면 else 문의 코드를 실행합니다.

<iframe
  loading="lazy"
  title="Python IDLE Trinket"
  src="https://trinket.io/embed/python3/4f34d13cdc"
  height="400"
/>

## 조건문 간단히 하기

if-else 조건문은 다음과 같은 형태로도 사용할 수 있습니다.

형태는 `(if 조건이 맞았다면 실행할 코드) if (조건) else (if조건이 틀리다면)}`입니다.

if-elif-else 조건문을 다음과 같이 사용할 수 있습니다.

형태는 `(if 조건 1이 맞았다면 실행할 코드) if (조건) else (if 조건2가 맞았다면 실행할 코드) if (조건2) else (if 조건문이 둘 다 틀리다면 실행할 코드)`입니다.

<iframe
  loading="lazy"
  title="Python IDLE Trinket"
  src="https://trinket.io/embed/python3/73c3356df0"
  height="400"
/>

## switch

다른 언어 (예: 자바스크립트)에서는 `switch`라는 키워드가 있습니다.

`switch`는 어떤 변수와 다른 값을 비교하는 키워드입니다.

조건문인데 두 값을 비교하는 조건문입니다.

하지만 파이썬에서는 `switch`가 없습니다.

그래서 다음과 같은 방법만으로 사용할 수 있습니다.

<iframe
  loading="lazy"
  title="Python IDLE Trinket"
  src="https://trinket.io/embed/python3/cb9b932e10"
  height="400"
/>

## 들여쓰기

들여쓰기란 새로운 문단을 쓸 때 코드 앞에 공백을 놓고 시작하는 것을 뜻합니다.

파이썬에서는 조건문을 만들때 들여쓰기는 필수입니다.

위의 코드와 같이 `print()`는 조건문 안에 있으므로 들여쓰기를 해야 합니다.

항상 어떤 코드는 어떤 것(함수, 조건문, 반복문 등) 안에 있거나 밖에 있는지를 고려하며 들여쓰기를 해야합니다.
