//
//  TaghvimWidget.swift
//  TaghvimWidget
//
//  Created by Hadi Sharghi on 7/18/23.
//

import WidgetKit
import SwiftUI
import Intents

struct Provider: IntentTimelineProvider {
    func placeholder(in context: Context) -> SimpleEntry {
        SimpleEntry(date: Date(), configuration: ConfigurationIntent())
    }

    func getSnapshot(for configuration: ConfigurationIntent, in context: Context, completion: @escaping (SimpleEntry) -> ()) {
        let entry = SimpleEntry(date: Date(), configuration: configuration)
        completion(entry)
    }

    func getTimeline(for configuration: ConfigurationIntent, in context: Context, completion: @escaping (Timeline<Entry>) -> ()) {
        var entries: [SimpleEntry] = []

        // Generate a timeline consisting of five entries an hour apart, starting from the current date.
        let currentDate = Date()
        for hourOffset in 0 ..< 5 {
            let entryDate = Calendar.current.date(byAdding: .hour, value: hourOffset, to: currentDate)!
            let entry = SimpleEntry(date: entryDate, configuration: configuration)
            entries.append(entry)
        }

        let timeline = Timeline(entries: entries, policy: .atEnd)
        completion(timeline)
    }
}

struct SimpleEntry: TimelineEntry {
    let date: Date
    let configuration: ConfigurationIntent
}

struct TaghvimWidgetEntryView : View {
    var entry: Provider.Entry

    let converter = DateConverter(calendar: .shamsi)
    var body: some View {
        VStack {
            Text(converter.weekdayAsText)
                .font(.title2)
            Spacer(minLength: 8)
            Text(converter.day)
                .font(.system(size: 60))
                .fontWeight(.bold)
                .foregroundColor(Color.red)
            Spacer(minLength: 0)
            Text(converter.monthAsText)
                .font(.title)
        }
        .padding(.vertical, 10)
    }
}

@main
struct TaghvimWidget: Widget {
    let kind: String = "TaghvimWidget"

    var body: some WidgetConfiguration {
        IntentConfiguration(kind: kind, intent: ConfigurationIntent.self, provider: Provider()) { entry in
            TaghvimWidgetEntryView(entry: entry)
        }
        .configurationDisplayName("My Widget")
        .description("This is an example widget.")
        .supportedFamilies([.systemSmall])
    }
}

struct TaghvimWidget_Previews: PreviewProvider {
    static var previews: some View {
        TaghvimWidgetEntryView(entry: SimpleEntry(date: Date(), configuration: ConfigurationIntent()))
            .previewContext(WidgetPreviewContext(family: .systemSmall))
    }
}

