/*
	Copyright (C) 2024 P. Last

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program. If not, see <https://www.gnu.org/licenses/>.
*/
#pragma once

#include "Building.h"
#include "Units/Resource/IResourceAcceptor.h"


class LumberMill : public Building, public IResourceAcceptor {
public:
	LumberMill(Peasant* pErecter, Map* pMap);
	LumberMill(Player* pOwner, Fraction fraction, Map* pMap);

	// IResourceAcceptor
	bool acceptsResource(ResourceType t) const override {
		// todo: when under construction return false
		return (t == ResourceType::Wood);
	}

	// BuildingEventHandler
	std::vector<ProductionItem::ItemType> getProductionItemList() const override;

private:
	void setProperties();
};
