# 🧠 Awesome Sora Prompts
[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

---
[Sora](https://openai.com/sora) is an AI model that can create realistic and imaginative scenes from text instructions from OpenAI. OpenAI is teaching AI to understand and simulate the physical world in motion, with the goal of training models that help people solve problems that require real-world interaction.

Sora can provide following functions:
* text to video
* animating images
* extending generated videos
* video to video editing
* connecting videos

📖 In this repository, you will find a variety of prompts that can be used with Sora. You can find examples of prompts and the generated videos, and modify them as needed.

**[View on Github](https://github.com/hr98w/awesome-sora-prompts)**

**[View on Website](https://prompts-sora.com)**

## 🚀 **OpenAI Sora Alternatives**  

Sora is officially released recently, but its premium pricing plans **($20 and $200/month)** may not suit everyone's budget.

To help you find the right tool for your needs, we've created a list of alternative video generation platforms, showcasing their standout features, pricing, and unique benefits. Whether you're looking for affordable options, specialized video effects, or easy-to-use interfaces, we’ve got you covered.


| **Name**       | **Key Features**                                                                                 | **Pricing(monthly)**        | **Why Choose It**                                                                                     |  
|---------------------|-------------------------------------------------------------------------------------------------|--------------------|-------------------------------------------------------------------------------------------------------|  
| **[Pollo.ai](https://pollo.ai/?ref=mjaxmwv)**  | - AI-driven customer support chatbot<br>- Natural language processing (NLP)<br>- Integration with multiple platforms |  Free/$10/$25   | Ideal for businesses seeking to automate and enhance customer interactions with AI-powered support.   |  
| **[Fliki](https://fliki.ai/?via=promptsora)**      | - AI text-to-video creation<br>- Idea to video <br>- Image to video  | Free/$21/$66         | Perfect for content creators and marketers needing quick and engaging videos with professional voiceovers. |  
| **[Gling](https://gling.ai/?via=sora)**  | - Automatic video editing for YouTubers<br>- Scene detection & trimming<br>- User-friendly workflow              | Free/$10/$20        | Great for YouTubers aiming to save time on editing while maintaining high-quality output.             |  
| **[Quso](https://quso.ai?via=9e3e1)**        | - AI-powered storytelling<br>- Scene design and rendering<br>- Supports team collaboration                        | Free/$10/$21/$25     | Ideal for creative teams looking to craft compelling narratives with advanced design tools.           |  
| **[Vizard](https://vizard.ai/?via=sora)**    | - AI script-to-video generation<br>- Customizable video templates<br>- Real-time editing                          | Free/$16/$32        | A versatile choice for businesses creating professional training or promotional videos.               |  
| **[Pictory](https://pictory.ai?ref=haoran-wang59)** | - AI video creation from scripts<br>- Automatic summarization<br>- Voiceover synchronization | Free/$19/$39/$99 | Perfect for businesses and creators needing to turn long-form content into short, engaging videos effortlessly. |

# Table of Content
This repository is organized as follows:

* [Techniques](#techniques)
* [Video Generation Prompts](#video-generation-prompts)
* [Animating Images Prompts](https://github.com/hr98w/awesome-sora-prompts/blob/main/animating-prompts.md)
* [Video-to-video Editing Prompts](https://github.com/hr98w/awesome-sora-prompts/blob/main/video-editting-prompts.md)
* [Image Generation Prompts](https://github.com/hr98w/awesome-sora-prompts/blob/main/image-generation-prompts.md)

# Techniques
Using simple, natural language, we can generate the desired videos or images. However, mastering this still requires skill. From lighting and style to scenery and characters, expertise is essential. This repository aims to collect these techniques and inspire you. 

By simply adding the following keywords, you can efficiently achieve the desired effect.

## Photographic technique/device
> cinematic film shot in 35mm </br>
> cinematic 35mm film </br>
> cinematic film shot in 70mm </br>
> shot with a mobile phone camera </br>

## Stylized keyword
> depth of field </br>
> close-up shot </br>
> The shot is clear and sharp, with a shallow depth of field </br>
> vivid color </br>
> cinematic </br>
> 3D digital render art style </br>


# Video Generation Prompts

## Official Video Generation Prompts

<details>
<summary>Click to see more examples</summary>

> A stylish woman walks down a Tokyo street filled with warm glowing neon and animated city signage. She wears a black leather jacket, a long red dress, and black boots, and carries a black purse. She wears sunglasses and red lipstick. She walks confidently and casually. The street is damp and reflective, creating a mirror effect of the colorful lights. Many pedestrians walk about.

Generated Videos: [link](https://cdn.openai.com/sora/videos/tokyo-walk.mp4)

> Several giant wooly mammoths approach treading through a snowy meadow, their long wooly fur lightly blows in the wind as they walk, snow covered trees and dramatic snow capped mountains in the distance, mid afternoon light with wispy clouds and a sun high in the distance creates a warm glow, the low camera view is stunning capturing the large furry mammal with beautiful photography, depth of field.

Generated Videos: [link](https://cdn.openai.com/sora/videos/wooly-mammoth.mp4)

> A movie trailer featuring the adventures of the 30 year old space man wearing a red wool knitted motorcycle helmet, blue sky, salt desert, cinematic style, shot on 35mm film, vivid colors.

Generated Videos: [link](https://cdn.openai.com/sora/videos/mitten-astronaut.mp4)

> Drone view of waves crashing against the rugged cliffs along Big Sur’s garay point beach. The crashing blue waters create white-tipped waves, while the golden light of the setting sun illuminates the rocky shore. A small island with a lighthouse sits in the distance, and green shrubbery covers the cliff’s edge. The steep drop from the road down to the beach is a dramatic feat, with the cliff’s edges jutting out over the sea. This is a view that captures the raw beauty of the coast and the rugged landscape of the Pacific Coast Highway.

Generated Videos: [link](https://cdn.openai.com/sora/videos/big-sur.mp4)

> Animated scene features a close-up of a short fluffy monster kneeling beside a melting red candle. The art style is 3D and realistic, with a focus on lighting and texture. The mood of the painting is one of wonder and curiosity, as the monster gazes at the flame with wide eyes and open mouth. Its pose and expression convey a sense of innocence and playfulness, as if it is exploring the world around it for the first time. The use of warm colors and dramatic lighting further enhances the cozy atmosphere of the image.

Generated Videos: [link](https://cdn.openai.com/sora/videos/monster-with-melting-candle.mp4)

> A gorgeously rendered papercraft world of a coral reef, rife with colorful fish and sea creatures.

Generated Videos: [link](https://cdn.openai.com/sora/videos/origami-undersea.mp4)

> This close-up shot of a Victoria crowned pigeon showcases its striking blue plumage and red chest. Its crest is made of delicate, lacy feathers, while its eye is a striking red color. The bird’s head is tilted slightly to the side, giving the impression of it looking regal and majestic. The background is blurred, drawing attention to the bird’s striking appearance.

Generated Videos: [link](https://cdn.openai.com/sora/videos/victoria-crowned-pigeon.mp4)

> Photorealistic closeup video of two pirate ships battling each other as they sail inside a cup of coffee.

Generated Videos: [link](https://cdn.openai.com/sora/videos/ships-in-coffee.mp4)

> A young man at his 20s is sitting on a piece of cloud in the sky, reading a book.

Generated Videos: [link](https://cdn.openai.com/sora/videos/man-on-the-cloud.mp4)

> Historical footage of California during the gold rush.

Generated Videos: [link](https://cdn.openai.com/sora/videos/gold-rush.mp4)

> A close up view of a glass sphere that has a zen garden within it. There is a small dwarf in the sphere who is raking the zen garden and creating patterns in the sand.

Generated Videos: [link](https://cdn.openai.com/sora/videos/zen-garden-gnome.mp4)

> Extreme close up of a 24 year old woman’s eye blinking, standing in Marrakech during magic hour, cinematic film shot in 70mm, depth of field, vivid colors, cinematic

Generated Videos: [link](https://cdn.openai.com/sora/videos/closeup-of-womans-eye.mp4)

> A cartoon kangaroo disco dances.

Generated Videos: [link](https://cdn.openai.com/sora/videos/dancing-kangaroo.mp4)

> A beautiful homemade video showing the people of Lagos, Nigeria in the year 2056. Shot with a mobile phone camera.

Generated Videos: [link](https://cdn.openai.com/sora/videos/lagos.mp4)

> A petri dish with a bamboo forest growing within it that has tiny red pandas running around.

Generated Videos: [link](https://cdn.openai.com/sora/videos/petri-dish-pandas.mp4)

> The camera rotates around a large stack of vintage televisions all showing different programs — 1950s sci-fi movies, horror movies, news, static, a 1970s sitcom, etc, set inside a large New York museum gallery.

Generated Videos: [link](https://cdn.openai.com/sora/videos/stack-of-tvs.mp4)

> 3D animation of a small, round, fluffy creature with big, expressive eyes explores a vibrant, enchanted forest. The creature, a whimsical blend of a rabbit and a squirrel, has soft blue fur and a bushy, striped tail. It hops along a sparkling stream, its eyes wide with wonder. The forest is alive with magical elements: flowers that glow and change colors, trees with leaves in shades of purple and silver, and small floating lights that resemble fireflies. The creature stops to interact playfully with a group of tiny, fairy-like beings dancing around a mushroom ring. The creature looks up in awe at a large, glowing tree that seems to be the heart of the forest.

Generated Videos: [link](https://cdn.openai.com/sora/videos/big-eyed-fluff-ball.mp4)

> The camera follows behind a white vintage SUV with a black roof rack as it speeds up a steep dirt road surrounded by pine trees on a steep mountain slope, dust kicks up from it’s tires, the sunlight shines on the SUV as it speeds along the dirt road, casting a warm glow over the scene. The dirt road curves gently into the distance, with no other cars or vehicles in sight. The trees on either side of the road are redwoods, with patches of greenery scattered throughout. The car is seen from the rear following the curve with ease, making it seem as if it is on a rugged drive through the rugged terrain. The dirt road itself is surrounded by steep hills and mountains, with a clear blue sky above with wispy clouds.

Generated Videos: [link](https://cdn.openai.com/sora/videos/suv-in-the-dust.mp4)

> Reflections in the window of a train traveling through the Tokyo suburbs.

Generated Videos: [link](https://cdn.openai.com/sora/videos/train-window.mp4)

> A drone camera circles around a beautiful historic church built on a rocky outcropping along the Amalfi Coast, the view showcases historic and magnificent architectural details and tiered pathways and patios, waves are seen crashing against the rocks below as the view overlooks the horizon of the coastal waters and hilly landscapes of the Amalfi Coast Italy, several distant people are seen walking and enjoying vistas on patios of the dramatic ocean views, the warm glow of the afternoon sun creates a magical and romantic feeling to the scene, the view is stunning captured with beautiful photography.

Generated Videos: [link](https://cdn.openai.com/sora/videos/amalfi-coast.mp4)

> A large orange octopus is seen resting on the bottom of the ocean floor, blending in with the sandy and rocky terrain. Its tentacles are spread out around its body, and its eyes are closed. The octopus is unaware of a king crab that is crawling towards it from behind a rock, its claws raised and ready to attack. The crab is brown and spiny, with long legs and antennae. The scene is captured from a wide angle, showing the vastness and depth of the ocean. The water is clear and blue, with rays of sunlight filtering through. The shot is sharp and crisp, with a high dynamic range. The octopus and the crab are in focus, while the background is slightly blurred, creating a depth of field effect.

Generated Videos: [link](https://cdn.openai.com/sora/videos/octopus-and-crab.mp4)

> A flock of paper airplanes flutters through a dense jungle, weaving around trees as if they were migrating birds.

Generated Videos: [link](https://cdn.openai.com/sora/videos/paper-airplanes.mp4)

> A cat waking up its sleeping owner demanding breakfast. The owner tries to ignore the cat, but the cat tries new tactics and finally the owner pulls out a secret stash of treats from under the pillow to hold the cat off a little longer.

Generated Videos: [link](https://cdn.openai.com/sora/videos/cat-on-bed.mp4)

> Borneo wildlife on the Kinabatangan River

Generated Videos: [link](https://cdn.openai.com/sora/videos/birds-over-river.mp4)

> A Chinese Lunar New Year celebration video with Chinese Dragon.

Generated Videos: [link](https://cdn.openai.com/sora/videos/chinese-new-year-dragon.mp4)

> Tour of an art gallery with many beautiful works of art in different styles.

Generated Videos: [link](https://cdn.openai.com/sora/videos/art-museum.mp4)

> Beautiful, snowy Tokyo city is bustling. The camera moves through the bustling city street, following several people enjoying the beautiful snowy weather and shopping at nearby stalls. Gorgeous sakura petals are flying through the wind along with snowflakes.

Generated Videos: [link](https://cdn.openai.com/sora/videos/tokyo-in-the-snow.mp4)

> A stop motion animation of a flower growing out of the windowsill of a suburban house.

Generated Videos: [link](https://cdn.openai.com/sora/videos/flower-blooming.mp4)

> The story of a robot’s life in a cyberpunk setting.

Generated Videos: [link](https://cdn.openai.com/sora/videos/robot-video-game.mp4)

> An extreme close-up of an gray-haired man with a beard in his 60s, he is deep in thought pondering the history of the universe as he sits at a cafe in Paris, his eyes focus on people offscreen as they walk as he sits mostly motionless, he is dressed in a wool coat suit coat with a button-down shirt , he wears a brown beret and glasses and has a very professorial appearance, and the end he offers a subtle closed-mouth smile as if he found the answer to the mystery of life, the lighting is very cinematic with the golden light and the Parisian streets and city in the background, depth of field, cinematic 35mm film.

Generated Videos: [link](https://cdn.openai.com/sora/videos/closeup-man-in-glasses.mp4)

> A beautiful silhouette animation shows a wolf howling at the moon, feeling lonely, until it finds its pack.

Generated Videos: [link](https://cdn.openai.com/sora/videos/wolves.mp4)

> New York City submerged like Atlantis. Fish, whales, sea turtles and sharks swim through the streets of New York.

Generated Videos: [link](https://cdn.openai.com/sora/videos/aquarium-nyc.mp4)

> A litter of golden retriever puppies playing in the snow. Their heads pop out of the snow, covered in.

Generated Videos: [link](https://cdn.openai.com/sora/videos/snow-dogs.mp4)

> The camera directly faces colorful buildings in Burano Italy. An adorable dalmation looks through a window on a building on the ground floor. Many people are walking and cycling along the canal streets in front of the buildings.

Generated Videos: [link](https://cdn.openai.com/sora/videos/italian-pup.mp4)

> An adorable happy otter confidently stands on a surfboard wearing a yellow lifejacket, riding along turquoise tropical waters near lush tropical islands, 3D digital render art style.

Generated Videos: [link](https://cdn.openai.com/sora/videos/otter-on-surfboard.mp4)

> This close-up shot of a chameleon showcases its striking color changing capabilities. The background is blurred, drawing attention to the animal’s striking appearance.

Generated Videos: [link](https://cdn.openai.com/sora/videos/chameleon.mp4)

> A corgi vlogging itself in tropical Maui.

Generated Videos: [link](https://cdn.openai.com/sora/videos/vlogger-corgi.mp4)

> A white and orange tabby cat is seen happily darting through a dense garden, as if chasing something. Its eyes are wide and happy as it jogs forward, scanning the branches, flowers, and leaves as it walks. The path is narrow as it makes its way between all the plants. the scene is captured from a ground-level angle, following the cat closely, giving a low and intimate perspective. The image is cinematic with warm tones and a grainy texture. The scattered daylight between the leaves and plants above creates a warm contrast, accentuating the cat’s orange fur. The shot is clear and sharp, with a shallow depth of field.

Generated Videos: [link](https://cdn.openai.com/sora/videos/happy-cat.mp4)

> Aerial view of Santorini during the blue hour, showcasing the stunning architecture of white Cycladic buildings with blue domes. The caldera views are breathtaking, and the lighting creates a beautiful, serene atmosphere.

Generated Videos: [link](https://cdn.openai.com/sora/videos/santorini.mp4)

> Tiltshift of a construction site filled with workers, equipment, and heavy machinery.

Generated Videos: [link](https://cdn.openai.com/sora/videos/tiny-construction.mp4)

> A giant, towering cloud in the shape of a man looms over the earth. The cloud man shoots lighting bolts down to the earth.

Generated Videos: [link](https://cdn.openai.com/sora/videos/cloud-man.mp4)

> A Samoyed and a Golden Retriever dog are playfully romping through a futuristic neon city at night. The neon lights emitted from the nearby buildings glistens off of their fur.

Generated Videos: [link](https://cdn.openai.com/sora/videos/dogs-downtown.mp4)

> The Glenfinnan Viaduct is a historic railway bridge in Scotland, UK, that crosses over the west highland line between the towns of Mallaig and Fort William. It is a stunning sight as a steam train leaves the bridge, traveling over the arch-covered viaduct. The landscape is dotted with lush greenery and rocky mountains, creating a picturesque backdrop for the train journey. The sky is blue and the sun is shining, making for a beautiful day to explore this majestic spot.

Generated Videos: [link](https://cdn.openai.com/sora/videos/photoreal-train.mp4)

</details>

## Official Video Generation Prompts (Twitter)

<details>
<summary>Click to see more examples</summary>

> a red panda and a toucan are best friends taking a stroll through santorini during the blue hour

Generated Videos: [link](https://x.com/_tim_brooks/status/1761236971186438178?s=20)

> a scuba diver discovers a hidden futuristic shipwreck, with cybernetic marine life and advanced alien technology

Generated Videos: [link](https://x.com/billpeeb/status/1761235907330400640?s=20)

> Close-up of a majestic white dragon with pearlescent, silver-edged scales, icy blue eyes, elegant ivory horns, and misty breath. Focus on detailed facial features and textured scales, set against a softly blurred background

Generated Videos: [link](https://x.com/hr98w/status/1761752242406019524?s=20)

> in a beautifully rendered papercraft world, a steamboat travels across a vast ocean with wispy clouds in the sky. vast grassy hills lie in the distant background, and some sealife is visible near the papercraft ocean's surface

Generated Videos: [link](https://x.com/billpeeb/status/1761235818515968314?s=20)

> a man BASE jumping over tropical hawaii waters. His pet macaw flies alongside him

Generated Videos: [link](https://x.com/_tim_brooks/status/1761235778875883810?s=20)

> a dark neon rainforest aglow with fantastical fauna and animals

Generated Videos: [link](https://x.com/_tim_brooks/status/1761235759464329278?s=20)

> a tortoise whose body is made of glass, with cracks that have been repaired using kintsugi, is walking on a black sand beach at sunset

Generated Videos: [link](https://x.com/model_mechanic/status/1761198301482021084?s=20)

> cinematic trailer for a group of samoyed puppies learning to become chefs

Generated Videos: [link](https://x.com/hr98w/status/1761752613111152977?s=20)

> Cinematic trailer for a group of adventurous puppies exploring ruins in the sky

Generated Videos: [link](https://x.com/_tim_brooks/status/1760168890959888818?s=20)

> nighttime footage of a hermit crab using an incandescent lightbulb as its shell

Generated Videos: [link](https://x.com/model_mechanic/status/1759343673484165262?s=20)

> minecraft with the most gorgeous high res 8k texture pack ever

Generated Videos: [link](https://x.com/_tim_brooks/status/1759125570825453785?s=20)

> this close-up shot of a futuristic cybernetic german shepherd showcases its striking brown and black fur

Generated Videos: [link](https://x.com/billpeeb/status/1759123245821817083?s=20)

> pov footage of an ant navigating the inside of an ant nest

Generated Videos: [link](https://x.com/model_mechanic/status/1759068809867166129?s=20)

> macro shot of a leaf showing tiny trains moving through its veins

Generated Videos: [link](https://x.com/model_mechanic/status/1758993960956219476?s=20)

> a white and orange tabby alley cat is seen darting across a back street alley in a heavy rain, looking for shelter

Generated Videos: [link](https://x.com/_tim_brooks/status/1758967853498450396?s=20)

> a photorealistic video of a butterfly that can swim navigating underwater through a beautiful coral reef

Generated Videos: [link](https://x.com/_tim_brooks/status/1758959726933774489?s=20)

> a giant duck walks through the streets in Boston

Generated Videos: [link](https://x.com/_tim_brooks/status/1758959404974760042?s=20)

> The camera lowers and widens to a grand panoramic view overlooking the beautiful ocean and the historical buildings along the a stunning coastal picturesque town perched on the cliffs

Generated Videos: [link](https://x.com/billpeeb/status/1758958132615619005?s=20)

> a walking figure made out of water tours an art gallery with many beautiful works of art in different styles

Generated Videos: [link](https://x.com/_tim_brooks/status/1758666264032280683?s=20)

> a green blob and an orange blob are in love and dancing together

Generated Videos: [link](https://x.com/_tim_brooks/status/1758662698190229643?s=20)

> a spooky haunted mansion, with friendly jack o lanterns and ghost characters welcoming trick or treaters to the entrance, tilt shift photography

Generated Videos: [link](https://x.com/billpeeb/status/1758658884582142310?s=20)

> a giant cathedral is completely filled with cats. there are cats everywhere you look. a man enters the cathedral and bows before the giant cat king sitting on a throne

Generated Videos: [link](https://x.com/_tim_brooks/status/1758655677864845707?s=20)

> realistic video of people relaxing at beach, then a shark jumps out of the water halfway through and surprises everyone

Generated Videos: [link](https://x.com/_tim_brooks/status/1758655323576164830?s=20)

</details>

## Official Video Generation Prompts (Tiktok)

<details>
<summary>Click to see more examples</summary>

> 1. Tiny potato kings wearing majestic crowns, sitting on thrones, overseeing their vast potato kingdom filled with potato subjects and potato castles.
> 2. A minimap diorama of a cafe adorned with indoor plants. Wooden beams crisscross above, and a cold brew station stands out with tiny bottles and glasses. 
> 3. An image of a realistic cloud that spells “SORA.”

Generated Videos: [link](https://www.tiktok.com/@openai/video/7336623342721486122)

> Monkey playing chess in a park.

Generated Videos: [link](https://www.tiktok.com/@openai/video/7336976814272695598)

> Macro shot of a leaf showing tiny trains moving through its veins.

Generated Videos: [link](https://www.tiktok.com/@openai/video/7337337783700360494)

> A computer hacker labrador retreiver wearing a black hooded sweatshirt sitting in front of the computer with the glare of the screen emanating on the dog's face as he types very quickly.

Generated Videos: [link](https://www.tiktok.com/@openai/video/7337475894115700011)

> A low to the ground camera closely following ants in the jungle down into the ground into their world.

Generated Videos: [link](https://www.tiktok.com/@openai/video/7337532544491130158)

> Leaning tower of pizza.

Generated Videos: [link](https://www.tiktok.com/@openai/video/7337782565870357803)

> A low-quality, visually disappointing superbowl commercial.

Generated Videos: [link](https://www.tiktok.com/@openai/video/7337862463951654190)

</details>

---

## Contributing
Your contributions are always welcome! Please read [this](https://github.com/hr98w/awesome-sora-prompts/blob/main/CONTRIBUTING.md) before creating PRs.

<a href="https://github.com/hr98w/awesome-sora-prompts/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=hr98w/awesome-sora-prompts" />
</a>
