10 REM -- PROGRAM TO PRINT OUT BIORHYTHMS FOR ONE MONTH
20 REM    GIVEN A BIRTHDATE AND A MONTH
30 REM
40 DIM M9(12),L(3),V(4),C$(4),M$(12)
50 DIM #2,V1$(4096)=1
60 OPEN "CYCLES.DAT" FOR OUTPUT AS FILE #2
70 REM
80 REM -- CALCULATE JULIAN DAY BASED ON DATE
90 REM
100 DEF FNJ(D0,M0,Y0)=M9(M0)+D0+SGN(INT(M0/3))*(1+SGN(4*INT(Y0/4)-Y0))
110 REM
120 REM -- CALCULATE DAYS BETWEEN TWO JULIAN DATES
130 REM
140 DEF FND(J1,Y1,J2,Y2)=INT(Y2/4-1-INT(Y1/4))+J2-J1+365*(Y2-Y1)
150 REM
160 REM -- INITIALIZE THE ARRAYS
170 REM
180 READ D$ \ FOR I=1 TO 3 \ READ L(I) \ NEXT I
190 FOR I=1 TO 4 \ READ C$(I) \ NEXT I
200 FOR I=1 TO 12 \ READ M9(I) \ NEXT I
210 FOR I=1 TO 12 \ READ M$(I) \ NEXT I
220 DATA "-"
230 DATA 23,28,33
240 DATA "P","E","I","*"
250 DATA 0,31,59,90,120,151,181,212,243,273,304,334
260 DATA "JANUARY","FEBRUARY","MARCH","APRIL","MAY","JUNE","JULY"
270 DATA "AUGUST","SEPTEMBER","OCTOBER","NOVEMBER","DECEMBER"
280 PRINT "OUTPUT DEV:FILNAM.EXT"; \ INPUT F$
290 IF F$="" THEN 310
300 GO TO 320
310 LET F$="TI:"
320 OPEN F$ FOR OUTPUT AS FILE #1
330 REM
340 REM -- RESET ARRAY P$
350 REM
360 FOR J=1 TO 41
370 FOR I=1 TO 93 \ V1$(93*(J-1)+I)=" " \ NEXT I
380 NEXT J
390 FOR I=1 TO 93
400 V1$(1860+I)="-"
410 NEXT I
420 REM
430 PRINT "INPUT BIRTHDATE IN FORMAT MMDDYYYY -- "; \ INPUT #0:N$
440 B2=VAL(SEG$(N$,1,2)) \ B1=VAL(SEG$(N$,3,4)) \ B3=VAL(SEG$(N$,5,8))
450 PRINT "INPUT DESIRED MONTH IN FORMAT MMYYYY -- "; \ INPUT #0:N$
460 C2=VAL(SEG$(N$,1,2)) \ C3=VAL(SEG$(N$,3,6))
470 REM
480 T0=FND(FNJ(B1,B2,B3),B3,FNJ(1,C2,C3),C3)
490 T=T0
500 REM
510 PRINT "NAME, PLEASE -- "; \ INPUT #0:N$
520 PRINT "INPUT ANY MISCELLANEOUS COMMENT HERE. " \ INPUT L$
530 PRINT  \ PRINT 
540 PRINT #1:TAB(50);N$
550 PRINT #1:,,L$ \ PRINT #1:
560 PRINT #1:,,"BIORHYTHM CHART FOR ";M$(C2);" ";C3
570 PRINT #1:
580 PRINT #1:,,"CHARTING THE PHYSICAL     - P (23 DAY CYCLE)"
590 PRINT #1:,,"             EMOTIONAL    - E (28 DAY CYCLE)"
600 PRINT #1:,,"             INTELLECTUAL - I (33 DAY CYCLE)"
610 PRINT #1:,,"         AND OVERALL      - *"
620 PRINT #1:,"THESE CYCLES ARE BELIEVED TO OCCUR IN ";
630 PRINT #1:"EVERYONE, BEGINNING ON THE DAY OF THEIR BIRTH."
640 PRINT #1: \ PRINT #1:,"NUMBER OF CYCLES SINCE BIRTH:  ";
650 FOR I=1 TO 3 \ PRINT #1:C$(I);" ";T/L(I), \ NEXT I
660 PRINT #1:
670 REM
680 REM -- COMPUTE THE CYCLES AND SET ARRAY P$
690 REM
700 LET P=3.14159
710 FOR I=1 TO 93
720 FOR K=1 TO 3
730 LET V(K)=-20*SIN(T/L(K)*2*P)
740 NEXT K
750 V(4)=(V(1)+V(2)+V(3))/3
760 FOR K=1 TO 4
770 K0=INT(ABS(V(K)+.5)*SGN(V(K)))+21
780 V1$(93*(K0-1)+I)=C$(K)
790 NEXT K
800 T=T+1/3
810 NEXT I
820 REM
830 REM -- PRINT ARRAY P$
840 REM
850 PRINT #1: \ PRINT #1:
860 FOR J=1 TO 41
870 PRINT #1:,"I ";
880 FOR I=1 TO 93 \ PRINT #1:V1$(93*(J-1)+I); \ NEXT I
890 PRINT #1:
900 NEXT J
910 PRINT #1:,"I--+-----------+--------------+--------------+------";
920 PRINT #1:"--------+--------------+--------------+---"
930 PRINT #1:,"   1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16 17";
940 PRINT #1:" 18 19 20 21 22 23 24 25 26 27 28 29 30 31"
950 PRINT #1: \ PRINT #1: \ PRINT #1: \ PRINT #1:TAB(48);M$(C2);" ";C3
960 PRINT #1:CHR$(12) \ CLOSE #1
970 END
