// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: userservice.proto

package protocol

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on NewAuditEventRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *NewAuditEventRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on NewAuditEventRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// NewAuditEventRequestMultiError, or nil if none found.
func (m *NewAuditEventRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *NewAuditEventRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for User_ID

	// no validation rules for Message

	if len(errors) > 0 {
		return NewAuditEventRequestMultiError(errors)
	}

	return nil
}

// NewAuditEventRequestMultiError is an error wrapping multiple validation
// errors returned by NewAuditEventRequest.ValidateAll() if the designated
// constraints aren't met.
type NewAuditEventRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m NewAuditEventRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m NewAuditEventRequestMultiError) AllErrors() []error { return m }

// NewAuditEventRequestValidationError is the validation error returned by
// NewAuditEventRequest.Validate if the designated constraints aren't met.
type NewAuditEventRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e NewAuditEventRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e NewAuditEventRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e NewAuditEventRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e NewAuditEventRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e NewAuditEventRequestValidationError) ErrorName() string {
	return "NewAuditEventRequestValidationError"
}

// Error satisfies the builtin error interface
func (e NewAuditEventRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sNewAuditEventRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = NewAuditEventRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = NewAuditEventRequestValidationError{}

// Validate checks the field values on AuditEventsListRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *AuditEventsListRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AuditEventsListRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AuditEventsListRequestMultiError, or nil if none found.
func (m *AuditEventsListRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *AuditEventsListRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Page

	// no validation rules for UserId

	if len(errors) > 0 {
		return AuditEventsListRequestMultiError(errors)
	}

	return nil
}

// AuditEventsListRequestMultiError is an error wrapping multiple validation
// errors returned by AuditEventsListRequest.ValidateAll() if the designated
// constraints aren't met.
type AuditEventsListRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AuditEventsListRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AuditEventsListRequestMultiError) AllErrors() []error { return m }

// AuditEventsListRequestValidationError is the validation error returned by
// AuditEventsListRequest.Validate if the designated constraints aren't met.
type AuditEventsListRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AuditEventsListRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AuditEventsListRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AuditEventsListRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AuditEventsListRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AuditEventsListRequestValidationError) ErrorName() string {
	return "AuditEventsListRequestValidationError"
}

// Error satisfies the builtin error interface
func (e AuditEventsListRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAuditEventsListRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AuditEventsListRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AuditEventsListRequestValidationError{}

// Validate checks the field values on AuditEvent with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *AuditEvent) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AuditEvent with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in AuditEventMultiError, or
// nil if none found.
func (m *AuditEvent) ValidateAll() error {
	return m.validate(true)
}

func (m *AuditEvent) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Id

	// no validation rules for User_ID

	// no validation rules for Message

	// no validation rules for Timestamp

	if len(errors) > 0 {
		return AuditEventMultiError(errors)
	}

	return nil
}

// AuditEventMultiError is an error wrapping multiple validation errors
// returned by AuditEvent.ValidateAll() if the designated constraints aren't met.
type AuditEventMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AuditEventMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AuditEventMultiError) AllErrors() []error { return m }

// AuditEventValidationError is the validation error returned by
// AuditEvent.Validate if the designated constraints aren't met.
type AuditEventValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AuditEventValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AuditEventValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AuditEventValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AuditEventValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AuditEventValidationError) ErrorName() string { return "AuditEventValidationError" }

// Error satisfies the builtin error interface
func (e AuditEventValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAuditEvent.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AuditEventValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AuditEventValidationError{}

// Validate checks the field values on AuditListResponse with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *AuditListResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AuditListResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AuditListResponseMultiError, or nil if none found.
func (m *AuditListResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *AuditListResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetEvents() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, AuditListResponseValidationError{
						field:  fmt.Sprintf("Events[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, AuditListResponseValidationError{
						field:  fmt.Sprintf("Events[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AuditListResponseValidationError{
					field:  fmt.Sprintf("Events[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for NumEvents

	if len(errors) > 0 {
		return AuditListResponseMultiError(errors)
	}

	return nil
}

// AuditListResponseMultiError is an error wrapping multiple validation errors
// returned by AuditListResponse.ValidateAll() if the designated constraints
// aren't met.
type AuditListResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AuditListResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AuditListResponseMultiError) AllErrors() []error { return m }

// AuditListResponseValidationError is the validation error returned by
// AuditListResponse.Validate if the designated constraints aren't met.
type AuditListResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AuditListResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AuditListResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AuditListResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AuditListResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AuditListResponseValidationError) ErrorName() string {
	return "AuditListResponseValidationError"
}

// Error satisfies the builtin error interface
func (e AuditListResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAuditListResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AuditListResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AuditListResponseValidationError{}

// Validate checks the field values on Nothing with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Nothing) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Nothing with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in NothingMultiError, or nil if none found.
func (m *Nothing) ValidateAll() error {
	return m.validate(true)
}

func (m *Nothing) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return NothingMultiError(errors)
	}

	return nil
}

// NothingMultiError is an error wrapping multiple validation errors returned
// by Nothing.ValidateAll() if the designated constraints aren't met.
type NothingMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m NothingMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m NothingMultiError) AllErrors() []error { return m }

// NothingValidationError is the validation error returned by Nothing.Validate
// if the designated constraints aren't met.
type NothingValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e NothingValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e NothingValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e NothingValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e NothingValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e NothingValidationError) ErrorName() string { return "NothingValidationError" }

// Error satisfies the builtin error interface
func (e NothingValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sNothing.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = NothingValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = NothingValidationError{}

// Validate checks the field values on ResetPasswordRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ResetPasswordRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ResetPasswordRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ResetPasswordRequestMultiError, or nil if none found.
func (m *ResetPasswordRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *ResetPasswordRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for UserID

	// no validation rules for OldPassword

	// no validation rules for NewPassword

	if len(errors) > 0 {
		return ResetPasswordRequestMultiError(errors)
	}

	return nil
}

// ResetPasswordRequestMultiError is an error wrapping multiple validation
// errors returned by ResetPasswordRequest.ValidateAll() if the designated
// constraints aren't met.
type ResetPasswordRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ResetPasswordRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ResetPasswordRequestMultiError) AllErrors() []error { return m }

// ResetPasswordRequestValidationError is the validation error returned by
// ResetPasswordRequest.Validate if the designated constraints aren't met.
type ResetPasswordRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ResetPasswordRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ResetPasswordRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ResetPasswordRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ResetPasswordRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ResetPasswordRequestValidationError) ErrorName() string {
	return "ResetPasswordRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ResetPasswordRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sResetPasswordRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ResetPasswordRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ResetPasswordRequestValidationError{}

// Validate checks the field values on SetRankRequest with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *SetRankRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on SetRankRequest with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in SetRankRequestMultiError,
// or nil if none found.
func (m *SetRankRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *SetRankRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for UserID

	// no validation rules for Rank

	if len(errors) > 0 {
		return SetRankRequestMultiError(errors)
	}

	return nil
}

// SetRankRequestMultiError is an error wrapping multiple validation errors
// returned by SetRankRequest.ValidateAll() if the designated constraints
// aren't met.
type SetRankRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SetRankRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SetRankRequestMultiError) AllErrors() []error { return m }

// SetRankRequestValidationError is the validation error returned by
// SetRankRequest.Validate if the designated constraints aren't met.
type SetRankRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SetRankRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SetRankRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SetRankRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SetRankRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SetRankRequestValidationError) ErrorName() string { return "SetRankRequestValidationError" }

// Error satisfies the builtin error interface
func (e SetRankRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSetRankRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SetRankRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SetRankRequestValidationError{}

// Validate checks the field values on BanUserRequest with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *BanUserRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on BanUserRequest with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in BanUserRequestMultiError,
// or nil if none found.
func (m *BanUserRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *BanUserRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for UserID

	if len(errors) > 0 {
		return BanUserRequestMultiError(errors)
	}

	return nil
}

// BanUserRequestMultiError is an error wrapping multiple validation errors
// returned by BanUserRequest.ValidateAll() if the designated constraints
// aren't met.
type BanUserRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BanUserRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BanUserRequestMultiError) AllErrors() []error { return m }

// BanUserRequestValidationError is the validation error returned by
// BanUserRequest.Validate if the designated constraints aren't met.
type BanUserRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BanUserRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BanUserRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BanUserRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BanUserRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BanUserRequestValidationError) ErrorName() string { return "BanUserRequestValidationError" }

// Error satisfies the builtin error interface
func (e BanUserRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBanUserRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BanUserRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BanUserRequestValidationError{}

// Validate checks the field values on BanUserResponse with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *BanUserResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on BanUserResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// BanUserResponseMultiError, or nil if none found.
func (m *BanUserResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *BanUserResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return BanUserResponseMultiError(errors)
	}

	return nil
}

// BanUserResponseMultiError is an error wrapping multiple validation errors
// returned by BanUserResponse.ValidateAll() if the designated constraints
// aren't met.
type BanUserResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BanUserResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BanUserResponseMultiError) AllErrors() []error { return m }

// BanUserResponseValidationError is the validation error returned by
// BanUserResponse.Validate if the designated constraints aren't met.
type BanUserResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BanUserResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BanUserResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BanUserResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BanUserResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BanUserResponseValidationError) ErrorName() string { return "BanUserResponseValidationError" }

// Error satisfies the builtin error interface
func (e BanUserResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBanUserResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BanUserResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BanUserResponseValidationError{}

// Validate checks the field values on GetUserIDsForUsernameRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *GetUserIDsForUsernameRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GetUserIDsForUsernameRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// GetUserIDsForUsernameRequestMultiError, or nil if none found.
func (m *GetUserIDsForUsernameRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *GetUserIDsForUsernameRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Username

	if len(errors) > 0 {
		return GetUserIDsForUsernameRequestMultiError(errors)
	}

	return nil
}

// GetUserIDsForUsernameRequestMultiError is an error wrapping multiple
// validation errors returned by GetUserIDsForUsernameRequest.ValidateAll() if
// the designated constraints aren't met.
type GetUserIDsForUsernameRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GetUserIDsForUsernameRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GetUserIDsForUsernameRequestMultiError) AllErrors() []error { return m }

// GetUserIDsForUsernameRequestValidationError is the validation error returned
// by GetUserIDsForUsernameRequest.Validate if the designated constraints
// aren't met.
type GetUserIDsForUsernameRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetUserIDsForUsernameRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetUserIDsForUsernameRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetUserIDsForUsernameRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetUserIDsForUsernameRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetUserIDsForUsernameRequestValidationError) ErrorName() string {
	return "GetUserIDsForUsernameRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetUserIDsForUsernameRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetUserIDsForUsernameRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetUserIDsForUsernameRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetUserIDsForUsernameRequestValidationError{}

// Validate checks the field values on GetUserIDsForUsernameResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *GetUserIDsForUsernameResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GetUserIDsForUsernameResponse with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// GetUserIDsForUsernameResponseMultiError, or nil if none found.
func (m *GetUserIDsForUsernameResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *GetUserIDsForUsernameResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return GetUserIDsForUsernameResponseMultiError(errors)
	}

	return nil
}

// GetUserIDsForUsernameResponseMultiError is an error wrapping multiple
// validation errors returned by GetUserIDsForUsernameResponse.ValidateAll()
// if the designated constraints aren't met.
type GetUserIDsForUsernameResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GetUserIDsForUsernameResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GetUserIDsForUsernameResponseMultiError) AllErrors() []error { return m }

// GetUserIDsForUsernameResponseValidationError is the validation error
// returned by GetUserIDsForUsernameResponse.Validate if the designated
// constraints aren't met.
type GetUserIDsForUsernameResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetUserIDsForUsernameResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetUserIDsForUsernameResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetUserIDsForUsernameResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetUserIDsForUsernameResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetUserIDsForUsernameResponseValidationError) ErrorName() string {
	return "GetUserIDsForUsernameResponseValidationError"
}

// Error satisfies the builtin error interface
func (e GetUserIDsForUsernameResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetUserIDsForUsernameResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetUserIDsForUsernameResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetUserIDsForUsernameResponseValidationError{}

// Validate checks the field values on GetForeignUserRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *GetForeignUserRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GetForeignUserRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// GetForeignUserRequestMultiError, or nil if none found.
func (m *GetForeignUserRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *GetForeignUserRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for OriginalWebsite

	// no validation rules for ForeignUserID

	if len(errors) > 0 {
		return GetForeignUserRequestMultiError(errors)
	}

	return nil
}

// GetForeignUserRequestMultiError is an error wrapping multiple validation
// errors returned by GetForeignUserRequest.ValidateAll() if the designated
// constraints aren't met.
type GetForeignUserRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GetForeignUserRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GetForeignUserRequestMultiError) AllErrors() []error { return m }

// GetForeignUserRequestValidationError is the validation error returned by
// GetForeignUserRequest.Validate if the designated constraints aren't met.
type GetForeignUserRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetForeignUserRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetForeignUserRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetForeignUserRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetForeignUserRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetForeignUserRequestValidationError) ErrorName() string {
	return "GetForeignUserRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetForeignUserRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetForeignUserRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetForeignUserRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetForeignUserRequestValidationError{}

// Validate checks the field values on GetForeignUserResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *GetForeignUserResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GetForeignUserResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// GetForeignUserResponseMultiError, or nil if none found.
func (m *GetForeignUserResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *GetForeignUserResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for NewUID

	if len(errors) > 0 {
		return GetForeignUserResponseMultiError(errors)
	}

	return nil
}

// GetForeignUserResponseMultiError is an error wrapping multiple validation
// errors returned by GetForeignUserResponse.ValidateAll() if the designated
// constraints aren't met.
type GetForeignUserResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GetForeignUserResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GetForeignUserResponseMultiError) AllErrors() []error { return m }

// GetForeignUserResponseValidationError is the validation error returned by
// GetForeignUserResponse.Validate if the designated constraints aren't met.
type GetForeignUserResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetForeignUserResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetForeignUserResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetForeignUserResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetForeignUserResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetForeignUserResponseValidationError) ErrorName() string {
	return "GetForeignUserResponseValidationError"
}

// Error satisfies the builtin error interface
func (e GetForeignUserResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetForeignUserResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetForeignUserResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetForeignUserResponseValidationError{}

// Validate checks the field values on ValidateJWTRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ValidateJWTRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ValidateJWTRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ValidateJWTRequestMultiError, or nil if none found.
func (m *ValidateJWTRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *ValidateJWTRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Jwt

	if len(errors) > 0 {
		return ValidateJWTRequestMultiError(errors)
	}

	return nil
}

// ValidateJWTRequestMultiError is an error wrapping multiple validation errors
// returned by ValidateJWTRequest.ValidateAll() if the designated constraints
// aren't met.
type ValidateJWTRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ValidateJWTRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ValidateJWTRequestMultiError) AllErrors() []error { return m }

// ValidateJWTRequestValidationError is the validation error returned by
// ValidateJWTRequest.Validate if the designated constraints aren't met.
type ValidateJWTRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ValidateJWTRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ValidateJWTRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ValidateJWTRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ValidateJWTRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ValidateJWTRequestValidationError) ErrorName() string {
	return "ValidateJWTRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ValidateJWTRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sValidateJWTRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ValidateJWTRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ValidateJWTRequestValidationError{}

// Validate checks the field values on ValidateJWTResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ValidateJWTResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ValidateJWTResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ValidateJWTResponseMultiError, or nil if none found.
func (m *ValidateJWTResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *ValidateJWTResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for IsValid

	// no validation rules for Uid

	if len(errors) > 0 {
		return ValidateJWTResponseMultiError(errors)
	}

	return nil
}

// ValidateJWTResponseMultiError is an error wrapping multiple validation
// errors returned by ValidateJWTResponse.ValidateAll() if the designated
// constraints aren't met.
type ValidateJWTResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ValidateJWTResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ValidateJWTResponseMultiError) AllErrors() []error { return m }

// ValidateJWTResponseValidationError is the validation error returned by
// ValidateJWTResponse.Validate if the designated constraints aren't met.
type ValidateJWTResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ValidateJWTResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ValidateJWTResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ValidateJWTResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ValidateJWTResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ValidateJWTResponseValidationError) ErrorName() string {
	return "ValidateJWTResponseValidationError"
}

// Error satisfies the builtin error interface
func (e ValidateJWTResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sValidateJWTResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ValidateJWTResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ValidateJWTResponseValidationError{}

// Validate checks the field values on RegisterRequest with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *RegisterRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RegisterRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RegisterRequestMultiError, or nil if none found.
func (m *RegisterRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *RegisterRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if err := m._validateEmail(m.GetEmail()); err != nil {
		err = RegisterRequestValidationError{
			field:  "Email",
			reason: "value must be a valid email address",
			cause:  err,
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetUsername()) > 10 {
		err := RegisterRequestValidationError{
			field:  "Username",
			reason: "value length must be at most 10 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_RegisterRequest_Username_Pattern.MatchString(m.GetUsername()) {
		err := RegisterRequestValidationError{
			field:  "Username",
			reason: "value does not match regex pattern \"^[a-zA-Z0-9]+$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for Password

	// no validation rules for ForeignUser

	// no validation rules for ForeignUserID

	// no validation rules for ForeignWebsite

	if len(errors) > 0 {
		return RegisterRequestMultiError(errors)
	}

	return nil
}

func (m *RegisterRequest) _validateHostname(host string) error {
	s := strings.ToLower(strings.TrimSuffix(host, "."))

	if len(host) > 253 {
		return errors.New("hostname cannot exceed 253 characters")
	}

	for _, part := range strings.Split(s, ".") {
		if l := len(part); l == 0 || l > 63 {
			return errors.New("hostname part must be non-empty and cannot exceed 63 characters")
		}

		if part[0] == '-' {
			return errors.New("hostname parts cannot begin with hyphens")
		}

		if part[len(part)-1] == '-' {
			return errors.New("hostname parts cannot end with hyphens")
		}

		for _, r := range part {
			if (r < 'a' || r > 'z') && (r < '0' || r > '9') && r != '-' {
				return fmt.Errorf("hostname parts can only contain alphanumeric characters or hyphens, got %q", string(r))
			}
		}
	}

	return nil
}

func (m *RegisterRequest) _validateEmail(addr string) error {
	a, err := mail.ParseAddress(addr)
	if err != nil {
		return err
	}
	addr = a.Address

	if len(addr) > 254 {
		return errors.New("email addresses cannot exceed 254 characters")
	}

	parts := strings.SplitN(addr, "@", 2)

	if len(parts[0]) > 64 {
		return errors.New("email address local phrase cannot exceed 64 characters")
	}

	return m._validateHostname(parts[1])
}

// RegisterRequestMultiError is an error wrapping multiple validation errors
// returned by RegisterRequest.ValidateAll() if the designated constraints
// aren't met.
type RegisterRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RegisterRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RegisterRequestMultiError) AllErrors() []error { return m }

// RegisterRequestValidationError is the validation error returned by
// RegisterRequest.Validate if the designated constraints aren't met.
type RegisterRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RegisterRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RegisterRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RegisterRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RegisterRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RegisterRequestValidationError) ErrorName() string { return "RegisterRequestValidationError" }

// Error satisfies the builtin error interface
func (e RegisterRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRegisterRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RegisterRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RegisterRequestValidationError{}

var _RegisterRequest_Username_Pattern = regexp.MustCompile("^[a-zA-Z0-9]+$")

// Validate checks the field values on LoginRequest with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *LoginRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on LoginRequest with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in LoginRequestMultiError, or
// nil if none found.
func (m *LoginRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *LoginRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Username

	// no validation rules for Password

	if len(errors) > 0 {
		return LoginRequestMultiError(errors)
	}

	return nil
}

// LoginRequestMultiError is an error wrapping multiple validation errors
// returned by LoginRequest.ValidateAll() if the designated constraints aren't met.
type LoginRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m LoginRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m LoginRequestMultiError) AllErrors() []error { return m }

// LoginRequestValidationError is the validation error returned by
// LoginRequest.Validate if the designated constraints aren't met.
type LoginRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LoginRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LoginRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LoginRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LoginRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LoginRequestValidationError) ErrorName() string { return "LoginRequestValidationError" }

// Error satisfies the builtin error interface
func (e LoginRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLoginRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LoginRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LoginRequestValidationError{}

// Validate checks the field values on LoginResponse with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *LoginResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on LoginResponse with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in LoginResponseMultiError, or
// nil if none found.
func (m *LoginResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *LoginResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Jwt

	if len(errors) > 0 {
		return LoginResponseMultiError(errors)
	}

	return nil
}

// LoginResponseMultiError is an error wrapping multiple validation errors
// returned by LoginResponse.ValidateAll() if the designated constraints
// aren't met.
type LoginResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m LoginResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m LoginResponseMultiError) AllErrors() []error { return m }

// LoginResponseValidationError is the validation error returned by
// LoginResponse.Validate if the designated constraints aren't met.
type LoginResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LoginResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LoginResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LoginResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LoginResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LoginResponseValidationError) ErrorName() string { return "LoginResponseValidationError" }

// Error satisfies the builtin error interface
func (e LoginResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLoginResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LoginResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LoginResponseValidationError{}

// Validate checks the field values on RegisterResponse with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *RegisterResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RegisterResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RegisterResponseMultiError, or nil if none found.
func (m *RegisterResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *RegisterResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Jwt

	if len(errors) > 0 {
		return RegisterResponseMultiError(errors)
	}

	return nil
}

// RegisterResponseMultiError is an error wrapping multiple validation errors
// returned by RegisterResponse.ValidateAll() if the designated constraints
// aren't met.
type RegisterResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RegisterResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RegisterResponseMultiError) AllErrors() []error { return m }

// RegisterResponseValidationError is the validation error returned by
// RegisterResponse.Validate if the designated constraints aren't met.
type RegisterResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RegisterResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RegisterResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RegisterResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RegisterResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RegisterResponseValidationError) ErrorName() string { return "RegisterResponseValidationError" }

// Error satisfies the builtin error interface
func (e RegisterResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRegisterResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RegisterResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RegisterResponseValidationError{}

// Validate checks the field values on GetUserFromIDRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *GetUserFromIDRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GetUserFromIDRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// GetUserFromIDRequestMultiError, or nil if none found.
func (m *GetUserFromIDRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *GetUserFromIDRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for UserID

	if len(errors) > 0 {
		return GetUserFromIDRequestMultiError(errors)
	}

	return nil
}

// GetUserFromIDRequestMultiError is an error wrapping multiple validation
// errors returned by GetUserFromIDRequest.ValidateAll() if the designated
// constraints aren't met.
type GetUserFromIDRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GetUserFromIDRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GetUserFromIDRequestMultiError) AllErrors() []error { return m }

// GetUserFromIDRequestValidationError is the validation error returned by
// GetUserFromIDRequest.Validate if the designated constraints aren't met.
type GetUserFromIDRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetUserFromIDRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetUserFromIDRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetUserFromIDRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetUserFromIDRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetUserFromIDRequestValidationError) ErrorName() string {
	return "GetUserFromIDRequestValidationError"
}

// Error satisfies the builtin error interface
func (e GetUserFromIDRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetUserFromIDRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetUserFromIDRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetUserFromIDRequestValidationError{}

// Validate checks the field values on UserResponse with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *UserResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UserResponse with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in UserResponseMultiError, or
// nil if none found.
func (m *UserResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *UserResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Username

	// no validation rules for Email

	// no validation rules for Rank

	// no validation rules for Banned

	if len(errors) > 0 {
		return UserResponseMultiError(errors)
	}

	return nil
}

// UserResponseMultiError is an error wrapping multiple validation errors
// returned by UserResponse.ValidateAll() if the designated constraints aren't met.
type UserResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UserResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UserResponseMultiError) AllErrors() []error { return m }

// UserResponseValidationError is the validation error returned by
// UserResponse.Validate if the designated constraints aren't met.
type UserResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UserResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UserResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UserResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UserResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UserResponseValidationError) ErrorName() string { return "UserResponseValidationError" }

// Error satisfies the builtin error interface
func (e UserResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUserResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UserResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UserResponseValidationError{}
