﻿<% 
  '**************************************************************** 
  '函数名称：js_checkform(frmName,errStr) 
  '功能：用ASP的方法动态写出javascript的表单验证的函数checksubmit() 
  '使用方法：1、<!--Include File=URL+本函数所在的页>; 
  ' 2、<form onsubmit="javascript:return checksubmit();">; 
  '**************************************************************** 
  '帮助： 
  '--------------------------------------------------------------- 
  '·参数说明： 
  'frmName:表单域的名称 
  'errStr:验证列表，如："num|3|型号必须不小于8位|8,email|5|请输入正确的email格式"，这里 
  ' num表示表单域名称，3表示验证参数，8表示不小于的位数（可选） 
  ' 
  '·验证参数列表： 
  '0:必填的Text类型 
  '1:必填的ListMenu类型 
  '2:必须为数字的Text类型 
  '3:必须为指定位数的Text类型 
  '4:必须大于指定位数的Text类型 
  '5:必须为Email的Text类型 
  '6:必须为a-z或0-9的字符的Text类型 
  '7:确认密码和密码必须相等的Text类型 
  '8:确认不是以以数字开头的Text类型 
  '9:必须包含10-888888格式的Text类型 
  '10:不得包含中文、空格及其他非法字符的Text类型，即只能包含"_""-""0-9""a-z"A-Z" 
  '11:必须只包含数字及"-"在内的Text类型 
  '12:必须为正确网址的Text类型 
  '13:必须小于指定位数的Text类型 
  '14:不得包含HTML标记的Text类型 
  '15:确认未被禁用的Select类型必须选择 格式:检查的表单项|15|提示信息|关联项" 
  '注意：如有级联菜单，请将级联菜单的验证过程放到最后检验！！！！ 
  '------------------------------------------------------------------------ 
  %> 
  <% 
  Sub js_checkform(frmName,errStr) 
  Dim tmpArr 
  Dim i 
  Dim strShow '输出JS的字符串 
   '获取错误列表，建立数组 
   tmpArr=Split(errStr,",") 
   '写JS 
   for i=0 to UBound(tmpArr) 
   if i<>0 then 
   strShow=strShow&"else "&findJS(frmName,tmpArr(i)) 
  else 
   strShow=strShow&findJS(frmName,tmpArr(i)) 
  end if 
   next 
   '输出 
   strShow="<script language='javascript' type='text/javascript'>"&vbCrlf&_ 
   "<!--"&vbCrlf&_ 
   "//Power by Guoquanman 2004"&vbCrlf&_ 
   "function checksubmit()"&vbCrlf&_ 
   "{"&vbCrlf&_ 
   "var emailReg = /^[_a-z0-9]+@([_a-z0-9]+\.)+[a-z0-9]{2,3}$/;"&vbCrlf&_ 
   "var pwdReg = /[a-z0-9]$/;"&vbCrlf&_ 
   "var uidBeginReg = /^[0-9]+[_a-z0-9]/;"&vbCrlf&_ 
   "var phoneReg = /\d{2}-\d{5}/;"&vbCrlf&_ 
   "var phoneDetailReg = /[^0-9\-]/;"&vbCrlf&_ 
   "var uidReg = /[^a-zA-Z0-9_\-]/;"&vbCrlf&_ 
   "var htmlReg = /<(.*)>.*<\/\1>/;"&vbCrlf&_ 
   
   "var re1 = /^http:\/\/[A-Za-z][A-Za-z0-9\-]*[A-Za-z]*\./;"&vbCrlf&_ 
   "var re2 = /^http:\/\/[0-9]{1,5}[A-Za-z]*[0-9]*\./;"&vbCrlf&_ 
   "var re3 = /\.{2,}/;"&vbCrlf&_ 
   "var re4 = /\:{2,}/;"&vbCrlf&_ 
   "var re5 = /\/{3,}/;"&vbCrlf&_ 
   "var re6 = /\,+/;"&vbCrlf&_ 
   "var re7 = /\!+/;"&vbCrlf&_ 
   "var re8 = /\@+/;"&vbCrlf&_ 
   "var re9 = /\#+/;"&vbCrlf&_ 
   "var re10 = /\$+/;"&vbCrlf&_ 
   "var re11 = /\^+/;"&vbCrlf&_ 
   "var re12 = /\*+/;"&vbCrlf&_ 
   "var re13 = /\|+/;"&vbCrlf&_ 
   "var re14 = /\.[a-z0-9_&=?\/]*[A-Za-z0-9\/\~]{2,}$/;"&vbCrlf&_ 
   strShow&_ 
   "else"&vbCrlf&_ 
   "return true;"&vbCrlf&_ 
   "}"&vbCrlf&_ 
   "//-->"&vbCrlf&_ 
   "</script>" 
   Response.Write strShow 
  End Sub 
   
  Function findJS(frmName,errStr) 
  Dim tmpArr 
  Dim i 
   '参数值 
   i=0 
   '获取错误列表，建立数组 
   tmpArr=Split(errStr,"|") 
   '输出查询条件 
   Select Case tmpArr(i+1) 
   
   
   Case "0" '必填的Text类型 
   findJS="if ((document."&frmName&"."&tmpArr(i)&".value)=="""")"&vbCrlf&_ 
   "{"&vbCrlf&_ 
  "window.alert ('"&tmpArr(i+2)&"');"&vbCrlf&_ 
  "document."&frmName&"."&tmpArr(i)&".select();"&vbCrlf&_ 
  "document."&frmName&"."&tmpArr(i)&".focus();"&vbCrlf&_ 
  "return false;"&vbCrlf&_ 
   "}"&vbCrlf 
   
   Exit Function 
   
   
   Case "1" '必填的ListMenu类型 
   findJS="if ((document."&frmName&"."&tmpArr(i)&".value)=="""")"&vbCrlf&_ 
   "{"&vbCrlf&_ 
   "window.alert ('"&tmpArr(i+2)&"');"&vbCrlf&_ 
   "document."&frmName&"."&tmpArr(i)&".focus();"&vbCrlf&_ 
  "return false;"&vbCrlf&_ 
   "}"&vbCrlf 
   Exit Function 
   
   
   Case "2" '必须为数字的Text类型 
   findJS="if (isNaN(document."&frmName&"."&tmpArr(i)&".value))"&vbCrlf&_ 
   "{"&vbCrlf&_ 
   "window.alert ('"&tmpArr(i+2)&"');"&vbCrlf&_ 
  "document."&frmName&"."&tmpArr(i)&".select();"&vbCrlf&_ 
   "document."&frmName&"."&tmpArr(i)&".focus();"&vbCrlf&_ 
  "return false;"&vbCrlf&_ 
   "}"&vbCrlf 
   Exit Function 
   
   
   Case "3" '必须为指定位数的Text类型 
   findJS="if (document."&frmName&"."&tmpArr(i)&".value.length!="&tmpArr(i+3)&")"&vbCrlf&_ 
   "{"&vbCrlf&_ 
   "window.alert ('"&tmpArr(i+2)&"');"&vbCrlf&_ 
  "document."&frmName&"."&tmpArr(i)&".select();"&vbCrlf&_ 
   "document."&frmName&"."&tmpArr(i)&".focus();"&vbCrlf&_ 
  "return false;"&vbCrlf&_ 
   "}"&vbCrlf 
   Exit Function 
   
   
   Case "4" '必须大于指定位数的Text类型 
   findJS="if (document."&frmName&"."&tmpArr(i)&".value.length<"&tmpArr(i+3)&")"&vbCrlf&_ 
   "{"&vbCrlf&_ 
   "window.alert ('"&tmpArr(i+2)&"');"&vbCrlf&_ 
  "document."&frmName&"."&tmpArr(i)&".select();"&vbCrlf&_ 
   "document."&frmName&"."&tmpArr(i)&".focus();"&vbCrlf&_ 
  "return false;"&vbCrlf&_ 
   "}"&vbCrlf 
   Exit Function 
   
   
   Case "5" '必须为Email的Text类型 
   findJS="if ((!emailReg.test(document."&frmName&"."&tmpArr(i)&".value))&&(document."&frmName&"."&tmpArr(i)&".value!=''))"&vbCrlf&_ 
   "{"&vbCrlf&_ 
   "window.alert ('"&tmpArr(i+2)&"');"&vbCrlf&_ 
  "document."&frmName&"."&tmpArr(i)&".select();"&vbCrlf&_ 
   "document."&frmName&"."&tmpArr(i)&".focus();"&vbCrlf&_ 
  "return false;"&vbCrlf&_ 
   "}"&vbCrlf 
   Exit Function 
   
   
   Case "6" '必须为a-z或0-9的字符的Text类型 
   findJS="if ((!pwdReg.test(document."&frmName&"."&tmpArr(i)&".value))&&(document."&frmName&"."&tmpArr(i)&".value!=''))"&vbCrlf&_ 
   "{"&vbCrlf&_ 
   "window.alert ('"&tmpArr(i+2)&"');"&vbCrlf&_ 
  "document."&frmName&"."&tmpArr(i)&".select();"&vbCrlf&_ 
   "document."&frmName&"."&tmpArr(i)&".focus();"&vbCrlf&_ 
  "return false;"&vbCrlf&_ 
  "}"&vbCrlf 
   Exit Function 
   
   
   Case "7" '确认密码和密码必须相等的Text类型 
   findJS="if ((document."&frmName&"."&tmpArr(i)&".value)!=(document."&frmName&"."&tmpArr(i+3)&".value))"&vbCrlf&_ 
   "{"&vbCrlf&_ 
   "window.alert ('"&tmpArr(i+2)&"');"&vbCrlf&_ 
  "document."&frmName&"."&tmpArr(i)&".select();"&vbCrlf&_ 
   "document."&frmName&"."&tmpArr(i)&".focus();"&vbCrlf&_ 
  "return false;"&vbCrlf&_ 
   "}"&vbCrlf 
   Exit Function 
   
   
   Case "8" '确认以数字开头的Text类型 
   findJS="if ((uidBeginReg.test(document."&frmName&"."&tmpArr(i)&".value))&&(document."&frmName&"."&tmpArr(i)&".value!=''))"&vbCrlf&_ 
   "{"&vbCrlf&_ 
   "window.alert ('"&tmpArr(i+2)&"');"&vbCrlf&_ 
  "document."&frmName&"."&tmpArr(i)&".select();"&vbCrlf&_ 
   "document."&frmName&"."&tmpArr(i)&".focus();"&vbCrlf&_ 
  "return false;"&vbCrlf&_ 
   "}"&vbCrlf 
   Exit Function 
   
   
   Case "9" '确认10-101212格式的电话号码 
   findJS="if ((!phoneReg.test(document."&frmName&"."&tmpArr(i)&".value))&&(document."&frmName&"."&tmpArr(i)&".value!=''))"&vbCrlf&_ 
   "{"&vbCrlf&_ 
   "window.alert ('"&tmpArr(i+2)&"');"&vbCrlf&_ 
  "document."&frmName&"."&tmpArr(i)&".select();"&vbCrlf&_ 
   "document."&frmName&"."&tmpArr(i)&".focus();"&vbCrlf&_ 
  "return false;"&vbCrlf&_ 
   "}"&vbCrlf 
   Exit Function 
   
   
   Case "10" '确认只包含英文字母及"-","_"在内的Text。（即不包括中文及其他特殊字符） 
   findJS="if ((uidReg.test(document."&frmName&"."&tmpArr(i)&".value))&&(document."&frmName&"."&tmpArr(i)&".value!=''))"&vbCrlf&_ 
   "{"&vbCrlf&_ 
   "window.alert ('"&tmpArr(i+2)&"');"&vbCrlf&_ 
  "document."&frmName&"."&tmpArr(i)&".select();"&vbCrlf&_ 
   "document."&frmName&"."&tmpArr(i)&".focus();"&vbCrlf&_ 
  "return false;"&vbCrlf&_ 
   "}"&vbCrlf 
   Exit Function 
   
   
   Case "11" '确认只包含数字及"-"在内的Text类型（电话号码及传真常用） 
   findJS="if ((phoneDetailReg.test(document."&frmName&"."&tmpArr(i)&".value))&&(document."&frmName&"."&tmpArr(i)&".value!=''))"&vbCrlf&_ 
   "{"&vbCrlf&_ 
   "window.alert ('"&tmpArr(i+2)&"');"&vbCrlf&_ 
  "document."&frmName&"."&tmpArr(i)&".select();"&vbCrlf&_ 
   "document."&frmName&"."&tmpArr(i)&".focus();"&vbCrlf&_ 
  "return false;"&vbCrlf&_ 
   "}"&vbCrlf 
   Exit Function 
   
   
   Case "12" '确认是否为有效网址！ 
   findJS="if (((!re1.test(document."&frmName&"."&tmpArr(i)&".value))&&(!re2.test(document."&frmName&"."&tmpArr(i)&".value))"&_ 
   "&&(document."&frmName&"."&tmpArr(i)&".value!=''))||"&_ 
   "(re3.test(document."&frmName&"."&tmpArr(i)&".value))||(re4.test(document."&frmName&"."&tmpArr(i)&".value))||"&_ 
   "(re5.test(document."&frmName&"."&tmpArr(i)&".value))||(re6.test(document."&frmName&"."&tmpArr(i)&".value))||"&_ 
   "(re7.test(document."&frmName&"."&tmpArr(i)&".value))||(re8.test(document."&frmName&"."&tmpArr(i)&".value))||"&_ 
   "(re9.test(document."&frmName&"."&tmpArr(i)&".value))||(re10.test(document."&frmName&"."&tmpArr(i)&".value))||"&_ 
   "(re11.test(document."&frmName&"."&tmpArr(i)&".value))||(re12.test(document."&frmName&"."&tmpArr(i)&".value))||"&_ 
   "(re13.test(document."&frmName&"."&tmpArr(i)&".value))||(!re14.test(document."&frmName&"."&tmpArr(i)&".value))"&_ 
   "&&(document."&frmName&"."&tmpArr(i)&".value!=''))"&vbCrlf&_ 
   "{"&vbCrlf&_ 
   "window.alert('"&tmpArr(i+2)&"');"&vbCrlf&_ 
  "document."&frmName&"."&tmpArr(i)&".select();"&vbCrlf&_ 
   "document."&frmName&"."&tmpArr(i)&".focus();"&vbCrlf&_ 
  "return false;"&vbCrlf&_ 
   "}"&vbCrlf 
   
   Exit Function 
   
   
   Case "13" '确认不大于固定位数的Text类型 
   findJS="if (document."&frmName&"."&tmpArr(i)&".value.length>"&tmpArr(i+3)&")"&vbCrlf&_ 
   "{"&vbCrlf&_ 
   "window.alert('"&tmpArr(i+2)&"');"&vbCrlf&_ 
  "document."&frmName&"."&tmpArr(i)&".select();"&vbCrlf&_ 
   "document."&frmName&"."&tmpArr(i)&".focus();"&vbCrlf&_ 
  "return false;"&vbCrlf&_ 
   "}"&vbCrlf 
   Exit Function 
   
   
   Case "14" '确认含有HTML标记的Text类型 
   findJS="if(htmlReg.test(document."&frmName&"."&tmpArr(i)&".value))"&vbCrlf&_ 
   "{"&vbCrlf&_ 
   "window.alert('"&tmpArr(i+2)&"');"&vbCrlf&_ 
  "document."&frmName&"."&tmpArr(i)&".select();"&vbCrlf&_ 
   "document."&frmName&"."&tmpArr(i)&".focus();"&vbCrlf&_ 
  "return false;"&vbCrlf&_ 
   "}"&vbCrlf 
   Exit Function 
   
   
   Case "15" 
  '========================================================== 
  ' 确认未被禁用的Select类型必须选择 格式:state|15|请选择所在省名称！|selCountry|city|请选择城市信息 
  '注：级联菜单第1项当selectedIndex!=0时，第2项第3项被禁用！无须检查其他两项 
  '当级联菜单第1项selectedIndex==0时，第2项的selectedIndex不能为0,第二项的selectedIndex!=0时，第3项的selectedIndex也不能为0 
  '此项用于检查国家/省/市三项级联菜单，当国家不为中国时，省市可不填，为中国时，必须填写省以及相对的市！ 
   findJS="if (document."&frmName&"."&tmpArr(i+3)&".selectedIndex ==0)"&vbCrlf&_ 
   "{"&vbCrlf&_ 
   "if (document."&frmName&"."&tmpArr(i)&".selectedIndex ==0)"&vbCrlf&_ 
   "{"&vbCrlf&_ 
   "window.alert('"&tmpArr(i+2)&"');"&vbCrlf&_ 
   "document."&frmName&"."&tmpArr(i)&".focus;"&vbCrlf&_ 
   "return false;"&vbCrlf&_ 
   "}"&vbCrlf&_ 
   "else if (document."&frmName&"."&tmpArr(i)&".selectedIndex != 0)"&vbCrlf&_ 
   "{"&vbCrlf&_ 
   "if (document."&frmName&"."&tmpArr(i+4)&".selectedIndex == 0)"&vbCrlf&_ 
   "{"&vbCrlf&_ 
   "window.alert('"&tmpArr(i+5)&"');"&vbCrlf&_ 
   "document."&frmName&"."&tmpArr(i+4)&".focus;"&vbCrlf&_ 
   "return false;"&vbCrlf&_ 
   "}"&vbCrlf&_ 
   
   
   "}"&vbCrlf&_ 
   
   "}"&vbCrlf 
   Exit Function 
   
   Case "16" '确认未被禁用的Select类型必须选择 格式:检查的表单项|16|提示信息|关联项"注：当关联项为第一项时，确认开始！ 
   findJS="if (document."&frmName&"."&tmpArr(i+3)&".selectedIndex != 0)"&vbCrlf&_ 
   "{"&vbCrlf&_ 
   "if (document."&frmName&"."&tmpArr(i)&".selectedIndex == 0)"&vbCrlf&_ 
   "{"&vbCrlf&_ 
   "window.alert('"&tmpArr(i+2)&"');"&vbCrlf&_ 
   "document."&frmName&"."&tmpArr(i)&".focus;"&vbCrlf&_ 
   "return false;"&vbCrlf&_ 
   "}"&vbCrlf&_ 
   
   
   "}"&vbCrlf 
   Exit Function 
   
   
   End Select 
  End Function 
  %> 
   