<%

'********************************************
'函数名：IsValidEmail
'作  用：检查Email地址合法性
'参  数：email ----要检查的Email地址
'返回值：True  ----Email地址合法
'       False ----Email地址不合法
'********************************************
Function IsValidEmail(email)
	dim names, name, i, c
	IsValidEmail = true
	names = Split(email, "@")
	if UBound(names) <> 1 then
	   IsValidEmail = false
	   exit function
	end if
	for each name in names
		if Len(name) <= 0 then
			IsValidEmail = false
    		exit function
		end if
		for i = 1 to Len(name)
		    c = Lcase(Mid(name, i, 1))
			if InStr("abcdefghijklmnopqrstuvwxyz_-.", c) <= 0 and not IsNumeric(c) then
		       IsValidEmail = false
		       exit function
		     end if
	   next
	   if Left(name, 1) = "." or Right(name, 1) = "." then
    	  IsValidEmail = false
	      exit function
	   end if
	next
	if InStr(names(1), ".") <= 0 then
		IsValidEmail = false
	   exit function
	end if
	i = Len(names(1)) - InStrRev(names(1), ".")
	if i <> 2 and i <> 3 then
	   IsValidEmail = false
	   exit function
	end if
	if InStr(email, "..") > 0 then
	   IsValidEmail = false
	end if
End Function

'********************************************
'函数名：MailServer
'作  用：发送邮件
'参  数：SendMail,MailTitle,MailBody,IfHtml ----收信人，主题，内容,是否html
'返回值：True  ----Email发送成功
'        False ----Email发送失败
'       
'********************************************
Function MailServer(SendMail,MailTitle,MailBody,IfHtml)'邮件发送程序(收信人，主题，内容, 是否html)
	on error resume next
	
	if not IsObjInstalled("JMail.SmtpMail") then'检测是否装了Jmail组件
	MailServer=false
	exit function
	end if
	if IsValidEmail(SendMail)=false then'判断收信人地址是否正确
	MailServer=false
	exit function
	end if
	if ifhtml=true or ifhtml=1 then'是否发送html邮件
	MailBody=html_encode(MailBody)
	end if
		Dim JMail
		Set JMail=server.createobject("JMail.Message")
		JMail.silent = true 
		JMail.Logging = true 
		JMail.Charset = "gb2312" 
		JMail.MailServerUserName =Application("Sys_Email_set")(1) 	'发送帐号
		JMail.MailServerPassword = Application("Sys_Email_set")(2)		'发送密码
		JMail.From =Application("Sys_Email_set")(3)				'发送地址
		JMail.FromName = Application("Sys_Email_set")(4)		'邮件标题
		JMail.AddRecipient SendMail					'接收地址
		JMail.Subject =MailTitle 			'邮件标题
		
		if ifhtml=true or ifhtml=1 then
		JMail.Body="请使用html格式阅读此邮件，谢谢！"&vbcrlf
		MailBody="<html><body><div style='font-size:12px;line-height:150%'>"&MailBody&"</div></body></html>"
		JMail.appendhtml(MailBody)
		else
		JMail.Body  =MailBody
		end if										'邮件内容
		JMail.Send (""&Application("Sys_Email_set")(0)&"")		'SMTP服务器
		JMail.Priority=1
		JMail.Close()
		set JMail = nothing 
	set rs = nothing
	MailServer=true
End Function
function Html_Encode(Str)
   if trim(Str)="" or isnull(str) then
   exit function
   end if
    str=replace(str,"&#39;",chr(39))
    Str = Replace(Str,chr(13), "")
    Str = Replace(Str,chr(10),"<BR>")
   Html_Encode = Str
end function



'***************************************************
'函数名：IsObjInstalled
'作  用：检查组件是否已经安装
'参  数：strClassString ----组件名
'返回值：True  ----已经安装
'       False ----没有安装
'***************************************************
Function IsObjInstalled(strClassString)
	On Error Resume Next
	IsObjInstalled = False
	Err = 0
	Dim xTestObj
	Set xTestObj = Server.CreateObject(strClassString)
	If 0 = Err Then IsObjInstalled = true
	Set xTestObj = Nothing
	Err = 0
End Function

Dim SendMail

function SendJmail(email,topic,mailbody)
	on error resume next
	dim JMail,sendflag
	Set JMail=Server.CreateObject("JMail.Message")
	JMail.silent=true
	JMail.Logging=True
	JMail.Charset="gb2312"
	JMail.MailServerUserName =Application("Sys_Email_set")(1) '您的邮件服务器登录名
	JMail.MailServerPassword = Application("Sys_Email_set")(2) '登录密码
	JMail.ContentType = "text/html"
	JMail.Priority = 1
	JMail.From =Application("Sys_Email_set")(3)  '邮件地址
	JMail.FromName =Application("Sys_Email_set")(4)  '网站名称
	JMail.AddRecipient email
	JMail.Subject = topic
	JMail.Body = mailbody
	JMail.Send (""&Application("Sys_Email_set")(0)&"")   '发邮件服务器地址
	Set JMail=nothing
	sendflag=True
	If err then sendflag=False
	SendJmail=sendflag
end function
	
sub Cdonts(email,topic,mailbody)
	on error resume next
	dim  objCDOMail
	Set objCDOMail = Server.CreateObject("CDONTS.NewMail")
	objCDOMail.From =Application("Sys_Email_set")(3)  '邮件地址
	objCDOMail.To = email
	objCDOMail.Subject = topic
	objCDOMail.BodyFormat = 0 
	objCDOMail.MailFormat = 0 
	objCDOMail.Body = mailbody
	objCDOMail.Send
	Set objCDOMail = Nothing
	SendMail="OK"
	If err then SendMail="False"
end sub

sub aspemail(email,topic,mailbody)
	on error resume next
	dim Mailer
	Set Mailer=Server.CreateObject("Persits.MailSender") 
	Mailer.Charset = "gb2312"
	Mailer.IsHTML = True
	Mailer.username =Application("Sys_Email_set")(1)	'服务器上有效的用户名
	Mailer.password =Application("Sys_Email_set")(2)	'服务器上有效的密码
	Mailer.Priority = 1
	Mailer.Host = Application("Sys_Email_set")(0)
	Mailer.Port = 25 ' 该项可选.端口25是默认值
	Mailer.From = Application("Sys_Email_set")(3)   '邮件地址
	Mailer.FromName = Application("Sys_Email_set")(4) ' 该项可选
	Mailer.AddAddress email,email
	Mailer.Subject = topic
	Mailer.Body = mailbody
	Mailer.Send
	SendMail="OK"
	If err then SendMail="False"
end sub
%>