

DROP TABLE IF EXISTS `hkcms_admin`;
CREATE TABLE `hkcms_admin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '登录名称',
  `nickname` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '昵称',
  `email` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '邮箱',
  `password` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '密码',
  `salt` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '密码盐',
  `avatar` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '头像',
  `remark` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '备注',
  `logintime` int(11) DEFAULT NULL COMMENT '登录时间',
  `loginip` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '登录IP',
  `status` enum('normal','hidden') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'normal' COMMENT '状态:normal-正常,hidden-禁用',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uniaue_username` (`username`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='后台管理员';



DROP TABLE IF EXISTS `hkcms_admin_log`;
CREATE TABLE `hkcms_admin_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `admin_id` int(10) unsigned NOT NULL COMMENT '用户id',
  `username` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '用户名',
  `useragent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'useragent',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '标题',
  `url` varchar(1500) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'URL',
  `ip` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'IP地址',
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '内容',
  `create_time` int(11) NOT NULL COMMENT '操作时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='后台操作日志';



DROP TABLE IF EXISTS `hkcms_admin_panel`;
CREATE TABLE `hkcms_admin_panel` (
  `auth_rule_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '菜单ID',
  `admin_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  UNIQUE KEY `userid` (`auth_rule_id`,`admin_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='管理后台常用菜单';



DROP TABLE IF EXISTS `hkcms_app`;
CREATE TABLE `hkcms_app` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL COMMENT '应用标识',
  `title` varchar(80) NOT NULL COMMENT '标题',
  `image` varchar(80) NOT NULL DEFAULT '' COMMENT '封面',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '价格',
  `module` varchar(20) NOT NULL DEFAULT '' COMMENT '所属模块',
  `type` enum('addon','module','template') NOT NULL COMMENT '类型',
  `config` text COMMENT '配置信息',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '描述',
  `author` varchar(50) NOT NULL DEFAULT '' COMMENT '作者',
  `version` varchar(20) NOT NULL COMMENT '版本',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态:1-启用,0-未安装,-1-禁用',
  `createtime` int(11) DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='应用表';

INSERT INTO `hkcms_app` VALUES ('3', 'simditor', 'simditor编辑器', 'http://api.hkcms.cn/uploads/20210319/6d1cbf8f5d89c8eb0248282df29686ae.png', '0.00', '', 'addon', null, 'simditor编辑器', 'HkCms', '1.0.1', '1', '1618552757');
INSERT INTO `hkcms_app` VALUES ('10', 'adminlte', '后台模板', '', '0.00', 'admin', 'template', null, '默认后台模板主题，更多主题前往应用市场下载安装。', 'HkCms', '1.0.0', '1', '1618564047');
INSERT INTO `hkcms_app` VALUES ('12', 'address', '地图位置选取插件', '', '0.00', '', 'addon', '', '支持百度、高德地图位置选取。', 'HkCms', '1.0.0', '1', '1618566933');
INSERT INTO `hkcms_app` VALUES ('15', 'abzbzs2', '双语言响应式珠宝展示模板', '', '0.00', 'index', 'template', null, '双语言响应式珠宝展示模板', '不善言谈', '1.0.0', '1', '1659543544');


DROP TABLE IF EXISTS `hkcms_archives`;
CREATE TABLE `hkcms_archives` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL COMMENT '栏目ID',
  `model_id` int(11) NOT NULL COMMENT '模型ID',
  `admin_id` int(11) NOT NULL COMMENT '管理员ID',
  `title` varchar(200) NOT NULL DEFAULT '' COMMENT '标题',
  `thumb` varchar(100) NOT NULL DEFAULT '' COMMENT '缩略封面图',
  `seotitle` varchar(200) NOT NULL DEFAULT '' COMMENT 'SEO标题',
  `keywords` varchar(200) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(250) NOT NULL DEFAULT '' COMMENT '描述',
  `tags` varchar(255) NOT NULL DEFAULT '' COMMENT '标签',
  `show_tpl` char(100) NOT NULL DEFAULT 'show.html' COMMENT '内容模板',
  `publish_time` int(11) DEFAULT NULL COMMENT '发布时间',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  `delete_time` int(11) DEFAULT NULL COMMENT '删除时间',
  `weigh` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `author` char(250) NOT NULL DEFAULT '小编' COMMENT '作者',
  `url` char(250) NOT NULL DEFAULT '' COMMENT 'URL',
  `views` int(11) NOT NULL DEFAULT '0' COMMENT '浏览量',
  `lang` varchar(20) NOT NULL DEFAULT '' COMMENT '语言标识',
  `status` enum('normal','hidden','reject','audit') NOT NULL DEFAULT 'normal' COMMENT '状态',
  `flags` varchar(100) NOT NULL DEFAULT '' COMMENT '文档属性',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

INSERT INTO `hkcms_archives` VALUES ('1', '6', '1', '1', 'Honor certificate', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/honor.jpg', '', '', '', '', 'show.html', '1636988345', '1636988345', '1636988345', null, '0', '小编', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('2', '6', '1', '1', 'Honor certificate', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/honor.jpg', '', '', '', '', 'show.html', '1636988374', '1636988374', '1636988374', null, '0', '小编', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('3', '6', '1', '1', 'Honor certificate', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/honor.jpg', '', '', '', '', 'show.html', '1636988383', '1636988383', '1636988383', null, '0', '小编', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('4', '6', '1', '1', 'Honor certificate', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/honor.jpg', '', '', '', '', 'show.html', '1636988390', '1636988390', '1636988390', null, '0', '小编', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('5', '5', '1', '1', '荣誉证书', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/honor.jpg', '', '', '', '', 'show.html', '1636988665', '1636988665', '1636988665', null, '0', '小编', '', '0', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('6', '5', '1', '1', '荣誉证书', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/honor.jpg', '', '', '', '', 'show.html', '1636988669', '1636988669', '1636988681', null, '0', '小编', '', '0', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('7', '5', '1', '1', '荣誉证书', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/honor.jpg', '', '', '', '', 'show.html', '1636988675', '1636988675', '1636988675', null, '0', '小编', '', '1', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('8', '5', '1', '1', '荣誉证书', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/honor.jpg', '', '', '', '', 'show.html', '1636988688', '1636988688', '1636988688', null, '0', '小编', '', '2', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('9', '12', '1', '1', '[Demo data] Learning the Fundamentals of Generative Design', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg', '', 'Design,demo data', 'Learning the Fundamentals of Generative Design.', '', 'show.html', '1637066656', '1637066656', '1637066656', null, '0', 'default', '', '1', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('10', '11', '1', '1', '[演示数据] 公司全新学习衍生式设计的基础知识', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg', '', '基础知识,演示数据', '公司全新学习衍生式设计的基础知识，坚持一个行业前行。', '', 'show.html', '1637066657', '1637066657', '1637066657', null, '0', '小编', '', '1', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('11', '11', '1', '1', '[演示数据]送给生活中设计爱好者的顶级现代节日礼物', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg', 'SEO自定义标题演示', 'SEO', '通过这些现代节日礼物创意，从玻璃器皿和装饰到游戏和扬声器，在这个假日季节赠送精美设计的礼物。', '', 'show.html', '1637133171', '1637133171', '1637133171', null, '0', '小编', '', '1', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('12', '12', '1', '1', '[Demo Data]The Top Modern Holiday Gifts for the Design Lover in Your Life', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg', 'SEO custom title demo', 'SEO', 'Give the gift of beautiful design this holiday season with these modern holiday gift ideas, from glassware and decor to games and speakers.', '', 'show.html', '1637133174', '1637133174', '1637133174', null, '0', 'default', '', '2', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('13', '11', '1', '1', '十二个设计师之内的多彩设计', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg', '', '[演示数据],SEO,关键词,英文逗号', '[演示数据]', '', 'show.html', '1637133573', '1637133573', '1637135414', null, '0', '小编', '', '0', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('14', '12', '1', '1', 'Inside Division Twelve’s Colorful Designs', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg', '', '[Demo data], SEO, keywords, English comma', '[Demo data]', '', 'show.html', '1637133576', '1637133576', '1637135411', null, '0', 'default', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('15', '12', '1', '1', 'This Modern Penthouse In Hong Kong Is a Neutral Lover’s Dream', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg', '', '[Demo data], SEO, keywords, English comma', 'Give Modern. Give The Best.', '', 'show.html', '1637133823', '1637133823', '1637135506', null, '0', 'default', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('16', '11', '1', '1', '香港这座现代顶层公寓是中性情人的梦想', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg', '', '[演示数据],SEO,关键词,英文逗号', '给现代。给予最好的。', '', 'show.html', '1637133833', '1637133833', '1637135508', null, '0', '小编', '', '0', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('17', '12', '1', '1', 'A Modern Florida Home With Warm Woods + Metallic Accents', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg', '', '[Demo data], SEO, keywords, English comma', '[Demo Data]The open concept kitchen features minimalist white cabinets alongside eye-catching Officine Gullo appliances featuring brass accents.', '', 'show.html', '1637134606', '1637134606', '1637134606', null, '0', 'default', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('18', '11', '1', '1', '温暖的树林+金属口音的现代佛罗里达住宅', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg', '', '[演示数据],SEO,关键词,英文逗号', '[演示数据]开放式概念厨房配有简约的白色橱柜，以及带有黄铜装饰的引人注目的 Officine Gullo 电器。', '', 'show.html', '1637134607', '1637134607', '1637134607', null, '0', '小编', '', '0', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('19', '11', '1', '1', '艺术与设计的基础[演示数据]', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg', '', '[演示数据],SEO,关键词,英文逗号', '艺术与设计的基础[演示数据]', '', 'show.html', '1637137267', '1637137267', '1637137267', null, '0', '小编', '', '0', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('20', '12', '1', '1', '[Demo Data]The basis of art, design, and more', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg', '', '[Demo data], SEO, keywords, English comma', '[Demo Data]The basis of art, design, and more', '', 'show.html', '1637137269', '1637137269', '1637137269', null, '0', 'default', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('21', '12', '1', '1', 'What do these examples have in common?', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg', '', 'line,shape,form,texture', 'Some very basic elements, including line, shape, form, texture, and balance.', '', 'show.html', '1637137583', '1637137583', '1637137583', null, '0', 'default', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('22', '11', '1', '1', '这些例子有什么共同点？', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg', '', '线条,形状,形式,纹理', '一些非常基本的元素，包括线条、形状、形式、纹理和平衡。', '', 'show.html', '1637137595', '1637137595', '1637137595', null, '0', '小编', '', '1', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('23', '11', '1', '1', '线是连接两个或多个点的形状。它可以是胖的、瘦的、波浪形的或锯齿状的——不胜枚举。', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg', '', '[演示数据],SEO,关键词,英文逗号', '线是连接两个或多个点的形状。它可以是胖的、瘦的、波浪形的或锯齿状的——不胜枚举。每一种可能性都给这条线带来了略微不同的感觉。', '', 'show.html', '1637138150', '1637138150', '1637138150', null, '0', '小编', '', '2', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('24', '12', '1', '1', 'A line is a shape that connects two or more points. It can be fat, thin, wavy, or jagged—the list goes on', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg', '', '[Demo data], SEO, keywords, English comma', 'A line is a shape that connects two or more points. It can be fat, thin, wavy, or jagged—the list goes on. Every possibility gives the line a slightly different feel.', '', 'show.html', '1637138150', '1637138150', '1637138150', null, '0', 'default', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('25', '12', '1', '1', 'Lines can be used in more humble compositions, too—for organization, emphasis, or just decoration', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg', '', '[Demo data], SEO, keywords, English comma', 'In the example below, lines have been used to create a flow chart that guides the reader’s eye from one element to the next.', '', 'show.html', '1637138413', '1637138413', '1637141587', null, '0', 'default', '', '1', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('26', '11', '1', '1', '行可以更多的使用简陋的成分， 太为组织，重点，或只是摆设', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg', '', '[演示数据],SEO,关键词,英文逗号', '在下面的例子中，线条被用来创建一个流程图，引导读者的视线从一个元素到下一个元素。', '', 'show.html', '1637138414', '1637138414', '1637138414', null, '0', '小编', '', '0', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('27', '12', '1', '1', 'A shape is any two-dimensional area with a recognizable boundary. This includes circles, squares, triangles, and so on.', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg', '', '[Demo data], SEO, keywords, English comma', 'Shapes fall into two distinct categories: geometric (or regular) and organic (where the shapes are more free form).', '', 'show.html', '1637138837', '1637138837', '1637138837', null, '0', 'default', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('28', '11', '1', '1', '形状是具有可识别边界的任何二维区域。这包括圆形、正方形、三角形等。', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg', '', '[演示数据],SEO,关键词,英文逗号', '形状分为两个不同的类别：几何（或规则）和有机（形状更自由）。', '', 'show.html', '1637138840', '1637138840', '1637138840', null, '0', '小编', '', '3', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('29', '11', '1', '1', '当一个形状变成 3D 时，我们称它为一个表格', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg', '', '[演示数据],SEO,关键词,英文逗号', '形式构成了现实世界中的各种事物，包括雕塑、建筑和其他三维物体。', '', 'show.html', '1637139183', '1637139183', '1637139183', null, '0', '小编', '', '5', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('30', '12', '1', '1', 'When a shape becomes 3D, we call it a form', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg', '', '[Demo data], SEO, keywords, English comma', 'Forms make up a variety of things in the real world, including sculptures, architecture, and other three-dimensional objects.', '', 'show.html', '1637139188', '1637139188', '1637139188', null, '0', 'default', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('34', '14', '1', '1', '[Demo Data]The Top Modern Holiday Gifts for the Design Lover in Your Life2', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg', 'SEO custom title demo', 'SEO', 'Give the gift of beautiful design this holiday season with these modern holiday gift ideas, from glassware and decor to games and speakers.', '', 'show.html', '1637133174', '1637139900', '1637139957', null, '0', 'default', '', '1', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('35', '16', '1', '1', '[Demo Data]The Top Modern Holiday Gifts for the Design Lover in Your Life3', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg', 'SEO custom title demo', 'SEO', 'Give the gift of beautiful design this holiday season with these modern holiday gift ideas, from glassware and decor to games and speakers.', '', 'show.html', '1637133174', '1637139900', '1637139966', null, '0', 'default', '', '1', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('36', '13', '1', '1', '[演示数据]送给生活中设计爱好者的顶级现代节日礼物2', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg', 'SEO自定义标题演示', 'SEO', '通过这些现代节日礼物创意，从玻璃器皿和装饰到游戏和扬声器，在这个假日季节赠送精美设计的礼物。', '', 'show.html', '1637133171', '1637139913', '1637139938', null, '0', '小编', '', '1', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('37', '15', '1', '1', '[演示数据]送给生活中设计爱好者的顶级现代节日礼物3', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg', 'SEO自定义标题演示', 'SEO', '通过这些现代节日礼物创意，从玻璃器皿和装饰到游戏和扬声器，在这个假日季节赠送精美设计的礼物。', '', 'show.html', '1637133171', '1637139913', '1637139946', null, '0', '小编', '', '1', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('38', '14', '1', '1', 'Texture is the physical quality of a surface', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg', '', '[Demo data], SEO, keywords, English comma', 'Texture is the physical quality of a surface. Like form, it can be part of a three-dimensional object, as in the example below (a small prickly cactus in a shiny ceramic pot).', '', 'show.html', '1637140321', '1637140321', '1637140321', null, '0', '小编', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('39', '13', '1', '1', '纹理是表面的物理质量。', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg', '', '[演示数据],SEO,关键词,英文逗号', '纹理是表面的物理质量。像表单一样，它可以是一个三维物体，如下例所示（闪亮的陶瓷锅中的小带刺的仙人掌）。', '', 'show.html', '1637140323', '1637140323', '1637140323', null, '0', '小编', '', '0', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('40', '13', '1', '1', '在设计中，纹理增加了平面图像的深度和触感', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg', '', '[演示数据],SEO,关键词,英文逗号', '在设计中，纹理增加了平面图像的深度和触感。物体可以显得光滑、粗糙、坚硬或柔软，这取决于所使用的元素。', '', 'show.html', '1637140444', '1637140444', '1637140444', null, '0', '小编', '', '0', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('41', '14', '1', '1', 'In design, texture adds depth and tactility to otherwise flat images.', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg', '', '[Demo data], SEO, keywords, English comma', 'In design, texture adds depth and tactility to otherwise flat images. Objects can appear smooth, rough, hard, or soft, depending on the elements at play.', '', 'show.html', '1637140445', '1637140445', '1637140445', null, '0', '小编', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('42', '15', '1', '1', '送给生活中设计爱好者的顶级现代节日礼物3', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg', 'SEO自定义标题演示', 'SEO', '通过这些现代节日礼物创意，从玻璃器皿和装饰到游戏和扬声器，在这个假日季节赠送精美设计的礼物。', '', 'show.html', '1637133171', '1637140549', '1637140562', null, '0', '小编', '', '1', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('43', '16', '1', '1', 'The Top Modern Holiday Gifts for the Design Lover in Your Life3', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg', 'SEO custom title demo', 'SEO', 'Give the gift of beautiful design this holiday season with these modern holiday gift ideas, from glassware and decor to games and speakers.', '', 'show.html', '1637133174', '1637140550', '1637140563', null, '0', 'default', '', '1', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('44', '15', '1', '1', '平衡是视觉重量的平均分配。平衡会受到很多因素的影响，包括颜色、大小、数量和负空间。', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg', '', '[演示数据],SEO,关键词,英文逗号', '平衡是视觉重量的平均分配（更具体地说，任何一种元素吸引观众眼球的程度）。平衡会受到很多因素的影响，包括颜色、大小、数量和负空间。', '', 'show.html', '1637140982', '1637140982', '1637140982', null, '0', '小编', '', '1', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('45', '16', '1', '1', 'Balance is the equal distribution of visual weight. Balance can be affected by many things, including color, size, number, and negative space.', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg', '', '[Demo data], SEO, keywords, English comma', 'Balance is the equal distribution of visual weight (more specifically, how much any one element attracts the viewer’s eye). Balance can be affected by many things, including color, size, number, and negative space.', '', 'show.html', '1637140984', '1637140984', '1637140984', null, '0', 'default', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('46', '16', '1', '1', 'Balance can be affected by many things, including color, size, number, and negative space.', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg', '', '[Demo data], SEO, keywords, English comma', 'Balance is the equal distribution of visual weight (more specifically, how much any one element attracts the viewer’s eye). Balance can be affected by many things, including color, size, number, and negative space.', '', 'show.html', '1637140984', '1637141010', '1637141042', null, '0', 'default', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('47', '15', '1', '1', '平衡会受到很多因素的影响，包括颜色、大小、数量和负空间。', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg', '', '[演示数据],SEO,关键词,英文逗号', '平衡是视觉重量的平均分配（更具体地说，任何一种元素吸引观众眼球的程度）。平衡会受到很多因素的影响，包括颜色、大小、数量和负空间。', '', 'show.html', '1637140982', '1637141011', '1637141036', null, '0', '小编', '', '2', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('48', '16', '1', '1', 'Many people, including designers and photographers, use a strategy called the rule of thirds', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg', '', '[Demo data], SEO, keywords, English comma', 'Many people, including designers and photographers, use a strategy called the rule of thirds. This imagines your work area divided into a 3x3 grid.', '', 'show.html', '1637141296', '1637141296', '1637141296', null, '0', 'default', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('49', '15', '1', '1', '许多人，包括设计师和摄影师，都使用一种称为三分法的策略', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg', '', '[演示数据],SEO,关键词,英文逗号', '许多人，包括设计师和摄影师，都使用一种称为三分法的策略。这将您的工作区想象成一个3x3 的网格。', '', 'show.html', '1637141298', '1637141298', '1637141298', null, '0', '小编', '', '0', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('50', '14', '1', '1', '[Demo data]including designers and photographers, use a strategy called the rule of thirds', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg', '', '[Demo data], SEO, keywords, English comma', 'Many people, including designers and photographers, use a strategy called the rule of thirds. This imagines your work area divided into a 3x3 grid.', '', 'show.html', '1637141296', '1637141341', '1637141375', null, '0', 'default', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('51', '13', '1', '1', '[演示数据]包括设计师和摄影师，都使用一种称为三分法的策略', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg', '', '[演示数据],SEO,关键词,英文逗号', '许多人，包括设计师和摄影师，都使用一种称为三分法的策略。这将您的工作区想象成一个3x3 的网格。', '', 'show.html', '1637141298', '1637141342', '1637141376', null, '0', '小编', '', '2', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('52', '36', '1', '1', '[Demo data]including designers and photographers, use a strategy called the rule of thirds', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg', '', '[Demo data], SEO, keywords, English comma', 'Many people, including designers and photographers, use a strategy called the rule of thirds. This imagines your work area divided into a 3x3 grid.', '', 'show.html', '1637141296', '1637141341', '1637141375', null, '0', 'default', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('53', '35', '1', '1', '[演示数据]包括设计师和摄影师，都使用一种称为三分法的策略', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg', '', '[演示数据],SEO,关键词,英文逗号', '许多人，包括设计师和摄影师，都使用一种称为三分法的策略。这将您的工作区想象成一个3x3 的网格。', '', 'show.html', '1637141298', '1637141342', '1637141376', null, '0', '小编', '', '1', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('54', '36', '1', '1', 'including designers and photographers, use a strategy called the rule of thirds', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg', '', '[Demo data], SEO, keywords, English comma', 'Many people, including designers and photographers, use a strategy called the rule of thirds. This imagines your work area divided into a 3x3 grid.', '', 'show.html', '1637141296', '1637141341', '1637141375', null, '0', 'default', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_archives` VALUES ('55', '35', '1', '1', '包括设计师和摄影师，都使用一种称为三分法的策略', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg', '', '[演示数据],SEO,关键词,英文逗号', '许多人，包括设计师和摄影师，都使用一种称为三分法的策略。这将您的工作区想象成一个3x3 的网格。', '', 'show.html', '1637141298', '1637141342', '1637141376', null, '0', '小编', '', '0', 'zh-cn', 'normal', '');


DROP TABLE IF EXISTS `hkcms_archives_data`;
CREATE TABLE `hkcms_archives_data` (
  `id` int(10) unsigned NOT NULL,
  `content` text COMMENT '内容',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

INSERT INTO `hkcms_archives_data` VALUES ('1', '');
INSERT INTO `hkcms_archives_data` VALUES ('2', '');
INSERT INTO `hkcms_archives_data` VALUES ('3', '');
INSERT INTO `hkcms_archives_data` VALUES ('4', '');
INSERT INTO `hkcms_archives_data` VALUES ('5', '');
INSERT INTO `hkcms_archives_data` VALUES ('6', '');
INSERT INTO `hkcms_archives_data` VALUES ('7', '');
INSERT INTO `hkcms_archives_data` VALUES ('8', '');
INSERT INTO `hkcms_archives_data` VALUES ('9', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;Manufacturing an industrial product that can go viral with your target audience is difficult.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&amp;nbsp;There are so many elements that need to be optimized simultaneously: material, utility, space, strength, and so much more. This makes design the key differentiator of great products from the good ones, where the core challenge lies.&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;Traditional industrial design development is incredibly limited in nature. Be it the quality, quantity, or time efficiency, your manufacturing process loses a significant amount of potential and resources at this product development stage. This is where generative design comes in.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;[Demo Data]&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('10', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;通过衍生式设计获得战略性以充分利用它。&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;制造一种可以在目标受众中传播开来的工业产品是很困难的。有很多元素需要同时优化：材料、实用性、空间、强度等等。这使得设计成为优秀产品与优秀产品的关键区别，而核心挑战就在于此。&amp;nbsp;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;传统的工业设计开发在本质上是极其有限的。无论是质量、数量还是时间效率，您的制造过程都会在这个产品开发阶段失去大量的潜力和资源。这就是衍生式设计的用武之地。&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;[演示数据]&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('11', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;通过这些现代节日礼物创意，从玻璃器皿和装饰到游戏和扬声器，在这个假日季节赠送精美设计的礼物。&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg&quot; width=&quot;502&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; 在我们的生活中，我们可能都至少有一位美学家——一个欣赏事物的外观和它的运作方式的人。这不仅仅是喜欢漂亮的东西，而是对事物如何以及为什么以某种方式设计以及它如何让我们感到身临其境的真正欣赏。他们是您想要真正考虑到他们的礼物的人，因为当您找到完美的东西时，您就会知道它会让他们感到多么高兴。用这些现代节日礼物创意，在这个假日季节赠送精美设计的礼物。从装饰和玻璃器皿到游戏和技术，您生活中的设计爱好者会喜欢这些精选的高雅美感。&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('12', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;Give the gift of beautiful design this holiday season with these modern holiday gift ideas, from glassware and decor to games and speakers.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img height=&quot;340&quot; width=&quot;502&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg&quot; alt=&quot;Image&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;We probably all have at least one aesthete in our lives – the one who appreciates the way something looks just as much as how it functions. It’s more than just liking pretty things, it’s that true appreciation for how and why something was designed a certain way and how it makes us feel being around it. They’re the ones whose gift you want to put real thought into because when you find that perfect something you know just how happy it will make them. Give the gift of beautiful design this holiday season with these modern holiday gift ideas. From decor and glassware to games and tech, the design lover in your life will love the elevated aesthetic of these picks.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('13', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;[演示数据]&lt;/span&gt;&lt;br&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('14', '&lt;p&gt;[Demo Data]&amp;nbsp;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('15', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;This tonal penthouse features a color and material palette of grey Japanese plastering, matte black rusted metal, warm wood, and subtle olive green accents.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('16', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;这间同色调的顶层公寓采用灰色日本灰泥、哑光黑色生锈金属、温暖的木材和微妙的橄榄绿色调的颜色和材料调色板。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('17', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;Glittering gold, luxe silver, brazen brass, unassuming bronze – most of us have a favorite we gravitate towards. Some go bold and mix metals, and when done right, it truly elevates the visual interest of a room. Others like to ease into metallics by starting with one finish and layering in a few accent pieces to make a space feel captivating. Metals can not only change the look of a space, but they also adjust the feel by adding warmth through bronze and matte gold, or a touch of glam by using chrome or brass. Pair with furniture and decor in bold or subtle textures and patterns, depending on where you fall between minimalism and maximalism, and your metallic elements will make any space shine.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;The open concept kitchen features minimalist white cabinets alongside eye-catching Officine Gullo appliances featuring brass accents. Burnished brass Aquitaine Pendants from RH hang above the white stone island. Even the tile backsplash glistens with brass inlays surrounded by white Thassos marble.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('18', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;闪闪发光的金色、奢华的银色、厚颜无耻的黄铜、不起眼的青铜——我们大多数人都有自己的最爱。有些人大胆地混合金属，如果做得好，它真正提升了房间的视觉趣味。其他人喜欢通过从一个饰面开始并在几个重点部分中分层来使空间变得迷人，从而轻松融入金属色。金属不仅可以改变空间的外观，还可以通过青铜和哑光金增添温暖感，或通过使用铬或黄铜增添一丝魅力，从而调整感觉。搭配大胆或微妙纹理和图案的家具和装饰，取决于您在极简主义和极简主义之间的位置，您的金属元素将使任何空间闪耀。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;[演示数据]&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;开放式概念厨房配有简约的白色橱柜，以及带有黄铜装饰的引人注目的 Officine Gullo 电器。RH 的抛光黄铜阿基坦吊坠悬挂在白色石头岛上。就连瓷砖后挡板上也闪烁着黄铜镶嵌物，周围环绕着白色的 Thassos 大理石。&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('19', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;设计的基础是每一种视觉媒体的基础，从美术到现代网页设计。它们甚至出现在看似不重要的细节中，例如构成大多数作品的字体。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('20', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;The fundamentals of design are the foundation of every visual medium, from fine art to modern web design. They’re even present in seemingly unimportant details, like the fonts that make up most compositions.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('21', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;Some very basic elements, including line, shape, form, texture, and balance. They might not seem like much on their own, but together, they’re part of almost everything we see and create.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;The fundamentals can be intimidating at first, especially if you don’t consider yourself an artist. But keep an open mind—there’s a lot they can teach you about working with different assets and creating simple visuals from scratch.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('22', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; 这些例子有什么共同点？一些非常基本的元素，包括线条、形状、形式、纹理和平衡。它们本身可能看起来并不多，但它们共同构成了我们所看到和创造的几乎所有事物的一部分。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img height=&quot;340&quot; width=&quot;510&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg&quot; alt=&quot;Image&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;一开始，基本面可能令人生畏，特别是如果您不认为自己是艺术家。但是请保持开放的心态——他们可以教你很多关于使用不同资产和从头开始创建简单视觉效果的知识。&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('23', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;线条在设计中经常出现；例如，在图纸和插图中。它们也常见于图形元素，如纹理、图案和背景。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;线是连接两个或多个点的形状。它可以是胖的、瘦的、波浪形的或锯齿状的——不胜枚举。每一种可能性都给这条线带来了略微不同的感觉。&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('24', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;Lines appear frequently in design; for example, in drawings and illustrations. They’re also common in graphic elements, like textures, patterns, and backgrounds.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;A line is a shape that connects two or more points. It can be fat, thin, wavy, or jagged—the list goes on. Every possibility gives the line a slightly different feel.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('25', '<p><span style=\"\"><img alt=\"Image\" src=\"http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg\" width=\"502\" height=\"340\"><br></span></p><p><span style=\"\">When working with lines, pay attention to things like weight, color, texture, and style. These subtle qualities can have a big impact on the way your design is perceived.</span><br></p>');
INSERT INTO `hkcms_archives_data` VALUES ('26', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg&quot; width=&quot;502&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;使用线条时，请注意重量、颜色、纹理和样式等内容。这些微妙的品质会对您的设计被感知的方式产生重大影响。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('27', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;Shapes are a vital part of communicating ideas visually. They give images heft and make them recognizable. We understand street signs, symbols, and even abstract art largely because of shapes.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;Shapes have a surprising number of uses in everyday design. They can help you organize or separate content, create simple illustrations, or just add interest to your work. See if you can spot the many examples in the image below.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;Shapes are important because they’re the foundation of so many things. Learn to look for them in other designs, and soon you’ll start seeing them everywhere.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('28', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;形状是视觉传达思想的重要组成部分。它们赋予图像重量并使它们易于识别。我们了解路牌、符号，甚至抽象艺术，很大程度上是因为形状。&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;形状在日常设计中有着惊人的用途。它们可以帮助您组织或分离内容、创建简单的插图，或者只是为您的工作增添趣味。看看您是否能在下图中找到许多示例。&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;形状很重要，因为它们是许多事物的基础。学习在其他设计中寻找它们，很快您就会开始在任何地方看到它们。&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('29', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;但是，形式不必是三维形状。它们也可以通过插图来暗示，使用 t运用光、影、透视等技巧来营造 深度错觉。&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;在二维设计中，形式使现实主义成为可能. 没有它，像下图这样的效果图——一个带有高光和阴影的球——根本就不一样。&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;即使是不太真实的图像使用类似的技术来创建维度。下面，照明和阴影是程式化的，但仍然暗示形式和深度。&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;在日常构图中，形式的目的是相同的，但规模较小。例如，一个简单的阴影可以创造层次的错觉或给一个对象一个地方感.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;基本形式可以为您的工作带来一丝真实感，这是适度使用的强大工具。&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('30', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;However, forms don’t have to be three-dimensional shapes. They can also be implied through illustration, using techniques like light, shadow, and perspective to create the illusion of depth.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;In two-dimensional design, form makes realism possible. Without it, renderings like the image below—a ball with highlights and shading—simply wouldn’t be the same.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;Even images that are less realistic use similar techniques to create dimension. Below, the lighting and shading are stylized, but still hint at form and depth.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;In everyday composition, the purpose of form is the same, but on a smaller scale. For example, a simple shadow can create the illusion of layers or give an object a sense of place.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;Basic forms can bring a touch of realism to your work, which is a powerful tool when used in moderation.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('34', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;Give the gift of beautiful design this holiday season with these modern holiday gift ideas, from glassware and decor to games and speakers.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img height=&quot;340&quot; width=&quot;502&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg&quot; alt=&quot;Image&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;We probably all have at least one aesthete in our lives – the one who appreciates the way something looks just as much as how it functions. It’s more than just liking pretty things, it’s that true appreciation for how and why something was designed a certain way and how it makes us feel being around it. They’re the ones whose gift you want to put real thought into because when you find that perfect something you know just how happy it will make them. Give the gift of beautiful design this holiday season with these modern holiday gift ideas. From decor and glassware to games and tech, the design lover in your life will love the elevated aesthetic of these picks.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('35', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;Give the gift of beautiful design this holiday season with these modern holiday gift ideas, from glassware and decor to games and speakers.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img height=&quot;340&quot; width=&quot;502&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg&quot; alt=&quot;Image&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;We probably all have at least one aesthete in our lives – the one who appreciates the way something looks just as much as how it functions. It’s more than just liking pretty things, it’s that true appreciation for how and why something was designed a certain way and how it makes us feel being around it. They’re the ones whose gift you want to put real thought into because when you find that perfect something you know just how happy it will make them. Give the gift of beautiful design this holiday season with these modern holiday gift ideas. From decor and glassware to games and tech, the design lover in your life will love the elevated aesthetic of these picks.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('36', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;通过这些现代节日礼物创意，从玻璃器皿和装饰到游戏和扬声器，在这个假日季节赠送精美设计的礼物。&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg&quot; width=&quot;502&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; 在我们的生活中，我们可能都至少有一位美学家——一个欣赏事物的外观和它的运作方式的人。这不仅仅是喜欢漂亮的东西，而是对事物如何以及为什么以某种方式设计以及它如何让我们感到身临其境的真正欣赏。他们是您想要真正考虑到他们的礼物的人，因为当您找到完美的东西时，您就会知道它会让他们感到多么高兴。用这些现代节日礼物创意，在这个假日季节赠送精美设计的礼物。从装饰和玻璃器皿到游戏和技术，您生活中的设计爱好者会喜欢这些精选的高雅美感。&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('37', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;通过这些现代节日礼物创意，从玻璃器皿和装饰到游戏和扬声器，在这个假日季节赠送精美设计的礼物。&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg&quot; width=&quot;502&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; 在我们的生活中，我们可能都至少有一位美学家——一个欣赏事物的外观和它的运作方式的人。这不仅仅是喜欢漂亮的东西，而是对事物如何以及为什么以某种方式设计以及它如何让我们感到身临其境的真正欣赏。他们是您想要真正考虑到他们的礼物的人，因为当您找到完美的东西时，您就会知道它会让他们感到多么高兴。用这些现代节日礼物创意，在这个假日季节赠送精美设计的礼物。从装饰和玻璃器皿到游戏和技术，您生活中的设计爱好者会喜欢这些精选的高雅美感。&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('38', '&lt;p&gt;&lt;img height=&quot;340&quot; width=&quot;510&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; alt=&quot;Image&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;img height=&quot;340&quot; width=&quot;510&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg&quot; alt=&quot;Image&quot;&gt;&lt;br&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('39', '&lt;p&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/p&gt;\r\n&lt;p&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('40', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;[演示数据]&lt;/span&gt;&lt;br&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('41', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;[Demo data]&lt;/span&gt;&lt;br&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('42', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;通过这些现代节日礼物创意，从玻璃器皿和装饰到游戏和扬声器，在这个假日季节赠送精美设计的礼物。&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg&quot; width=&quot;502&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; 在我们的生活中，我们可能都至少有一位美学家——一个欣赏事物的外观和它的运作方式的人。这不仅仅是喜欢漂亮的东西，而是对事物如何以及为什么以某种方式设计以及它如何让我们感到身临其境的真正欣赏。他们是您想要真正考虑到他们的礼物的人，因为当您找到完美的东西时，您就会知道它会让他们感到多么高兴。用这些现代节日礼物创意，在这个假日季节赠送精美设计的礼物。从装饰和玻璃器皿到游戏和技术，您生活中的设计爱好者会喜欢这些精选的高雅美感。&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('43', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;Give the gift of beautiful design this holiday season with these modern holiday gift ideas, from glassware and decor to games and speakers.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img height=&quot;340&quot; width=&quot;502&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg&quot; alt=&quot;Image&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;We probably all have at least one aesthete in our lives – the one who appreciates the way something looks just as much as how it functions. It’s more than just liking pretty things, it’s that true appreciation for how and why something was designed a certain way and how it makes us feel being around it. They’re the ones whose gift you want to put real thought into because when you find that perfect something you know just how happy it will make them. Give the gift of beautiful design this holiday season with these modern holiday gift ideas. From decor and glassware to games and tech, the design lover in your life will love the elevated aesthetic of these picks.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('44', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;对于初学者来说，掌握平衡可能会很棘手，因为它确实需要一些直觉。幸运的是，设计世界充满了可以帮助您理解其不同迭代的示例。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;对称设计在轴的两侧相同或相似。他们感到平衡，因为每一方都有效地相同 （如果不相同）。&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;不对称设计不同，但重量仍然均匀分布。成分是平衡的，因为它引起注意 到正确的事情（在这个例子中，人的姓名和公司标志）。&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('45', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;Mastering balance can be tricky for beginners because it does take some intuition. Luckily, the design world is full of examples that can help you understand its different iterations.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;color: rgb(78, 78, 78);&quot;&gt;Symmetrical&lt;/span&gt;&lt;span style=&quot;color: rgb(78, 78, 78);&quot;&gt;&amp;nbsp;designs are the same or similar on both sides of an axis. They feel balanced because each side is effectively&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;color: rgb(78, 78, 78);&quot;&gt;the same&lt;/span&gt;&lt;span style=&quot;color: rgb(78, 78, 78);&quot;&gt;&amp;nbsp;(if not identical).&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;color: rgb(78, 78, 78);&quot;&gt;&lt;span style=&quot;&quot;&gt;Asymmetrical designs are different, but the weight is still evenly distributed. The composition is balanced because it calls attention to the right things (in this example, the person’s name and company logo).&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('46', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;Mastering balance can be tricky for beginners because it does take some intuition. Luckily, the design world is full of examples that can help you understand its different iterations.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;color: rgb(78, 78, 78);&quot;&gt;Symmetrical&lt;/span&gt;&lt;span style=&quot;color: rgb(78, 78, 78);&quot;&gt;&amp;nbsp;designs are the same or similar on both sides of an axis. They feel balanced because each side is effectively&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;color: rgb(78, 78, 78);&quot;&gt;the same&lt;/span&gt;&lt;span style=&quot;color: rgb(78, 78, 78);&quot;&gt;&amp;nbsp;(if not identical).&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;color: rgb(78, 78, 78);&quot;&gt;&lt;span style=&quot;&quot;&gt;Asymmetrical designs are different, but the weight is still evenly distributed. The composition is balanced because it calls attention to the right things (in this example, the person’s name and company logo).&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('47', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;对于初学者来说，掌握平衡可能会很棘手，因为它确实需要一些直觉。幸运的是，设计世界充满了可以帮助您理解其不同迭代的示例。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;对称设计在轴的两侧相同或相似。他们感到平衡，因为每一方都有效地相同 （如果不相同）。&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;不对称设计不同，但重量仍然均匀分布。成分是平衡的，因为它引起注意 到正确的事情（在这个例子中，人的姓名和公司标志）。&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('48', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;We find this type of composition appealing because, according to studies, the human eye naturally follows this path when scanning a design.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('49', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;我们发现这种类型的构图很有吸引力，因为根据研究，人眼 自然会走这条路 扫描设计时。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('50', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;We find this type of composition appealing because, according to studies, the human eye naturally follows this path when scanning a design.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('51', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;我们发现这种类型的构图很有吸引力，因为根据研究，人眼 自然会走这条路 扫描设计时。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('52', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;We find this type of composition appealing because, according to studies, the human eye naturally follows this path when scanning a design.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('53', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;我们发现这种类型的构图很有吸引力，因为根据研究，人眼 自然会走这条路 扫描设计时。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('54', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;We find this type of composition appealing because, according to studies, the human eye naturally follows this path when scanning a design.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `hkcms_archives_data` VALUES ('55', '&lt;p&gt;&lt;span style=&quot;&quot;&gt;我们发现这种类型的构图很有吸引力，因为根据研究，人眼 自然会走这条路 扫描设计时。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');


DROP TABLE IF EXISTS `hkcms_attachment`;
CREATE TABLE `hkcms_attachment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '附件ID',
  `user_id` int(11) NOT NULL COMMENT '用户ID',
  `user_type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '用户类型:1-后台管理员',
  `title` char(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '附件名',
  `path` char(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '附件路径',
  `size` int(11) NOT NULL DEFAULT '0' COMMENT '附件大小(字节)',
  `ext` char(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '附件扩展',
  `mime_type` char(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '附件mimeType',
  `md5` char(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5',
  `storage` char(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'local' COMMENT '存储位置',
  `remark` char(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '描述',
  `status` enum('normal','hidden') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'normal' COMMENT '状态:normal-正常,hidden-禁用',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `path` (`path`,`storage`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='附件表';



DROP TABLE IF EXISTS `hkcms_auth_group`;
CREATE TABLE `hkcms_auth_group` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '名称',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级',
  `rules` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '规则',
  `remark` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '备注',
  `status` enum('normal','hidden') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'normal' COMMENT '状态:normal-正常,hidden-禁用',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='角色管理';

INSERT INTO `hkcms_auth_group` VALUES ('1', '超级管理员', '0', '*', '', 'normal', '1594794684', '1594795080');


DROP TABLE IF EXISTS `hkcms_auth_group_access`;
CREATE TABLE `hkcms_auth_group_access` (
  `admin_id` int(10) unsigned NOT NULL COMMENT '管理员ID',
  `group_id` mediumint(8) unsigned NOT NULL COMMENT '角色组ID',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  UNIQUE KEY `uid_group_id` (`admin_id`,`group_id`) USING BTREE,
  KEY `uid` (`admin_id`) USING BTREE,
  KEY `group_id` (`group_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='权限分组表';

INSERT INTO `hkcms_auth_group_access` VALUES ('1', '1', '1595834080', '1595834080');


DROP TABLE IF EXISTS `hkcms_auth_rule`;
CREATE TABLE `hkcms_auth_rule` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父级',
  `name` char(80) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '规则',
  `title` char(50) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '标题',
  `route` char(80) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '路由',
  `app` char(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '所属应用',
  `icon` char(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '图标',
  `remark` char(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '备注',
  `weigh` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '类型:0-权限规则,1-菜单,2-菜单头',
  `status` enum('normal','hidden') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'normal' COMMENT '状态:normal-正常,hidden-禁用',
  `is_nav` tinyint(2) NOT NULL DEFAULT '0' COMMENT '快速导航:1-是,0-否',
  `condition` char(100) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '附加条件',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `name` (`name`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=116 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='菜单规则';

INSERT INTO `hkcms_auth_rule` VALUES ('33', '0', 'index/dashboard', 'Dashboard', '', '', 'fas fa-tachometer-alt', '', '100', '0', 'normal', '0', '', '1594779897', '1617268812');
INSERT INTO `hkcms_auth_rule` VALUES ('34', '58', 'auth', 'Auth', '', '', 'fas fa-user-alt', '', '42', '1', 'normal', '0', '', '1594779929', '1610535401');
INSERT INTO `hkcms_auth_rule` VALUES ('35', '34', 'auth/rule', 'Menu', 'auth.rule/index', '', 'far fa-circle', '', '8', '1', 'normal', '1', '', '1594780028', '1601016617');
INSERT INTO `hkcms_auth_rule` VALUES ('36', '35', 'auth/rule/index', 'View', 'auth.rule/index', '', 'far fa-circle', '', '0', '0', 'normal', '0', '', '1594780073', '1594978319');
INSERT INTO `hkcms_auth_rule` VALUES ('37', '35', 'auth/rule/add', 'Add', 'auth.rule/add', '', 'far fa-circle', '', '0', '0', 'normal', '0', '', '1594780119', '1594780119');
INSERT INTO `hkcms_auth_rule` VALUES ('38', '35', 'auth/rule/edit', 'Edit', 'auth.rule/edit', '', 'far fa-circle', '', '0', '0', 'normal', '0', '', '1594780154', '1594780794');
INSERT INTO `hkcms_auth_rule` VALUES ('39', '35', 'auth/rule/del', 'Delete', 'auth.rule/del', '', 'far fa-circle', '', '0', '0', 'normal', '0', '', '1594780205', '1594780205');
INSERT INTO `hkcms_auth_rule` VALUES ('40', '34', 'auth/admin', 'Admin', 'auth.admin/index', '', 'far fa-circle', '', '10', '1', 'normal', '1', '', '1594780596', '1601016611');
INSERT INTO `hkcms_auth_rule` VALUES ('41', '34', 'auth/group', 'Group', 'auth.group/index', '', 'far fa-circle', '', '9', '1', 'normal', '1', '', '1594780999', '1601016612');
INSERT INTO `hkcms_auth_rule` VALUES ('42', '34', 'auth/adminlog', 'Admin log', 'auth.adminlog/index', '', 'far fa-circle', '', '0', '1', 'normal', '1', '', '1594781045', '1601016622');
INSERT INTO `hkcms_auth_rule` VALUES ('43', '57', 'appcenter', 'Application', '', '', 'fas fa-th', '', '9', '1', 'normal', '0', '', '1594781146', '1610535417');
INSERT INTO `hkcms_auth_rule` VALUES ('45', '58', 'cms/model', 'Model', 'cms.model/index', '', 'fas fa-database', '', '46', '1', 'normal', '1', '', '1596080998', '1610535376');
INSERT INTO `hkcms_auth_rule` VALUES ('46', '0', 'cms/category', 'Category', 'cms.category/index', '', 'fas fa-columns', '', '76', '1', 'normal', '1', '', '1596085252', '1605256403');
INSERT INTO `hkcms_auth_rule` VALUES ('47', '0', 'cms/content/index', 'Content', 'cms.content/index', '', 'fas fa-file', '', '78', '1', 'normal', '1', '', '1596085625', '1610587398');
INSERT INTO `hkcms_auth_rule` VALUES ('48', '35', 'auth/rule/batches', 'Batch edit', 'auth.rule/batches', '', 'far fa-circle', '', '0', '0', 'normal', '0', '', '1599105525', '1599105525');
INSERT INTO `hkcms_auth_rule` VALUES ('50', '108', 'routine/config/index', 'Site config', 'routine.config/index', '', 'fas fa-globe', '', '48', '1', 'normal', '1', '', '1599134646', '1610534629');
INSERT INTO `hkcms_auth_rule` VALUES ('51', '42', 'auth/adminlog/index', 'View', 'auth.adminlog/index', '', 'far fa-circle', '', '0', '0', 'normal', '0', '', '1599557159', '1599557214');
INSERT INTO `hkcms_auth_rule` VALUES ('52', '58', 'routine/attachment', 'Attachment', 'routine.Attachment/index', '', 'fas fa-folder', '', '44', '1', 'normal', '1', '', '1600849714', '1610535390');
INSERT INTO `hkcms_auth_rule` VALUES ('54', '50', 'routine/config/edit', 'Edit', 'routine.config/edit', '', 'far fa-circle', '', '0', '0', 'normal', '0', '', '1601436785', '1601436851');
INSERT INTO `hkcms_auth_rule` VALUES ('55', '0', 'cms/recommend', 'Site module', 'cms.recommend/index', '', 'fas fa-border-all', '', '74', '1', 'normal', '1', '', '1602207862', '1605257692');
INSERT INTO `hkcms_auth_rule` VALUES ('57', '0', 'more', 'More', '', '', 'far fa-circle', '', '10', '2', 'normal', '0', '', '1605256229', '1605256347');
INSERT INTO `hkcms_auth_rule` VALUES ('58', '0', 'setting', 'Setting', '', '', 'far fa-circle', '', '50', '2', 'normal', '0', '', '1605256302', '1605256425');
INSERT INTO `hkcms_auth_rule` VALUES ('59', '40', 'auth/admin/edit', 'Edit', 'auth.admin/edit', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608516768', '1608516768');
INSERT INTO `hkcms_auth_rule` VALUES ('60', '40', 'auth/admin/index', 'View', 'auth.admin/index', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608517595', '1608517844');
INSERT INTO `hkcms_auth_rule` VALUES ('61', '40', 'auth/admin/add', 'Add', 'auth.admin/admin', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608517687', '1608517687');
INSERT INTO `hkcms_auth_rule` VALUES ('62', '40', 'auth/admin/del', 'Delete', 'auth.admin/del', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608517733', '1608517826');
INSERT INTO `hkcms_auth_rule` VALUES ('63', '40', 'auth/admin/batches', 'Batch edit', 'auth.admin/batches', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608517821', '1608517821');
INSERT INTO `hkcms_auth_rule` VALUES ('64', '41', 'auth/group/index', 'View', 'auth.group/index', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608518081', '1608518093');
INSERT INTO `hkcms_auth_rule` VALUES ('65', '41', 'auth/group/add', 'Add', 'auth.group/add', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608518320', '1608518327');
INSERT INTO `hkcms_auth_rule` VALUES ('66', '41', 'auth/group/edit', 'Edit', 'auth.group/edit', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608518434', '1608518434');
INSERT INTO `hkcms_auth_rule` VALUES ('67', '41', 'auth/group/del', 'Delete', 'auth.group/del', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608518463', '1608518463');
INSERT INTO `hkcms_auth_rule` VALUES ('68', '41', 'auth/group/batches', 'Batch edit', 'auth.group/batches', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608518515', '1608518528');
INSERT INTO `hkcms_auth_rule` VALUES ('69', '42', 'auth/adminlog/del', 'Delete', 'auth.adminlog/del', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608518616', '1608518897');
INSERT INTO `hkcms_auth_rule` VALUES ('70', '52', 'common/upload', 'Upload', '', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608545354', '1608545354');
INSERT INTO `hkcms_auth_rule` VALUES ('71', '52', 'routine/attachment/del', 'Delete', 'routine.attachment/del', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608545444', '1608545444');
INSERT INTO `hkcms_auth_rule` VALUES ('72', '52', 'routine/attachment/index', 'View', 'routine.attachment/index', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608545893', '1608545893');
INSERT INTO `hkcms_auth_rule` VALUES ('73', '45', 'cms/model/index', 'View', 'cms.model/index', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608545982', '1608545982');
INSERT INTO `hkcms_auth_rule` VALUES ('74', '45', 'cms/model/add', 'Add', 'cms.model/add', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608546009', '1608546009');
INSERT INTO `hkcms_auth_rule` VALUES ('75', '45', 'cms/model/edit', 'Edit', 'cms.model/edit', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608546042', '1608546087');
INSERT INTO `hkcms_auth_rule` VALUES ('76', '45', 'cms/model/del', 'Delete', 'cms.model/del', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608546082', '1608546082');
INSERT INTO `hkcms_auth_rule` VALUES ('77', '45', 'cms/modelfield/index', 'Model field view', 'cms.model_field/index', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608546138', '1608546138');
INSERT INTO `hkcms_auth_rule` VALUES ('78', '45', 'cms/modelfield/add', 'Model field add', 'cms.model_field/add', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608546185', '1608546185');
INSERT INTO `hkcms_auth_rule` VALUES ('79', '45', 'cms/modelfield/edit', 'Model field edit', 'cms.model_field/edit', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608546212', '1608546212');
INSERT INTO `hkcms_auth_rule` VALUES ('80', '45', 'cms/modelfield/del', 'Model field delete', 'cms.model_field/del', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608546248', '1608546248');
INSERT INTO `hkcms_auth_rule` VALUES ('82', '45', 'cms/model/batches', 'Batch edit', 'cms.model/batches', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608546422', '1608546427');
INSERT INTO `hkcms_auth_rule` VALUES ('83', '45', 'cms/modelfield/batches', 'Model field batch edit', 'cms.model_field/batches', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608546463', '1608546463');
INSERT INTO `hkcms_auth_rule` VALUES ('84', '55', 'cms/recommend/index', 'View', 'cms.recommend/index', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608547657', '1608547657');
INSERT INTO `hkcms_auth_rule` VALUES ('85', '55', 'cms/recommend/add', 'Add', 'cms.recommend/add', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608548615', '1608548615');
INSERT INTO `hkcms_auth_rule` VALUES ('86', '55', 'cms/recommend/edit', 'Edit', 'cms.recommend/edit', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608548650', '1608548650');
INSERT INTO `hkcms_auth_rule` VALUES ('87', '55', 'cms/recommend/del', 'Delete', 'cms.recommend/del', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608548678', '1608548678');
INSERT INTO `hkcms_auth_rule` VALUES ('88', '55', 'cms/recommend/batches', 'Batch edit', 'cms.recommend/batches', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608548894', '1608548894');
INSERT INTO `hkcms_auth_rule` VALUES ('89', '46', 'cms/category/index', 'View', 'cms.category/index', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608550359', '1608550363');
INSERT INTO `hkcms_auth_rule` VALUES ('90', '46', 'cms/category/add', 'Add', 'cms.category/add', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608551179', '1608551261');
INSERT INTO `hkcms_auth_rule` VALUES ('91', '46', 'cms/category/del', 'Delete', 'cms.category/del', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608551315', '1608551315');
INSERT INTO `hkcms_auth_rule` VALUES ('92', '46', 'cms/category/edit', 'Edit', 'cms.category/edit', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608551316', '1608551316');
INSERT INTO `hkcms_auth_rule` VALUES ('93', '46', 'cms/category/batches', 'Batch edit', 'cms.category/batches', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608551362', '1610588095');
INSERT INTO `hkcms_auth_rule` VALUES ('94', '46', 'cms/category/recycle', 'Recycle', 'cms.category/recycle', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608551416', '1608551416');
INSERT INTO `hkcms_auth_rule` VALUES ('95', '46', 'cms/category/destroy', 'Destroy', 'cms.category/destroy', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608551728', '1608551728');
INSERT INTO `hkcms_auth_rule` VALUES ('96', '46', 'cms/category/restore', 'Restore', 'cms.category/restore', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608551775', '1608551775');
INSERT INTO `hkcms_auth_rule` VALUES ('97', '43', 'appcenter/index', 'Local', '', '', 'fa fa-cloud-download-alt', '', '0', '1', 'normal', '0', '', '1608705333', '1608705348');
INSERT INTO `hkcms_auth_rule` VALUES ('98', '43', 'appcenter/online', 'Online', '', '', 'fas fa-cloud', '', '0', '1', 'normal', '0', '', '1608705372', '1617268688');
INSERT INTO `hkcms_auth_rule` VALUES ('99', '46', 'cms/category/auth', 'Column auth', 'cms.ategory/auth', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1610623305', '1610623305');
INSERT INTO `hkcms_auth_rule` VALUES ('100', '45', 'cms/modelfield/fieldcategory', 'Designated column', 'cms.model_field/fieldcategory', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1618999384', '1618999384');
INSERT INTO `hkcms_auth_rule` VALUES ('101', '46', 'cms/category/fields', 'Extended field', 'cms/category/fields', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1626420443', '1626420443');
INSERT INTO `hkcms_auth_rule` VALUES ('102', '45', 'cms/model/export', 'Model export', 'cms.model/export', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1629871111', '1629871280');
INSERT INTO `hkcms_auth_rule` VALUES ('103', '45', 'cms/model/import', 'Model import', 'cms.model/import', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1629871219', '1629871355');
INSERT INTO `hkcms_auth_rule` VALUES ('104', '45', 'cms/model/copy', 'Model copy', 'cms.model/copy', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1629871319', '1629871319');
INSERT INTO `hkcms_auth_rule` VALUES ('105', '52', 'routine/attachment/edit', 'Edit', 'routine.attachment/edit', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1608545893', '1608545893');
INSERT INTO `hkcms_auth_rule` VALUES ('106', '108', 'routine/seo/index', 'SEO Setting', 'routine.Seo/index', '', 'fas fa-link', '', '0', '1', 'normal', '1', '', '1649080788', '1649903731');
INSERT INTO `hkcms_auth_rule` VALUES ('107', '108', 'cms/flags', 'Flag', 'cms.flags/index', '', 'fas fa-file-alt', '', '0', '1', 'normal', '1', '', '1649081519', '1649903749');
INSERT INTO `hkcms_auth_rule` VALUES ('108', '58', 'config', 'Configure', '', '', 'fas fa-cogs', '', '50', '1', 'normal', '0', '', '1649903613', '1649903997');
INSERT INTO `hkcms_auth_rule` VALUES ('109', '107', 'cms/flags/index', 'View', 'cms.flag/index', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1649904448', '1649904448');
INSERT INTO `hkcms_auth_rule` VALUES ('110', '107', 'cms/flags/add', 'Add', 'cms.flags/add', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1649904896', '1649904896');
INSERT INTO `hkcms_auth_rule` VALUES ('111', '107', 'cms/flags/edit', 'Edit', 'cms.flags/edit', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1649905610', '1649905610');
INSERT INTO `hkcms_auth_rule` VALUES ('112', '107', 'cms/flags/del', 'Delete', 'cms.flags/del', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1649905706', '1649905706');
INSERT INTO `hkcms_auth_rule` VALUES ('113', '107', 'cms/flags/batches', 'Batch edit', 'cms.flags/batches', '', 'fas fa-circle', '', '0', '0', 'normal', '0', '', '1649905774', '1649905774');
INSERT INTO `hkcms_auth_rule` VALUES ('114', '52', 'routine/attachment/water', 'Watermark', 'routine.attachment/water', '', 'fas fa-tint', '', '0', '0', 'normal', '1', '', '1658593132', '1658593132');
INSERT INTO `hkcms_auth_rule` VALUES ('115', '52', 'routine/attachment/thumb', 'Thumbnail', 'routine.attachment/thumb', '', 'far fa-image', '', '0', '0', 'normal', '1', '', '1658593175', '1658593175');


DROP TABLE IF EXISTS `hkcms_banner`;
CREATE TABLE `hkcms_banner` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `recommend_id` int(11) NOT NULL,
  `admin_id` int(11) NOT NULL COMMENT '管理员ID',
  `type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '类型:1-图集,2-多媒体,3-html代码',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `image` varchar(255) NOT NULL DEFAULT '' COMMENT '图片路径',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '链接',
  `notes` text COMMENT '描述',
  `content` text COMMENT '内容',
  `weigh` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `new_window` tinyint(2) NOT NULL DEFAULT '0' COMMENT '新窗口:1-启用,0-禁用',
  `lang` char(20) NOT NULL DEFAULT '' COMMENT '语言标识',
  `status` enum('normal','hidden') NOT NULL DEFAULT 'normal' COMMENT '状态:normal-正常,hidden-禁用',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='轮播图/广告';

INSERT INTO `hkcms_banner` VALUES ('1', '1', '1', '1', 'Fashion life, concept design', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/banner2.jpg', 'http://www.hkcms.cn', 'When Services Matters.Your Choice is Simple! We have a culturally diverse, forward thinking team looking for talent like.', null, '1', '0', 'en', 'normal', '1636968200', '1636968200');
INSERT INTO `hkcms_banner` VALUES ('2', '2', '1', '1', '时尚生活、概念设计', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/banner2.jpg', 'http://www.hkcms.cn', '当服务很重要时，您的选择很简单！我们拥有一支文化多元、具有前瞻性思维的团队，正在寻找类似的人才。', null, '1', '0', 'zh-cn', 'normal', '1636968200', '1636968200');
INSERT INTO `hkcms_banner` VALUES ('3', '1', '1', '1', 'Design industry', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/banner.jpg', 'https://gitee.com/Hk_Cms/HkCms', '17 Years Of Excellence In.You have ideas, goals, and dreams. We have a culturally diverse, forward thinking team looking for talent like.', null, '2', '1', 'en', 'normal', '1636968200', '1636968200');
INSERT INTO `hkcms_banner` VALUES ('4', '2', '1', '1', '设计行业', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/banner.jpg', 'https://gitee.com/Hk_Cms/HkCms', '17 年的卓越成就。您有想法、目标和梦想。 我们拥有一支文化多元、具有前瞻性思维的团队，正在寻找类似的人才。', null, '2', '1', 'zh-cn', 'normal', '1636968200', '1636968200');
INSERT INTO `hkcms_banner` VALUES ('5', '3', '1', '3', '', '', '', null, '<div class=\"link_list\" id=\"link\">\r\n友情链接：<a href=\"https://www.hkcms.cn/\" target=\"_blank\" title=\"HkCms官网\">HkCms官网</a> | <a href=\"http://doc.hkcms.cn/\" target=\"_blank\" title=\"使用手册\">使用手册</a> | \r\n<a href=\"https://gitee.com/Hk_Cms/HkCms/issues\" target=\"_blank\" title=\"BUG/建议反馈\">BUG/建议反馈</a>\r\n</div>', '0', '0', 'zh-cn', 'normal', '1636978556', '1636978556');
INSERT INTO `hkcms_banner` VALUES ('6', '4', '1', '3', '', '', '', null, '<div class=\"link_list\" id=\"link\">\r\nFriendship link：<a href=\"https://www.hkcms.cn/\" target=\"_blank\" title=\"HkCms official website\">HkCms official website</a> | <a href=\"http://doc.hkcms.cn/\" target=\"_blank\" title=\"User manual\">User manual</a> | \r\n<a href=\"https://gitee.com/Hk_Cms/HkCms/issues\" target=\"_blank\" title=\"BUG/suggest feedback\">BUG/suggest feedback</a>\r\n</div>', '0', '0', 'en', 'normal', '1636978556', '1636978556');
INSERT INTO `hkcms_banner` VALUES ('7', '5', '2', '1', 'bannerA', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/banner4.jpg', '', '', null, '1', '0', 'en', 'normal', '1637142375', '1637142375');
INSERT INTO `hkcms_banner` VALUES ('8', '6', '2', '1', '横幅A', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/banner4.jpg', '', '', null, '1', '0', 'zh-cn', 'normal', '1637142375', '1637142375');
INSERT INTO `hkcms_banner` VALUES ('9', '5', '2', '1', 'bannerB', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/banner5.jpg', '', '', null, '2', '0', 'en', 'normal', '1637142375', '1637142375');
INSERT INTO `hkcms_banner` VALUES ('10', '6', '2', '1', '横幅B', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/banner5.jpg', '', '', null, '2', '0', 'zh-cn', 'normal', '1637142375', '1637142375');
INSERT INTO `hkcms_banner` VALUES ('11', '1', '1', '1', 'Promotional video', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/banner3.jpg', '#', 'Learn about the entire design industry from the promotional video, click the button below to play the promotional video and learn more about us!', null, '3', '1', 'en', 'normal', '1636968200', '1636968200');
INSERT INTO `hkcms_banner` VALUES ('12', '2', '1', '1', '宣传视频', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/banner3.jpg', '#', '从宣传视频了解整个设计行业，点击下方按钮播放宣传视频，更深入的了解我们！', null, '3', '1', 'zh-cn', 'normal', '1636968200', '1636968200');
INSERT INTO `hkcms_banner` VALUES ('13', '7', '1', '2', '视频演示', '', '#', '站点模块视频演示', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/ae38f8c7f57d48d5074bb7e199b6bec8.mp4', '0', '0', 'zh-cn', 'normal', '1656248247', '1656248247');
INSERT INTO `hkcms_banner` VALUES ('14', '8', '1', '2', 'Video demo', '', '#', 'Site Module Video Demo', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/ae38f8c7f57d48d5074bb7e199b6bec8.mp4', '1', '0', 'en', 'normal', '1656248247', '1656248247');
INSERT INTO `hkcms_banner` VALUES ('15', '9', '1', '5', 'HkCms官网', '', 'https://www.hkcms.cn/', '', null, '0', '1', 'zh-cn', 'normal', '1656610216', '1656610216');
INSERT INTO `hkcms_banner` VALUES ('16', '9', '1', '5', '使用手册', '', 'http://doc.hkcms.cn/', '', null, '0', '1', 'zh-cn', 'normal', '1656610216', '1656610216');
INSERT INTO `hkcms_banner` VALUES ('17', '9', '1', '5', 'BUG/建议反馈', '', 'https://gitee.com/Hk_Cms/HkCms/issues', '', null, '0', '1', 'zh-cn', 'normal', '1656610216', '1656610216');
INSERT INTO `hkcms_banner` VALUES ('18', '10', '1', '5', 'HkCms', '', 'https://www.hkcms.cn/', '', null, '1', '1', 'en', 'normal', '1656610216', '1656610216');
INSERT INTO `hkcms_banner` VALUES ('19', '10', '1', '5', 'User Manual', '', 'http://doc.hkcms.cn/', '', null, '2', '1', 'en', 'normal', '1656610216', '1656610216');
INSERT INTO `hkcms_banner` VALUES ('20', '10', '1', '5', 'Gitee BUG', '', 'https://gitee.com/Hk_Cms/HkCms/issues', '', null, '3', '1', 'en', 'normal', '1656610216', '1656610216');
INSERT INTO `hkcms_banner` VALUES ('21', '11', '1', '1', '伙伴1', 'http://holuo.cn-gd.ufileos.com/hkcms/logo.png', 'https://www.hkcms.cn/help/', '演示数据', null, '1', '1', 'zh-cn', 'normal', '1657460086', '1657460086');
INSERT INTO `hkcms_banner` VALUES ('22', '11', '1', '1', '伙伴2', 'http://holuo.cn-gd.ufileos.com/hkcms/logo.png', 'https://www.hkcms.cn/help/', '演示数据', null, '2', '1', 'zh-cn', 'normal', '1657460086', '1657460086');
INSERT INTO `hkcms_banner` VALUES ('23', '11', '1', '1', '伙伴3', 'http://holuo.cn-gd.ufileos.com/hkcms/logo.png', 'https://www.hkcms.cn/help/', '演示数据', null, '3', '1', 'zh-cn', 'normal', '1657460086', '1657460086');
INSERT INTO `hkcms_banner` VALUES ('24', '11', '1', '1', '伙伴4', 'http://holuo.cn-gd.ufileos.com/hkcms/logo.png', 'https://www.hkcms.cn/help/', '演示数据', null, '4', '1', 'zh-cn', 'normal', '1657460086', '1657460086');
INSERT INTO `hkcms_banner` VALUES ('25', '11', '1', '1', '伙伴5', 'http://holuo.cn-gd.ufileos.com/hkcms/logo.png', 'https://www.hkcms.cn/help/', '演示数据', null, '5', '1', 'zh-cn', 'normal', '1657460086', '1657460086');
INSERT INTO `hkcms_banner` VALUES ('26', '11', '1', '1', '伙伴6', 'http://holuo.cn-gd.ufileos.com/hkcms/logo.png', 'https://www.hkcms.cn/help/', '演示数据', null, '6', '1', 'zh-cn', 'normal', '1657460086', '1657460086');
INSERT INTO `hkcms_banner` VALUES ('27', '11', '1', '1', '伙伴7', 'http://holuo.cn-gd.ufileos.com/hkcms/logo.png', 'https://www.hkcms.cn/help/', '演示数据', null, '7', '1', 'zh-cn', 'normal', '1657460086', '1657460086');
INSERT INTO `hkcms_banner` VALUES ('28', '11', '1', '1', '伙伴8', 'http://holuo.cn-gd.ufileos.com/hkcms/logo.png', 'https://www.hkcms.cn/help/', '演示数据', null, '8', '1', 'zh-cn', 'normal', '1657460086', '1657460086');
INSERT INTO `hkcms_banner` VALUES ('29', '12', '1', '1', 'Partner 1', 'http://holuo.cn-gd.ufileos.com/hkcms/logo.png', 'https://www.hkcms.cn/help/', 'demo data', null, '1', '1', 'en', 'normal', '1657460086', '1657460086');
INSERT INTO `hkcms_banner` VALUES ('30', '12', '1', '1', 'Partner 2', 'http://holuo.cn-gd.ufileos.com/hkcms/logo.png', 'https://www.hkcms.cn/help/', 'demo data', null, '2', '1', 'en', 'normal', '1657460086', '1657460086');
INSERT INTO `hkcms_banner` VALUES ('31', '12', '1', '1', 'Partner 3', 'http://holuo.cn-gd.ufileos.com/hkcms/logo.png', 'https://www.hkcms.cn/help/', 'demo data', null, '3', '1', 'en', 'normal', '1657460086', '1657460086');
INSERT INTO `hkcms_banner` VALUES ('32', '12', '1', '1', 'Partner 4', 'http://holuo.cn-gd.ufileos.com/hkcms/logo.png', 'https://www.hkcms.cn/help/', 'demo data', null, '4', '1', 'en', 'normal', '1657460086', '1657460086');
INSERT INTO `hkcms_banner` VALUES ('33', '12', '1', '1', 'Partner 5', 'http://holuo.cn-gd.ufileos.com/hkcms/logo.png', 'https://www.hkcms.cn/help/', 'demo data', null, '5', '1', 'en', 'normal', '1657460086', '1657460086');
INSERT INTO `hkcms_banner` VALUES ('34', '12', '1', '1', 'Partner 6', 'http://holuo.cn-gd.ufileos.com/hkcms/logo.png', 'https://www.hkcms.cn/help/', 'demo data', null, '6', '1', 'en', 'normal', '1657460086', '1657460086');
INSERT INTO `hkcms_banner` VALUES ('35', '12', '1', '1', 'Partner 7', 'http://holuo.cn-gd.ufileos.com/hkcms/logo.png', 'https://www.hkcms.cn/help/', 'demo data', null, '7', '1', 'en', 'normal', '1657460086', '1657460086');
INSERT INTO `hkcms_banner` VALUES ('36', '12', '1', '1', 'Partner 18', 'http://holuo.cn-gd.ufileos.com/hkcms/logo.png', 'https://www.hkcms.cn/help/', 'demo data', null, '8', '1', 'en', 'normal', '1657460086', '1657460086');


DROP TABLE IF EXISTS `hkcms_category`;
CREATE TABLE `hkcms_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `model_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '模型ID',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `type` enum('link','list','category') NOT NULL DEFAULT 'link' COMMENT '类型',
  `app` varchar(15) NOT NULL DEFAULT 'cms' COMMENT '所属应用',
  `name` varchar(50) NOT NULL COMMENT '栏目名称',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '栏目标题',
  `url` varchar(250) NOT NULL DEFAULT '' COMMENT '指定url',
  `image` varchar(250) NOT NULL DEFAULT '' COMMENT '栏目图片',
  `category_tpl` varchar(100) NOT NULL DEFAULT '' COMMENT '栏目模板',
  `list_tpl` varchar(100) NOT NULL DEFAULT '' COMMENT '列表模板',
  `show_tpl` varchar(100) NOT NULL DEFAULT '' COMMENT '内容模板',
  `seo_title` varchar(250) NOT NULL DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(250) NOT NULL DEFAULT '' COMMENT 'SEO关键字',
  `seo_desc` varchar(250) NOT NULL DEFAULT '' COMMENT 'SEO描述',
  `ismenu` tinyint(4) NOT NULL DEFAULT '1' COMMENT '导航显示:1-显示,0-隐藏',
  `target` varchar(20) NOT NULL DEFAULT '_self' COMMENT '弹出方式',
  `user_auth` tinyint(1) NOT NULL DEFAULT '0' COMMENT '用户投稿:1=允许,0=不允许',
  `lang` varchar(20) NOT NULL DEFAULT '' COMMENT '语言标识',
  `weigh` tinyint(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `num` int(11) NOT NULL DEFAULT '10' COMMENT '分页大小',
  `delete_time` int(11) DEFAULT NULL COMMENT '删除时间',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `status` enum('normal','hidden') NOT NULL DEFAULT 'normal' COMMENT '状态:normal-正常,hidden-禁用',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='栏目管理';

INSERT INTO `hkcms_category` VALUES ('1', '0', '0', 'link', 'cms', 'hone', '首页', '/', '', '', '', '', '', '', '', '1', '_self', '0', 'zh-cn', '40', '10', null, '1636979415', '1636979415', 'normal');
INSERT INTO `hkcms_category` VALUES ('2', '0', '0', 'link', 'cms', 'hone', 'Home', '/', '', '', '', '', '', '', '', '1', '_self', '0', 'en', '40', '10', null, '1657806791', '1636979415', 'normal');
INSERT INTO `hkcms_category` VALUES ('3', '2', '0', 'link', 'cms', 'about', '关于我们', '', '', '', '', 'page.html', '', '', '', '1', '_self', '0', 'zh-cn', '39', '10', null, '1636981343', '1636981343', 'normal');
INSERT INTO `hkcms_category` VALUES ('4', '2', '0', 'link', 'cms', 'about', 'About us', '', '', '', '', 'page.html', '', '', '', '1', '_self', '0', 'en', '39', '10', null, '1636981369', '1636981343', 'normal');
INSERT INTO `hkcms_category` VALUES ('5', '1', '3', 'list', 'cms', 'honor', '公司荣誉', '', '', '', 'list_team.html', 'show.html', '', '', '', '1', '_self', '0', 'zh-cn', '1', '10', null, '1657807337', '1636986900', 'normal');
INSERT INTO `hkcms_category` VALUES ('6', '1', '4', 'list', 'cms', 'honor', 'Company honor', '', '', '', 'list_honor.html', 'show.html', '', '', '', '1', '_self', '0', 'en', '0', '10', null, '1636988489', '1636986900', 'normal');
INSERT INTO `hkcms_category` VALUES ('7', '2', '3', 'link', 'cms', 'cp', '公司简介', '', '', '', '', 'page.html', '', '', '演示数据-这是栏目的描述信息', '1', '_self', '0', 'zh-cn', '2', '10', null, '1636987541', '1636986934', 'normal');
INSERT INTO `hkcms_category` VALUES ('8', '2', '4', 'link', 'cms', 'cp', 'Company Profile', '', '', '', '', 'page.html', '', '', 'Presentation data - this is the description of the column', '1', '_self', '0', 'en', '1', '10', null, '1636987740', '1636986934', 'normal');
INSERT INTO `hkcms_category` VALUES ('9', '1', '0', 'category', 'cms', 'news', '新闻中心', '', '', 'category.html', '', '', '', '', '热门资讯、新闻动态、公司新闻', '1', '_self', '0', 'zh-cn', '38', '5', null, '1637052314', '1637052314', 'normal');
INSERT INTO `hkcms_category` VALUES ('10', '1', '0', 'category', 'cms', 'news', 'News', '', '', 'category.html', '', '', '', '', 'Hot news, news trends, company news', '1', '_self', '0', 'en', '38', '5', null, '1637052662', '1637052314', 'normal');
INSERT INTO `hkcms_category` VALUES ('11', '1', '9', 'list', 'cms', 'cd', '公司新闻', '', '', '', 'list.html', 'show.html', '', '', '', '1', '_self', '0', 'zh-cn', '0', '10', null, '1637052822', '1637052636', 'normal');
INSERT INTO `hkcms_category` VALUES ('12', '1', '10', 'list', 'cms', 'cd', 'Company news', '', '', '', 'list.html', 'show.html', '', '', '', '1', '_self', '0', 'en', '0', '10', null, '1637052898', '1637052636', 'normal');
INSERT INTO `hkcms_category` VALUES ('13', '1', '9', 'list', 'cms', 'ind', '行业资讯', '', '', '', 'list.html', 'show.html', '', '', '', '1', '_self', '0', 'zh-cn', '0', '10', null, '1637052636', '1637052636', 'normal');
INSERT INTO `hkcms_category` VALUES ('14', '1', '10', 'list', 'cms', 'ind', 'Industry news', '', '', '', 'list.html', 'show.html', '', '', '', '1', '_self', '0', 'en', '0', '10', null, '1637052889', '1637052636', 'normal');
INSERT INTO `hkcms_category` VALUES ('15', '1', '9', 'list', 'cms', 'other', '其他资讯', '', '', '', 'list.html', 'show.html', '', '', '', '1', '_self', '0', 'zh-cn', '0', '10', null, '1637052636', '1637052636', 'normal');
INSERT INTO `hkcms_category` VALUES ('16', '1', '10', 'list', 'cms', 'other', 'Other info', '', '', '', 'list.html', 'show.html', '', '', '', '1', '_self', '0', 'en', '0', '10', null, '1637052867', '1637052636', 'normal');
INSERT INTO `hkcms_category` VALUES ('17', '8', '0', 'list', 'cms', 'job', 'Jobs', '', '', '', 'list_job.html', 'show_job.html', '', 'job', 'We look forward to help you in taking your company to new height.', '1', '_self', '0', 'en', '30', '10', null, '1637288210', '1637288017', 'normal');
INSERT INTO `hkcms_category` VALUES ('18', '8', '0', 'list', 'cms', 'job', '人才招聘', '', '', '', 'list_job.html', 'show.html', '', '招聘', '在帮助客户寻找综合解决方案方面拥有超过 10 年的经验。', '1', '_self', '0', 'zh-cn', '30', '10', null, '1657807885', '1637288017', 'normal');
INSERT INTO `hkcms_category` VALUES ('19', '7', '0', 'list', 'cms', 'case', '客户案例', '', '', '', 'list_case.html', 'show.html', '', 'SEO关键字', 'SEO描述', '1', '_self', '0', 'zh-cn', '35', '6', null, '1658216996', '1637289702', 'normal');
INSERT INTO `hkcms_category` VALUES ('20', '7', '0', 'list', 'cms', 'case', 'Customer case', '', '', '', 'list_image.html', 'show_image.html', '', 'SEO keywords', 'SEO description', '1', '_self', '0', 'en', '35', '6', null, '1637289809', '1637289702', 'normal');
INSERT INTO `hkcms_category` VALUES ('21', '6', '0', 'category', 'cms', 'product', '产品展示', '', '', 'category.html', '', '', 'SEO标题', 'SEO关键字,演示数据', 'SEO描述演示数据', '1', '_self', '0', 'zh-cn', '36', '10', null, '1657692407', '1637295023', 'normal');
INSERT INTO `hkcms_category` VALUES ('22', '6', '0', 'category', 'cms', 'product', 'Product', '', '', 'category_product.html', '', '', 'SEO title', 'SEO keywords, demo data', 'SEO description demo data', '1', '_self', '0', 'en', '36', '10', null, '1637295057', '1637295023', 'normal');
INSERT INTO `hkcms_category` VALUES ('23', '6', '21', 'list', 'cms', 'wc', '木椅', '', '', '', 'list_product.html', 'show_product.html', '', '', '', '1', '_self', '0', 'zh-cn', '0', '10', null, '1657807527', '1637315946', 'normal');
INSERT INTO `hkcms_category` VALUES ('24', '6', '22', 'list', 'cms', 'wc', 'Wooden Chair', '', '', '', 'list_product.html', 'show_product.html', '', '', '', '1', '_self', '0', 'en', '0', '10', null, '1637318012', '1637315946', 'normal');
INSERT INTO `hkcms_category` VALUES ('25', '6', '21', 'list', 'cms', 'sa', '单人扶手椅', '', '', '', 'list_product.html', 'show_product.html', '', '', '', '1', '_self', '0', 'zh-cn', '0', '10', null, '1657807540', '1637316027', 'normal');
INSERT INTO `hkcms_category` VALUES ('26', '6', '22', 'list', 'cms', 'sa', 'Single Armchair', '', '', '', 'list_product.html', 'show_product.html', '', '', '', '1', '_self', '0', 'en', '0', '10', null, '1637318004', '1637316027', 'normal');
INSERT INTO `hkcms_category` VALUES ('27', '6', '21', 'list', 'cms', 'wb', '木床', '', '', '', 'list_product.html', 'show_product.html', '', '', '', '1', '_self', '0', 'zh-cn', '0', '10', null, '1657807534', '1637316067', 'normal');
INSERT INTO `hkcms_category` VALUES ('28', '6', '22', 'list', 'cms', 'wb', 'Wooden Bed', '', '', '', 'list_product.html', 'show_product.html', '', '', '', '1', '_self', '0', 'en', '0', '10', null, '1637318050', '1637316067', 'normal');
INSERT INTO `hkcms_category` VALUES ('29', '2', '0', 'link', 'cms', 'us', '联系我们', '', '', '', '', 'page_contact.html', '', '', '', '1', '_self', '0', 'zh-cn', '0', '10', null, '1637318149', '1637318114', 'normal');
INSERT INTO `hkcms_category` VALUES ('30', '2', '0', 'link', 'cms', 'us', 'Contact us', '', '', '', '', 'page_contact.html', '', '', '', '1', '_self', '0', 'en', '0', '10', null, '1637318152', '1637318114', 'normal');
INSERT INTO `hkcms_category` VALUES ('31', '2', '3', 'link', 'cms', 'ser', '我们的服务', '', '', '', '', 'page.html', '', '', '', '1', '_self', '0', 'zh-cn', '0', '10', null, '1637386778', '1637386732', 'normal');
INSERT INTO `hkcms_category` VALUES ('32', '2', '4', 'link', 'cms', 'ser', 'Our service', '', '', '', '', 'page.html', '', '', '', '1', '_self', '0', 'en', '0', '10', null, '1637386768', '1637386732', 'normal');
INSERT INTO `hkcms_category` VALUES ('33', '5', '30', 'link', 'cms', 'msg', 'Message', '', '', '', '', 'page.html', '', '', '', '0', '_self', '0', 'en', '0', '10', null, '1637388362', '1637388218', 'normal');
INSERT INTO `hkcms_category` VALUES ('34', '5', '29', 'link', 'cms', 'msg', '在线留言', '', '', '', '', 'page_guestbook.html', '', '', '', '0', '_self', '0', 'zh-cn', '0', '10', null, '1657695727', '1637388218', 'normal');
INSERT INTO `hkcms_category` VALUES ('35', '1', '9', 'list', 'cms', 'mr', '媒体报导', '', '', '', 'list.html', 'show.html', '', '', '', '1', '_self', '0', 'zh-cn', '0', '10', null, '1637052822', '1637052636', 'normal');
INSERT INTO `hkcms_category` VALUES ('36', '1', '10', 'list', 'cms', 'mr', 'Media reports', '', '', '', 'list.html', 'show.html', '', '', '', '1', '_self', '0', 'en', '0', '10', null, '1637052898', '1637052636', 'normal');
INSERT INTO `hkcms_category` VALUES ('37', '7', '19', 'list', 'cms', 'snsj', '室内设计', '', '', '', 'list_case.html', 'show.html', '', '', '', '1', '_self', '0', 'zh-cn', '0', '10', null, '1658217018', '1656579210', 'normal');
INSERT INTO `hkcms_category` VALUES ('38', '7', '20', 'list', 'cms', 'snsj', 'Interior design', '', '', '', 'list_image.html', 'show_image.html', '', '', '', '1', '_self', '0', 'en', '0', '10', null, '1656579210', '1656579210', 'normal');
INSERT INTO `hkcms_category` VALUES ('39', '7', '19', 'list', 'cms', 'pmsj', '平面设计', '', '', '', 'list_case.html', 'show.html', '', '', '', '1', '_self', '0', 'zh-cn', '0', '10', null, '1658217025', '1656579407', 'normal');
INSERT INTO `hkcms_category` VALUES ('40', '7', '20', 'list', 'cms', 'pmsj', 'Graphic design', '', '', '', 'list_image.html', 'show_image.html', '', '', '', '1', '_self', '0', 'en', '0', '10', null, '1656579407', '1656579407', 'normal');
INSERT INTO `hkcms_category` VALUES ('41', '5', '18', 'link', 'cms', 'zaixianzhaopin', '在线招聘', '', '', '', '', 'page_guestbook.html', '', '', '', '0', '_self', '0', 'zh-cn', '0', '10', null, '1657214351', '1657214339', 'normal');
INSERT INTO `hkcms_category` VALUES ('42', '5', '17', 'link', 'cms', 'zaixianzhaopin', 'Online jobs', '', '', '', '', 'page_guestbook.html', '', '', '', '0', '_self', '0', 'en', '0', '10', null, '1657214339', '1657214339', 'normal');


DROP TABLE IF EXISTS `hkcms_category_priv`;
CREATE TABLE `hkcms_category_priv` (
  `category_id` int(10) unsigned NOT NULL COMMENT '栏目ID',
  `auth_group_id` mediumint(8) NOT NULL COMMENT '管理员ID',
  `action` char(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '操作方法'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='栏目权限';



DROP TABLE IF EXISTS `hkcms_config`;
CREATE TABLE `hkcms_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '分组：basics（基础），mail（邮箱），extend（扩展）',
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '键名',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '名称',
  `value` text COLLATE utf8mb4_unicode_ci COMMENT '值',
  `type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '类型',
  `data_list` text COLLATE utf8mb4_unicode_ci COMMENT '数据列表',
  `tips` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '提示',
  `error_tips` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '错误提示',
  `rules` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '规则',
  `extend` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '附加属性',
  `max_number` int(11) NOT NULL DEFAULT '0' COMMENT '最大数量',
  `is_default` tinyint(1) NOT NULL DEFAULT '1' COMMENT '默认配置',
  `lang` char(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '语言标识',
  `setting` text COLLATE utf8mb4_unicode_ci COMMENT '配置信息',
  `weigh` int(11) NOT NULL DEFAULT '1' COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uq_name_lang` (`name`,`lang`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=93 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='全站配置';

INSERT INTO `hkcms_config` VALUES ('1', 'basics', 'title', 'Site name', '某科技模板', 'text', null, '请填写网站名称', '', '', '', '0', '1', 'zh-cn', null, '1');
INSERT INTO `hkcms_config` VALUES ('2', 'basics', 'cdn', 'CDN', '', 'text', null, 'CDN、填写域名后静态资源也将改变，无需\"/\"结尾', '', '', '', '0', '1', '-1', null, '8');
INSERT INTO `hkcms_config` VALUES ('3', 'basics', 'home_title', 'Home title', 'HkCms演示站点 - 网站首页', 'text', null, '', '', '', '', '0', '1', 'zh-cn', null, '1');
INSERT INTO `hkcms_config` VALUES ('4', 'basics', 'keyword', 'Home Keyword', '开源、可商用、免授权、开箱即用', 'textarea', null, '建议不超过100字符', '', '', '', '0', '1', 'zh-cn', null, '1');
INSERT INTO `hkcms_config` VALUES ('5', 'basics', 'description', 'Home description', 'HkCms开源内容管理系统是一款基于ThinkPHP6.0开发的CMS系统。以免授权、永久商用、系统易安装升级、界面功能简洁轻便、易上手、插件与模板在线升级安装、建站联盟扶持计划等优势为一体的CMS系统。', 'textarea', null, '建议不超过200字符', '', '', '', '0', '1', 'zh-cn', null, '1');
INSERT INTO `hkcms_config` VALUES ('6', 'basics', 'icp', 'Case number', '粤ICP备10XXXX00号', 'text', null, '粤ICP备10000000号-1', '', '', '', '0', '1', 'zh-cn', null, '1');
INSERT INTO `hkcms_config` VALUES ('8', 'basics', 'version', 'Version', '1.0.3', 'text', null, '修改版本号更新前台JS、CSS', '', '', '', '0', '1', '-1', null, '9');
INSERT INTO `hkcms_config` VALUES ('9', 'mail', 'mail_type', 'Mail sending mode', 'smtp', 'select', '{\"smtp\":\"SMTP\"}', '选择邮件发送方式', '', '', '', '0', '1', '-1', null, '2');
INSERT INTO `hkcms_config` VALUES ('10', 'mail', 'mail_server', 'SMTP server', 'smtp.qq.com', 'text', null, '错误的配置发送邮件会导致服务器超时', '', '', '', '0', '1', '-1', null, '2');
INSERT INTO `hkcms_config` VALUES ('11', 'mail', 'mail_port', 'SMTP port', '465', 'text', null, '(不加密默认25,SSL默认465,TLS默认587)', '', '', '', '0', '1', '-1', null, '2');
INSERT INTO `hkcms_config` VALUES ('12', 'mail', 'mail_from', 'Sender mailbox', '', 'text', null, '（填写完整邮箱）', '', '', '', '0', '1', '-1', null, '2');
INSERT INTO `hkcms_config` VALUES ('13', 'mail', 'mail_fname', 'Sender name', '', 'text', null, '（发件人名称标题）', '', '', '', '0', '1', '-1', null, '2');
INSERT INTO `hkcms_config` VALUES ('14', 'mail', 'mail_auth', 'SMTP auth', 'ssl', 'select', '{\"ssl\":\"SSL\",\"tls\":\"TLS\"}', '（SMTP验证方式[推荐SSL]）', '', '', '', '0', '1', '-1', null, '2');
INSERT INTO `hkcms_config` VALUES ('15', 'mail', 'mail_user', 'SMTP username', '', 'text', null, '（填写完整邮箱）', '', '', '', '0', '1', '-1', null, '2');
INSERT INTO `hkcms_config` VALUES ('16', 'mail', 'mail_password', 'SMTP password', '', 'text', null, '（密码）', '', '', '', '0', '1', '-1', null, '2');
INSERT INTO `hkcms_config` VALUES ('17', 'upload', 'file_type', 'Upload attachment type', 'jpg|gif|png|bmp|jpeg|ico|zip|gz|rar|iso|txt|doc|xls|ppt|wps|swf|mpg|mp3|rm|rmvb|wmv|wma|wav|mid|mov|mp4', 'textarea', null, '格式：value0|value1|value2', '', '', '', '0', '1', '-1', null, '1');
INSERT INTO `hkcms_config` VALUES ('18', 'upload', 'file_size', 'Upload attachment size', '10', 'number', null, 'MB', '', 'required', '', '0', '1', '-1', null, '1');
INSERT INTO `hkcms_config` VALUES ('35', 'more', 'cloud_username', 'Application center account', '', 'text', null, '应用中心登录账号', '', '', '', '0', '1', '-1', null, '1');
INSERT INTO `hkcms_config` VALUES ('36', 'more', 'cloud_password', 'Application center password', '', 'text', null, '应用中心登录账号的密码', '', '', '', '0', '1', '-1', null, '1');
INSERT INTO `hkcms_config` VALUES ('42', 'basics', 'logo', 'Website LOGO', '/static/module/index/abzbzs/img/logo.png', 'image', null, '', '', '', '', '0', '1', 'zh-cn', null, '1');
INSERT INTO `hkcms_config` VALUES ('43', 'basics', 'favicon', 'Address bar icon', '/favicon.ico', 'image', null, '', '', '', '', '0', '1', 'zh-cn', null, '1');
INSERT INTO `hkcms_config` VALUES ('44', 'basics', 'web_status', 'Site status', '1', 'radio', '{\"1\":\"\\u5f00\\u542f\",\"0\":\"\\u5173\\u95ed\"}', '', '', '', '', '0', '1', '-1', null, '10');
INSERT INTO `hkcms_config` VALUES ('47', 'more', 'admin_theme', 'Background template', 'adminlte', 'text', null, '', '', '', '', '0', '1', '-1', null, '1');
INSERT INTO `hkcms_config` VALUES ('48', 'more', 'index_theme', 'Foreground template', 'abzbzs2', 'text', null, '', '', '', '', '0', '1', '-1', null, '1');
INSERT INTO `hkcms_config` VALUES ('49', 'language', 'admin_lang', 'Background language', 'zh-cn', 'select', '{\"zh-cn\":\"中文简体\",\"en\":\"English\"}', '', '', '', '', '0', '1', '-1', null, '1');
INSERT INTO `hkcms_config` VALUES ('50', 'language', 'index_lang', 'Foreground language', 'zh-cn', 'select', '{\"zh-cn\":\"中文简体\",\"en\":\"English\"}', '', '', '', '', '0', '1', '-1', null, '1');
INSERT INTO `hkcms_config` VALUES ('51', 'group', 'group', 'Group config', '{\"basics\":\"Basic config\",\"mail\":\"Mail config\",\"upload\":\"Upload config\",\"language\":\"Language\",\"more\":\"Advanced config\"}', '', null, '配置分组', '', '', '', '0', '1', '-1', null, '1');
INSERT INTO `hkcms_config` VALUES ('52', 'upload', 'upload_url', 'Upload url', '/common/upload', 'text', null, '每个模块默认上传地址', '', '', '', '0', '1', '-1', null, '1');
INSERT INTO `hkcms_config` VALUES ('53', 'upload', 'cdn_url', 'CDN url', '', 'text', null, '', '', '', '', '0', '1', '-1', null, '1');
INSERT INTO `hkcms_config` VALUES ('54', 'upload', 'savename', 'Save format', '/uploads/{year}{month}{day}/{md5}{suffix}', 'text', null, '', '', '', '', '0', '1', '-1', null, '1');
INSERT INTO `hkcms_config` VALUES ('55', 'upload', 'chunk', 'Chunk', '2', 'radio', '{\"1\":\"\\u5f00\\u542f\",\"2\":\"\\u5173\\u95ed\"}', '', '', '', '', '0', '1', '-1', null, '1');
INSERT INTO `hkcms_config` VALUES ('56', 'upload', 'chunk_size', 'Chunk size', '2', 'number', null, '单位：MB', '', 'required', '', '0', '1', '-1', null, '1');
INSERT INTO `hkcms_config` VALUES ('57', 'more', 'url_mode', 'URL mode', '0', 'radio', '{\"1\":\"伪静态\",\"0\":\"动态\",\"2\":\"静态页面\"}', '', '', '', '', '0', '1', '-1', null, '1');
INSERT INTO `hkcms_config` VALUES ('58', 'language', 'content_lang_on', 'Content multilingual', '1', 'radio', '{\"1\":\"开启\",\"2\":\"关闭\"}', '内容多语言，开启后栏目、内容将支持多语言。详情前往手册了解', '', '', '', '0', '1', '-1', null, '1');
INSERT INTO `hkcms_config` VALUES ('59', 'mail', 'mail_on', 'Mailbox switch', '0', 'radio', '{\"1\":\"开启\",\"0\":\"关闭\"}', '', '', '', '', '0', '1', '-1', null, '1');
INSERT INTO `hkcms_config` VALUES ('60', 'more', 'url_rewrite', 'URL rewrite', '{\"search/index\":\"/search$.html\",\"guestbook/index\":\"/guestbook$.html\",\"index/lists\":\"/:catname/$,/:catname/list_:page$.html\",\"index/show\":\"/:catname/:id$.html\"}', 'array', '{\"key\":\"URL\\u5730\\u5740\",\"value\":\"\\u89c4\\u5219\"}', '', '', '', '', '0', '1', '-1', null, '3');
INSERT INTO `hkcms_config` VALUES ('61', 'language', 'content_lang', 'Content language', 'zh-cn', 'select', '{\"zh-cn\":\"中文简体\",\"en\":\"English\"}', '', '', '', '', '0', '1', '-1', null, '1');
INSERT INTO `hkcms_config` VALUES ('62', 'more', 'mobile_domain', 'Mobile domain name', '', 'text', null, '填写域名后开启，访问时将自动访问手机端模板，如果是响应式则访问响应式', '', '', '', '0', '1', '-1', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '4');
INSERT INTO `hkcms_config` VALUES ('63', 'more', 'url_file', 'Entry file', '1', 'radio', '{\"1\":\"显示\",\"0\":\"隐藏\"}', '用于URL模式为动态时，默认加上入口文件实现无需配置URL重写，注意：隐藏后您的服务器必须配置URL重写才能正常访问', '', '', '', '0', '1', '-1', null, '2');
INSERT INTO `hkcms_config` VALUES ('64', 'more', 'category_format', 'Column title format', '$name - $site', 'text', null, '', '', '', '', '0', '1', '-1', null, '8');
INSERT INTO `hkcms_config` VALUES ('65', 'more', 'content_format', 'Content title format', '$title - $name - $site', 'text', null, '', '', '', '', '0', '1', '-1', null, '8');
INSERT INTO `hkcms_config` VALUES ('66', 'basics', 'thirdcode_pc', 'Third party code,PC', '', 'textarea', null, '代码自动放在前台网页底部，无需手动添加，常用于站点统计、百度商桥等代码', '', '', '', '0', '1', '-1', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '9');
INSERT INTO `hkcms_config` VALUES ('67', 'basics', 'thirdcode_mobile', 'Third party code,Mobile', '', 'textarea', null, '代码自动放在前台网页底部，无需手动添加，常用于站点统计、百度商桥等代码', '', '', '', '0', '1', '-1', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '9');
INSERT INTO `hkcms_config` VALUES ('68', 'basics', 'dev', 'Developer', 'disabled', 'radio', '{\"enable\":\"\\u5f00\\u542f\",\"disabled\":\"\\u5173\\u95ed\"}', '一键开启调试模式，方便修改页面、不受缓存影响以及显示详细的错误信息。', '', '', '', '0', '1', '-1', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '9');
INSERT INTO `hkcms_config` VALUES ('69', 'basics', 'title', 'Site name', 'en_某科技', 'text', null, '请填写网站名称', '', '', '', '0', '1', 'en', null, '1');
INSERT INTO `hkcms_config` VALUES ('70', 'basics', 'home_title', 'Home title', 'HkCms Demo site - homepage', 'text', null, '', '', '', '', '0', '1', 'en', null, '1');
INSERT INTO `hkcms_config` VALUES ('71', 'basics', 'keyword', 'Home Keyword', 'en_开源、可商用、免授权、开箱即用', 'textarea', null, '建议不超过100字符', '', '', '', '0', '1', 'en', null, '1');
INSERT INTO `hkcms_config` VALUES ('72', 'basics', 'description', 'Home description', 'en_HkCms开源内容管理系统是一款基于ThinkPHP6.0开发的CMS系统。以免授权、永久商用、系统易安装升级、界面功能简洁轻便、易上手、插件与模板在线升级安装、建站联盟扶持计划等优势为一体的CMS系统。', 'textarea', null, '建议不超过200字符', '', '', '', '0', '1', 'en', null, '1');
INSERT INTO `hkcms_config` VALUES ('73', 'basics', 'icp', 'Case number', '粤ICP备10XXXX00号', 'text', null, '粤ICP备10000000号-1', '', '', '', '0', '1', 'en', null, '1');
INSERT INTO `hkcms_config` VALUES ('74', 'basics', 'logo', 'Website LOGO', '/static/module/index/abswkjsy/img/logo.png', 'image', null, '', '', '', '', '0', '1', 'en', null, '1');
INSERT INTO `hkcms_config` VALUES ('75', 'basics', 'favicon', 'Address bar icon', '/favicon.ico', 'image', null, '', '', '', '', '0', '1', 'en', null, '1');
INSERT INTO `hkcms_config` VALUES ('76', 'seo', 'html_dir', '静态文件保存目录', '', 'text', null, '', '', '', '', '0', '1', '-1', null, '1');
INSERT INTO `hkcms_config` VALUES ('77', 'seo', 'html_column_rules', '栏目规则', '/[list]/index.html|/[list]/index_[page].html', 'text', null, '', '', '', '', '0', '1', '-1', null, '1');
INSERT INTO `hkcms_config` VALUES ('78', 'seo', 'html_content_rules', '内容规则', '/[list]/[id].html|/[list]/[id]_[page].html', 'text', null, '', '', '', '', '0', '1', '-1', null, '1');
INSERT INTO `hkcms_config` VALUES ('79', 'water', 'water_on', '水印功能', '0', 'radio', '{\"1\":\"\\u5f00\\u542f\",\"0\":\"\\u5173\\u95ed\"}', '', '', '', '', '0', '1', '-1', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '11');
INSERT INTO `hkcms_config` VALUES ('80', 'water', 'water_type', '水印类型', '1', 'radio', '{\"1\":\"\\u56fe\\u7247\",\"2\":\"\\u6587\\u5b57\"}', '', '', '', '', '0', '1', '-1', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '12');
INSERT INTO `hkcms_config` VALUES ('81', 'water', 'water_img', '水印图片', '/static/common/image/water.png', 'text', null, '', '', '', '', '0', '1', '-1', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '13');
INSERT INTO `hkcms_config` VALUES ('82', 'water', 'water_width', '图片宽度', '100', 'text', null, '', '', '', '', '0', '1', '-1', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '14');
INSERT INTO `hkcms_config` VALUES ('83', 'water', 'water_height', '图片高度', '50', 'text', null, '', '', '', '', '0', '1', '-1', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '15');
INSERT INTO `hkcms_config` VALUES ('84', 'water', 'water_text', '文字', 'HkCms', 'text', null, '', '', '', '', '0', '1', '-1', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '16');
INSERT INTO `hkcms_config` VALUES ('85', 'water', 'water_text_size', '文字大小', '16', 'text', null, '', '', '', '', '0', '1', '-1', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '17');
INSERT INTO `hkcms_config` VALUES ('86', 'water', 'water_text_color', '文字颜色', '#00000042', 'text', null, '', '', '', '', '0', '1', '-1', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '18');
INSERT INTO `hkcms_config` VALUES ('87', 'water', 'water_img_opacity', '水印透明度', '60', 'text', null, '', '', '', '', '0', '1', '-1', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '19');
INSERT INTO `hkcms_config` VALUES ('88', 'water', 'water_img_position', '水印位置', '7', 'text', null, '', '', '', '', '0', '1', '-1', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '20');
INSERT INTO `hkcms_config` VALUES ('89', 'thumb', 'thumb_on', '缩略图', '0', 'radio', '{\"1\":\"\\u5f00\\u542f\",\"0\":\"\\u5173\\u95ed\"}', '', '', '', '', '0', '1', '-1', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '11');
INSERT INTO `hkcms_config` VALUES ('90', 'thumb', 'thumb_type', '生成方式', '1', 'text', null, '', '', '', '', '0', '1', '-1', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '12');
INSERT INTO `hkcms_config` VALUES ('91', 'thumb', 'thumb_width', '宽度', '160', 'text', null, '', '', '', '', '0', '1', '-1', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '13');
INSERT INTO `hkcms_config` VALUES ('92', 'thumb', 'thumb_height', '高度', '120', 'text', null, '', '', '', '', '0', '1', '-1', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '14');


DROP TABLE IF EXISTS `hkcms_ems`;
CREATE TABLE `hkcms_ems` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `event` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '事件',
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '邮箱',
  `code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '验证码',
  `count` int(11) NOT NULL DEFAULT '0' COMMENT '验证次数',
  `ip` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'IP',
  `create_time` int(11) NOT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;



DROP TABLE IF EXISTS `hkcms_fields`;
CREATE TABLE `hkcms_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `source` varchar(30) NOT NULL DEFAULT '' COMMENT '来源',
  `source_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '来源ID',
  `field_name` varchar(20) NOT NULL COMMENT '字段名称',
  `field_title` varchar(50) NOT NULL DEFAULT '' COMMENT '字段中文名',
  `form_type` varchar(20) NOT NULL COMMENT '字段类型',
  `field_group` varchar(50) NOT NULL DEFAULT '常规' COMMENT '字段分组',
  `length` int(11) NOT NULL DEFAULT '250' COMMENT '长度',
  `default_value` text COMMENT '默认值',
  `data_list` text COMMENT '选项列表',
  `max_number` int(11) NOT NULL DEFAULT '0' COMMENT '最大数量',
  `decimals` tinyint(4) NOT NULL DEFAULT '0' COMMENT '小数位',
  `rules` varchar(255) NOT NULL DEFAULT '' COMMENT '规则',
  `tips` varchar(255) NOT NULL DEFAULT '' COMMENT '提示信息',
  `error_tips` varchar(255) NOT NULL DEFAULT '' COMMENT '错误提示',
  `extend` varchar(500) NOT NULL DEFAULT '' COMMENT '附加属性',
  `weigh` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `setting` text COMMENT '配置信息',
  `status` enum('normal','hidden') NOT NULL DEFAULT 'normal' COMMENT '状态:normal-正常,hidden-禁用',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='通用字段表';



DROP TABLE IF EXISTS `hkcms_flags`;
CREATE TABLE `hkcms_flags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` char(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '名称',
  `name` char(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '属性值',
  `weigh` int(11) NOT NULL DEFAULT '1' COMMENT '排序',
  `lang` char(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '语言',
  `status` enum('normal','hidden') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'normal' COMMENT '状态',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

INSERT INTO `hkcms_flags` VALUES ('1', '置顶', 'top', '1', 'zh-cn', 'normal', '1650166154', '1650166154');
INSERT INTO `hkcms_flags` VALUES ('2', 'Top', 'top', '1', 'en', 'normal', '1650166154', '1650166178');


DROP TABLE IF EXISTS `hkcms_guestbook`;
CREATE TABLE `hkcms_guestbook` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL COMMENT '栏目ID',
  `model_id` int(11) NOT NULL COMMENT '模型ID',
  `name` char(100) NOT NULL DEFAULT '' COMMENT '姓名',
  `email` char(250) NOT NULL DEFAULT '' COMMENT '邮箱',
  `phone` char(20) NOT NULL DEFAULT '' COMMENT '手机',
  `content` varchar(250) NOT NULL DEFAULT '' COMMENT '内容',
  `title` char(100) NOT NULL DEFAULT '' COMMENT '申请职位',
  `is_read` tinyint(1) NOT NULL DEFAULT '0' COMMENT '查阅:1=已阅读,0=未读',
  `lang` char(20) NOT NULL DEFAULT '' COMMENT '语言标识',
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT 'IP',
  `show_tpl` varchar(50) NOT NULL DEFAULT 'page_guestbook.html' COMMENT '模板',
  `read_time` int(11) DEFAULT NULL COMMENT '阅读时间',
  `status` enum('normal','hidden','reject','audit') NOT NULL DEFAULT 'normal' COMMENT '状态',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='留言表单';



DROP TABLE IF EXISTS `hkcms_images`;
CREATE TABLE `hkcms_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL COMMENT '栏目ID',
  `model_id` int(11) NOT NULL COMMENT '模型ID',
  `admin_id` int(11) NOT NULL COMMENT '管理员ID',
  `title` varchar(200) NOT NULL DEFAULT '' COMMENT '标题',
  `thumb` varchar(100) NOT NULL DEFAULT '' COMMENT '缩略封面图',
  `seotitle` varchar(200) NOT NULL DEFAULT '' COMMENT 'SEO标题',
  `keywords` varchar(200) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(250) NOT NULL DEFAULT '' COMMENT '描述',
  `tags` varchar(255) NOT NULL DEFAULT '' COMMENT '标签',
  `show_tpl` char(100) NOT NULL DEFAULT 'show.html' COMMENT '内容模板',
  `publish_time` int(11) DEFAULT NULL COMMENT '发布时间',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  `delete_time` int(11) DEFAULT NULL COMMENT '删除时间',
  `weigh` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `author` char(250) NOT NULL DEFAULT '小编' COMMENT '作者',
  `url` char(250) NOT NULL DEFAULT '' COMMENT 'URL',
  `views` int(11) NOT NULL DEFAULT '0' COMMENT '浏览量',
  `lang` varchar(20) NOT NULL DEFAULT '' COMMENT '语言标识',
  `status` enum('normal','hidden','reject','audit') NOT NULL DEFAULT 'normal' COMMENT '状态',
  `flags` varchar(100) NOT NULL DEFAULT '' COMMENT '文档属性',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

INSERT INTO `hkcms_images` VALUES ('1', '38', '7', '1', 'Customer Cases (Demo Data)', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg', '', 'keyword,seo,customer case', 'Most folks are about as happy as they make up their minds to be .', '', 'show_image.html', '1637382374', '1637382374', '1637382465', null, '0', 'default', '', '8', 'en', 'normal', '');
INSERT INTO `hkcms_images` VALUES ('2', '37', '7', '1', '客户案例A', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg', '', '关键字,seo,客户案例', '对于大多数人来说，他们认定自己有多幸福，就有多幸福。', '', 'show.html', '1637382375', '1637382375', '1637382464', null, '0', '小编', '', '1', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_images` VALUES ('3', '37', '7', '1', '客户案例B', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg', '', '关键字,seo,客户案例', '对于大多数人来说，他们认定自己有多幸福，就有多幸福。', '', 'show.html', '1637382375', '1637382383', '1637382383', null, '0', '小编', '', '0', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_images` VALUES ('4', '37', '7', '1', '客户案例C', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg', '', '关键字,seo,客户案例', '对于大多数人来说，他们认定自己有多幸福，就有多幸福。', '', 'show.html', '1637382375', '1637382387', '1637382478', null, '0', '小编', '', '0', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_images` VALUES ('5', '37', '7', '1', '客户案例D', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg', '', '关键字,seo,客户案例', '对于大多数人来说，他们认定自己有多幸福，就有多幸福。', '', 'show.html', '1637382375', '1637382394', '1637382394', null, '0', '小编', '', '0', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_images` VALUES ('6', '38', '7', '1', 'Customer Cases (Demo Data)', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg', '', 'keyword,seo,customer case', 'Most folks are about as happy as they make up their minds to be .', '', 'show_image.html', '1637382374', '1637382397', '1637382397', null, '0', 'default', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_images` VALUES ('7', '38', '7', '1', 'Customer Cases (Demo Data)', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg', '', 'keyword,seo,customer case', 'Most folks are about as happy as they make up their minds to be .', '', 'show_image.html', '1637382374', '1637382401', '1637382476', null, '0', 'default', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_images` VALUES ('8', '38', '7', '1', 'Customer Cases (Demo Data)', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg', '', 'keyword,seo,customer case', 'Most folks are about as happy as they make up their minds to be .', '', 'show_image.html', '1637382374', '1637382407', '1637382407', null, '0', 'default', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_images` VALUES ('9', '37', '7', '1', '客户案例E', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg', '', '关键字,seo,客户案例', '对于大多数人来说，他们认定自己有多幸福，就有多幸福。', '', 'show.html', '1637382375', '1637382411', '1637382411', null, '0', '小编', '', '1', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_images` VALUES ('10', '37', '7', '1', '客户案例F', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg', '', '关键字,seo,客户案例', '对于大多数人来说，他们认定自己有多幸福，就有多幸福。', '', 'show.html', '1637382375', '1637382411', '1637382491', null, '0', '小编', '', '4', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_images` VALUES ('11', '39', '7', '1', '客户案例G', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg', '', '关键字,seo,客户案例', '对于大多数人来说，他们认定自己有多幸福，就有多幸福。', '', 'show.html', '1637382375', '1637382411', '1637382554', null, '0', '小编', '', '1', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_images` VALUES ('12', '39', '7', '1', '客户案例H', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg', '', '关键字,seo,客户案例', '对于大多数人来说，他们认定自己有多幸福，就有多幸福。', '', 'show.html', '1637382375', '1637382411', '1637382411', null, '0', '小编', '', '2', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_images` VALUES ('13', '38', '7', '1', 'Customer Cases (Demo Data)', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg', '', 'keyword,seo,customer case', 'Most folks are about as happy as they make up their minds to be .', '', 'show_image.html', '1637382374', '1637382417', '1637382553', null, '0', 'default', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_images` VALUES ('14', '38', '7', '1', 'Customer Cases (Demo Data)', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg', '', 'keyword,seo,customer case', 'Most folks are about as happy as they make up their minds to be .', '', 'show_image.html', '1637382374', '1637382417', '1637382495', null, '0', 'default', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_images` VALUES ('15', '40', '7', '1', 'Customer Cases (Demo Data)', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg', '', 'keyword,seo,customer case', 'Most folks are about as happy as they make up their minds to be .', '', 'show_image.html', '1637382374', '1637382417', '1637382417', null, '0', 'default', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_images` VALUES ('16', '40', '7', '1', 'Customer Cases (Demo Data)', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg', '', 'keyword,seo,customer case', 'Most folks are about as happy as they make up their minds to be .', '', 'show_image.html', '1637382374', '1637382417', '1637382417', null, '0', 'default', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_images` VALUES ('17', '39', '7', '1', '客户案例XZ', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg', '', '关键字,seo,客户案例', '对于大多数人来说，他们认定自己有多幸福，就有多幸福。', '', 'show.html', '1637382375', '1637382411', '1637382411', null, '0', '小编', '', '9', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_images` VALUES ('18', '40', '7', '1', 'Customer Cases XZ', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg', '', 'keyword,seo,customer case', 'Most folks are about as happy as they make up their minds to be .', '', 'show_image.html', '1637382374', '1637382417', '1637382417', null, '0', 'default', '', '0', 'en', 'normal', '');


DROP TABLE IF EXISTS `hkcms_images_data`;
CREATE TABLE `hkcms_images_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content` text,
  `images` varchar(1000) NOT NULL DEFAULT '' COMMENT '图集',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

INSERT INTO `hkcms_images_data` VALUES ('1', '<p><span style=\"\">Customer Cases (Demo Data)</span></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg');
INSERT INTO `hkcms_images_data` VALUES ('2', '<p><span style=\"\">客户案例内容描述信息1</span></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg');
INSERT INTO `hkcms_images_data` VALUES ('3', '<p><span style=\"\">客户案例内容描述信息2</span></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg');
INSERT INTO `hkcms_images_data` VALUES ('4', '<p><span style=\"\">客户案例内容描述信息3</span></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg');
INSERT INTO `hkcms_images_data` VALUES ('5', '<p><span style=\"\">客户案例内容描述信息4</span></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg');
INSERT INTO `hkcms_images_data` VALUES ('6', '<p><span style=\"\">Customer Cases (Demo Data)</span></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg');
INSERT INTO `hkcms_images_data` VALUES ('7', '<p><span style=\"\">Customer Cases (Demo Data)</span></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg');
INSERT INTO `hkcms_images_data` VALUES ('8', '<p><span style=\"\">Customer Cases (Demo Data)</span></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg');
INSERT INTO `hkcms_images_data` VALUES ('9', '<p><span style=\"\">客户案例内容描述信息1</span></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg');
INSERT INTO `hkcms_images_data` VALUES ('10', '<p><span style=\"\">客户案例内容描述信息2</span></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg');
INSERT INTO `hkcms_images_data` VALUES ('11', '<p><span style=\"\">客户案例内容描述信息3</span></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg');
INSERT INTO `hkcms_images_data` VALUES ('12', '<p><span style=\"\">客户案例内容描述信息4</span></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg');
INSERT INTO `hkcms_images_data` VALUES ('13', '<p><span style=\"\">Customer Cases (Demo Data)</span></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg');
INSERT INTO `hkcms_images_data` VALUES ('14', '<p><span style=\"\">Customer Cases (Demo Data)</span></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg');
INSERT INTO `hkcms_images_data` VALUES ('15', '<p><span style=\"\">Customer Cases (Demo Data)</span></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg');
INSERT INTO `hkcms_images_data` VALUES ('16', '<p><span style=\"\">Customer Cases (Demo Data)</span></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg');
INSERT INTO `hkcms_images_data` VALUES ('17', '<p><span style=\"\">客户案例内容描述信息、更多案例</span></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg');
INSERT INTO `hkcms_images_data` VALUES ('18', '<p><span style=\"\">Customer Cases (Demo Data)、more</span></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg');


DROP TABLE IF EXISTS `hkcms_job`;
CREATE TABLE `hkcms_job` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL COMMENT '栏目ID',
  `model_id` int(11) NOT NULL COMMENT '模型ID',
  `admin_id` int(11) NOT NULL COMMENT '管理员ID',
  `title` varchar(200) NOT NULL DEFAULT '' COMMENT '标题',
  `seotitle` varchar(200) NOT NULL DEFAULT '' COMMENT 'SEO标题',
  `keywords` varchar(200) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(250) NOT NULL DEFAULT '' COMMENT '描述',
  `tags` varchar(255) NOT NULL DEFAULT '' COMMENT '标签',
  `show_tpl` char(100) NOT NULL DEFAULT 'show.html' COMMENT '内容模板',
  `publish_time` int(11) DEFAULT NULL COMMENT '发布时间',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  `delete_time` int(11) DEFAULT NULL COMMENT '删除时间',
  `weigh` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `author` char(250) NOT NULL DEFAULT 'HR' COMMENT '作者',
  `url` char(250) NOT NULL DEFAULT '' COMMENT 'URL',
  `views` int(11) NOT NULL DEFAULT '0' COMMENT '浏览量',
  `lang` varchar(20) NOT NULL DEFAULT '' COMMENT '语言标识',
  `status` enum('normal','hidden','reject','audit') NOT NULL DEFAULT 'normal' COMMENT '状态',
  `flags` varchar(100) NOT NULL DEFAULT '' COMMENT '文档属性',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

INSERT INTO `hkcms_job` VALUES ('13', '18', '8', '1', 'PHP开发工程师', '', 'PHP', 'PHP开发工程师招募', '', 'show.html', '1618564047', '1618564047', '1618564047', null, '0', 'HR', '', '21', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_job` VALUES ('14', '18', '8', '1', 'PHP工程师', '', 'PHP', 'PHP开发工程师招募', '', 'show.html', '1618564047', '1618564047', '1618564047', null, '0', 'HR', '', '10', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_job` VALUES ('15', '18', '8', '1', 'Python开发', '', 'Python', 'Python招募', '', 'show.html', '1618564047', '1618564047', '1618564047', null, '0', 'HR', '', '3', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_job` VALUES ('16', '18', '8', '1', 'Vue前端工程师', '', 'vue,js', 'vue招募', '', 'show.html', '1618564047', '1618564047', '1618564047', null, '0', 'HR', '', '12', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_job` VALUES ('17', '18', '8', '1', 'Vue初级工程师', '', 'vue,js', 'vue初级招募', '', 'show.html', '1618564047', '1618564047', '1618564047', null, '0', 'HR', '', '2', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_job` VALUES ('18', '18', '8', '1', 'Uniapp', '', 'vue,js,Uniapp', 'Uniapp', '', 'show.html', '1618564047', '1618564047', '1618564047', null, '0', 'HR', '', '1', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_job` VALUES ('19', '18', '8', '1', 'Go开发', '', 'go', 'golang', '', 'show.html', '1618564047', '1618564047', '1618564047', null, '0', 'HR', '', '1', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_job` VALUES ('20', '18', '8', '1', 'Uniapp', '', 'Uniapp', 'Uniapp', '', 'show.html', '1618564047', '1618564047', '1618564047', null, '0', 'HR', '', '8', 'zh-cn', 'normal', '');
INSERT INTO `hkcms_job` VALUES ('21', '17', '8', '1', 'PHP Developer', '', '', '', '', 'show_job.html', '1657207668', '1657207668', '1657207668', null, '0', 'HR', '', '4', 'en', 'normal', '');
INSERT INTO `hkcms_job` VALUES ('22', '17', '8', '1', 'PHP Developer', '', '', '', '', 'show_job.html', '1657207794', '1657207794', '1657207794', null, '0', 'HR', '', '1', 'en', 'normal', '');
INSERT INTO `hkcms_job` VALUES ('23', '17', '8', '1', 'Python development', '', '', '', '', 'show_job.html', '1657207885', '1657207885', '1657207885', null, '0', 'HR', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_job` VALUES ('24', '17', '8', '1', 'Vue Frontend Engineer', '', '', '', '', 'show_job.html', '1657207988', '1657207988', '1657207988', null, '0', 'HR', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_job` VALUES ('25', '17', '8', '1', 'Vue Junior Engineer', '', '', '', '', 'show_job.html', '1657208071', '1657208071', '1657208071', null, '0', 'HR', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_job` VALUES ('26', '17', '8', '1', 'Uniapp', '', '', '', '', 'show_job.html', '1657208139', '1657208139', '1657208139', null, '0', 'HR', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_job` VALUES ('27', '17', '8', '1', 'Go development', '', '', '', '', 'show_job.html', '1657208239', '1657208239', '1657208239', null, '0', 'HR', '', '0', 'en', 'normal', '');
INSERT INTO `hkcms_job` VALUES ('28', '17', '8', '1', 'Uniapp', '', '', '', '', 'show_job.html', '1657208300', '1657208300', '1657208300', null, '0', 'HR', '', '0', 'en', 'normal', '');


DROP TABLE IF EXISTS `hkcms_job_data`;
CREATE TABLE `hkcms_job_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content` text,
  `address` char(250) NOT NULL DEFAULT '' COMMENT '工作地点',
  `degree` enum('不限','高中及以下','大专','本科','硕士','博士') NOT NULL DEFAULT '不限' COMMENT '学历要求',
  `salary` enum('面议','3-5K','5-10K','10-20K') NOT NULL DEFAULT '面议' COMMENT '薪资待遇',
  `nature` enum('全职','兼职') NOT NULL DEFAULT '全职' COMMENT '工作性质',
  `exp` enum('不限','应届生','1年以内','1-3年','3-5年','5-10年','10年以上') NOT NULL DEFAULT '不限' COMMENT '工作经验',
  `number` char(20) NOT NULL DEFAULT '' COMMENT '招聘人数',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

INSERT INTO `hkcms_job_data` VALUES ('13', '<p><span style=\"color: rgb(81, 88, 109);\"><b>1. 岗位职责</b></span></p><p><span style=\"color: rgb(81, 88, 109);\">1）运用php独立进行网站项目开发，以及网站程序的优化；</span></p><p><span style=\"color: rgb(81, 88, 109);\">2）负责解决开发过程中的技术难点等问题，编写网站开发文档工作；</span></p><p><span style=\"color: rgb(81, 88, 109);\">3）负责Linux服务器的优化、保证服务器网站正常访问。</span></p><p><span style=\"color: rgb(81, 88, 109);\">4）能独立完成网站的前端、后端开发。</span></p><p><span style=\"color: rgb(81, 88, 109);\"><b>2. 任职要求</b></span></p><p><span style=\"color: rgb(81, 88, 109);\">1）精通PHP+MYSQL编程，熟悉使用ThinkPHP、HkCms等至少一种开发框架，熟悉Javascript/Ajax以及sql编写；</span></p><p><span style=\"color: rgb(81, 88, 109);\">2）熟悉MYSQL索引优化、查询优化和存储优化方面的经验；</span></p><p><span style=\"color: rgb(81, 88, 109);\">3）熟悉微信小程序开发，微信接口开发，钉钉接口对接；</span></p><p><span style=\"color: rgb(81, 88, 109);\">4）熟悉Vue等单页应用的开发；</span></p><p><span style=\"color: rgb(81, 88, 109);\">4）能在uni-app框架下进行移动多端开发者优先；</span></p><blockquote><p>公司有10年行业网站开发大牛带你入行</p></blockquote>', '广州天河区', '本科', '5-10K', '全职', '1年以内', '2');
INSERT INTO `hkcms_job_data` VALUES ('14', '<p><span style=\"color: rgb(81, 88, 109);\"><b>1. 岗位职责</b></span></p><p><span style=\"color: rgb(81, 88, 109);\">1）运用php独立进行网站项目开发，以及网站程序的优化；</span></p><p><span style=\"color: rgb(81, 88, 109);\">2）负责解决开发过程中的技术难点等问题，编写网站开发文档工作；</span></p><p><span style=\"color: rgb(81, 88, 109);\">3）负责Linux服务器的优化、保证服务器网站正常访问。</span></p><p><span style=\"color: rgb(81, 88, 109);\">4）能独立完成网站的前端、后端开发。</span></p><p><span style=\"color: rgb(81, 88, 109);\"><b>2. 任职要求</b></span></p><p><span style=\"color: rgb(81, 88, 109);\">1）精通PHP+MYSQL编程，熟悉使用ThinkPHP等至少一种开发框架，熟悉Javascript/Ajax以及sql编写；</span></p><p><span style=\"color: rgb(81, 88, 109);\">2）熟悉MYSQL索引优化、查询优化和存储优化方面的经验；</span></p><p><span style=\"color: rgb(81, 88, 109);\">3）熟悉微信小程序开发，微信接口开发，钉钉接口对接；</span></p><p><span style=\"color: rgb(81, 88, 109);\">4）熟悉Vue等单页应用的开发；</span></p><p><span style=\"color: rgb(81, 88, 109);\">4）能在uni-app框架下进行移动多端开发者优先；</span></p>', '广州天河区', '大专', '面议', '兼职', '1-3年', '1');
INSERT INTO `hkcms_job_data` VALUES ('15', '<p><span style=\"color: rgb(81, 88, 109);\"><b>1. 岗位职责</b></span></p><p><span style=\"\">负责公司内部数据分析平台，运维管理平台的开发工作。</span><br></p><p><span style=\"color: rgb(81, 88, 109);\"><b>2. 任职要求</b></span></p><p><span style=\"color: rgb(81, 88, 109);\">1）<span style=\"\">熟悉Python语言及其特性，了解相关Python Web框架 Flask，FastAPI 等</span>；</span></p><p><span style=\"color: rgb(81, 88, 109);\">2）熟悉MYSQL索引优化、查询优化和存储优化方面的经验；</span></p><p><span style=\"color: rgb(81, 88, 109);\">3）<span style=\"\">掌握面向对象的程序设计思想</span>；</span></p><p><span style=\"color: rgb(81, 88, 109);\">4）<span style=\"\">熟悉Linux开发环境;</span></span></p>', '广州天河区', '大专', '3-5K', '全职', '1-3年', '3');
INSERT INTO `hkcms_job_data` VALUES ('16', '<p><span style=\"color: rgb(81, 88, 109);\"><b>岗位职责</b></span></p><p><span style=\"\">1、对Web前沿技术研究和新技术调用，并给出应用建议</span></p><p><span style=\"\">2、负责PC端页面开发、页面重构以及交互设计逻辑处理</span></p><p><span style=\"\">3、负责移动端H5、微信小程序、APP页面开发以及交互设计逻辑处理</span></p><p><span style=\"color: rgb(81, 88, 109);\"><b>任职要求</b></span></p><p><span style=\"\">1、精通JavaScript、JQuery、CSS、HTML 等前端相关技术原理，熟悉 W3C 标准与 ES 规范</span></p><p><span style=\"\">2、熟悉或使用过elementUI、vant、mint UI中一种前端UI框架</span></p><p><span style=\"\">3、至少熟练使用过Vue、React、AngularJS其中一种前端框架，有Vue实际开发经验优先</span></p><p><span style=\"\">4、有丰富的移动端开发经验，对H5、微信小程序的开发有深刻的理解,能够进行APP开发者优先</span></p><p><span style=\"\">5、对移动端的适配以及兼容性问题有较为深刻的理解或丰富的经验</span></p>', '广州天河区', '大专', '10-20K', '全职', '3-5年', '1');
INSERT INTO `hkcms_job_data` VALUES ('17', '<p><span style=\"color: rgb(81, 88, 109);\"><b>岗位职责</b></span></p><p><span style=\"\">1、对Web前沿技术研究和新技术调用，并给出应用建议</span></p><p><span style=\"\">2、负责PC端页面开发、页面重构以及交互设计逻辑处理</span></p><p><span style=\"\">3、负责移动端H5、微信小程序、APP页面开发以及交互设计逻辑处理</span></p><p><span style=\"color: rgb(81, 88, 109);\"><b>2. 任职要求</b></span></p><p><span style=\"\">1、精通JavaScript、JQuery、CSS、HTML 等前端相关技术原理，熟悉 W3C 标准与 ES 规范</span></p><p><span style=\"\">2、熟悉或使用过elementUI、vant、mint UI中一种前端UI框架</span></p><p><span style=\"\">3、至少熟练使用过Vue、React、AngularJS其中一种前端框架，有Vue实际开发经验优先</span></p><p><span style=\"\">4、有丰富的移动端开发经验，对H5、微信小程序的开发有深刻的理解,能够进行APP开发者优先</span></p><p><span style=\"\">5、对移动端的适配以及兼容性问题有较为深刻的理解或丰富的经验</span></p>', '广州天河区', '不限', '3-5K', '全职', '1年以内', '5');
INSERT INTO `hkcms_job_data` VALUES ('18', '<p><span style=\"color: rgb(81, 88, 109);\"><b>岗位职责</b></span></p><p>负责公司的Uniapp项目开发与维护<br></p><p><span style=\"color: rgb(81, 88, 109);\"><b>任职要求</b></span></p><p><span style=\"\">1、精通JavaScript、JQuery、CSS、HTML 等前端相关技术原理，熟悉 W3C 标准与 ES 规范</span></p><p><span style=\"\">2、熟悉或使用过elementUI、vant、mint UI中一种前端UI框架</span></p><p><span style=\"\">3、至少熟练使用过Vue、Uniapp、AngularJS其中一种前端框架，有Vue实际开发经验优先</span></p><p><span style=\"\">4、有丰富的移动端开发经验，对H5、微信小程序的开发有深刻的理解,能够进行APP开发者优先</span></p><p><span style=\"\">5、对移动端的适配以及兼容性问题有较为深刻的理解或丰富的经验</span></p>', '广州白云区', '本科', '3-5K', '全职', '不限', '5');
INSERT INTO `hkcms_job_data` VALUES ('19', '<p><span style=\"color: rgb(81, 88, 109);\"><b>岗位职责</b></span></p><p>负责公司的GO项目的开发与维护<br></p><p><span style=\"color: rgb(81, 88, 109);\"><b>任职要求</b></span></p><p><span style=\"\">1、<span style=\"\">熟悉tcp/http网络原理</span></span></p><p><span style=\"\">2、<span style=\"\">熟悉redis/memcache等缓存中间件</span></span></p><p><span style=\"\">3、<span style=\"\">熟练使用MySQL/MongoDB等数据库</span></span></p><p><span style=\"\">4、<span style=\"\">熟悉Go web开发，有其它语言开发经验优先</span></span></p>', '广州白云区', '不限', '面议', '全职', '应届生', '1');
INSERT INTO `hkcms_job_data` VALUES ('20', '<p><span style=\"color: rgb(81, 88, 109);\"><b>岗位职责</b></span></p><p>负责公司的UNIAPP项目的开发与维护<br></p><p><span style=\"color: rgb(81, 88, 109);\"><b>任职要求</b></span></p><p><span style=\"\">1、<span style=\"\">熟悉uniapp框架、vue</span></span></p>', '广州天河区', '大专', '5-10K', '全职', '5-10年', '1');
INSERT INTO `hkcms_job_data` VALUES ('21', '<p><span style=\"\"><b>1. Job Responsibilities</b></span></p><p><span style=\"\">1) Use php to independently develop website projects and optimize website programs;</span></p><p><span style=\"\">2) Responsible for solving technical difficulties and other problems in the development process, and writing website development documents;</span></p><p><span style=\"\">3) Responsible for the optimization of the Linux server and ensure the normal access of the server website.</span></p><p><span style=\"\">4) Can independently complete the front-end and back-end development of the website.</span></p><p><span style=\"\"><b>2. Job Requirements</b></span></p><p><span style=\"\">1) Proficient in PHP+MYSQL programming, familiar with at least one development framework such as ThinkPHP, HkCms, familiar with Javascript/Ajax and sql writing;</span></p><p><span style=\"\">2) Familiar with MYSQL index optimization, query optimization and storage optimization experience;</span></p><p><span style=\"\">3) Familiar with WeChat applet development, WeChat interface development, and DingTalk interface docking;</span></p><p><span style=\"\">4) Familiar with the development of single-page applications such as Vue;</span></p><p><span style=\"\">5) Developers who can perform mobile multi-terminal under the uni-app framework are preferred;</span></p><blockquote><p><span style=\"\">The company has 10 years of industry website development Daniel to bring you into the industry</span><br></p></blockquote>', 'Tianhe District, Guangzhou', '本科', '5-10K', '全职', '1年以内', '2');
INSERT INTO `hkcms_job_data` VALUES ('22', '<p><span style=\"\"><b>1. Job Responsibilities</b></span></p><p><span style=\"\">1) Use php to independently develop website projects and optimize website programs;</span></p><p><span style=\"\">2) Responsible for solving technical difficulties and other problems in the development process, and writing website development documents;</span></p><p><span style=\"\">3) Responsible for the optimization of the Linux server and ensure the normal access of the server website.</span></p><p><span style=\"\">4) Can independently complete the front-end and back-end development of the website.</span></p><p><span style=\"\"><b>2. Job Requirements</b></span></p><p><span style=\"\">1) Proficient in PHP+MYSQL programming, familiar with at least one development framework such as ThinkPHP, familiar with Javascript/Ajax and sql writing;</span></p><p><span style=\"\">2) Familiar with MYSQL index optimization, query optimization and storage optimization experience;</span></p><p><span style=\"\">3) Familiar with WeChat applet development, WeChat interface development, and DingTalk interface docking;</span></p><p><span style=\"\">4) Familiar with the development of single-page applications such as Vue;</span></p><p><span style=\"\">5) Developers who can perform mobile multi-terminal under the uni-app framework are preferred;</span></p>', 'Tianhe District, Guangzhou', '大专', '面议', '兼职', '1-3年', '1');
INSERT INTO `hkcms_job_data` VALUES ('23', '<p><span style=\"\"><b>1. Job Responsibilities</b></span></p><p><span style=\"\">Responsible for the development of the company\'s internal data analysis platform and operation and maintenance management platform.</span></p><p><span style=\"\"><b>2. Job Requirements</b></span></p><p><span style=\"\">1) Familiar with the Python language and its features, and understand related Python web frameworks Flask, FastAPI, etc.;</span></p><p><span style=\"\">2) Familiar with MYSQL index optimization, query optimization and storage optimization experience;</span></p><p><span style=\"\">3) Master the idea of object-oriented programming;</span></p><p><span style=\"\">4) Familiar with Linux development environment;</span></p>', 'Tianhe District, Guangzhou', '大专', '3-5K', '全职', '1-3年', '3');
INSERT INTO `hkcms_job_data` VALUES ('24', '<p><span style=\"\"><b>Job Responsibilities</b></span></p><p><span style=\"\">1. Research and call new technologies on the web, and give application suggestions</span></p><p><span style=\"\">2. Responsible for PC-side page development, page reconstruction and interaction design logic processing</span></p><p><span style=\"\">3. Responsible for mobile H5, WeChat applet, APP page development and interaction design logic processing</span></p><p><span style=\"\"><b>Job Requirements</b></span></p><p><span style=\"\">1. Proficient in front-end related technical principles such as JavaScript, JQuery, CSS, HTML, etc., familiar with W3C standards and ES specifications</span></p><p><span style=\"\">2. Familiar with or used a front-end UI framework in elementUI, vant, and mint UI</span></p><p><span style=\"\">3. Familiar with at least one of the front-end frameworks of Vue, React and AngularJS, and experience in Vue development is preferred</span></p><p><span style=\"\">4. Have rich experience in mobile terminal development, have a deep understanding of H5 and WeChat applet development, and be able to develop APP is preferred</span></p><p><span style=\"\">5. Have a deep understanding or rich experience in the adaptation and compatibility of mobile terminals</span></p>', 'Tianhe District, Guangzhou', '大专', '10-20K', '全职', '3-5年', '1');
INSERT INTO `hkcms_job_data` VALUES ('25', '<p><span style=\"\"><b>Job Responsibilities</b></span></p><p><span style=\"\">1. Research and call new technologies on the web, and give application suggestions</span></p><p><span style=\"\">2. Responsible for PC-side page development, page reconstruction and interaction design logic processing</span></p><p><span style=\"\">3. Responsible for mobile H5, WeChat applet, APP page development and interaction design logic processing</span></p><p><span style=\"\"><b>Job Requirements</b></span></p><p><span style=\"\">1. Proficient in front-end related technical principles such as JavaScript, JQuery, CSS, HTML, etc., familiar with W3C standards and ES specifications</span></p><p><span style=\"\">2. Familiar with or used a front-end UI framework in elementUI, vant, and mint UI</span></p><p><span style=\"\">3. Familiar with at least one of the front-end frameworks of Vue, React and AngularJS, and experience in Vue development is preferred</span></p><p><span style=\"\">4. Have rich experience in mobile terminal development, have a deep understanding of H5 and WeChat applet development, and be able to develop APP is preferred</span></p><p><span style=\"\">5. Have a deep understanding or rich experience in the adaptation and compatibility of mobile terminals</span></p>', 'Tianhe District, Guangzhou', '不限', '3-5K', '全职', '1年以内', '5');
INSERT INTO `hkcms_job_data` VALUES ('26', '<p><span style=\"\"><b>Job Responsibilities</b></span></p><p><span style=\"\">Responsible for the development and maintenance of the company\'s Uniapp project</span></p><p><span style=\"\"><b>Job Requirements</b></span></p><p><span style=\"\">1. Proficient in front-end related technical principles such as JavaScript, JQuery, CSS, HTML, etc., familiar with W3C standards and ES specifications</span></p><p><span style=\"\">2. Familiar with or used a front-end UI framework in elementUI, vant, and mint UI</span></p><p><span style=\"\">3. At least one of the front-end frameworks such as Vue, Uniapp and AngularJS has been used proficiently. Experience in Vue development is preferred</span></p><p><span style=\"\">4. Have rich experience in mobile terminal development, have a deep understanding of H5 and WeChat applet development, and be able to develop APP is preferred</span></p><p><span style=\"\">5. Have a deep understanding or rich experience in the adaptation and compatibility of mobile terminals</span></p>', 'Guangzhou Baiyun District', '本科', '3-5K', '全职', '不限', '5');
INSERT INTO `hkcms_job_data` VALUES ('27', '<p><span style=\"\"><b>Job Responsibilities</b></span></p><p><span style=\"\">Responsible for the development and maintenance of the company\'s GO project</span></p><p><span style=\"\"><b>job requirements</b></span></p><p><span style=\"\">1. Familiar with tcp/http network principles</span></p><p><span style=\"\">2. Familiar with caching middleware such as redis/memcache</span></p><p><span style=\"\">3. Proficient in using MySQL/MongoDB and other databases</span></p><p><span style=\"\">4. Familiar with Go web development, experience in other language development is preferred</span></p>', 'Guangzhou Baiyun District', '不限', '面议', '全职', '应届生', '1');
INSERT INTO `hkcms_job_data` VALUES ('28', '<p><span style=\"\"><b>Job Responsibilities</b></span></p><p><span style=\"\">Responsible for the development and maintenance of the company\'s UNIAPP project</span></p><p><span style=\"\"><b>job requirements</b></span></p><p><span style=\"\">1. Familiar with uniapp framework and vue</span></p>', 'Tianhe District, Guangzhou', '大专', '5-10K', '全职', '5-10年', '1');


DROP TABLE IF EXISTS `hkcms_lang_bind`;
CREATE TABLE `hkcms_lang_bind` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `main_id` int(11) NOT NULL DEFAULT '0' COMMENT '主来源ID',
  `value_id` int(11) NOT NULL DEFAULT '0' COMMENT '绑定ID',
  `table` char(50) NOT NULL DEFAULT '' COMMENT '表',
  `lang` char(50) NOT NULL DEFAULT 'zh-cn' COMMENT '语言标识',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=67 DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='内容语言绑定';

INSERT INTO `hkcms_lang_bind` VALUES ('1', '3', '0', 'recommend', 'zh-cn', '1636978556');
INSERT INTO `hkcms_lang_bind` VALUES ('2', '3', '4', 'recommend', 'en', '1636978556');
INSERT INTO `hkcms_lang_bind` VALUES ('3', '1', '0', 'category', 'zh-cn', '1636979415');
INSERT INTO `hkcms_lang_bind` VALUES ('4', '1', '2', 'category', 'en', '1636979415');
INSERT INTO `hkcms_lang_bind` VALUES ('5', '3', '0', 'category', 'zh-cn', '1636981343');
INSERT INTO `hkcms_lang_bind` VALUES ('6', '3', '4', 'category', 'en', '1636981343');
INSERT INTO `hkcms_lang_bind` VALUES ('7', '5', '0', 'category', 'zh-cn', '1636986900');
INSERT INTO `hkcms_lang_bind` VALUES ('8', '5', '6', 'category', 'en', '1636986900');
INSERT INTO `hkcms_lang_bind` VALUES ('9', '7', '0', 'category', 'zh-cn', '1636986934');
INSERT INTO `hkcms_lang_bind` VALUES ('10', '7', '8', 'category', 'en', '1636986934');
INSERT INTO `hkcms_lang_bind` VALUES ('11', '2', '0', 'recommend', 'zh-cn', '1636986934');
INSERT INTO `hkcms_lang_bind` VALUES ('22', '2', '1', 'recommend', 'en', '1636986934');
INSERT INTO `hkcms_lang_bind` VALUES ('23', '9', '0', 'category', 'zh-cn', '1637052314');
INSERT INTO `hkcms_lang_bind` VALUES ('24', '9', '10', 'category', 'en', '1637052314');
INSERT INTO `hkcms_lang_bind` VALUES ('25', '11', '0', 'category', 'zh-cn', '1637052636');
INSERT INTO `hkcms_lang_bind` VALUES ('26', '11', '12', 'category', 'en', '1637052636');
INSERT INTO `hkcms_lang_bind` VALUES ('27', '13', '0', 'category', 'zh-cn', '1637052636');
INSERT INTO `hkcms_lang_bind` VALUES ('28', '13', '14', 'category', 'en', '1637052636');
INSERT INTO `hkcms_lang_bind` VALUES ('29', '15', '0', 'category', 'zh-cn', '1637052636');
INSERT INTO `hkcms_lang_bind` VALUES ('30', '15', '16', 'category', 'en', '1637052636');
INSERT INTO `hkcms_lang_bind` VALUES ('31', '5', '0', 'recommend', 'en', '1637142375');
INSERT INTO `hkcms_lang_bind` VALUES ('32', '5', '6', 'recommend', 'zh-cn', '1637142375');
INSERT INTO `hkcms_lang_bind` VALUES ('33', '18', '0', 'category', 'zh-cn', '1637142375');
INSERT INTO `hkcms_lang_bind` VALUES ('34', '18', '17', 'category', 'en', '1637142375');
INSERT INTO `hkcms_lang_bind` VALUES ('35', '19', '0', 'category', 'zh-cn', '1637142375');
INSERT INTO `hkcms_lang_bind` VALUES ('36', '19', '20', 'category', 'en', '1637142375');
INSERT INTO `hkcms_lang_bind` VALUES ('37', '21', '0', 'category', 'zh-cn', '1637142375');
INSERT INTO `hkcms_lang_bind` VALUES ('38', '21', '22', 'category', 'en', '1637142375');
INSERT INTO `hkcms_lang_bind` VALUES ('39', '23', '0', 'category', 'zh-cn', '1637142375');
INSERT INTO `hkcms_lang_bind` VALUES ('40', '23', '24', 'category', 'en', '1637142375');
INSERT INTO `hkcms_lang_bind` VALUES ('41', '25', '0', 'category', 'zh-cn', '1637142375');
INSERT INTO `hkcms_lang_bind` VALUES ('42', '25', '26', 'category', 'en', '1637142375');
INSERT INTO `hkcms_lang_bind` VALUES ('43', '27', '0', 'category', 'zh-cn', '1637142375');
INSERT INTO `hkcms_lang_bind` VALUES ('44', '27', '28', 'category', 'en', '1637142375');
INSERT INTO `hkcms_lang_bind` VALUES ('45', '29', '0', 'category', 'zh-cn', '1637142375');
INSERT INTO `hkcms_lang_bind` VALUES ('46', '29', '30', 'category', 'en', '1637142375');
INSERT INTO `hkcms_lang_bind` VALUES ('47', '31', '0', 'category', 'zh-cn', '1637386732');
INSERT INTO `hkcms_lang_bind` VALUES ('48', '31', '32', 'category', 'en', '1637386732');
INSERT INTO `hkcms_lang_bind` VALUES ('49', '33', '0', 'category', 'en', '1637388218');
INSERT INTO `hkcms_lang_bind` VALUES ('50', '33', '34', 'category', 'zh-cn', '1637388218');
INSERT INTO `hkcms_lang_bind` VALUES ('51', '1', '0', 'flags', 'zh-cn', '1637388218');
INSERT INTO `hkcms_lang_bind` VALUES ('52', '1', '2', 'flags', 'en', '1637388218');
INSERT INTO `hkcms_lang_bind` VALUES ('53', '7', '0', 'recommend', 'zh-cn', '1637388218');
INSERT INTO `hkcms_lang_bind` VALUES ('54', '7', '8', 'recommend', 'en', '1637388218');
INSERT INTO `hkcms_lang_bind` VALUES ('55', '35', '0', 'category', 'zh-cn', '1637388218');
INSERT INTO `hkcms_lang_bind` VALUES ('56', '35', '36', 'category', 'en', '1637388218');
INSERT INTO `hkcms_lang_bind` VALUES ('57', '37', '0', 'category', 'zh-cn', '1656579210');
INSERT INTO `hkcms_lang_bind` VALUES ('58', '37', '38', 'category', 'en', '1656579210');
INSERT INTO `hkcms_lang_bind` VALUES ('59', '39', '0', 'category', 'zh-cn', '1656579407');
INSERT INTO `hkcms_lang_bind` VALUES ('60', '39', '40', 'category', 'en', '1656579407');
INSERT INTO `hkcms_lang_bind` VALUES ('61', '9', '0', 'recommend', 'zh-cn', '1656610216');
INSERT INTO `hkcms_lang_bind` VALUES ('62', '9', '10', 'recommend', 'en', '1656610216');
INSERT INTO `hkcms_lang_bind` VALUES ('63', '11', '0', 'recommend', 'zh-cn', '1657460086');
INSERT INTO `hkcms_lang_bind` VALUES ('64', '11', '12', 'recommend', 'en', '1657460086');
INSERT INTO `hkcms_lang_bind` VALUES ('65', '41', '0', 'category', 'zh-cn', '1656579407');
INSERT INTO `hkcms_lang_bind` VALUES ('66', '41', '42', 'category', 'en', '1656579407');


DROP TABLE IF EXISTS `hkcms_model`;
CREATE TABLE `hkcms_model` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '模型ID',
  `name` char(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '模型名称',
  `alias` char(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '模型别名',
  `tablename` char(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '表名称',
  `remark` char(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '备注说明',
  `controller` char(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Archives' COMMENT '控制器',
  `type` enum('single','more') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'more' COMMENT '类型:sing-独立表,more-主表加副表',
  `allow_single` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'type=more下有效，1-允许单表，0-不允许',
  `is_search` tinyint(1) NOT NULL DEFAULT '1' COMMENT '搜索:1-允许搜索,0-不允许,-1-不支持',
  `category_tpl` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '栏目模板',
  `list_tpl` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '列表模板',
  `show_tpl` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '内容模板',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `status` enum('normal','hidden') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'normal' COMMENT '状态:normal-正常,hidden-禁用',
  `config` text COLLATE utf8mb4_unicode_ci COMMENT '模型配置',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC COMMENT='模型表';

INSERT INTO `hkcms_model` VALUES ('1', '文章模型', '文章', 'archives', '', 'Archives', 'more', '0', '1', '', '', '', '1603332354', '1602330338', 'normal', null);
INSERT INTO `hkcms_model` VALUES ('2', '单页模型', '单页', 'single', '', 'Single', 'single', '0', '1', '', '', '', '1617965433', '1606901317', 'normal', null);
INSERT INTO `hkcms_model` VALUES ('5', '留言表单', '留言', 'guestbook', '', 'Guestbook', 'single', '0', '-1', '', '', '', '1617871031', '1617871031', 'normal', '{\"captcha\":\"1\",\"type\":\"text\",\"msg\":\"0\",\"msgtype\":[\"email\"],\"msgemail\":\"\",\"tcount\":\"60\"}');
INSERT INTO `hkcms_model` VALUES ('6', '产品模型', '产品', 'product', '', 'Archives', 'more', '0', '1', '', '', '', '1637055066', '1637055066', 'normal', null);
INSERT INTO `hkcms_model` VALUES ('7', '图集模型', '图集', 'images', '', 'Archives', 'more', '0', '1', '', '', '', '1656558734', '1656558734', 'normal', null);
INSERT INTO `hkcms_model` VALUES ('8', '招聘模型', '招聘', 'job', '', 'Archives', 'more', '0', '1', '', '', '', '1657164403', '1657164403', 'normal', null);


DROP TABLE IF EXISTS `hkcms_model_controller`;
CREATE TABLE `hkcms_model_controller` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` varchar(80) NOT NULL COMMENT '标题',
  `name` varchar(50) NOT NULL COMMENT '控制器名称',
  `sql_file` varchar(500) NOT NULL COMMENT 'sql执行文件',
  `single_sql` varchar(500) NOT NULL DEFAULT '' COMMENT '类型为more时有效，支持单表SQL执行文件',
  `type` enum('more','single') NOT NULL DEFAULT 'single' COMMENT '类型:sing-独立表,more-主表加副表',
  `is_search` tinyint(1) NOT NULL DEFAULT '1' COMMENT '搜索:1-支持全局,-1-不支持',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `status` enum('normal','hidden') NOT NULL DEFAULT 'normal' COMMENT '状态:normal-正常,hidden-禁用',
  `config` text COMMENT '模型初始配置',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='模型控制器';

INSERT INTO `hkcms_model_controller` VALUES ('1', '文章类', 'Archives', 'extend/libs/table/template/base.sql,extend/libs/table/template/base_data.sql,extend/libs/table/template/base_data_insert_field.sql,extend/libs/table/template/base_insert_field.sql', 'extend/libs/table/template/base_single.sql,extend/libs/table/template/base_single_insert_field.sql', 'more', '1', '1606820939', 'normal', null);
INSERT INTO `hkcms_model_controller` VALUES ('2', '单页类', 'Single', 'extend/libs/table/template/single.sql,extend/libs/table/template/single_insert_field.sql', '', 'single', '1', '1606820939', 'normal', null);
INSERT INTO `hkcms_model_controller` VALUES ('3', '表单类', 'Guestbook', 'extend/libs/table/template/guestbook.sql', '', 'single', '-1', '1606820939', 'normal', '{\"captcha\":{\"title\":\"验证码\",\"type\":\"radio\",\"tips\":\"开启后表单提交必须要有验证码\",\"rules\":\"\",\"error_tips\":\"\",\"options\":{\"1\":\"开启\",\"0\":\"关闭\"},\"value\":\"1\"},\"type\":{\"title\":\"验证码类型\",\"type\":\"radio\",\"tips\":\"手机验证码需要短信插件，邮箱验证码站点配置-邮箱配置\",\"rules\":\"\",\"error_tips\":\"\",\"options\":{\"text\":\"文本\",\"email\":\"邮箱\",\"mobile\":\"手机\"},\"value\":\"text\"},\"msg\":{\"title\":\"留言通知\",\"type\":\"radio\",\"tips\":\"开启后用户留言您将收到通知~\",\"rules\":\"\",\"error_tips\":\"\",\"options\":{\"1\":\"开启\",\"0\":\"关闭\"},\"value\":\"0\"},\"msgtype\":{\"title\":\"留言通知方式\",\"type\":\"checkbox\",\"tips\":\"开启后用户留言您将收到通知\",\"rules\":\"\",\"error_tips\":\"\",\"options\":{\"email\":\"邮箱\"},\"value\":\"email\"},\"msgemail\":{\"title\":\"通知邮箱地址\",\"type\":\"text\",\"tips\":\"通知方式为邮箱时生效,格式：admin@qq.com\",\"rules\":\"\",\"error_tips\":\"\",\"value\":\"\"},\"tcount\":{\"title\":\"间隔\",\"type\":\"text\",\"tips\":\"表单提交间隔(秒)\",\"rules\":\"\",\"error_tips\":\"\",\"value\":\"60\"}}');


DROP TABLE IF EXISTS `hkcms_model_field`;
CREATE TABLE `hkcms_model_field` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `model_id` int(10) unsigned NOT NULL COMMENT '模型ID',
  `field_name` varchar(20) NOT NULL COMMENT '字段名称',
  `field_title` varchar(50) NOT NULL DEFAULT '' COMMENT '字段中文名',
  `form_type` varchar(20) NOT NULL COMMENT '字段类型',
  `field_group` varchar(50) NOT NULL DEFAULT '常规' COMMENT '字段分组',
  `length` int(11) NOT NULL DEFAULT '250' COMMENT '长度',
  `default_value` text COMMENT '默认值',
  `data_list` text COMMENT '选项列表',
  `max_number` int(11) NOT NULL DEFAULT '0' COMMENT '最大数量',
  `decimals` tinyint(4) NOT NULL DEFAULT '0' COMMENT '小数位',
  `rules` varchar(255) NOT NULL DEFAULT '' COMMENT '规则',
  `tips` varchar(255) NOT NULL DEFAULT '' COMMENT '提示信息',
  `error_tips` varchar(255) NOT NULL DEFAULT '' COMMENT '错误提示',
  `extend` varchar(500) NOT NULL DEFAULT '' COMMENT '附加属性',
  `iscore` tinyint(1) NOT NULL DEFAULT '0' COMMENT '主表字段:1-是,0-不是',
  `default_field` tinyint(1) NOT NULL DEFAULT '0' COMMENT '默认字段:1-默认,0-不是',
  `weigh` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `setting` text COMMENT '配置信息',
  `user_auth` tinyint(1) NOT NULL DEFAULT '0' COMMENT '用户投稿:1=允许,0=不允许',
  `is_filter` tinyint(1) NOT NULL DEFAULT '0' COMMENT '筛选:1=开启,0=关闭',
  `is_order` tinyint(1) NOT NULL DEFAULT '0' COMMENT '排序:1=开启,0=关闭',
  `status` enum('normal','hidden') NOT NULL DEFAULT 'normal' COMMENT '状态:normal-正常,hidden-禁用',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=201 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='模型字段表';

INSERT INTO `hkcms_model_field` VALUES ('21', '1', 'title', '标题', 'text', '常规', '200', '', null, '0', '0', 'required', '', '', '', '1', '1', '20', null, '1', '0', '0', 'normal', '1604564165', '1600400002');
INSERT INTO `hkcms_model_field` VALUES ('32', '1', 'thumb', '封面图', 'image', '常规', '100', '', null, '0', '0', '', '', '', '', '1', '0', '18', null, '1', '0', '0', 'normal', '1604564175', '1600400154');
INSERT INTO `hkcms_model_field` VALUES ('33', '1', 'keywords', '关键词', 'text', 'SEO', '200', '', null, '0', '0', '', '多关键词之间用英文逗号隔开', '', '', '1', '0', '0', null, '1', '0', '0', 'normal', '1606985224', '1600400833');
INSERT INTO `hkcms_model_field` VALUES ('34', '1', 'description', '描述', 'textarea', 'SEO', '250', '', null, '0', '0', '', '', '', '', '1', '0', '0', null, '1', '0', '0', 'normal', '1603937358', '1600400870');
INSERT INTO `hkcms_model_field` VALUES ('35', '1', 'show_tpl', '内容模板', 'text', '其他', '100', 'show.html', null, '0', '0', '', '', '', 'class=\"form-control selectpage\",data-select-only=\"true\",data-data=\"/cms.model/getTplName.html?type=show\",data-pagination=\"false\",data-key-field=\"name\"', '1', '1', '1', null, '0', '0', '0', 'normal', '1604561449', '1600400927');
INSERT INTO `hkcms_model_field` VALUES ('37', '1', 'publish_time', '发布时间', 'datetime', '其他', '0', '', null, '0', '0', '', '', '', '', '1', '1', '2', null, '0', '0', '1', 'normal', '1604563079', '1600401003');
INSERT INTO `hkcms_model_field` VALUES ('39', '1', 'weigh', '排序', 'number', '常规', '11', '0', null, '0', '0', '', '', '', '', '1', '1', '1', null, '0', '0', '0', 'normal', '1604564047', '1600401198');
INSERT INTO `hkcms_model_field` VALUES ('40', '1', 'content', '内容', 'editor', '常规', '0', '', null, '0', '0', '', '', '', '', '0', '1', '6', null, '1', '0', '0', 'normal', '1604565377', '1600410507');
INSERT INTO `hkcms_model_field` VALUES ('73', '1', 'status', '状态', 'radio', '常规', '250', 'normal', '{\"normal\":\"\\u6b63\\u5e38\",\"hidden\":\"\\u7981\\u7528\",\"reject\":\"\\u62d2\\u7edd\",\"audit\":\"\\u5f85\\u5ba1\\u6838\"}', '0', '0', 'required', '', '', '', '1', '1', '0', null, '0', '0', '0', 'normal', '1604041706', '1604041706');
INSERT INTO `hkcms_model_field` VALUES ('74', '1', 'author', '作者', 'text', '其他', '250', '小编', null, '0', '0', '', '', '', '', '1', '0', '10', null, '0', '0', '0', 'normal', '1604561438', '1604557612');
INSERT INTO `hkcms_model_field` VALUES ('76', '1', 'views', '浏览量', 'number', '其他', '11', '0', null, '0', '0', '', '', '', '', '1', '1', '3', null, '0', '0', '1', 'normal', '1604563975', '1604561217');
INSERT INTO `hkcms_model_field` VALUES ('77', '2', 'status', '状态', 'radio', '常规', '250', 'normal', '{\"normal\":\"\\u6b63\\u5e38\",\"hidden\":\"\\u7981\\u7528\"}', '0', '0', 'required', '', '', '', '1', '1', '0', null, '0', '0', '0', 'normal', '1604041706', '1604041706');
INSERT INTO `hkcms_model_field` VALUES ('113', '2', 'title', '标题', 'text', '常规', '200', '', null, '0', '0', 'required', '', '', '', '1', '1', '100', null, '1', '0', '0', 'normal', '1617358340', '1600400002');
INSERT INTO `hkcms_model_field` VALUES ('114', '2', 'keywords', '关键词', 'text', '常规', '200', '', null, '0', '0', '', '多关键词之间用英文逗号隔开', '', '', '1', '0', '90', null, '1', '0', '0', 'normal', '1617358493', '1600400833');
INSERT INTO `hkcms_model_field` VALUES ('115', '2', 'show_tpl', '内容模板', 'text', '常规', '100', 'page.html', null, '0', '0', '', '', '', 'class=\"form-control selectpage\",data-select-only=\"true\",data-data=\"/cms.model/getTplName.html?type=page\",data-pagination=\"false\",data-key-field=\"name\"', '1', '1', '1', null, '0', '0', '0', 'normal', '1617358534', '1600400927');
INSERT INTO `hkcms_model_field` VALUES ('116', '2', 'content', '内容', 'editor', '常规', '0', '', null, '0', '0', '', '', '', '', '1', '1', '60', null, '1', '0', '0', 'normal', '1617358548', '1600410507');
INSERT INTO `hkcms_model_field` VALUES ('117', '2', 'thumb', '图片', 'image', '常规', '250', '', null, '0', '0', '', '', '', '', '1', '0', '70', null, '1', '0', '0', 'normal', '1617358509', '1608034373');
INSERT INTO `hkcms_model_field` VALUES ('118', '2', 'description', '描述', 'textarea', '常规', '250', '', null, '0', '0', '', '', '', '', '1', '0', '80', null, '1', '0', '0', 'normal', '1617358503', '1608034434');
INSERT INTO `hkcms_model_field` VALUES ('119', '1', 'seotitle', 'seo标题', 'text', 'SEO', '200', '', null, '0', '0', '', 'seo标题，为空则使用文章标题', '', '', '1', '0', '1', null, '1', '0', '0', 'normal', '1604564378', '1600400833');
INSERT INTO `hkcms_model_field` VALUES ('120', '2', 'seotitle', 'seo标题', 'text', '常规', '200', '', null, '0', '0', '', 'seo标题，为空则使用文章标题', '', '', '1', '0', '91', null, '1', '0', '0', 'normal', '1604564378', '1600400833');
INSERT INTO `hkcms_model_field` VALUES ('139', '5', 'name', '姓名', 'text', '常规', '100', '', null, '0', '0', 'required', '', '', '', '1', '0', '0', null, '0', '0', '0', 'normal', '1617871125', '1617871125');
INSERT INTO `hkcms_model_field` VALUES ('140', '5', 'email', '邮箱', 'text', '常规', '250', '', null, '0', '0', 'required,email', '', '', '', '1', '0', '0', null, '0', '0', '0', 'normal', '1617871193', '1617871193');
INSERT INTO `hkcms_model_field` VALUES ('141', '5', 'phone', '手机', 'text', '常规', '20', '', null, '0', '0', 'required,mobile', '', '', '', '1', '0', '0', null, '0', '0', '0', 'normal', '1617871239', '1617871239');
INSERT INTO `hkcms_model_field` VALUES ('142', '5', 'content', '内容', 'textarea', '常规', '250', '', null, '0', '0', 'required', '', '', '', '1', '0', '0', null, '0', '0', '0', 'normal', '1617871288', '1617871288');
INSERT INTO `hkcms_model_field` VALUES ('143', '1', 'flags', '文档属性', 'selectpage', '其他', '100', '', '{\"type\":\"table\",\"url\":\"\",\"url-show-field\":\"\",\"url-key-field\":\"\",\"url-search-field\":\"\",\"table\":\"flags\",\"show-field\":\"title\",\"key-field\":\"name\",\"search-field\":\"title\",\"and-or\":\"\",\"order-by\":\"weigh desc\",\"param\":{\"custom\":{\"status\":\"normal\"}},\"multiple\":\"1\",\"pagination\":\"1\",\"select-only\":\"1\",\"enable-lang\":\"1\"}', '0', '0', '', '', '', '', '1', '1', '19', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '0', '0', '0', 'normal', '1649942700', '1649924031');
INSERT INTO `hkcms_model_field` VALUES ('144', '6', 'content', '内容', 'editor', '常规', '0', '', null, '0', '0', '', '', '', '', '0', '1', '6', null, '1', '0', '0', 'normal', '1604565377', '1600410507');
INSERT INTO `hkcms_model_field` VALUES ('145', '6', 'title', '标题', 'text', '常规', '200', '', null, '0', '0', 'required', '', '', '', '1', '1', '20', null, '1', '0', '0', 'normal', '1604564165', '1600400002');
INSERT INTO `hkcms_model_field` VALUES ('146', '6', 'thumb', '封面图', 'image', '常规', '100', '', null, '0', '0', '', '', '', '', '1', '0', '18', null, '1', '0', '0', 'normal', '1604564175', '1600400154');
INSERT INTO `hkcms_model_field` VALUES ('147', '6', 'keywords', '关键词', 'text', 'SEO', '200', '', null, '0', '0', '', '多关键词之间用英文逗号隔开', '', '', '1', '0', '0', null, '1', '0', '0', 'normal', '1604564378', '1600400833');
INSERT INTO `hkcms_model_field` VALUES ('148', '6', 'description', '描述', 'textarea', 'SEO', '250', '', null, '0', '0', '', '', '', '', '1', '0', '0', null, '1', '0', '0', 'normal', '1603937358', '1600400870');
INSERT INTO `hkcms_model_field` VALUES ('149', '6', 'show_tpl', '内容模板', 'text', '其他', '100', 'show.html', null, '0', '0', '', '', '', 'class=\"form-control selectpage\",data-select-only=\"true\",data-data=\"/cms.model/getTplName.html?type=show\",data-pagination=\"false\",data-key-field=\"name\"', '1', '1', '1', null, '0', '0', '0', 'normal', '1604561449', '1600400927');
INSERT INTO `hkcms_model_field` VALUES ('150', '6', 'publish_time', '发布时间', 'datetime', '其他', '0', '', null, '0', '0', '', '', '', '', '1', '1', '2', null, '0', '0', '1', 'normal', '1604563079', '1600401003');
INSERT INTO `hkcms_model_field` VALUES ('151', '6', 'weigh', '排序', 'number', '常规', '11', '0', null, '0', '0', '', '', '', '', '1', '1', '1', null, '0', '0', '0', 'normal', '1604564047', '1600401198');
INSERT INTO `hkcms_model_field` VALUES ('152', '6', 'status', '状态', 'radio', '常规', '250', 'normal', '{\"normal\":\"\\u6b63\\u5e38\",\"hidden\":\"\\u7981\\u7528\",\"reject\":\"\\u62d2\\u7edd\",\"audit\":\"\\u5f85\\u5ba1\\u6838\"}', '0', '0', 'required', '', '', '', '1', '1', '0', null, '0', '0', '0', 'normal', '1604041706', '1604041706');
INSERT INTO `hkcms_model_field` VALUES ('153', '6', 'author', '作者', 'text', '其他', '250', '小编', null, '0', '0', '', '', '', '', '1', '0', '10', null, '0', '0', '0', 'normal', '1604561438', '1604557612');
INSERT INTO `hkcms_model_field` VALUES ('154', '6', 'views', '浏览量', 'number', '其他', '11', '0', null, '0', '0', '', '', '', '', '1', '1', '3', null, '0', '0', '1', 'normal', '1604563975', '1604561217');
INSERT INTO `hkcms_model_field` VALUES ('155', '6', 'images', '图集', 'images', '常规', '500', '', null, '6', '0', 'required', '', '', '', '1', '0', '18', null, '1', '0', '0', 'normal', '1637055273', '1637055273');
INSERT INTO `hkcms_model_field` VALUES ('156', '6', 'seotitle', 'seo标题', 'text', 'SEO', '200', '', null, '0', '0', '', 'seo标题，为空则使用文章标题', '', '', '1', '0', '1', null, '1', '0', '0', 'normal', '1604564378', '1600400833');
INSERT INTO `hkcms_model_field` VALUES ('157', '6', 'price', '价格', 'number', '常规', '10', '0', null, '0', '2', 'required', '', '', '', '1', '0', '17', null, '1', '0', '1', 'normal', '1616492830', '1616492650');
INSERT INTO `hkcms_model_field` VALUES ('158', '2', 'point', '经纬度', 'text', '常规', '250', '', null, '0', '0', 'required', '', '', 'data-toggle=\"address\",data-point=\"frm-point\",data-address=\"frm-address\"', '1', '0', '69', null, '0', '0', '0', 'normal', '1617359532', '1617358199');
INSERT INTO `hkcms_model_field` VALUES ('159', '2', 'email', '联系邮箱', 'text', '常规', '250', '', null, '0', '0', '', '', '', '', '1', '0', '66', null, '0', '0', '0', 'normal', '1617358735', '1617358619');
INSERT INTO `hkcms_model_field` VALUES ('160', '2', 'address', '详细地址', 'text', '常规', '250', '', null, '0', '0', '', '', '', '', '1', '0', '68', null, '0', '0', '0', 'normal', '1617358658', '1617358649');
INSERT INTO `hkcms_model_field` VALUES ('161', '2', 'contact_info', '联系方式', 'text', '常规', '250', '', null, '0', '0', '', '', '', '', '1', '0', '67', null, '0', '0', '0', 'normal', '1617358728', '1617358713');
INSERT INTO `hkcms_model_field` VALUES ('162', '2', 'company', '公司名称', 'text', '常规', '250', '', null, '0', '0', '', '', '', '', '1', '0', '67', null, '0', '0', '0', 'normal', '1617358939', '1617358939');
INSERT INTO `hkcms_model_field` VALUES ('163', '6', 'flags', '文档属性', 'selectpage', '其他', '100', '', '{\"type\":\"table\",\"url\":\"\",\"url-show-field\":\"\",\"url-key-field\":\"\",\"url-search-field\":\"\",\"table\":\"flags\",\"show-field\":\"title\",\"key-field\":\"name\",\"search-field\":\"title\",\"and-or\":\"\",\"order-by\":\"weigh desc\",\"param\":{\"custom\":{\"status\":\"normal\"}},\"multiple\":\"1\",\"pagination\":\"1\",\"select-only\":\"1\",\"enable-lang\":\"1\"}', '0', '0', '', '', '', '', '1', '1', '19', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '0', '0', '0', 'normal', '1649942700', '1649924031');
INSERT INTO `hkcms_model_field` VALUES ('164', '6', 'buylink', '购买链接', 'text', '常规', '250', '', null, '0', '0', '', '', '', '', '0', '0', '1', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '0', '0', '0', 'normal', '1656515160', '1656515119');
INSERT INTO `hkcms_model_field` VALUES ('165', '6', 'attr', '产品参数', 'array', '常规', '0', '', '{\"key\":\"\\u53c2\\u6570\\u540d\",\"value\":\"\\u53c2\\u6570\\u503c\"}', '0', '0', '', '', '', '', '0', '0', '1', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '0', '0', '0', 'normal', '1656515397', '1656515353');
INSERT INTO `hkcms_model_field` VALUES ('166', '6', 'color', '颜色', 'select', '常规', '250', 'blue', '{\"red\":\"\\u7ea2\\u8272\",\"blue\":\"\\u84dd\\u8272\",\"green\":\"\\u7eff\\u8272\",\"white\":\"\\u767d\\u8272\",\"black\":\"\\u9ed1\\u8272\"}', '0', '0', '', '', '', '', '0', '0', '0', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '0', '1', '0', 'normal', '1656516025', '1656516018');
INSERT INTO `hkcms_model_field` VALUES ('167', '7', 'content', '内容', 'editor', '常规', '0', '', null, '0', '0', '', '', '', '', '0', '1', '6', null, '1', '0', '0', 'normal', '1604565377', '1600410507');
INSERT INTO `hkcms_model_field` VALUES ('168', '7', 'title', '标题', 'text', '常规', '200', '', null, '0', '0', 'required', '', '', '', '1', '1', '20', null, '1', '0', '0', 'normal', '1604564165', '1600400002');
INSERT INTO `hkcms_model_field` VALUES ('169', '7', 'thumb', '封面图', 'image', '常规', '100', '', null, '0', '0', '', '', '', '', '1', '0', '18', null, '1', '0', '0', 'normal', '1604564175', '1600400154');
INSERT INTO `hkcms_model_field` VALUES ('170', '7', 'seotitle', 'seo标题', 'text', 'SEO', '200', '', null, '0', '0', '', 'seo标题，为空则使用文章标题', '', '', '1', '0', '0', null, '0', '0', '0', 'normal', '1604564378', '1600400833');
INSERT INTO `hkcms_model_field` VALUES ('171', '7', 'keywords', '关键词', 'text', 'SEO', '200', '', null, '0', '0', '', '多关键词之间用英文逗号隔开', '', '', '1', '0', '0', null, '0', '0', '0', 'normal', '1604564378', '1600400833');
INSERT INTO `hkcms_model_field` VALUES ('172', '7', 'description', '描述', 'textarea', 'SEO', '250', '', null, '0', '0', '', '', '', '', '1', '0', '0', null, '0', '0', '0', 'normal', '1603937358', '1600400870');
INSERT INTO `hkcms_model_field` VALUES ('173', '7', 'show_tpl', '内容模板', 'text', '其他', '100', 'show.html', null, '0', '0', '', '', '', 'class=\"form-control selectpage\",data-select-only=\"true\",data-data=\"/cms.model/getTplName.html?type=show\",data-pagination=\"false\",data-key-field=\"name\"', '1', '1', '1', null, '0', '0', '0', 'normal', '1604561449', '1600400927');
INSERT INTO `hkcms_model_field` VALUES ('174', '7', 'publish_time', '发布时间', 'datetime', '其他', '0', '', null, '0', '0', '', '', '', '', '1', '1', '2', null, '0', '0', '1', 'normal', '1604563079', '1600401003');
INSERT INTO `hkcms_model_field` VALUES ('175', '7', 'weigh', '排序', 'number', '常规', '11', '0', null, '0', '0', '', '', '', '', '1', '1', '1', null, '0', '0', '0', 'normal', '1604564047', '1600401198');
INSERT INTO `hkcms_model_field` VALUES ('176', '7', 'status', '状态', 'radio', '常规', '250', 'normal', '{\"normal\":\"\\u6b63\\u5e38\",\"hidden\":\"\\u7981\\u7528\",\"reject\":\"\\u62d2\\u7edd\",\"audit\":\"\\u5f85\\u5ba1\\u6838\"}', '0', '0', 'required', '', '', '', '1', '1', '0', null, '0', '0', '0', 'normal', '1604041706', '1604041706');
INSERT INTO `hkcms_model_field` VALUES ('177', '7', 'author', '作者', 'text', '其他', '250', '小编', null, '0', '0', '', '', '', '', '1', '0', '10', null, '0', '0', '0', 'normal', '1604561438', '1604557612');
INSERT INTO `hkcms_model_field` VALUES ('178', '7', 'views', '浏览量', 'number', '其他', '11', '0', null, '0', '0', '', '', '', '', '1', '1', '3', null, '0', '0', '1', 'normal', '1604563975', '1604561217');
INSERT INTO `hkcms_model_field` VALUES ('179', '7', 'flags', '文档属性', 'selectpage', '其他', '100', '', '{\"type\":\"table\",\"url\":\"\",\"url-show-field\":\"\",\"url-key-field\":\"\",\"url-search-field\":\"\",\"table\":\"flags\",\"show-field\":\"title\",\"key-field\":\"name\",\"search-field\":\"title\",\"and-or\":\"\",\"order-by\":\"weigh desc\",\"param\":{\"custom\":{\"status\":\"normal\"}},\"multiple\":\"1\",\"pagination\":\"1\",\"select-only\":\"1\",\"enable-lang\":\"1\"}', '0', '0', '', '', '', '', '1', '1', '19', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '0', '0', '0', 'normal', '1649942700', '1649924031');
INSERT INTO `hkcms_model_field` VALUES ('180', '7', 'images', '图集', 'images', '常规', '1000', '', null, '10', '0', '', '', '', '', '0', '0', '17', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '0', '0', '0', 'normal', '1656560220', '1656559756');
INSERT INTO `hkcms_model_field` VALUES ('181', '8', 'content', '内容', 'editor', '常规', '0', '', null, '0', '0', '', '', '', '', '0', '1', '6', null, '1', '0', '0', 'normal', '1604565377', '1600410507');
INSERT INTO `hkcms_model_field` VALUES ('182', '8', 'title', '标题', 'text', '常规', '200', '', null, '0', '0', 'required', '', '', '', '1', '1', '20', null, '1', '0', '0', 'normal', '1604564165', '1600400002');
INSERT INTO `hkcms_model_field` VALUES ('184', '8', 'seotitle', 'seo标题', 'text', 'SEO', '200', '', null, '0', '0', '', 'seo标题，为空则使用文章标题', '', '', '1', '0', '0', null, '0', '0', '0', 'normal', '1604564378', '1600400833');
INSERT INTO `hkcms_model_field` VALUES ('185', '8', 'keywords', '关键词', 'text', 'SEO', '200', '', null, '0', '0', '', '多关键词之间用英文逗号隔开', '', '', '1', '0', '0', null, '0', '0', '0', 'normal', '1604564378', '1600400833');
INSERT INTO `hkcms_model_field` VALUES ('186', '8', 'description', '描述', 'textarea', 'SEO', '250', '', null, '0', '0', '', '', '', '', '1', '0', '0', null, '0', '0', '0', 'normal', '1603937358', '1600400870');
INSERT INTO `hkcms_model_field` VALUES ('187', '8', 'show_tpl', '内容模板', 'text', '其他', '100', 'show.html', null, '0', '0', '', '', '', 'class=\"form-control selectpage\",data-select-only=\"true\",data-data=\"/cms.model/getTplName.html?type=show\",data-pagination=\"false\",data-key-field=\"name\"', '1', '1', '1', null, '0', '0', '0', 'normal', '1604561449', '1600400927');
INSERT INTO `hkcms_model_field` VALUES ('188', '8', 'publish_time', '发布时间', 'datetime', '其他', '0', '', null, '0', '0', '', '', '', '', '1', '1', '2', null, '0', '0', '1', 'normal', '1604563079', '1600401003');
INSERT INTO `hkcms_model_field` VALUES ('189', '8', 'weigh', '排序', 'number', '常规', '11', '0', null, '0', '0', '', '', '', '', '1', '1', '1', null, '0', '0', '0', 'normal', '1604564047', '1600401198');
INSERT INTO `hkcms_model_field` VALUES ('190', '8', 'status', '状态', 'radio', '常规', '250', 'normal', '{\"normal\":\"\\u6b63\\u5e38\",\"hidden\":\"\\u7981\\u7528\",\"reject\":\"\\u62d2\\u7edd\",\"audit\":\"\\u5f85\\u5ba1\\u6838\"}', '0', '0', 'required', '', '', '', '1', '1', '0', null, '0', '0', '0', 'normal', '1604041706', '1604041706');
INSERT INTO `hkcms_model_field` VALUES ('191', '8', 'author', '作者', 'text', '其他', '250', 'HR', null, '0', '0', '', '', '', '', '1', '0', '10', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '0', '0', '0', 'normal', '1657183835', '1604557612');
INSERT INTO `hkcms_model_field` VALUES ('192', '8', 'views', '浏览量', 'number', '其他', '11', '0', null, '0', '0', '', '', '', '', '1', '1', '3', null, '0', '0', '1', 'normal', '1604563975', '1604561217');
INSERT INTO `hkcms_model_field` VALUES ('193', '8', 'flags', '文档属性', 'selectpage', '其他', '100', '', '{\"type\":\"table\",\"url\":\"\",\"url-show-field\":\"\",\"url-key-field\":\"\",\"url-search-field\":\"\",\"table\":\"flags\",\"show-field\":\"title\",\"key-field\":\"name\",\"search-field\":\"title\",\"and-or\":\"\",\"order-by\":\"weigh desc\",\"param\":{\"custom\":{\"status\":\"normal\"}},\"multiple\":\"1\",\"pagination\":\"1\",\"select-only\":\"1\",\"enable-lang\":\"1\"}', '0', '0', '', '', '', '', '1', '1', '19', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '0', '0', '0', 'normal', '1649942700', '1649924031');
INSERT INTO `hkcms_model_field` VALUES ('194', '8', 'address', '工作地点', 'text', '常规', '250', '', null, '0', '0', '', '', '', '', '0', '0', '19', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '0', '0', '0', 'normal', '1657184066', '1657175926');
INSERT INTO `hkcms_model_field` VALUES ('195', '8', 'degree', '学历要求', 'select', '常规', '20', '不限', '{\"\\u4e0d\\u9650\":\"\\u4e0d\\u9650\",\"\\u9ad8\\u4e2d\\u53ca\\u4ee5\\u4e0b\":\"\\u9ad8\\u4e2d\\u53ca\\u4ee5\\u4e0b\",\"\\u5927\\u4e13\":\"\\u5927\\u4e13\",\"\\u672c\\u79d1\":\"\\u672c\\u79d1\",\"\\u7855\\u58eb\":\"\\u7855\\u58eb\",\"\\u535a\\u58eb\":\"\\u535a\\u58eb\"}', '0', '0', '', '', '', '', '0', '0', '19', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '0', '1', '0', 'normal', '1657193252', '1657176248');
INSERT INTO `hkcms_model_field` VALUES ('196', '8', 'salary', '薪资待遇', 'select', '常规', '20', '面议', '{\"\\u9762\\u8bae\":\"\\u9762\\u8bae\",\"3-5K\":\"3-5K\",\"5-10K\":\"5-10K\",\"10-20K\":\"10-20K\"}', '0', '0', '', '', '', '', '0', '0', '19', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '0', '1', '0', 'normal', '1657193292', '1657176628');
INSERT INTO `hkcms_model_field` VALUES ('197', '8', 'nature', '工作性质', 'select', '常规', '20', '全职', '{\"\\u5168\\u804c\":\"\\u5168\\u804c\",\"\\u517c\\u804c\":\"\\u517c\\u804c\"}', '0', '0', '', '', '', '', '0', '0', '19', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '0', '1', '0', 'normal', '1657193319', '1657181008');
INSERT INTO `hkcms_model_field` VALUES ('198', '8', 'exp', '工作经验', 'select', '常规', '20', '不限', '{\"\\u4e0d\\u9650\":\"\\u4e0d\\u9650\",\"\\u5e94\\u5c4a\\u751f\":\"\\u5e94\\u5c4a\\u751f\",\"1\\u5e74\\u4ee5\\u5185\":\"1\\u5e74\\u4ee5\\u5185\",\"1-3\\u5e74\":\"1-3\\u5e74\",\"3-5\\u5e74\":\"3-5\\u5e74\",\"5-10\\u5e74\":\"5-10\\u5e74\",\"10\\u5e74\\u4ee5\\u4e0a\":\"10\\u5e74\\u4ee5\\u4e0a\"}', '0', '0', '', '', '', '', '0', '0', '19', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '0', '1', '0', 'normal', '1657184080', '1657183634');
INSERT INTO `hkcms_model_field` VALUES ('199', '8', 'number', '招聘人数', 'text', '常规', '20', '', null, '0', '0', '', '', '', '', '0', '0', '19', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '0', '0', '0', 'normal', '1657184083', '1657183891');
INSERT INTO `hkcms_model_field` VALUES ('200', '5', 'title', '申请职位', 'text', '常规', '100', '', null, '0', '0', '', '', '', '', '1', '0', '0', '{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}', '0', '0', '0', 'normal', '1657213521', '1657213521');


DROP TABLE IF EXISTS `hkcms_model_field_bind`;
CREATE TABLE `hkcms_model_field_bind` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL DEFAULT '0' COMMENT '栏目ID',
  `model_field_id` int(11) NOT NULL COMMENT '字段ID',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='模型字段绑定栏目表';

INSERT INTO `hkcms_model_field_bind` VALUES ('19', '30', '159', '1637339961', '1637339961');
INSERT INTO `hkcms_model_field_bind` VALUES ('20', '29', '159', '1637339961', '1637339961');
INSERT INTO `hkcms_model_field_bind` VALUES ('21', '30', '162', '1637340007', '1637340007');
INSERT INTO `hkcms_model_field_bind` VALUES ('22', '29', '162', '1637340007', '1637340007');
INSERT INTO `hkcms_model_field_bind` VALUES ('23', '30', '161', '1637340036', '1637340036');
INSERT INTO `hkcms_model_field_bind` VALUES ('24', '29', '161', '1637340036', '1637340036');
INSERT INTO `hkcms_model_field_bind` VALUES ('25', '30', '160', '1637340039', '1637340039');
INSERT INTO `hkcms_model_field_bind` VALUES ('26', '29', '160', '1637340039', '1637340039');
INSERT INTO `hkcms_model_field_bind` VALUES ('27', '30', '158', '1637340043', '1637340043');
INSERT INTO `hkcms_model_field_bind` VALUES ('28', '29', '158', '1637340043', '1637340043');
INSERT INTO `hkcms_model_field_bind` VALUES ('29', '42', '200', '1657214389', '1657214389');
INSERT INTO `hkcms_model_field_bind` VALUES ('30', '41', '200', '1657214389', '1657214389');


DROP TABLE IF EXISTS `hkcms_product`;
CREATE TABLE `hkcms_product` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL COMMENT '栏目ID',
  `model_id` int(11) NOT NULL COMMENT '模型ID',
  `admin_id` int(11) NOT NULL COMMENT '管理员ID',
  `title` varchar(200) NOT NULL DEFAULT '' COMMENT '标题',
  `thumb` varchar(100) NOT NULL DEFAULT '' COMMENT '缩略封面图',
  `seotitle` varchar(200) NOT NULL DEFAULT '' COMMENT 'SEO标题',
  `keywords` varchar(200) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(250) NOT NULL DEFAULT '' COMMENT '描述',
  `tags` varchar(255) NOT NULL DEFAULT '' COMMENT '标签',
  `show_tpl` char(100) NOT NULL DEFAULT 'show.html' COMMENT '内容模板',
  `publish_time` int(11) DEFAULT NULL COMMENT '发布时间',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  `delete_time` int(11) DEFAULT NULL COMMENT '删除时间',
  `weigh` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `author` char(250) NOT NULL DEFAULT '小编' COMMENT '作者',
  `url` char(250) NOT NULL DEFAULT '' COMMENT 'URL',
  `views` int(11) NOT NULL DEFAULT '0' COMMENT '浏览量',
  `lang` varchar(20) NOT NULL DEFAULT '' COMMENT '语言标识',
  `images` varchar(500) NOT NULL DEFAULT '' COMMENT '图集',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '价格',
  `status` enum('normal','hidden','reject','audit') NOT NULL DEFAULT 'normal' COMMENT '状态',
  `flags` varchar(100) NOT NULL DEFAULT '' COMMENT '文档属性',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

INSERT INTO `hkcms_product` VALUES ('1', '23', '6', '1', '奥特维尔摇椅 [演示数据]', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg', '', '关键字,seo,产品展示,木椅,演示数据', '如果你希望成功，当以恒心为良友、以经验为参谋、以谨慎为兄弟、以希望为哨兵。', '', 'show_product.html', '1637383565', '1637383565', '1637383565', null, '0', 'default', '', '3', 'zh-cn', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '799.00', 'normal', '');
INSERT INTO `hkcms_product` VALUES ('2', '24', '6', '1', 'Hauteville Rocking Chair [Demo Data]', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg', '', 'keyword,seo,product,wooden chair,demo data', 'If you wish to succeed , you should use persistence as your good friend , experience as your reference , prudence as your brother and hope as your sentry.', '', 'show_product.html', '1637383565', '1637383565', '1637383565', null, '0', 'default', '', '1', 'en', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '799.00', 'normal', '');
INSERT INTO `hkcms_product` VALUES ('3', '23', '6', '1', '奥特维尔摇椅 [演示]2', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '', '关键字,seo,产品展示,木椅,演示数据', '如果你希望成功，当以恒心为良友、以经验为参谋、以谨慎为兄弟、以希望为哨兵。', '', 'show_product.html', '1637383565', '1637383587', '1637383808', null, '0', 'default', '', '2', 'zh-cn', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '199.00', 'normal', '');
INSERT INTO `hkcms_product` VALUES ('4', '25', '6', '1', '白色现代椅子', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg', '', '关键字,seo,产品展示,单人扶手椅,演示数据', '如果你希望成功，当以恒心为良友、以经验为参谋、以谨慎为兄弟、以希望为哨兵。', '', 'show_product.html', '1637383565', '1637383587', '1637383729', null, '0', 'default', '', '1', 'zh-cn', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '799.00', 'normal', '');
INSERT INTO `hkcms_product` VALUES ('5', '27', '6', '1', '[演示]奥特维尔摇椅 [演示数据]', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg', '', '关键字,seo,产品展示,木椅,演示数据', '如果你希望成功，当以恒心为良友、以经验为参谋、以谨慎为兄弟、以希望为哨兵。', '', 'show_product.html', '1637383565', '1637383587', '1637383866', null, '0', 'default', '', '0', 'zh-cn', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '799.00', 'normal', '');
INSERT INTO `hkcms_product` VALUES ('6', '24', '6', '1', 'Hauteville Rocking Chair [Demo]2', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '', 'keyword,seo,product,wooden chair,demo data', 'If you wish to succeed , you should use persistence as your good friend , experience as your reference , prudence as your brother and hope as your sentry.', '', 'show_product.html', '1637383565', '1637383587', '1637383809', null, '0', 'default', '', '0', 'en', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '199.00', 'normal', '');
INSERT INTO `hkcms_product` VALUES ('7', '26', '6', '1', 'White Modern Chair', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg', '', 'keyword,seo,product,Single Armch,demo data', 'If you wish to succeed , you should use persistence as your good friend , experience as your reference , prudence as your brother and hope as your sentry.', '', 'show_product.html', '1637383565', '1637383587', '1637383728', null, '0', 'default', '', '0', 'en', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '799.00', 'normal', '');
INSERT INTO `hkcms_product` VALUES ('8', '28', '6', '1', '[Demo]Hauteville Rocking Chair [Demo Data]', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg', '', 'keyword,seo,product,wooden chair,demo data', 'If you wish to succeed , you should use persistence as your good friend , experience as your reference , prudence as your brother and hope as your sentry.', '', 'show_product.html', '1637383565', '1637383587', '1637383867', null, '0', 'default', '', '0', 'en', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '799.00', 'normal', '');
INSERT INTO `hkcms_product` VALUES ('9', '23', '6', '1', '白色现代椅子2', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg', '', '关键字,seo,产品展示,单人扶手椅,演示数据', '如果你希望成功，当以恒心为良友、以经验为参谋、以谨慎为兄弟、以希望为哨兵。', '', 'show_product.html', '1637383565', '1637383762', '1637383794', null, '0', 'default', '', '4', 'zh-cn', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '799.00', 'normal', '');
INSERT INTO `hkcms_product` VALUES ('10', '25', '6', '1', '白色现代椅子2[演示数据]', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg', '', '关键字,seo,产品展示,单人扶手椅,演示数据', '如果你希望成功，当以恒心为良友、以经验为参谋、以谨慎为兄弟、以希望为哨兵。', '', 'show_product.html', '1637383565', '1637383762', '1637384107', null, '0', 'default', '', '1', 'zh-cn', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '799.00', 'normal', '');
INSERT INTO `hkcms_product` VALUES ('11', '27', '6', '1', '白色现代椅子', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg', '', '关键字,seo,产品展示,单人扶手椅,演示数据', '如果你希望成功，当以恒心为良友、以经验为参谋、以谨慎为兄弟、以希望为哨兵。', '', 'show_product.html', '1637383565', '1637383762', '1637383762', null, '0', 'default', '', '0', 'zh-cn', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '799.00', 'normal', '');
INSERT INTO `hkcms_product` VALUES ('12', '24', '6', '1', 'White Modern Chair2', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg', '', 'keyword,seo,product,Single Armch,demo data', 'If you wish to succeed , you should use persistence as your good friend , experience as your reference , prudence as your brother and hope as your sentry.', '', 'show_product.html', '1637383565', '1637383763', '1637383795', null, '0', 'default', '', '0', 'en', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '799.00', 'normal', '');
INSERT INTO `hkcms_product` VALUES ('13', '26', '6', '1', 'White Modern Chair2[Demo Data]', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg', '', 'keyword,seo,product,Single Armch,demo data', 'If you wish to succeed , you should use persistence as your good friend , experience as your reference , prudence as your brother and hope as your sentry.', '', 'show_product.html', '1637383565', '1637383763', '1637384106', null, '0', 'default', '', '0', 'en', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '799.00', 'normal', '');
INSERT INTO `hkcms_product` VALUES ('14', '28', '6', '1', 'White Modern Chair', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg', '', 'keyword,seo,product,Single Armch,demo data', 'If you wish to succeed , you should use persistence as your good friend , experience as your reference , prudence as your brother and hope as your sentry.', '', 'show_product.html', '1637383565', '1637383763', '1637383763', null, '0', 'default', '', '0', 'en', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '799.00', 'normal', '');
INSERT INTO `hkcms_product` VALUES ('15', '28', '6', '1', 'Wooden Bed - White Modern Chair', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg', '', 'keyword,seo,product,Single Armch,demo data', 'If you wish to succeed , you should use persistence as your good friend , experience as your reference , prudence as your brother and hope as your sentry.', '', 'show_product.html', '1637383565', '1637383890', '1637383921', null, '0', 'default', '', '0', 'en', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '799.00', 'normal', '');
INSERT INTO `hkcms_product` VALUES ('16', '27', '6', '1', '木床-白色现代椅子', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg', '', '关键字,seo,产品展示,单人扶手椅,演示数据', '如果你希望成功，当以恒心为良友、以经验为参谋、以谨慎为兄弟、以希望为哨兵。', '', 'show_product.html', '1637383565', '1637383892', '1637383910', null, '0', 'default', '', '0', 'zh-cn', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '799.00', 'normal', '');
INSERT INTO `hkcms_product` VALUES ('17', '27', '6', '1', '白色现代椅子', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '', '关键字,seo,产品展示,单人扶手椅,演示数据', '如果你希望成功，当以恒心为良友、以经验为参谋、以谨慎为兄弟、以希望为哨兵。', '', 'show_product.html', '1637383565', '1637383977', '1637384024', null, '0', 'default', '', '11', 'zh-cn', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '799.00', 'normal', '');
INSERT INTO `hkcms_product` VALUES ('18', '28', '6', '1', 'White Modern Chair', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '', 'keyword,seo,product,Single Armch,demo data', 'If you wish to succeed , you should use persistence as your good friend , experience as your reference , prudence as your brother and hope as your sentry.', '', 'show_product.html', '1637383565', '1637383982', '1637384025', null, '0', 'default', '', '0', 'en', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '799.00', 'normal', '');
INSERT INTO `hkcms_product` VALUES ('19', '26', '6', '1', 'White Modern Chair[demo]', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg', '', 'keyword,seo,product,Single Armch,demo data', 'If you wish to succeed , you should use persistence as your good friend , experience as your reference , prudence as your brother and hope as your sentry.', '', 'show_product.html', '1637383565', '1637384076', '1637384076', null, '0', 'default', '', '0', 'en', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '0.00', 'normal', '');
INSERT INTO `hkcms_product` VALUES ('20', '25', '6', '1', '白色现代椅子[演示]', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg', '', '关键字,seo,产品展示,单人扶手椅,演示数据', '如果你希望成功，当以恒心为良友、以经验为参谋、以谨慎为兄弟、以希望为哨兵。', '', 'show_product.html', '1637383565', '1637384083', '1637384083', null, '0', 'default', '', '3', 'zh-cn', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg', '0.00', 'normal', '');


DROP TABLE IF EXISTS `hkcms_product_data`;
CREATE TABLE `hkcms_product_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content` text,
  `buylink` char(250) NOT NULL DEFAULT '' COMMENT '购买链接',
  `attr` text COMMENT '产品参数',
  `color` enum('red','blue','green','white','black') NOT NULL DEFAULT 'blue' COMMENT '颜色',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

INSERT INTO `hkcms_product_data` VALUES ('1', '&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% 棉，50% 聚酯纤维&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;洋&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无闭合闭合&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;机洗&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;中等重量，50%棉/50%聚酯纤维摇粒绒，高达5%由回收塑料瓶制成&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;柔软的 7.5 盎司棉混纺面料，在任何气候下都能带来舒适感&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;卫衣位于自然腰围下方。罗纹下摆和袖口保持其形状&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;高针迹密度，因此持续时间更长，不会起球&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无标签，增加舒适度&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;套筒类型：长袖&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;&lt;p&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg&quot; width=&quot;263&quot; height=&quot;280&quot;&gt;&lt;br&gt;&lt;/p&gt;', 'https://www.hkcms.cn/', '{\"款 号\":\"abc4731111THL\",\"材 质\":\"大理石\",\"风 格\":\"休闲\",\"品 牌\":\"ABS\",\"颜 色\":\"红色\"}', 'green');
INSERT INTO `hkcms_product_data` VALUES ('2', '&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% Cotton, 50% Polyester&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Imported&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;No Closure closure&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Machine Wash&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Midweight, 50% Cotton/50% Polyester fleece, with up to 5% made from recycled plastic bottles&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Soft, 7.5-Oz cotton blend provides comfort in any climate&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sweatshirt sits just below your natural waistline. Ribbed hem and cuffs keep their shape&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;High-stitch density, so it lasts longer without pilling&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Tag-free for added comfort&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sleeve Type: Long Sleeve&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;&lt;p&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://local.cms.comhttp://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg&quot; width=&quot;263&quot; height=&quot;280&quot;&gt;&lt;br&gt;&lt;/p&gt;', 'https://www.hkcms.cn/', '{\"Model number\":\"abc4731111THL\",\"Material\":\"Marble\",\"Style\":\"Casual\",\"Brand\":\"ABS\",\"Color\":\"Red\"}', 'green');
INSERT INTO `hkcms_product_data` VALUES ('3', '&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% 棉，50% 聚酯纤维&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;洋&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无闭合闭合&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;机洗&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;中等重量，50%棉/50%聚酯纤维摇粒绒，高达5%由回收塑料瓶制成&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;柔软的 7.5 盎司棉混纺面料，在任何气候下都能带来舒适感&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;卫衣位于自然腰围下方。罗纹下摆和袖口保持其形状&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;高针迹密度，因此持续时间更长，不会起球&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无标签，增加舒适度&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;套筒类型：长袖&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;&lt;p&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg&quot; width=&quot;263&quot; height=&quot;280&quot;&gt;&lt;br&gt;&lt;/p&gt;', 'https://www.hkcms.cn/', '{\"款 号\":\"abc4731111THL\",\"材 质\":\"金刚石\",\"风 格\":\"运动\",\"品 牌\":\"ABC\",\"颜 色\":\"蓝色\"}', 'blue');
INSERT INTO `hkcms_product_data` VALUES ('4', '&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% 棉，50% 聚酯纤维&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;洋&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无闭合闭合&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;机洗&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;中等重量，50%棉/50%聚酯纤维摇粒绒，高达5%由回收塑料瓶制成&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;柔软的 7.5 盎司棉混纺面料，在任何气候下都能带来舒适感&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;卫衣位于自然腰围下方。罗纹下摆和袖口保持其形状&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;高针迹密度，因此持续时间更长，不会起球&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无标签，增加舒适度&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;套筒类型：长袖&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;', 'https://www.baidu.com/', '{\"款 号\":\"abc4732222THL\",\"材 质\":\"黄金\",\"风 格\":\"商务办公\",\"品 牌\":\"GGB\",\"颜 色\":\"红色\"}', 'red');
INSERT INTO `hkcms_product_data` VALUES ('5', '&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% 棉，50% 聚酯纤维&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;洋&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无闭合闭合&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;机洗&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;中等重量，50%棉/50%聚酯纤维摇粒绒，高达5%由回收塑料瓶制成&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;柔软的 7.5 盎司棉混纺面料，在任何气候下都能带来舒适感&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;卫衣位于自然腰围下方。罗纹下摆和袖口保持其形状&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;高针迹密度，因此持续时间更长，不会起球&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无标签，增加舒适度&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;套筒类型：长袖&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;&lt;p&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg&quot; width=&quot;263&quot; height=&quot;280&quot;&gt;&lt;br&gt;&lt;/p&gt;', 'https://www.baidu.com/', '{\"款 号\":\"abc4731111THL\",\"材 质\":\"大理石\",\"风 格\":\"休闲\",\"品 牌\":\"ABS\",\"颜 色\":\"白色\"}', 'white');
INSERT INTO `hkcms_product_data` VALUES ('6', '&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% Cotton, 50% Polyester&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Imported&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;No Closure closure&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Machine Wash&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Midweight, 50% Cotton/50% Polyester fleece, with up to 5% made from recycled plastic bottles&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Soft, 7.5-Oz cotton blend provides comfort in any climate&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sweatshirt sits just below your natural waistline. Ribbed hem and cuffs keep their shape&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;High-stitch density, so it lasts longer without pilling&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Tag-free for added comfort&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sleeve Type: Long Sleeve&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;&lt;p&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://local.cms.comhttp://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg&quot; width=&quot;263&quot; height=&quot;280&quot;&gt;&lt;br&gt;&lt;/p&gt;', 'https://www.hkcms.cn/', '{\"Model number\":\"abc4731111THL\",\"Material\":\"Diamond\",\"Style\":\"Sports\",\"Brand\":\"ABC\",\"Color\":\"Blue\"}', 'blue');
INSERT INTO `hkcms_product_data` VALUES ('7', '&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% Cotton, 50% Polyester&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Imported&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;No Closure closure&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Machine Wash&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Midweight, 50% Cotton/50% Polyester fleece, with up to 5% made from recycled plastic bottles&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Soft, 7.5-Oz cotton blend provides comfort in any climate&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sweatshirt sits just below your natural waistline. Ribbed hem and cuffs keep their shape&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;High-stitch density, so it lasts longer without pilling&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Tag-free for added comfort&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sleeve Type: Long Sleeve&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;', 'https://www.baidu.com/', '{\"Model number\":\"abc4731111THL\",\"Material\":\"Marble\",\"Style\":\"Leisure\",\"Brand\":\"ABS\",\"Color\":\"White\"}', 'white');
INSERT INTO `hkcms_product_data` VALUES ('8', '&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% Cotton, 50% Polyester&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Imported&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;No Closure closure&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Machine Wash&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Midweight, 50% Cotton/50% Polyester fleece, with up to 5% made from recycled plastic bottles&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Soft, 7.5-Oz cotton blend provides comfort in any climate&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sweatshirt sits just below your natural waistline. Ribbed hem and cuffs keep their shape&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;High-stitch density, so it lasts longer without pilling&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Tag-free for added comfort&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sleeve Type: Long Sleeve&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;&lt;p&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://local.cms.comhttp://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg&quot; width=&quot;263&quot; height=&quot;280&quot;&gt;&lt;br&gt;&lt;/p&gt;', 'https://www.hkcms.cn/', '{\"Model number\":\"abc4731111THL\",\"Material\":\"Stainless steel\",\"Style\":\"Casual\",\"Brand\":\"ABS\",\"Color\":\"Black\"}', 'black');
INSERT INTO `hkcms_product_data` VALUES ('9', '&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% 棉，50% 聚酯纤维&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;洋&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无闭合闭合&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;机洗&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;中等重量，50%棉/50%聚酯纤维摇粒绒，高达5%由回收塑料瓶制成&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;柔软的 7.5 盎司棉混纺面料，在任何气候下都能带来舒适感&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;卫衣位于自然腰围下方。罗纹下摆和袖口保持其形状&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;高针迹密度，因此持续时间更长，不会起球&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无标签，增加舒适度&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;套筒类型：长袖&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;', 'https://www.baidu.com/', '{\"款 号\":\"abc4701111THL\",\"材 质\":\"不锈钢\",\"风 格\":\"时尚休闲\",\"品 牌\":\"HHJ\",\"颜 色\":\"黑色\"}', 'black');
INSERT INTO `hkcms_product_data` VALUES ('10', '&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% 棉，50% 聚酯纤维&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;洋&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无闭合闭合&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;机洗&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;中等重量，50%棉/50%聚酯纤维摇粒绒，高达5%由回收塑料瓶制成&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;柔软的 7.5 盎司棉混纺面料，在任何气候下都能带来舒适感&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;卫衣位于自然腰围下方。罗纹下摆和袖口保持其形状&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;高针迹密度，因此持续时间更长，不会起球&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无标签，增加舒适度&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;套筒类型：长袖&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;', 'https://www.hkcms.cn/', '{\"款 号\":\"abc4031111THL\",\"材 质\":\"PVC\",\"风 格\":\"现代\",\"品 牌\":\"ABS\",\"颜 色\":\"红色\"}', 'red');
INSERT INTO `hkcms_product_data` VALUES ('11', '&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% 棉，50% 聚酯纤维&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;洋&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无闭合闭合&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;机洗&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;中等重量，50%棉/50%聚酯纤维摇粒绒，高达5%由回收塑料瓶制成&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;柔软的 7.5 盎司棉混纺面料，在任何气候下都能带来舒适感&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;卫衣位于自然腰围下方。罗纹下摆和袖口保持其形状&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;高针迹密度，因此持续时间更长，不会起球&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无标签，增加舒适度&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;套筒类型：长袖&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;', 'https://www.hkcms.cn/', '{\"款 号\":\"abc4031111THL\",\"材 质\":\"黄金\",\"风 格\":\"现代\",\"品 牌\":\"ABS\",\"颜 色\":\"绿色\"}', 'green');
INSERT INTO `hkcms_product_data` VALUES ('12', '&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% Cotton, 50% Polyester&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Imported&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;No Closure closure&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Machine Wash&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Midweight, 50% Cotton/50% Polyester fleece, with up to 5% made from recycled plastic bottles&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Soft, 7.5-Oz cotton blend provides comfort in any climate&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sweatshirt sits just below your natural waistline. Ribbed hem and cuffs keep their shape&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;High-stitch density, so it lasts longer without pilling&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Tag-free for added comfort&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sleeve Type: Long Sleeve&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;', 'https://www.baidu.com/', '{\"Model number\":\"abc4732222THL\",\"Material\":\"Gold\",\"Style\":\"Business office\",\"Brand\":\"GGB\",\"Color\":\"Red\"}', 'red');
INSERT INTO `hkcms_product_data` VALUES ('13', '&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% Cotton, 50% Polyester&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Imported&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;No Closure closure&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Machine Wash&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Midweight, 50% Cotton/50% Polyester fleece, with up to 5% made from recycled plastic bottles&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Soft, 7.5-Oz cotton blend provides comfort in any climate&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sweatshirt sits just below your natural waistline. Ribbed hem and cuffs keep their shape&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;High-stitch density, so it lasts longer without pilling&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Tag-free for added comfort&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sleeve Type: Long Sleeve&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;', 'https://www.hkcms.cn/', '{\"Model number\":\"abc4031111THL\",\"Material\":\"PVC\",\"Style\":\"Modern\",\"Brand\":\"ABS\",\"Color\":\"Red\"}', 'red');
INSERT INTO `hkcms_product_data` VALUES ('14', '&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% Cotton, 50% Polyester&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Imported&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;No Closure closure&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Machine Wash&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Midweight, 50% Cotton/50% Polyester fleece, with up to 5% made from recycled plastic bottles&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Soft, 7.5-Oz cotton blend provides comfort in any climate&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sweatshirt sits just below your natural waistline. Ribbed hem and cuffs keep their shape&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;High-stitch density, so it lasts longer without pilling&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Tag-free for added comfort&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sleeve Type: Long Sleeve&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;', 'https://www.hkcms.cn/', '{\"Model number\":\"abc4031111THL\",\"Material\":\"Gold\",\"Style\":\"Modern\",\"Brand\":\"ABS\",\"Color\":\"Green\"}', 'green');
INSERT INTO `hkcms_product_data` VALUES ('15', '&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% Cotton, 50% Polyester&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Imported&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;No Closure closure&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Machine Wash&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Midweight, 50% Cotton/50% Polyester fleece, with up to 5% made from recycled plastic bottles&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Soft, 7.5-Oz cotton blend provides comfort in any climate&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sweatshirt sits just below your natural waistline. Ribbed hem and cuffs keep their shape&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;High-stitch density, so it lasts longer without pilling&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Tag-free for added comfort&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sleeve Type: Long Sleeve&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;', '', '{\"Model number\":\"abc5731111THL\",\"Material\":\"Transistor\",\"Style\":\"Business office\",\"Brand\":\"HW\",\"Color\":\"Black\"}', 'black');
INSERT INTO `hkcms_product_data` VALUES ('16', '&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% 棉，50% 聚酯纤维&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;洋&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无闭合闭合&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;机洗&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;中等重量，50%棉/50%聚酯纤维摇粒绒，高达5%由回收塑料瓶制成&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;柔软的 7.5 盎司棉混纺面料，在任何气候下都能带来舒适感&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;卫衣位于自然腰围下方。罗纹下摆和袖口保持其形状&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;高针迹密度，因此持续时间更长，不会起球&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无标签，增加舒适度&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;套筒类型：长袖&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;', '', '{\"款 号\":\"abc5731111THL\",\"材 质\":\"晶体管\",\"风 格\":\"商务办公\",\"品 牌\":\"HW\",\"颜 色\":\"黑色\"}', 'black');
INSERT INTO `hkcms_product_data` VALUES ('17', '&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% 棉，50% 聚酯纤维&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;洋&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无闭合闭合&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;机洗&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;中等重量，50%棉/50%聚酯纤维摇粒绒，高达5%由回收塑料瓶制成&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;柔软的 7.5 盎司棉混纺面料，在任何气候下都能带来舒适感&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;卫衣位于自然腰围下方。罗纹下摆和袖口保持其形状&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;高针迹密度，因此持续时间更长，不会起球&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无标签，增加舒适度&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;套筒类型：长袖&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;', '', '{\"款 号\":\"abc4931111THL\",\"材 质\":\"二极管\",\"风 格\":\"民国风\",\"品 牌\":\"CCD\",\"颜 色\":\"白色\"}', 'white');
INSERT INTO `hkcms_product_data` VALUES ('18', '&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% Cotton, 50% Polyester&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Imported&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;No Closure closure&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Machine Wash&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Midweight, 50% Cotton/50% Polyester fleece, with up to 5% made from recycled plastic bottles&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Soft, 7.5-Oz cotton blend provides comfort in any climate&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sweatshirt sits just below your natural waistline. Ribbed hem and cuffs keep their shape&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;High-stitch density, so it lasts longer without pilling&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Tag-free for added comfort&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sleeve Type: Long Sleeve&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;', '', '{\"Model number\":\"abc4931111THL\",\"Material\":\"Diode\",\"Style\":\"Republic of China style\",\"Brand\":\"CCD\",\"Color\":\"White\"}', 'white');
INSERT INTO `hkcms_product_data` VALUES ('19', '&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% Cotton, 50% Polyester&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Imported&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;No Closure closure&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Machine Wash&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Midweight, 50% Cotton/50% Polyester fleece, with up to 5% made from recycled plastic bottles&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Soft, 7.5-Oz cotton blend provides comfort in any climate&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sweatshirt sits just below your natural waistline. Ribbed hem and cuffs keep their shape&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;High-stitch density, so it lasts longer without pilling&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Tag-free for added comfort&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sleeve Type: Long Sleeve&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;', 'https://www.hkcms.cn/', '{\"Model number\":\"abc4731111THL\",\"Material\":\"Rubber\",\"Style\":\"Antique\",\"Brand\":\"ABS\",\"Color\":\"Blue\"}', 'blue');
INSERT INTO `hkcms_product_data` VALUES ('20', '&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% 棉，50% 聚酯纤维&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;洋&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无闭合闭合&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;机洗&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;中等重量，50%棉/50%聚酯纤维摇粒绒，高达5%由回收塑料瓶制成&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;柔软的 7.5 盎司棉混纺面料，在任何气候下都能带来舒适感&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;卫衣位于自然腰围下方。罗纹下摆和袖口保持其形状&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;高针迹密度，因此持续时间更长，不会起球&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无标签，增加舒适度&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;套筒类型：长袖&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;', 'https://www.hkcms.cn/', '{\"款 号\":\"abc4731111THL\",\"材 质\":\"橡胶\",\"风 格\":\"古风\",\"品 牌\":\"ABS\",\"颜 色\":\"蓝色\"}', 'blue');


DROP TABLE IF EXISTS `hkcms_recommend`;
CREATE TABLE `hkcms_recommend` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '推荐位id',
  `admin_id` int(11) NOT NULL COMMENT '管理员ID',
  `type` char(10) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '类型:1-图集,2-多媒体,3-HTML内容',
  `value_id` text CHARACTER SET utf8 COMMENT '内容id',
  `name` char(20) CHARACTER SET utf8 NOT NULL COMMENT '标识',
  `remark` char(100) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '备注',
  `weigh` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `lang` char(20) NOT NULL DEFAULT '' COMMENT '语言标识',
  `status` enum('normal','hidden') CHARACTER SET utf8 NOT NULL DEFAULT 'normal' COMMENT '状态:normal-正常,hidden-禁用',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uq_name_lang` (`name`,`lang`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='推荐位';

INSERT INTO `hkcms_recommend` VALUES ('1', '1', '1', null, 'home_banner', 'Homepage carousel', '0', 'en', 'normal', '1636968234', '1636968200');
INSERT INTO `hkcms_recommend` VALUES ('2', '1', '1', null, 'home_banner', '首页轮播图', '0', 'zh-cn', 'normal', '1636968356', '1636968200');
INSERT INTO `hkcms_recommend` VALUES ('3', '1', '3', null, 'links', '友情链接(HTML演示)', '0', 'zh-cn', 'normal', '1636978556', '1636978556');
INSERT INTO `hkcms_recommend` VALUES ('4', '1', '3', null, 'links', 'Friendship link(HTML Demo)', '0', 'en', 'normal', '1636979192', '1636978556');
INSERT INTO `hkcms_recommend` VALUES ('5', '2', '1', null, 'sub', 'Inner page banner', '0', 'en', 'normal', '1637142422', '1637142375');
INSERT INTO `hkcms_recommend` VALUES ('6', '2', '1', null, 'sub', '内页横幅', '0', 'zh-cn', 'normal', '1637142445', '1637142375');
INSERT INTO `hkcms_recommend` VALUES ('7', '1', '2', null, 'video', '视频演示', '0', 'zh-cn', 'normal', '1637142445', '1637142375');
INSERT INTO `hkcms_recommend` VALUES ('8', '1', '2', null, 'video', 'Video demo', '0', 'en', 'normal', '1637142445', '1637142375');
INSERT INTO `hkcms_recommend` VALUES ('9', '1', '5', null, 'link', '友情链接', '0', 'zh-cn', 'normal', '1656610216', '1656610216');
INSERT INTO `hkcms_recommend` VALUES ('10', '1', '5', null, 'link', 'Links', '0', 'en', 'normal', '1656610243', '1656610216');
INSERT INTO `hkcms_recommend` VALUES ('11', '1', '1', null, 'partner', '合作伙伴', '0', 'zh-cn', 'normal', '1657460086', '1657460086');
INSERT INTO `hkcms_recommend` VALUES ('12', '1', '1', null, 'partner', 'Partner', '0', 'en', 'normal', '1657460475', '1657460086');


DROP TABLE IF EXISTS `hkcms_single`;
CREATE TABLE `hkcms_single` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL COMMENT '栏目ID',
  `model_id` int(11) NOT NULL COMMENT '模型ID',
  `admin_id` int(11) NOT NULL COMMENT '管理员ID',
  `title` varchar(200) NOT NULL DEFAULT '' COMMENT '标题',
  `seotitle` varchar(200) NOT NULL DEFAULT '' COMMENT 'SEO标题',
  `keywords` varchar(200) NOT NULL DEFAULT '' COMMENT '关键字',
  `show_tpl` char(100) NOT NULL DEFAULT 'page.html' COMMENT '内容模板',
  `content` text COMMENT '内容',
  `thumb` varchar(250) NOT NULL DEFAULT '' COMMENT '图片',
  `description` varchar(250) NOT NULL DEFAULT '' COMMENT '描述',
  `lang` varchar(20) NOT NULL DEFAULT '' COMMENT '语言标识',
  `status` enum('normal','hidden') NOT NULL DEFAULT 'normal' COMMENT '状态',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `point` char(250) NOT NULL DEFAULT '' COMMENT '经纬度',
  `email` char(250) NOT NULL DEFAULT '' COMMENT '联系邮箱',
  `address` char(250) NOT NULL DEFAULT '' COMMENT '详细地址',
  `contact_info` char(250) NOT NULL DEFAULT '' COMMENT '联系方式',
  `company` char(250) NOT NULL DEFAULT '' COMMENT '公司名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

INSERT INTO `hkcms_single` VALUES ('1', '3', '2', '1', 'HkCms 演示', '', '', 'page.html', '<p><span style=\"\">[演示数据]<span style=\"\">XXX公司是一家某省最早做大型设计电商平台的现代化互联网公司，多年大型电商平台建设经验，拥有一支技术过硬的电商平台建设团队。XXX公司主要从事大型电商设计，是一家专注于企业信息化和网络营销的公司，可以给客户提供快捷的互联网服务。能为大型企业提供专业电商服务。多年来以优质的服务，过硬的技术，贴心的用户体验，早就了多家大型电商平台的成功建设运营上线都受到广大消费者的赞美。[演示数据]</span></span><br></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/c.jpg', '公司简介说明', 'zh-cn', 'normal', '1636986256', '1636986256', '', '', '', '', '');
INSERT INTO `hkcms_single` VALUES ('2', '4', '2', '1', 'HkCms Demo', '', '', 'page.html', '<p><span style=\"\">XXX Company is a modern Internet company that was the first to design a large-scale e-commerce platform in a certain province. It has many years of experience in the construction of large-scale e-commerce platforms and has a highly skilled e-commerce platform construction team. XXX company is mainly engaged in large-scale e-commerce design. It is a company that focuses on enterprise informatization and network marketing, and can provide customers with fast Internet services. Can provide professional e-commerce services for large enterprises. Over the years, with high-quality services, excellent technology, and intimate user experience, many large-scale e-commerce platforms have been successfully constructed and operated for a long time and have been praised by consumers. [Demo Data]</span><br></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/c.jpg', 'Company profile description', 'en', 'normal', '1636986661', '1636986661', '', '', '', '', '');
INSERT INTO `hkcms_single` VALUES ('3', '7', '2', '1', '公司简介', '', '', 'page.html', '<p>[演示数据]XXX公司是一家某省最早做大型设计电商平台的现代化互联网公司，多年大型电商平台建设经验，拥有一支技术过硬的电商平台建设团队。XXX公司主要从事大型电商设计，是一家专注于企业信息化和网络营销的公司，可以给客户提供快捷的互联网服务。能为大型企业提供专业电商服务。多年来以优质的服务，过硬的技术，贴心的用户体验，早就了多家大型电商平台的成功建设运营上线都受到广大消费者的赞美。[演示数据]<br></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/c.jpg', '[演示数据]XXX公司是一家某省最早做大型设计电商平台的现代化互联网公司，多年大型电商平台建设经验，拥有一支技术过硬的电商平台建设团队。XXX公司主要从事大型电商设计，是一家专注于企业信息化和网络营销的公司，可以给客户提供快捷的互联网服务。能为大型企业提供专业电商服务。多年来以优质的服务，过硬的技术，贴心的用户体验，早就了多家大型电商平台的成功建设运营上线都受到广大消费者的赞美。[演示数据]', 'zh-cn', 'normal', '1636987653', '1636987653', '', '', '', '', '');
INSERT INTO `hkcms_single` VALUES ('4', '8', '2', '1', 'Company Profile', '', '', 'page.html', '<p>XXX Company is a modern Internet company that was the first to design a large-scale e-commerce platform in a certain province. It has many years of experience in the construction of large-scale e-commerce platforms and has a highly skilled e-commerce platform construction team. XXX company is mainly engaged in large-scale e-commerce design. It is a company that focuses on enterprise informatization and network marketing, and can provide customers with fast Internet services. Can provide professional e-commerce services for large enterprises. Over the years, with high-quality services, excellent technology, and intimate user experience, many large-scale e-commerce platforms have been successfully constructed and operated for a long time and have been praised by consumers. [Demo Data]<br></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/c.jpg', '', 'en', 'normal', '1636987782', '1636987782', '', '', '', '', '');
INSERT INTO `hkcms_single` VALUES ('5', '29', '2', '1', '联系我们', 'seo标题', '关键字,seo,联系我们', 'page_contact.html', '', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg', '历史使人明智；诗词使人灵秀；数学使人周密；自然哲学使人深刻；伦理使人庄重；逻辑修辞学使人善辨。', 'zh-cn', 'normal', '1637384536', '1637384536', '{\"lng\":116.404,\"lat\":39.915}', '11XXXX22@qq.com', '北京市东城区中华路甲10号', '158xxxx8888', '公司名称');
INSERT INTO `hkcms_single` VALUES ('6', '30', '2', '2', 'Contact us', 'SEO title', 'keyword,seo,contact us', 'page_contact.html', '', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg', 'Histories make men wise ; poems witty; the mathematics subtle; natural philosophy deep ; moral grave ; logic and rhetoric able to contend .', 'en', 'normal', '1637384537', '1637384537', '{\"lng\":116.404,\"lat\":39.915}', 'admin2@qq.com', '10 China Road A, Dongcheng District, Beijing', '400-123-1234,13013013011', 'Company Name');
INSERT INTO `hkcms_single` VALUES ('7', '31', '2', '1', '我们有专业的团队，一流的服务。', '', '关键字,seo,服务', 'page.html', '<p><span style=\"\">[演示数据]XXX公司是一家某省最早做大型设计电商平台的现代化互联网公司，多年大型电商平台建设经验，拥有一支技术过硬的电商平台建设团队。XXX公司主要从事大型电商设计，是一家专注于企业信息化和网络营销的公司，可以给客户提供快捷的互联网服务。能为大型企业提供专业电商服务。多年来以优质的服务，过硬的技术，贴心的用户体验，早就了多家大型电商平台的成功建设运营上线都受到广大消费者的赞美。[演示数据]</span><br></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/ser.jpg', '', 'zh-cn', 'normal', '1637386867', '1637386867', '', '', '', '', '');
INSERT INTO `hkcms_single` VALUES ('8', '32', '2', '1', 'We have a professional team and first-class service.', '', '关键字,seo,service', 'page.html', '<p><span style=\"\">XXX Company is a modern Internet company that was the first to design a large-scale e-commerce platform in a certain province. It has many years of experience in the construction of large-scale e-commerce platforms and has a highly skilled e-commerce platform construction team. XXX company is mainly engaged in large-scale e-commerce design. It is a company that focuses on enterprise informatization and network marketing, and can provide customers with fast Internet services. Can provide professional e-commerce services for large enterprises. Over the years, with high-quality services, excellent technology, and intimate user experience, many large-scale e-commerce platforms have been successfully constructed and operated for a long time and have been praised by consumers. [Demo Data]</span><br></p>', 'http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/ser.jpg', '', 'en', 'normal', '1637386997', '1637386997', '', '', '', '', '');
